<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>A - Artistes & groupes</title>
   <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>

<!-- Liste verticale des albums -->
<div class="album-list">

 <!-- TOUS LES ARTISTES A -->
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/9tcdvbC/A-Team-Music.jpg" alt="A-Team-Music"></div>
  <div class="r-details"><div class="r-band"><a href="a-team-music.php">A-Team-Music</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/5/1744930388-abner-g-cover.png" alt="Abner G"></div>
  <div class="r-details"><div class="r-band"><a href="abner-g.php">Abner G</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1e595be3a901738c4f2cc8d81be9ef79/250x250-000000-80-0-0.jpg" alt="Abraham PLF"></div>
  <div class="r-details"><div class="r-band"><a href="abraham-plf.php">Abraham PLF</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/21/5/1747957056-acccover.jpg" alt="Accolade"></div>
  <div class="r-details"><div class="r-band"><a href="accolade-de-paris.php">Accolade #1 de Paris</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/21/4/1747940798-accolade-cover.jpg" alt="accolade"></div>
  <div class="r-details"><div class="r-band"><a href="accolade-de-new-york.php">Accolade de New York</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/1/1748295102-actionn.jpg" alt="Actionn"></div>
  <div class="r-details"><div class="r-band"><a href="actionn.php">Actionn</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/2/1748300704-adma-cover.png" alt="Adamastor Master Speed"></div>
  <div class="r-details"><div class="r-band"><a href="adamastor-master-speed.php">Adamastor Master Speed</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/2/1748297435-1.jpg" alt="Adjabel"></div>
  <div class="r-details"><div class="r-band"><a href="adjabel.php">Adjabel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/2/1748301294-adjay-cover.jpg" alt="Cover"></div>
  <div class="r-details"><div class="r-band"><a href="adjay.php">Adjay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61N3+9txc9L._UXNaN_FMjpg_QL85_.jpg" alt="Admael Charles"></div>
  <div class="r-details"><div class="r-band"><a href="admael-charles.php">Admael Charles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/72nDLMc/Adrien-Jeannite-Marjolaine.jpg" alt="Adrien "></div>
  <div class="r-details"><div class="r-band"><a href="adrien-jeannite-marjolaine.php">Adrien Jeannite Marjolaine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/3BhzZrT/cover.jpg" alt="Afro-Combo de Boston"></div>
  <div class="r-details"><div class="r-band"><a href="afro-combo-de-boston.php">Afro-Combo de Boston</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/28h24sK/Agoci-Music-Band.jpg" alt="Agoci"></div>
  <div class="r-details"><div class="r-band"><a href="agoci-music-band.php">Agoci Music Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/510eJHCVDRL._UXNaN_FMjpg_QL85_.jpg" alt="AJT"></div>
  <div class="r-details"><div class="r-band"><a href="ajt.php">AJT</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/X53m3Cy/Akor-Mizik-de-Style-Poulard.jpg" alt="Akor Mizik de Style Poulard"></div>
  <div class="r-details"><div class="r-band"><a href="akor-mizik-de-style-poulard.php">Akor Mizik de Style Poulard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/3/1748393030-alabanza-cover.png" alt="Alabanza"></div>
  <div class="r-details"><div class="r-band"><a href="alabanza.php">Alabanza</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/TMrgYJD/Alain-Bossous.jpg" alt="Alain Bossous"></div>
  <div class="r-details"><div class="r-band"><a href="alain-bossous-gael-grunder.php">Alain Bossous & Gael Grunder</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/7/1748803020-alain-cover.png" alt="Alain Fleurine"></div>
  <div class="r-details"><div class="r-band"><a href="alain-fleurine.php">Alain Fleurine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/XbqGTZq/folder.jpg" alt="Alamod"></div>
  <div class="r-details"><div class="r-band"><a href="alamod.php">Alamod</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/9y4rR3t/Alan-Cave.jpg" alt="Alan Cave"></div>
  <div class="r-details"><div class="r-band"><a href="alan-cave.php">Alan Cave</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/fSPCWbFKlUAYkRiAXOqgyX5v4POHSm133e-Qk422-do/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTExMjAw/NjQxLTE1MTE3MzE5/NTctNTA4Ny5qcGVn.jpeg" alt="Albert Chancy"></div>
  <div class="r-details"><div class="r-band"><a href="albert-chancy.php">Albert Chancy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/LStsjjc/Albertos.jpg" alt="Albertos"></div>
  <div class="r-details"><div class="r-band"><a href="albertos.php">Albertos</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3f423d1d73bce05a88479355e790660f/250x250-000000-80-0-0.jpg" alt="Aleus Rico"></div>
  <div class="r-details"><div class="r-band"><a href="aleus-rico.php">Aleus Rico</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/1KS17q3/Alez-Live-Four-Men-W.jpg" alt="Alez"></div>
  <div class="r-details"><div class="r-band"><a href="alez.php">Alez</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3aa00fd3b8a4477c111efec1285bc450/250x250-000000-80-0-0.jpg" alt="Alezzz"></div>
  <div class="r-details"><div class="r-band"><a href="alezzz.php">Alezzz</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6beb131ce9e2f3b382b09752c98f2db3/250x250-000000-80-0-0.jpg" alt="Ali Louissaint"></div>
  <div class="r-details"><div class="r-band"><a href="ali-louissaint.php">Ali Louissaint</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://destinationkompa.info/albums/covers/fritz-pereira-and-his-orchestra-man-smart-woman-smarter.jpg" alt="Alix Julien"></div>
  <div class="r-details"><div class="r-band"><a href="alix-jacques.php">Alix Jacques</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Mgn6x4m/Alix.jpg" alt="Alix"></div>
  <div class="r-details"><div class="r-band"><a href="alix.php">Alix</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/MVZrk80/Alix-Julien.jpg" alt="Alix Julien"></div>
  <div class="r-details"><div class="r-band"><a href="alix-julien.php">Alix Julien</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/KGTXhJh/Alix-Pascal.jpg" alt="Alix Pascal"></div>
  <div class="r-details"><div class="r-band"><a href="alix-pascal.php">Alix Pascal</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/DrzXV7b/All-Star-Kramel-Chak-fwa-M-wew.jpg" alt="All Star Kramel"></div>
  <div class="r-details"><div class="r-band"><a href="all-star-kramel.php">All Star Kramel</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/McgHN0K/Allianss-Compas-Gato-doukoun.jpg" alt="Allianss Compas"></div>
  <div class="r-details"><div class="r-band"><a href="allianss-compas.php">Allianss Compas</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/jTXxJzk/All-Stars.jpg" alt="All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="all-stars-music-majik.php">All Stars Music Majik</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/076d1a379a8503e38eaab849467b2388/250x250-000000-80-0-0.jpg" alt="Alma Danger"></div>
  <div class="r-details"><div class="r-band"><a href="alma-danger.php">Alma Danger</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/J025i8mVoRrju_G19rDeWU7NcmrunJSn6FsBOW29sas/rs:fit/g:sm/q:90/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMwMjY0/Nzc2LTE3MTE5MTU3/MzQtNTg0MC5qcGVn.jpeg" alt="Alamod"></div>
  <div class="r-details"><div class="r-band"><a href="almando-keslin.php">Almando Keslin et Omni Band</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/vz7S6HN/Althiery-Dorival.jpg" alt="Althiery Dorival"></div>
  <div class="r-details"><div class="r-band"><a href="althiery-dorival.php">Althiery Dorival</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3eece1f73ad7179866b8d3e072091bb7/250x250-000000-80-0-0.jpg" alt="Altidor Reynold"></div>
  <div class="r-details"><div class="r-band"><a href="altidor-reynold.php">Altidor Reynold</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/zRYn2jT/AMFM.jpg" alt="AM/FM"></div>
  <div class="r-details"><div class="r-band"><a href="am-fm.php">AM/FM</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/YD5b2bg/Ambiance-Paillote.jpg" alt="Ambiance Paillote"></div>
  <div class="r-details"><div class="r-band"><a href="ambiance-paillote.php">Ambiance Paillote</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/ynqSTxF/Amos-Coulanges.jpg" alt="Amos Coulanges"></div>
  <div class="r-details"><div class="r-band"><a href="amos-coulanges.php">Amos Coulanges</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://img.over-blog.com/600x600/0/38/74/14/a-2012/compas-2012/Amos-dolce-sweet-amos-2011.jpg" alt="Amos Dolces"></div>
  <div class="r-details"><div class="r-band"><a href="amos-dolce.php">Amos Dolce</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/876d3b44d3453210d15e9cdd43469112/250x250-000000-80-0-0.jpg" alt="Anbasad Camp"></div>
  <div class="r-details"><div class="r-band"><a href="anbasad-camp.php">Anbasad Camp</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music6/v4/ee/c7/cd/eec7cdf7-1307-c394-09de-5b4b3e323798/3433190673926.jpg/1200x1200bb.jpg" alt="Anbyans"></div>
  <div class="r-details"><div class="r-band"><a href="anbyans.php">Anbyans</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/k9r1qRY/Anbyans-Kreyol.jpg" alt="Anbyans Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="anbyans-kreyol.php">Anbyans Kreyol</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/6/1748697452-ac-cover.jpg" alt="Anderson Cameau"></div>
  <div class="r-details"><div class="r-band"><a href="anderson-cameau.php">Anderson-Cameau</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/HkTN7V270Zng9wAQG-rlkzpnU8akWwJWMKeRz_BCVOQ/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEwODQ0/MDY1LTE1MDUyMjYy/NDktNDg5Ni5qcGVn.jpeg" alt="Andree Lescot"></div>
  <div class="r-details"><div class="r-band"><a href="andree-lescot.php">Andree Lescot</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/x1Bvh8h/Andr-Charles-and-his-Quisqueya-Ibo-Combo-Group.jpg" alt="Andre Charles"></div>
  <div class="r-details"><div class="r-band"><a href="andre-charles.php">Andre Charles and his Quisqueya Ibo Combo Group</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/71dc065ad03f188f9f43e2c7ce0bea31/250x250-000000-80-0-0.jpg" alt="Andre Buteau Cadely"></div>
  <div class="r-details"><div class="r-band"><a href="andre-buteau-cadely.php">Andre Buteau Cadely</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/QfzGskQ/Andre-Fouad.jpg" alt="Andre Fouad"></div>
  <div class="r-details"><div class="r-band"><a href="andre-fouad.php">Andre Fouad & Wooly Saint Louis Jean</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/BqHxQq6/Andre-Pipirite.jpg" alt="Andre Pipirite"></div>
  <div class="r-details"><div class="r-band"><a href="andre-pipirite.php">Andre Pipirite</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/YRSSNdr/Andre-Toussaint.jpg" alt="Andre Toussaint"></div>
  <div class="r-details"><div class="r-band"><a href="andre-toussaint-and-the-caribbeans.php">Andre Toussaint</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Y0ctDFf/Andrew-Cyrille.jpg" alt="Andrew Cyrille"></div>
  <div class="r-details"><div class="r-band"><a href="andrew-cyrille.php">Andrew Cyrille w. Haitian Fascination</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/MGSDMd6/Andy.jpg" alt="Andy"></div>
  <div class="r-details"><div class="r-band"><a href="andy.php">Andy</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://149747260.v2.pressablecdn.com/wp-content/uploads/2024/02/andy-beatz2.jpg" alt="AndyBeatz"></div>
  <div class="r-details"><div class="r-band"><a href="andy-Beatz.php">AndyBeatz</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/k897zRy/Jod-Lav.jpg" alt="Angelo"></div>
  <div class="r-details"><div class="r-band"><a href="angelo.php">Angelo</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5eb6b039f9274e9266068c92e41" alt="Anie Alerte"></div>
  <div class="r-details"><div class="r-band"><a href="anie-alerte.php">Anie Alerte</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/62803b8ef1785ebc2bc8362057b15d5a/250x250-000000-80-0-0.jpg" alt="Anne Noralie"></div>
  <div class="r-details"><div class="r-band"><a href="anne-noralie.php">Anne Noralie</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/bWrnC6k/Anna-Pierre.jpg" alt="Anna Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="anna-pierre.php">Anna Pierre</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8a789d24c85de141b03c20f3028210b1/250x250-000000-80-0-0.jpg" alt="Anna Teko"></div>
  <div class="r-details"><div class="r-band"><a href="anna-teko.php">Anna Teko</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://media9ht.com/wp-content/uploads/2020/04/Annette-Auguste-dite-So-Anne-2.jpg" alt="Annette Auguste"></div>
  <div class="r-details"><div class="r-band"><a href="annette-auguste.php">Annette Auguste</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000104891010-5e4sj7-t500x500.jpg" alt="Ansy Derose"></div>
  <div class="r-details"><div class="r-band"><a href="ansy-derose.php">Ansy Derose</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/6/1748699829-cover.jpg" alt="Antidote De Montreal"></div>
  <div class="r-details"><div class="r-band"><a href="antidote-de-montreal.php">Antidote De Montreal</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/B468093/Cover-Anti-Missil.jpg" alt="Anti-Missil"></div>
  <div class="r-details"><div class="r-band"><a href="anti-missil.php">Anti-Missil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/2/1748359640-awm-cover.png" alt="Apachidiz"></div>
  <div class="r-details"><div class="r-band"><a href="apachidiz.php">Apachidiz</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/whdtQY8/Cover-Apocalypse.jpg" alt="Apocalypse"></div>
  <div class="r-details"><div class="r-band"><a href="apocalypse.php">Apocalypse</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/eda691fb18f75fdba8322375227411e0/1900x1900-000000-80-0-0.jpg" alt="Apocalypse 2000"></div>
  <div class="r-details"><div class="r-band"><a href="apocalypse2000.php">Apocalypse 2000</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/da85803ef4fa0f6e708b300e7abbcf27/250x250-000000-80-0-0.jpg" alt="Aquela Dorvil"></div>
  <div class="r-details"><div class="r-band"><a href="aquela-dorvil.php">Aquela Dorvil</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/4/1750901359-default-cover.jpg" alt="Aquarelle"></div>
  <div class="r-details"><div class="r-band"><a href="aquarelle.php">Aquarelle</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0cf199806dacef8639c284737bfc713b/250x250-000000-80-0-0.jpg" alt="Ariette Jean Louis"></div>
  <div class="r-details"><div class="r-band"><a href="ariette-jean-louis.php">Ariette Jean Louis</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/J7xyQ22/Arkanj.jpg" alt="Arkanj"></div>
  <div class="r-details"><div class="r-band"><a href="ar-kanj.php">Ar'kanj</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/SPzhPHB/Design-sans-titre-3.png" alt="Arly Lariviere"></div>
  <div class="r-details"><div class="r-band"><a href="arly-lariviere.php">Arly Lariviere</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/bFfTZwH/folder.jpg" alt="Armstrong Jeune"></div>
  <div class="r-details"><div class="r-band"><a href="armstrong-jeune.php">Armstrong Jeune</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/jZtFGss/Arnaud-Poinvil.jpg" alt="Arnaud Poinvil"></div>
  <div class="r-details"><div class="r-band"><a href="arnaud-poinvil.php">Arnaud Poinvil</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/mF2d7y1/Arnold-Dubreuil.jpg" alt="Arnold Dubreuil"></div>
  <div class="r-details"><div class="r-band"><a href="arnold-dubreuil.php">Arnold Dubreuil</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/mqyZFdc/Arnold-Fortune.jpg" alt="Arnold Fortune"></div>
  <div class="r-details"><div class="r-band"><a href="arnold-fortune.php">Arnold Fortune & Tandem</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/WPtmXD1/folder.jpg" alt="Arnold Pat Tomat"></div>
  <div class="r-details"><div class="r-band"><a href="arnold-pat.php">Arnold Pat Tomat</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/7yRgF3M/Art-Marcel-Volmar.jpg" alt="Art Marcel Volmar"></div>
  <div class="r-details"><div class="r-band"><a href="art-marcel-volmar.php">Art Marcel Volmar</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/HDBsGkC/Arthur-Duroseau.jpg" alt="Arthur Duroseau"></div>
  <div class="r-details"><div class="r-band"><a href="arthur-duroseau.php">Arthur Duroseau his Family & Ensemble</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/5FLxZfx/AS-NASH-Mystere-1976.jpg" alt="As Nash"></div>
  <div class="r-details"><div class="r-band"><a href="as-nash.php">AS NASH</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/2/1750780000-cover.jpg" alt="Asap Jexus"></div>
  <div class="r-details"><div class="r-band"><a href="asap-jexus.php">Asap Jexus</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/4/1750901359-default-cover.jpg
" alt="Ashadei"></div>
  <div class="r-details"><div class="r-band"><a href="ashadei.php">Ashadei</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/4/1750901359-default-cover.jpg" alt="Ashley"></div>
  <div class="r-details"><div class="r-band"><a href="ashley.php">Ashley</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/RcK0QLP/As-t.jpg" alt="Asoto"></div>
  <div class="r-details"><div class="r-band"><a href="asoto.php">Asoto</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/HHxWGS1/Assade-Francoeur.jpg" alt="Assade Francoeur"></div>
  <div class="r-details"><div class="r-band"><a href="assade-francoeur.php">Assade Francoeur</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/bd3ff3789372268fca764a3767ef1516/250x250-000000-80-0-0.jpg" alt="Astral Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="astral-konpa.php">Astral Kompa</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/23/4/1749081805-astros-album-cover.jpg" alt="Astros"></div>
  <div class="r-details"><div class="r-band"><a href="astros.php">Astros</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/4wkXxcX/Atis-Constant.jpg" alt="Atis Constant"></div>
  <div class="r-details"><div class="r-band"><a href="atis-constant.php">Atis Constant</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://destinationkompa.info/albums/covers/fritz-pereira-and-his-orchestra-man-smart-woman-smarter.jpg" alt="Atis Meteyer"></div>
  <div class="r-details"><div class="r-band"><a href="atis-meteyer.php">Atis Meteyer</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://destinationkompa.info/albums/covers/atis-pou-ayiti-apa.jpg" alt="Atomik Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="atis-pou-ayiti.php">Atis Pou Ayiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/GvzGwYn/Atomik-Konpa.jpg" alt="Atomik Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="atomik-konpa.php">Atomik Konpa</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/2hv454X/Covers.jpg" alt="Atomyk 6-Tem"></div>
  <div class="r-details"><div class="r-band"><a href="atomyk-6-tem.php">Atomyk 6-Tem</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/ZMCsJs1/Avalas-System.jpg" alt="Avalas System"></div>
  <div class="r-details"><div class="r-band"><a href="avalas-System.php">Avalas System +</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/LhQFnSd/Ayenn.jpg" alt="Ayenn"></div>
  <div class="r-details"><div class="r-band"><a href="ayenn.php">Ayenn</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106058.jpg" alt="Ayibobo"></div>
  <div class="r-details"><div class="r-band"><a href="ayibobo.php">Ayibobo</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/21/4/1747933540-ayiiti-cover.jpg" alt="Ayiiti"></div>
  <div class="r-details"><div class="r-band"><a href="ayiiti.php">Ayiiti</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/21/4/1747923419-achiv-kompacover.png" alt="Ayiti Toma"></div>
  <div class="r-details"><div class="r-band"><a href="ayiti-Toma.php">Ayiti Toma</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Tm37bYC/cover.jpg" alt="Ayizan"></div>
  <div class="r-details"><div class="r-band"><a href="ayizan.php">Ayizan</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/yVK33DN/cover.jpg" alt="Aylaan"></div>
  <div class="r-details"><div class="r-band"><a href="aylaan.php">Aylaan</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/tcRP5yH/Design-sans-titre-1.png" alt="AZ artiste"></div>
  <div class="r-details"><div class="r-band"><a href="az-artiste.php">AZ Artiste</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/fCGy0jK/Azaka-Z-Fanm-Nan-Gr-ss.jpg" alt="Azaka Z."></div>
  <div class="r-details"><div class="r-band"><a href="azaka-z.php">Azaka Z.</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/eb436517363c6ae05d942e94d64b18c3/1900x1900-000000-80-0-0.jpg" alt="Azor"></div>
  <div class="r-details"><div class="r-band"><a href="azor.php">Azor</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/nLjmJw3/Azuei.jpg" alt="Azuei."></div>
  <div class="r-details"><div class="r-band"><a href="azuei.php">Azuei.</a></div></div>
</div>




</div> <!-- Fin de .album-list -->
</div> <!-- Fin du conteneur principal si applicable -->

</main>


<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>

