<?php
$file = basename(__FILE__, '.php') . ".json";
$path = __DIR__ . "/" . $file;

if (!file_exists($path)) {
  http_response_code(404);
  echo "<h2>Le fichier JSON '$file' est introuvable.</h2>";
  exit;
}

$data = json_decode(file_get_contents($path), true);
if (!$data) {
  echo "<h2>Erreur : fichier JSON invalide ou vide.</h2>";
  exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Fiche Artiste</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    .album-item { display: flex; gap: 10px; align-items: center; cursor: pointer; padding: 5px; }
    .album-item img { border-radius: 6px; }
    .album-item:hover { background: #eee; }
    .tracklist-container li { list-style-type: none; }
  </style>
</head>
<body>
<div id="albumSidebar"></div>
<div id="albumPreview"></div>

<script>
const allAlbums = <?= json_encode($data, JSON_UNESCAPED_UNICODE); ?>;
const sidebar = document.getElementById('albumSidebar');
const preview = document.getElementById('albumPreview');

function showAlbum(album, el) {
  document.querySelectorAll('.album-item').forEach(i => i.classList.remove('active'));
  if (el) el.classList.add('active');

  const format = album.format ? album.format.toLowerCase() : '';
  let icon = '';
  if (format.includes('vinyl') || format.includes('lp') || format.includes('33') || format.includes('45')) {
    icon = '<img src="/albums/icons/vinyl-bw.png" alt="vinyl" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
  } else if (format.includes('cd')) {
    icon = '<img src="/albums/icons/cd-icon.png" alt="cd" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
  } else if (format.includes('k7') || format.includes('cassette')) {
    icon = '<img src="/albums/icons/cassette-icon.png" alt="k7" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
  } else if (format.includes('digital') || format.includes('dg')) {
    icon = '<img src="/albums/icons/digital-icon.png" alt="dg" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
  }

  preview.innerHTML = `
    <div class="cover-and-info">
      <img src="${album.cover}" alt="${album.title}" style="max-width:200px;">
      <div class="album-meta">
        <h2>${album.artist}</h2>
        <h3>${album.title}</h3>
        <p><strong>Année :</strong> ${album.year}</p>
        <p><strong>Catégorie :</strong> ${album.category || '-'}</p>
        <p><strong>Format :</strong> <span style="display:inline-flex;align-items:center;gap:6px;align-items:baseline;">${icon}<span style="font-size:15px;">${album.format || '-'}</span></span></p>
        <p><strong>Genre :</strong> ${album.genre || '-'}</p>
        <p><strong>Label :</strong> ${album.label || '-'}</p>
      </div>
    </div>
    <div class="tracklist-container" style="flex: 1; min-width: 300px;">
      <h3>Tracklist</h3>
      ` + (function() {
        let html = '';
        if (album.tracks && typeof album.tracks === 'object' && !Array.isArray(album.tracks)) {
          const discs = {};
          for (const face in album.tracks) {
            const match = face.match(/disc\s*(\d+)\s*[-–]?\s*([ab])/i);
            const discNum = match ? match[1] : '1';
            const side = match ? match[2].toUpperCase() : face.toUpperCase();
            if (!discs[discNum]) discs[discNum] = {};
            discs[discNum][side] = album.tracks[face];
          }

          for (const disc in discs) {
            html += `<h4 style="margin-top:2em;margin-bottom:0.5em;font-size:16px;color:#444;background:#f5f5f5;padding:6px 10px;border-left:4px solid #C9A54C;">Disque ${disc}</h4>`;
            for (const side of ['A', 'B']) {
              if (discs[disc][side]) {
                html += `<h5 style="margin:10px 0 6px;font-weight:bold;color:#C9A54C;">Face ${side}</h5><ol style="padding-left:1rem;">`;
                discs[disc][side].forEach((t) => {
                  html += `<li style="padding:6px 10px;background:#fff;border-radius:6px;margin-bottom:5px;border-left:4px solid #C9A54C;">${t}</li>`;
                });
                html += `</ol>`;
              }
            }
          }
        } else if (Array.isArray(album.tracks)) {
          html += `<ol style="padding-left:1rem;">`;
          album.tracks.forEach((t, i) => {
            html += `<li style="padding:6px 10px;background:#fff;border-radius:6px;margin-bottom:5px;border-left:4px solid #C9A54C;">${i + 1}. ${t}</li>`;
          });
          html += `</ol>`;
        }
        return html;
      })() + `
    </div>`;
}

function renderSidebar(albums) {
  if (!sidebar) return;
  sidebar.innerHTML = '';
  albums.forEach((album, index) => {
    const item = document.createElement('div');
    item.className = 'album-item';

    let icon = '';
    const format = album.format ? album.format.toLowerCase() : '';
    if (format.includes('vinyl') || format.includes('lp') || format.includes('33') || format.includes('45')) {
      icon = '<img src="/albums/icons/vinyl-bw.png" alt="vinyl" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
    } else if (format.includes('cd')) {
      icon = '<img src="/albums/icons/cd-icon.png" alt="cd" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
    } else if (format.includes('k7') || format.includes('cassette')) {
      icon = '<img src="/albums/icons/cassette-icon.png" alt="k7" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
    } else if (format.includes('digital') || format.includes('dg')) {
      icon = '<img src="/albums/icons/digital-icon.png" alt="dg" style="height:18px;width:auto;margin-right:6px;vertical-align:middle;">';
    }

    item.innerHTML = `
      <img src="${album.cover}" alt="${album.title}" style="width:60px;height:60px;border-radius:6px;">
      <div>
        <strong>${album.title}</strong><br>
        <small>${album.year} • ${icon}${album.format || ''}</small>
      </div>
    `;
    item.onclick = () => showAlbum(album, item);
    sidebar.appendChild(item);

    if (index === 0) showAlbum(album, item);
  });
}

renderSidebar(allAlbums);
</script>
</body>
</html>




