<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>B - Artistes & groupes</title>
   <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>

<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES B -->

  
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/106962.jpg" alt="B12"></div>
    <div class="r-details"><div class="r-band"><a href="b12.php">B12</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/102838.jpg" alt="B52"></div>
    <div class="r-details"><div class="r-band"><a href="b-52.php">B52</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3562296b19af8d0fc4799db522485d04/250x250-000000-80-0-0.jpg" alt="B-Wade"></div>
    <div class="r-details"><div class="r-band"><a href="b-wade.php">B-Wade</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/3TmJHfM/folder.jpg" alt="Baba Boogie Band"></div>
    <div class="r-details"><div class="r-band"><a href="baba-boogie-band.php">Baba Boogie Band</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music211/v4/a5/03/43/a503430d-54e3-dcda-38c1-2680cbf8247b/859787736653_cover.jpg/1200x1200bf-60.jpg" alt="Baby1King"></div>
    <div class="r-details"><div class="r-band"><a href="baby1king.php">Baby1King</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/UdXYUiIjJFOTc2ozv5FMrZ3lq1FMcOBBQgh0R1bVZbk/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI5NDY5/MTU3LTE3MDUwODk4/NTEtODQ1Mi5qcGVn.jpeg" alt="Baby Combo"></div>
    <div class="r-details"><div class="r-band"><a href="baby-combo.php">Baby Combo</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/6/1741436393-babootheblackman-album-cover.png" alt="Baboo the blackman"></div>
    <div class="r-details"><div class="r-band"><a href="baboo-the-black-man.php">Baboo the blackman</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02dfc7ec30b837b68eca2cd080" alt="Back Up"></div>
    <div class="r-details"><div class="r-band"><a href="back-up.php">Back Up</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music113/v4/78/42/ec/7842ec5e-14ca-dd2d-a460-8d99c472293e/859735522598_cover.jpg/600x600bf-60.jpg" alt="Badikamall"></div>
    <div class="r-details"><div class="r-band"><a href="badikamall.php">Badikamall</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://ring.cdandlp.com/diaspora/photo_grande/115049778.jpg" alt="Bajy"></div>
    <div class="r-details"><div class="r-band"><a href="bajy.php">Bajy</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105688.jpg" alt="Baker"></div>
    <div class="r-details"><div class="r-band"><a href="baker.php">Baker</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music122/v4/45/0c/47/450c4738-fde8-483c-508d-f6b39b6b83d8/0.jpg/1200x1200bb.jpg" alt="Baky"></div>
    <div class="r-details"><div class="r-band"><a href="baky.php">Baky</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/516SYSN+dDL._UXNaN_FMjpg_QL85_.jpg.jpg" alt="Balans"></div>
    <div class="r-details"><div class="r-band"><a href="balans.php">Balans</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/91QZXZCzqYL._SL1500_.jpg" alt="Banboch"></div>
    <div class="r-details"><div class="r-band"><a href="banboch.php">Banboch</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/102812.jpg" alt="Bandjo"></div>
    <div class="r-details"><div class="r-band"><a href="bandjo.php">Bandjo</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105917.jpg" alt="Barbara Guillaume"></div>
    <div class="r-details"><div class="r-band"><a href="barbara-guillaume.php">Barbara Guillaume</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000077124028-g6hysl-t1080x1080.jpg" alt="Barika Crew"></div>
    <div class="r-details"><div class="r-band"><a href="barikad-crew.php">Barikad Crew</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/5e/72/80/mzi.xqduhzxe.jpg/600x600bf-60.jpg" alt="Baron Black"></div>
    <div class="r-details"><div class="r-band"><a href="baron-black.php">Baron Black</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105240.jpg" alt="Basha"></div>
    <div class="r-details"><div class="r-band"><a href="basha.php">Basha</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music111/v4/57/61/f8/5761f897-327d-a222-1794-3998af772719/859718040583_cover.jpg/1200x1200bb.jpg" alt="BaskerBen"></div>
    <div class="r-details"><div class="r-band"><a href="baskerben.php">Baskerben</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://imageprod.eu-central-1.linodeobjects.com/products/2185790/conversions/6436a74234d8b-lg.jpg" alt="Batako"></div>
    <div class="r-details"><div class="r-band"><a href="batako.php">Batako</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/3851220a0f3eb2f4d04ccd74d86c0b15/1900x1900-000000-80-0-0.jpg" alt="Bato Alaways"></div>
    <div class="r-details"><div class="r-band"><a href="bato-always.php">Bato Always</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/3/1749649096-battle.jpg" alt="Battle Live"></div>
    <div class="r-details"><div class="r-band"><a href="battle-live.php">Battle Live</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61uSexa0kLL._UF1000,1000_QL80_DpWeblab_.jpg" alt="Batwel Rada"></div>
    <div class="r-details"><div class="r-band"><a href="batwel-rada.php">Batwel Rada</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e4dcc6560521f8346d2fe979c4f100b1/250x250-000000-80-0-0.jpg" alt="Baz Bel Tet"></div>
    <div class="r-details"><div class="r-band"><a href="baz-bel-tet.php">Baz Bel Tet</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/tLjGpcp/hqdefault-1.jpg" alt="Bazouka Compas Masters"></div>
    <div class="r-details"><div class="r-band"><a href="bazouka-compas-masters.php">Bazouka Compas Masters</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/106358.jpg" alt="BBTA"></div>
    <div class="r-details"><div class="r-band"><a href="bbta.php">BBTA</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/106507.jpg" alt="Bbwonn Beatz"></div>
    <div class="r-details"><div class="r-band"><a href="bbwonn-beatz.php">Bbwonn Beatz</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103857.jpg" alt="Beat Night Band"></div>
    <div class="r-details"><div class="r-band"><a href="beat-night-band.php">Beat Night Band</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://destinationkompa.info/albums/covers/fritz-pereira-and-his-orchestra-man-smart-woman-smarter.jpg" alt="Bebo Valdés and his Rhythm"></div>
    <div class="r-details"><div class="r-band"><a href="bebo-valdes-and-his-rhythm.php">Bebo Valdés and his Rhythm</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/cyszL42/Cover.jpg" alt="Bee-Zee"></div>
    <div class="r-details"><div class="r-band"><a href="bee-zee.php">Bee-Zee</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/6e0de65035d7e061ed4507aaea6e016b/1900x1900-000000-80-0-0.jpg" alt="Beethova Obas"></div>
    <div class="r-details"><div class="r-band"><a href="beethova-obas.php">Beethova Obas</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/26f74e8773c840b0a829531e57b57fd2/500x500.jpg" alt="Beken"></div>
    <div class="r-details"><div class="r-band"><a href="beken.php">Beken</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/5/1749798515-cover.jpg" alt="Bel"></div>
    <div class="r-details"><div class="r-band"><a href="bel.php">Bel</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music211/v4/4a/79/1a/4a791a11-ec03-9933-5483-b9069d65af90/5975.jpg/1200x1200bb.jpg" alt="Bel and Quinn"></div>
    <div class="r-details"><div class="r-band"><a href="bel-and-quinn.php">Bel and Quinn</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/r3PRrxv/cover.jpg" alt="Bel Atis"></div>
    <div class="r-details"><div class="r-band"><a href="bel-atis.php">Bel Atis</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/9nZ6tDs/BEL-BAZZ-Di-m-sa-vle.jpg" alt="Bel Baz"></div>
    <div class="r-details"><div class="r-band"><a href="bel-baz.php">Bel Baz</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/5/1744931637-beljazz-cover.png" alt="Bel Jazz"></div>
    <div class="r-details"><div class="r-band"><a href="beljazz.php">Bel Jazz</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105535.jpg" alt="Bella"></div>
    <div class="r-details"><div class="r-band"><a href="bella.php">Bella</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103859.jpg" alt="Bellgarde"></div>
    <div class="r-details"><div class="r-band"><a href="bellegarde.php">Bellgarde</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000085815587-ursrg2-t1080x1080.jpg" alt="BelO"></div>
    <div class="r-details"><div class="r-band"><a href="belo.php">BelO</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/z2FYKzR/BEL-PLESI-Virgo.jpg" alt="Bel Plezi"></div>
    <div class="r-details"><div class="r-band"><a href="bel-plezi.php">Bel Plezi</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/cXq37Yx/BEL-REELAX.jpg" alt="Bel Reelax"></div>
    <div class="r-details"><div class="r-band"><a href="bel-reelax.php">Bel Reelax</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/yFVmYqT2/469465267-1086286699954353-3676706764092812316-n.jpg" alt="Bel Vyb"></div>
    <div class="r-details"><div class="r-band"><a href="bel-vyb.php">Bel Vyb</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/104211.jpg" alt="Bemol Jean Telfort"></div>
    <div class="r-details"><div class="r-band"><a href="bemol-jean-telfort.php">Bemol Jean Telfort</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/393799f0dab8548efc178ac4eb71fafe/1900x1900-000000-80-0-0.jpg" alt="Benedict Lamartine"></div>
    <div class="r-details"><div class="r-band"><a href="benedict-lamartine.php">Benedict Lamartine</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/31+988mM8KL._UXNaN_FMjpg_QL85_.jpg" alt="Benjamin Guirand"></div>
    <div class="r-details"><div class="r-band"><a href="benjamin-guirand.php">Benjamin Guirand</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/d2yGZSr/Folder.jpg" alt="Beoty"></div>
    <div class="r-details"><div class="r-band"><a href="beoty.php">Beoty</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/qBsC10M/00-bernabe-lerandy-compas-nati.jpg" alt="Bernabe Lerandy"></div>
    <div class="r-details"><div class="r-band"><a href="bernabe-lerandy.php">Bernabe Lerandy</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/87f2dcaad88de608c1f9dfd048bbcba2/250x250-000000-80-0-0.jpg" alt="Berthold Prophete"></div>
    <div class="r-details"><div class="r-band"><a href="berthold-prophete.php">Berthold Prophete</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/Ttd5GB3/t-l-chargement.jpg" alt="Berthony Pierre-Louis"></div>
    <div class="r-details"><div class="r-band"><a href="berthony-pierre-louis.php">Berthony-Pierre-Louis</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/WGD7FXh/cover.jpg" alt="Best-Joe"></div>
    <div class="r-details"><div class="r-band"><a href="best-joe.php">Best Joe</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/gv6Z6gV/cover.jpg" alt="Bestoo-HAiti"></div>
    <div class="r-details"><div class="r-band"><a href="bestoo-haiti.php">Bestoo-HAiti</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b7f300ce189f1702e6dc12f91c972742/250x250-000000-80-0-0.jpg" alt="Betenson Constant"></div>
    <div class="r-details"><div class="r-band"><a href="betenson-constant.php">Betenson Constant</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/zV8SRJc/BIC.webp" alt="BIC Tizon dife"></div>
    <div class="r-details"><div class="r-band"><a href="bic.php">BIC Tizon dife</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/U8dFz2Xgl8n52NbiAGvPiMlYHA9nxNFdWFixgJrPUFc/rs:fit/g:sm/q:90/h:600/w:588/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU1Mjgz/NTYtMTQ2NjYzMDc1/Ni05NjQzLmpwZWc.jpeg" alt="Bichotte et Les players"></div>
    <div class="r-details"><div class="r-band"><a href="bichotte-et-les-players.php">Bichotte et Les players</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/jzxvT4OJVlyuNdFQ4PT_EDnH-zTdXz0fXHMp-lrEylg/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMwMTUw/MzQ3LTE3MTA5Mjg1/NjctNzQwNC5qcGVn.jpeg" alt="Big-Band-Ulysse"></div>
    <div class="r-details"><div class="r-band"><a href="big-band-ulysse.php">Big Band Ulysse</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105314.jpg" alt="Big Family"></div>
    <div class="r-details"><div class="r-band"><a href="big-family.php">Big Family</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/80aa49e970710fe723141e04389595b7/250x250-000000-80-0-0.jpg" alt="Biggystal"></div>
    <div class="r-details"><div class="r-band"><a href="biggystal.php">Biggystali</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/e4f76e8aa6026855d9da4f8750a467db/250x250-000000-80-0-0.jpg" alt="Big Jim Epi Dat7"></div>
    <div class="r-details"><div class="r-band"><a href="big-jim-epi-dat7.php">Big Jim Epi Dat7</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105736.jpg" alt="Bijoux"></div>
    <div class="r-details"><div class="r-band"><a href="bijoux.php">Bijoux</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/d1/cc/04/d1cc0408-7966-785a-7008-4c5cdc13acad/198003080560.jpg/1200x1200bf-60.jpg" alt="Billy Bills"></div>
    <div class="r-details"><div class="r-band"><a href="billy-bills.php">Billy Bills</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/6Xh7qq8/billy-cover.jpg" alt="Billy Tha Kid"></div>
    <div class="r-details"><div class="r-band"><a href="billy-tha-kid.php">Billy Tha Kid</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/101347.jpg" alt="Bisou"></div>
    <div class="r-details"><div class="r-band"><a href="bisou.php">Bisou</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51DpENaLiKL._UXNaN_FMjpg_QL85_.jpg" alt="Bizi"></div>
    <div class="r-details"><div class="r-band"><a href="bizi.php">Bizi</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/104189.jpg" alt="Biznis"></div>
    <div class="r-details"><div class="r-band"><a href="biznis.php">Biznis</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/105536.jpg" alt="Biznis La"></div>
    <div class="r-details"><div class="r-band"><a href="biznis-la.php">Biznis La</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51pJZtt2r3L._UXNaN_FMjpg_QL85_.jpg" alt="Bizou"></div>
    <div class="r-details"><div class="r-band"><a href="bizou.php">Bizou</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/105922.jpg" alt="Bizz Band"></div>
    <div class="r-details"><div class="r-band"><a href="bizz-band.php">Bizz Band</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/26de6f5ae408d43c6ffd0cdf626b4c7b/250x250-000000-80-0-0.jpg" alt="Bjwes Beatz"></div>
    <div class="r-details"><div class="r-band"><a href="bjwes-beatz.php">Bjwes Beatz</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ_aVqOcGWwvVbHK2_w3f5dvJXtVCmElRD3MQ&s" alt="Black A"></div>
    <div class="r-details"><div class="r-band"><a href="black-a.php">Black A</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000813029083-stm9jt-t1080x1080.jpg" alt="B-Kool"></div>
    <div class="r-details"><div class="r-band"><a href="b-kool.php">B-Kool</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103688.jpg" alt="B-Jay"></div>
    <div class="r-details"><div class="r-band"><a href="b-jay.php">B-Jay</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/5jSwLFb/Design-sans-titre-1.png" alt="Black Alex"></div>
    <div class="r-details"><div class="r-band"><a href="black-alex.php">Black Alex</a></div></div>
</div>

<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5ebf3e261f7caa36f0b7eb0a35b" alt="Black Boy Haiti"></div>
    <div class="r-details"><div class="r-band"><a href="black-boy-haiti.php">Black Boy Haiti</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/NYL0CRn/hqdefault.jpg" alt="Black-Eleven"></div>
    <div class="r-details"><div class="r-band"><a href="black-eleven.php">Black Eleven</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a4533742c5583eeee7704d6f82efe3a8/250x250-000000-80-0-0.jpg" alt="Black-Eleven"></div>
    <div class="r-details"><div class="r-band"><a href="black-leaders.php">Black Leaders</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100059.jpg" alt="Black Magic Band"></div>
    <div class="r-details"><div class="r-band"><a href="black-magic-band.php">Black Magic Band</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/104676.jpg" alt="Black MP Well"></div>
    <div class="r-details"><div class="r-band"><a href="black-mp-well.php">Black MP Well</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100060.jpg" alt="Black Original"></div>
    <div class="r-details"><div class="r-band"><a href="black-original.php">Black Original</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/4/1749761755-achiv-album-cover.jpg" alt="Black Parents"></div>
    <div class="r-details"><div class="r-band"><a href="black-parents.php">Black Parents</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/KSsbEl2H0E3HluINuLty7GNjsMFdiwVRXFVw_2yLEXo/rs:fit/g:sm/q:90/h:600/w:598/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc5NTgz/MDctMTQ1MjQyOTUy/Mi0yMTIzLmpwZWc.jpeg" alt="Black-People-d-Ha�ti"></div>
    <div class="r-details"><div class="r-band"><a href="black-people-d-haiti.php">Black People D''Haiti</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100061.jpg" alt="Black Shu Shu"></div>
    <div class="r-details"><div class="r-band"><a href="black-shu-shu.php">Black Shu Shu</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/ZzbsSxL/Cover-Blaise.jpg" alt="Blaise"></div>
    <div class="r-details"><div class="r-band"><a href="blaise.php">Blaise</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51oNLf0ZQlL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Blaze One"></div>
    <div class="r-details"><div class="r-band"><a href="blaze-one.php">Blaze One</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2736b22dabc16e4730356c17994" alt="Blokos"></div>
    <div class="r-details"><div class="r-band"><a href="blokos.php">Blokos</a></div></div>
</div>

<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/104987.jpg" alt="Blondy The Prince Lover"></div>
    <div class="r-details"><div class="r-band"><a href="blondy-the-prince-lover.php">Blondy The Prince Lover</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/artist/8eb7c105778393ffe88a5da7174db73c/1900x1900-000000-80-0-0.jpg" alt="BMNEY"></div>
    <div class="r-details"><div class="r-band"><a href="bmney.php">BMNEY</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music128/v4/29/5c/f0/295cf0d3-02bf-df95-425c-88e602ae54d4/888295720540.jpg/486x486bb.png" alt="Bo Billion & John Magik"></div>
    <div class="r-details"><div class="r-band"><a href="bo-billion.php">Bo Billion & John Magik</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2733dab5a60bdfbe69882954661" alt="Bob-Bovano"></div>
    <div class="r-details"><div class="r-band"><a href="bob-bovano.php">Bob Bovano</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/95cc55d3cbb5f38d4fe45e11e3646930/1900x1900-000000-80-0-0.jpg" alt="BOB CaillouX"></div>
    <div class="r-details"><div class="r-band"><a href="bob-cailloux.php">BOB CaillouX</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61RNkFnXrCL._UXNaN_FMjpg_QL85_.jpg" alt="Boddhi Satva"></div>
    <div class="r-details"><div class="r-band"><a href="boddhi-satva.php">Boddhi Satva</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51WwYdFxiOL._UXNaN_FMjpg_QL85_.jpg" alt="Bohio Music"></div>
    <div class="r-details"><div class="r-band"><a href="bohio-music.php">Bohio Music</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/822CZFaVAaYPdp5rp5i5Nzg2cM54a31Xrs2ZG1y8sHc/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc1NDM1/NDItMTQ0MzY2MTg2/NC0xODgwLmpwZWc.jpeg" alt="Bon Bagay Band"></div>
    <div class="r-details"><div class="r-band"><a href="bon-bagay-band.php">Bon Bagay Band</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/KbMxJNB/0-Boogiboul-Nou-Sanble.jpg" alt="Boogiboul"></div>
    <div class="r-details"><div class="r-band"><a href="boogiboul.php">Boogiboul</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/21+u9IL9PyL._UF1000,1000_QL80_.jpg" alt="Bonga"></div>
    <div class="r-details"><div class="r-band"><a href="bonga.php">Bonga</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/y2005/m03/d07/h22/s05.dgddiqnz.jpg/600x600bf-60.jpg" alt="Bonnie Devlin"></div>
    <div class="r-details"><div class="r-band"><a href="bonnie-devlin.php">Bonnie Devlin</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://destinationkompa.info/albums/covers/born-haitian-them-a-fool.jpg" alt="Born Haitian"></div>
    <div class="r-details"><div class="r-band"><a href="born-haitian.php">Born Haitian</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/bgkTpCK/Design-sans-titre-3.png" alt="Bossa Combo"></div>
    <div class="r-details"><div class="r-band"><a href="bossa-combo.php">Bossa Combo</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/BgjLdnj/Boss-Micko-Padone-M.jpg" alt="Boss-Micko"></div>
    <div class="r-details"><div class="r-band"><a href="boss-micko.php">Boss Micko</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Boss Harry"></div>
    <div class="r-details"><div class="r-band"><a href="boss-harry.php">Boss Harry</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i0.wp.com/worldmusiccentral.org/wp-content/uploads/Boukan_Ginen_Stephen_Homer.jpg?fit=500%2C425&ssl=1" alt="Boukan Ginen"></div>
    <div class="r-details"><div class="r-band"><a href="boukan-ginen.php">Boukan Ginen</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c5b6a05e5967d8703adf9e9790e91969/0x1900-000000-80-0-0.jpg" alt="Boukman Eksperyans"></div>
    <div class="r-details"><div class="r-band"><a href="boukman-eksperyans.php">Boukman Eksperyans</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/1e33a24c0a81ec7704e1a170ac42edc2/1900x1900-000000-80-0-0.jpg" alt="Boulo Valcourt"></div>
    <div class="r-details"><div class="r-band"><a href="boulo-valcourt.php">Boulo Valcourt</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.lusafrica.com/wp-content/uploads/2018/08/boulpik-album.jpg" alt="Boulpik"></div>
    <div class="r-details"><div class="r-band"><a href="boulpik.php">Boulpik</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/95dbdbae5867c544051b00dc14666106/500x500.jpg" alt="Bourik The Latalay"></div>
    <div class="r-details"><div class="r-band"><a href="bourik-the-latalay.php">Bourik The Latalay</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/101173.jpg" alt="Bout Tonton"></div>
    <div class="r-details"><div class="r-band"><a href="bout-tonton.php">Bout Tonton</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273c28ea098697a8b0d31245d65" alt="Breaker Beatz"></div>
    <div class="r-details"><div class="r-band"><a href="breaker-beatz.php">Breaker Beatz</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/82/47/53/82475313-6cce-ceae-5d1a-54e9e2b50f78/artwork.jpg/600x600bf-60.jpg" alt="Bref Intellect"></div>
    <div class="r-details"><div class="r-band"><a href="bref-intellect.php">Bref Intellect</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/kMqVr7j/B-R-O-Artists-Cover.jpg" alt="B-R-O Artists"></div>
    <div class="r-details"><div class="r-band"><a href="b-r-o-artists.php">B-R-O Artists</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51nbO0cHx-L._UXNaN_FMjpg_QL85_.jpg" alt="Brother Jay"></div>
    <div class="r-details"><div class="r-band"><a href="brother-jay.php">Brother Jay</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000016998063-cv0opt-t500x500.jpg" alt="Brothers Posse"></div>
    <div class="r-details"><div class="r-band"><a href="brothers-posse.php">Brothers Posse</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f9a397ac8e2f97f35fb9abb284c98350/250x250-000000-80-0-0.jpg" alt="Bujimix"></div>
    <div class="r-details"><div class="r-band"><a href="bujimix.php">Bujimix</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273571cce6253fa50357e53b40e" alt="Buyu-Ambroise"></div>
    <div class="r-details"><div class="r-band"><a href="buyu-ambroise.php">Buyu Ambroise</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/100092.jpg" alt="Buzz International"></div>
    <div class="r-details"><div class="r-band"><a href="buzz-international.php">Buzz International</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://coverartarchive.org/release/af8e8ec7-da17-4856-ab3b-b75f9df3131d/37213656725.jpg" alt="Bwakore"></div>
    <div class="r-details"><div class="r-band"><a href="bwakore.php">Bwakore</a></div></div>
</div>

<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/4/1749737305-achiv-album-cover.jpg" alt="BZ From New Jersey"></div>
    <div class="r-details"><div class="r-band"><a href="bz-from-new-jersey.php">BZ From New Jersey</a></div></div>
</div>



<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>
