<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>C- Artistes & groupes</title>
   <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>

<!-- Liste verticale des albums -->
<div class="album-list">

<!-- TOUS LES ARTISTES C -->

<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/1/1751301387-c-rom.jpg" alt="C-Rom"></div>
    <div class="r-details"><div class="r-band"><a href="c-rom.php">C-Rom</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/u0mBtvwDyXXOQzGOc8lzVPQGmqzoND_qSaMUEoBw3m0/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE2NjI3/NDMtMTIzNTMyODI5/Ny5qcGVn.jpeg" alt="C.C. All Stars"></div>
    <div class="r-details"><div class="r-band"><a href="c-c-all-stars.php">C.C. All Stars</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/468f69c8b4bb875dc10a9574415ae165/250x250-000000-80-0-0.jpg" alt="C2J"></div>
    <div class="r-details"><div class="r-band"><a href="c2j.php">C2J</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/1/1751301419-folder.jpg" alt="Cad Performing Arts & Cultural Group"></div>
    <div class="r-details"><div class="r-band"><a href="cad-performing-arts-cultural-group.php">Cad Performing Arts & Cultural Group</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/3/1750859555-cover.jpg" alt="Cadeau Star"></div>
    <div class="r-details"><div class="r-band"><a href="cadeau-star.php">Cadeau Star</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/3/1750859108-cade-album-cover.png" alt="Cadelouse"></div>
    <div class="r-details"><div class="r-band"><a href="cadelouse.php">Cadelouse</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSg0WmCFwTuI08JObZ2yom0yIOLq2MjkT2zYg&s" alt="Camille Coco"></div>
    <div class="r-details"><div class="r-band"><a href="camille-coco.php">Camille Coco</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://img.discogs.com/5YKX1YRHd-rg5sw5FWs0xiJBft8=/fit-in/590x600/filters:strip_icc():format(jpeg):mode_rgb():quality(90)/discogs-images/R-7233967-1436779715-7358.jpeg.jpg" alt="Cap All Stars Heritage Compas"></div>
    <div class="r-details"><div class="r-band"><a href="cap-all-stars-heritage-compas.php">Cap All Stars Heritage Compas</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music3/v4/80/c8/a3/80c8a33f-9e0d-bebc-cc23-ecd4121f9358/cover.jpg/1200x1200bb.jpg" alt="Capricone All Stars De Gertho"></div>
    <div class="r-details"><div class="r-band"><a href="capricone-all-stars-de-gertho.php">Capricone All Stars De Gertho</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/bbtWmsARjEmZGXCOQth71UYaqIUbKb4mAiP0iqnVACw/rs:fit/g:sm/q:90/h:570/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTg0MDgy/MzUtMTQ2MTAxODIz/MS0xMDU2Lm1wbw.jpeg" alt="Cara�bes-Systemso"></div>
    <div class="r-details"><div class="r-band"><a href="caraibes-systems.php">Caraibes-Systems</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/103303.jpg" alt="Caribbean All Stars"></div>
    <div class="r-details"><div class="r-band"><a href="caribbean-all-stars.php">Caribbean All Stars</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/106351.jpg" alt="Caribbean Masters"></div>
    <div class="r-details"><div class="r-band"><a href="caribbean-masters.php">Caribbean Masters</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100104.jpg" alt="Caribbean Sextet"></div>
    <div class="r-details"><div class="r-band"><a href="caribbean-sextet.php">Caribbean Sextet</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100107.jpg" alt="Caribbean Stars"></div>
    <div class="r-details"><div class="r-band"><a href="caribbean-stars.php">Caribbean Stars</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/104953.jpg" alt="Carillon Des Jeunes"></div>
    <div class="r-details"><div class="r-band"><a href="carillon-des-jeunes.php">Carillon Des Jeunes</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/881cc043e882ee8b0ab854b3ba78635b/1900x1900-000000-80-0-0.jpg" alt="Carimi"></div>
    <div class="r-details"><div class="r-band"><a href="carimi.php">Carimi</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/103861.jpg" alt="Carline Pierre Bartley"></div>
    <div class="r-details"><div class="r-band"><a href="carline-pierre-bartley.php">Carline Pierre Bartley</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/106121.jpg" alt="Carlo Placide and Rolard Ligonde"></div>
    <div class="r-details"><div class="r-band"><a href="carlo-placide-and-rolard-ligonde.php">Carlo Placide and Rolard Ligonde</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/104106.jpg" alt="Carlton Rara"></div>
    <div class="r-details"><div class="r-band"><a href="carlton-rara.php">Carlton Rara</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/100111.jpg" alt="Carole Demesmin"></div>
    <div class="r-details"><div class="r-band"><a href="carole-demesmin.php">Carole Demesmin</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e021ac9dd96d7f424e6357fb536" alt="Carolina-Marius"></div>
    <div class="r-details"><div class="r-band"><a href="carolina-marius.php">Carolina-Marius</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749871260-achiv-album-cover.jpg" alt="Cash K Dance"></div>
    <div class="r-details"><div class="r-band"><a href="cash-k-dance.php">Cash-K-Dance</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/103181.jpg" alt="Casley"></div>
    <div class="r-details"><div class="r-band"><a href="casley.php">Casley</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51npFcgcP1L._UXNaN_FMjpg_QL85_.jpg" alt="Cassandra Momplaisir"></div>
    <div class="r-details"><div class="r-band"><a href="cassandra-momplaisir.php">Cassandra Momplaisir</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/19/4/1746734304-cd-d-or-bel-atis.jpg" alt="CD D'or Bel Atis"></div>
    <div class="r-details"><div class="r-band"><a href="cd-d-or-bel-atis.php">CD D'or Bel Atis</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/219b4282f51726092bc9446b3679ab18/1900x1900-000000-80-0-0.jpg" alt="Cedric Chevignac"></div>
    <div class="r-details"><div class="r-band"><a href="cedric-chevignac.php">Cedric Chevignac</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100114.jpg" alt="Celestar Orchestra"></div>
    <div class="r-details"><div class="r-band"><a href="celestar-orchestra.php">Celestar Orchestra</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6923c9c6f90d753aabeaf26875c30e99/250x250-000000-80-0-0.jpg" alt="Celigny Dathus "></div>
    <div class="r-details"><div class="r-band"><a href="celigny-dathus.php">Celigny Dathus</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/106031.jpg" alt="Celimene Daudet"></div>
    <div class="r-details"><div class="r-band"><a href="celimene-daudet.php">Celimene Daudet</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2732229261e01dd8419a60e04ed" alt="Chadet-Charles"></div>
    <div class="r-details"><div class="r-band"><a href="chadet-charles.php">Chadet Charles</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2733b07fb1ebc1c8c2ebf4a487d" alt="Chaj Vokal"></div>
    <div class="r-details"><div class="r-band"><a href="chaj-vokal.php">Chaj Vokal</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103620.jpg" alt="Chale Mizik"></div>
    <div class="r-details"><div class="r-band"><a href="chale-mizik.php">Chale Mizik</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/101481.jpg" alt="Chandel"></div>
    <div class="r-details"><div class="r-band"><a href="chandel.php">Chandel</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music113/v4/01/a0/66/01a06623-5f82-ece5-49c2-96a3100531a7/859722584141_cover.jpg/600x600bf-60.jpg" alt="Chango"></div>
    <div class="r-details"><div class="r-band"><a href="chango.php">Chango</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100115.jpg" alt="Channel 10"></div>
    <div class="r-details"><div class="r-band"><a href="channel-10.php">Channel 10</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/102763.jpg" alt="Chansons-D-Amour"></div>
    <div class="r-details"><div class="r-band"><a href="chansons-d-amour.php">Chansons D'Amourk</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.ibb.co/pXD7C6P/Chantale-Laurent-Defile.png" alt="Chantale-Laurent"></div>
    <div class="r-details"><div class="r-band"><a href="chantale-laurent.php">Chantale Laurent</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749871260-achiv-album-cover.jpg" alt="Chantons-Noel"></div>
    <div class="r-details"><div class="r-band"><a href="chantons-noel.php">Chantons Noel</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2738016ef2840850b26a076f905" alt="Chardavoine"></div>
    <div class="r-details"><div class="r-band"><a href="chardavoine.php">Chardavoine</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/whs_Psa87D57_MTPLk6KHqel6wJ71hCmI9Pcmhwd-F0/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI1MDEz/NjkyLTE2NjcyOTA5/MDEtMzE1NS5qcGVn.jpeg" alt="Charlemagre Pierre-Noel"></div>
    <div class="r-details"><div class="r-band"><a href="charlemagre-pierre-noel.php">Charlemagre Pierre-Noel</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/100122.jpg" alt="Charles Adolphe"></div>
    <div class="r-details"><div class="r-band"><a href="charles-adolphe.php">Charles Adolphe</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/vsXY4iqmucC3dDpOogoPnNpnyu6ydk6e77an6ev9zDw/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU0Mzc3/MTYtMTM5MzM0NzQ5/Ni0xNzM2LmpwZWc.jpeg" alt="Charles Dessalines"></div>
    <div class="r-details"><div class="r-band"><a href="charles-dessalines.php">Charles Dessalines</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.discogs.com/5poUY3-G21ozP_vxDnQbreEGsZTPaUhdK8N-ZHmaVcw/rs:fit/g:sm/q:90/h:600/w:587/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTExNzA3/OTU4LTE1MjEwMjA0/NjMtNTEyOS5qcGVn.jpeg" alt="Charles Jean"></div>
    <div class="r-details"><div class="r-band"><a href="charles-jean.php">Charles Jean</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61LC7nRsnfL._UXNaN_FMjpg_QL85_.jpg" alt="Charles Masner Flow"></div>
    <div class="r-details"><div class="r-band"><a href="charles-masner-flow.php">Charles Masner Flow</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://pbs.twimg.com/profile_images/378800000233684665/2f4ff1436d30a766181305c8f417199e_400x400.jpeg" alt="Charlie Paulle"></div>
    <div class="r-details"><div class="r-band"><a href="charlie-paulle.php">Charlie Paulle</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749858588-charlin.jpg" alt="Charlin Bato"></div>
    <div class="r-details"><div class="r-band"><a href="charlin-bato.php">Charlin Bato</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749858201-album-cover.jpg" alt="Charline Victor"></div>
    <div class="r-details"><div class="r-band"><a href="charline-victor.php">Charline Victor</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51NglI0ORcL._UXNaN_FMjpg_QL85_.jpg" alt="Charlot & Suspense"></div>
    <div class="r-details"><div class="r-band"><a href="charlot-suspense.php">Charlot & Suspense</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/103816.jpg" alt="Charlot Lucien"></div>
    <div class="r-details"><div class="r-band"><a href="charlot-lucien.php">Charlot Lucien</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/100126.jpg" alt="Charly Mike-Bass"></div>
    <div class="r-details"><div class="r-band"><a href="charly-mike-bass.php">Charly Mike-Bass</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/1/1751301281-103863.jpg" alt="Chavanne Clerveaux"></div>
    <div class="r-details"><div class="r-band"><a href="chavanne-clerveaux.php">Chavanne Clerveaux</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/1/1751299766-cover.jpg" alt="Chef Dupond"></div>
    <div class="r-details"><div class="r-band"><a href="chef-dupond.php">Chef Dupond</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100127.jpg" alt="Chery System"></div>
    <div class="r-details"><div class="r-band"><a href="chery-system.php">Chery System</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.dailysplace.com/assets/img/DailysPlace_582x516-ed9d3fa531.jpg" alt="Chicago"></div>
    <div class="r-details"><div class="r-band"><a href="chicago.php">Chicago</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/1/1751301197-cover.jpg" alt="Chill de Jude Jean"></div>
    <div class="r-details"><div class="r-band"><a href="chill-de-jude-jean.php">Chill de Jude Jean</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/1/1751301225-cover.jpg" alt="Chill Konpa"></div>
    <div class="r-details"><div class="r-band"><a href="chill-konpa.php">Chill Konpa</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/e4e2e085839b01d54e10bc8e723f8948/1900x1900-000000-80-0-0.jpg" alt="Choeur D-Hommes Adventistes du Cap-Ha�tien"></div>
    <div class="r-details"><div class="r-band"><a href="choeur-d-hommes-adventistes-du-cap-haitien.php">Choeur D-Hommes Adventistes du Cap-Ha�tien</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103476.jpg" alt="Choeur Voix et Harmonie"></div>
    <div class="r-details"><div class="r-band"><a href="choeur-voix-et-harmonie.php">Choeur Voix et Harmonie</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0121cfea9ee47cfa87b538f6bec708ac/250x250-000000-80-0-0.jpg" alt="Chorale Deg"></div>
    <div class="r-details"><div class="r-band"><a href="chorale-deg.php">Chorale Deg</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/101339.jpg" alt="Chouchou Du Nordest"></div>
    <div class="r-details"><div class="r-band"><a href="chouchou-du-nordest.php">Chouchou Du Nordest</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/106375.jpg" alt="Chouk Bwa Libete"></div>
    <div class="r-details"><div class="r-band"><a href="chouk-bwa-libete.php">Chouk Bwa Libete</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/103640.jpg" alt="Chris Bazile"></div>
    <div class="r-details"><div class="r-band"><a href="chris-bazile.php">Chris Bazile</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51okGRaMlJL._UXNaN_FMjpg_QL85_.jpg" alt="Chris Morning"></div>
    <div class="r-details"><div class="r-band"><a href="chris-morning.php">Chris Morning</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.withguitars.com/wp-content/uploads/2021/05/Freedom-2021-promo-1a-859x639.jpg" alt="Christopher Laroche"></div>
    <div class="r-details"><div class="r-band"><a href="christopher-laroche.php">Christopher Laroche</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/85/65/6d/85656dcd-3405-90d1-d89a-cf25f7b474e7/859781107169_cover.jpg/1200x1200bf-60.jpg" alt="Chwa'm"></div>
    <div class="r-details"><div class="r-band"><a href="chwa-m.php">Chwa'm</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/b250e06fccf699208425c92128008e93/500x500.jpg" alt="Cie Bazou"></div>
    <div class="r-details"><div class="r-band"><a href="cie-bazou.php">Cie Bazou</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103259.jpg" alt="Cinna O Charles"></div>
    <div class="r-details"><div class="r-band"><a href="cinna-o-charles.php">Cinna O Charles</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103638.jpg" alt="Cisco The Batch & 911 Kompa"></div>
    <div class="r-details"><div class="r-band"><a href="cisco-the-batch-911-kompa.php">Cisco The Batch & 911 Kompa</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000517495a17a197ead391e4448e9b7" alt="Ciyou Paradoks"></div>
    <div class="r-details"><div class="r-band"><a href="ciyou-paradoks.php">Ciyou-Paradoks</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/98f596cf392d2e652af8808d82b17134/250x250-000000-80-0-0.jpg" alt="Claude & Lea"></div>
    <div class="r-details"><div class="r-band"><a href="claude-lea.php">Claude & Lea</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/104613.jpg" alt="Claude Desgrottes"></div>
    <div class="r-details"><div class="r-band"><a href="claude-desgrottes.php">Claude Desgrottes</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/41a14281c4f265d09ca5e84d77ae2816/250x250-000000-80-0-0.jpg" alt="Claude Louissaint"></div>
    <div class="r-details"><div class="r-band"><a href="claude-louissaint.php">Claude Louissaint</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/ab75fae0466e387bcd7f8f009c135710/250x250-000000-80-0-0.jpg" alt="Claude Marcelin"></div>
    <div class="r-details"><div class="r-band"><a href="claude-marcelin.php">Claude Marcelin</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/102764.jpg" alt="Claude Montreuil"></div>
    <div class="r-details"><div class="r-band"><a href="claude-montreuil.php">Claude Montreuil</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105996.jpg" alt="Claude Valbrun"></div>
    <div class="r-details"><div class="r-band"><a href="claude-valbrun.php">Claude Valbrun</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100149.jpg" alt="Claudette et Ti Pierre"></div>
    <div class="r-details"><div class="r-band"><a href="claudette-et-ti-pierre.php">Claudette et Ti Pierre</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273453500429c6722dfd2d657f1" alt="Clayband5"></div>
    <div class="r-details"><div class="r-band"><a href="clayband5.php">Clayband5</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/102913.jpg" alt="Cleona Pierre"></div>
    <div class="r-details"><div class="r-band"><a href="cleona-pierre.php">Cleona Pierre</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJ-PlvlDsDSZj-51rsRYgLm5nK2Yc9vRqu8w&s" alt="Clinton Benoit"></div>
    <div class="r-details"><div class="r-band"><a href="clinton-benoit.php">Clinton Benoit</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/105764.jpg" alt="Colette Jacques"></div>
    <div class="r-details"><div class="r-band"><a href="colette-jacques.php">Colette Jacques</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/101337.jpg" alt="Combit Creole"></div>
    <div class="r-details"><div class="r-band"><a href="combit-creole.php">Combit Creole</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/102345.jpg" alt="Combite Express"></div>
    <div class="r-details"><div class="r-band"><a href="combite-express.php">Combite Express</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/100166.jpg" alt="Combo Creole de Dodof"></div>
    <div class="r-details"><div class="r-band"><a href="combo-creole-de-dodof.php">Combo Creole de Dodof</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/b5/3a/41/b53a41c2-57cb-0cca-71b1-c323231c4e9b/859749551393_cover.jpg/1200x1200bf-60.jpg" alt="Compalogie"></div>
    <div class="r-details"><div class="r-band"><a href="compalogie.php">Compalogie</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/images_produits/ZoomPE/0/2/2/3433190603220/tsp20130831190921/Compas-djet-voumel-2.jpg" alt="Compas-D-jet-Amelie"></div>
    <div class="r-details"><div class="r-band"><a href="compas-d-jet-amelie.php">Compas D'jet Amelie</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/102761.jpg" alt="Compas Express"></div>
    <div class="r-details"><div class="r-band"><a href="compas-express.php">Compas Express</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/101337.jpg" alt="Compas-Mamba-de-Ti-Guy"></div>
    <div class="r-details"><div class="r-band"><a href="compas-mamba-de-ti-guy.php">Compas Mamba de Ti-Guy</a></div></div>
</div>

<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/3/1751443021-compas-plus-band.jpg" alt="Compas Plus Band"></div>
    <div class="r-details"><div class="r-band"><a href="compas-plus-band.php">Compas Plus Band</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTJBsxHM8CYbQ9PdcNpTbi92s7aL7ynC3g7Dw&s" alt="Comsel-Crew"></div>
    <div class="r-details"><div class="r-band"><a href="comsel-crew.php">Comsel-Crew</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103078.jpg" alt="Connection Toto Necessite et Les Doyens"></div>
    <div class="r-details"><div class="r-band"><a href="connection-toto-necessite-et-les-doyens.php">Connection Toto Necessite et Les Doyens</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://fr.shopping.rakuten.com/photo/1090050587_L.jpg" alt="Cosmos-97"></div>
    <div class="r-details"><div class="r-band"><a href="cosmos-97.php">Cosmos-97</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/106653.jpg" alt="Couloute Andre Manes"></div>
    <div class="r-details"><div class="r-band"><a href="couloute-andre-manes.php">Couloute Andre Manes</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/27/3/1751442229-coupe-cover.jpg" alt="Coupé Cloué"></div>
    <div class="r-details"><div class="r-band"><a href="coupe-cloue.php">Coupé Cloué</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/5/1749839410-coupe.png" alt="Coupe Cloue Jr"></div>
    <div class="r-details"><div class="r-band"><a href="coupe-cloue-jr.php">Coupé Cloué Jr</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27394c34d7869478df2d4dffdbb" alt="Creolemix"></div>
    <div class="r-details"><div class="r-band"><a href="creolemix.php">Creolemix</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273a13858573fd31ac4ccbc1711" alt="Cruz La"></div>
    <div class="r-details"><div class="r-band"><a href="cruz-la.php">Cruz La</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/104546.jpg" alt="Crystal Secure"></div>
    <div class="r-details"><div class="r-band"><a href="crystal-secure.php">Crysteal Secure</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/104610.jpg" alt="Cubano"></div>
    <div class="r-details"><div class="r-band"><a href="cubano.php">Cubano</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/preview-75/103184.jpg" alt="Curve"></div>
    <div class="r-details"><div class="r-band"><a href="curve.php">Curve</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://www.konpa.info/cover-300/103008.jpg" alt="Cyclone"></div>
    <div class="r-details"><div class="r-band"><a href="cyclone.php">Cyclone</a></div></div>
</div>
<div class="album-item">
    <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749871260-achiv-album-cover.jpg" alt="Cytise"></div>
    <div class="r-details"><div class="r-band"><a href="cytise.php">Cytise</a></div></div>
</div>

</div>

<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>
