<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>D - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>

<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES D -->
  <div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104438.jpg" alt="D-Blozay"></div>
  <div class="r-details"><div class="r-band"><a href="d-blozay.php">D-Blozay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/01/24/865a52a14a8a4c9a8699a48241f0da94_464_464.jpg" alt="D-Colight"></div>
  <div class="r-details"><div class="r-band"><a href="d-colight.php">D-Colight</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/50e2016b52cc66b3245faa8e1c312d5f/1900x1900-000000-80-0-0.jpg" alt="D-FI Powèt Revòlte"></div>
  <div class="r-details"><div class="r-band"><a href="d-fipowètrevòlte.php">D-FI Powèt Revòlte</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103408.jpg" alt="DD Santana"></div>
  <div class="r-details"><div class="r-band"><a href="dd.php">DD Santana</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105543.jpg" alt="D-Luz"></div>
  <div class="r-details"><div class="r-band"><a href="d-lux.php">D-Luz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41F79IP0hFL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="D-Singer"></div>
  <div class="r-details"><div class="r-band"><a href="d-singer.php">D-Singer</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101490.jpg" alt="Daan Junior"></div>
  <div class="r-details"><div class="r-band"><a href="daan-junior.php">Daan Junior</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/5679cae00a12a5b75951585d95bc5437/1900x1900-000000-80-0-0.jpg" alt="Dadi Beaubruny"></div>
  <div class="r-details"><div class="r-band"><a href="dadi-beaubrun.php">Dadi Beaubrun</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100681.jpg" alt="Dadou Pasquet"></div>
  <div class="r-details"><div class="r-band"><a href="dadou-pasquet.php">Dadou Pasquet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106190.jpg" alt="Daniel Bellegarde"></div>
  <div class="r-details"><div class="r-band"><a href="daniel-bellegarde.php">Daniel Bellegarde</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music125/v4/1f/d3/69/1fd369a1-71f8-95c2-1523-98bf7466b857/195999661070.jpg/1200x1200bf-60.jpg" alt="Daniel Joseph Et Les Cherubinse"></div>
  <div class="r-details"><div class="r-band"><a href="danieljosephetlescherubins.php">Daniel Joseph Et Les Cherubins</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/850f0c243f8cb5c47fd28269fc232968/250x250-000000-80-0-0.jpg" alt="Daniel Lariviere"></div>
  <div class="r-details"><div class="r-band"><a href="daniel-lariviere.php">Daniel Lariviere</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/956b2759426622c09d1a983ce8111d6f/250x250-000000-80-0-0.jpg" alt="Daniel Coulanges"></div>
  <div class="r-details"><div class="r-band"><a href="danielcoulanges.php">Daniel Coulanges</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100244.jpg" alt="Danielle Thermidor"></div>
  <div class="r-details"><div class="r-band"><a href="danielle-thermidor.php">Danielle Thermidor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106661.jpg" alt="Danny Deshlon"></div>
  <div class="r-details"><div class="r-band"><a href="danny-deshlon.php">Danny Deshlon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music122/v4/e5/2c/3c/e52c3c2c-a54f-6a69-a4db-d328a119658d/3610156615040_cover.jpg/486x486bb.png" alt="Danny Desplan"></div>
  <div class="r-details"><div class="r-band"><a href="danny-desplan.php">Danny Desplan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51fU5136fqL._UXNaN_FMjpg_QL85_.jpg" alt="Danny Salomon"></div>
  <div class="r-details"><div class="r-band"><a href="dannysalomon.php">Danny Salomon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103867.jpg" alt="Dany"></div>
  <div class="r-details"><div class="r-band"><a href="dany.php">Dany</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101845.jpg" alt="Danzon By Six"></div>
  <div class="r-details"><div class="r-band"><a href="danzonbysix.php">Danzon By Six</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104238.jpg" alt="Damballa Wèdo Singers"></div>
  <div class="r-details"><div class="r-band"><a href="damballawedosingers.php">Damballa Wèdo Singers</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102394.jpg" alt="Darbens with Laraj"></div>
  <div class="r-details"><div class="r-band"><a href="darbens-with-laraj.php">Darbens with Laraj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273baa365e958e54d8bf246d8d4" alt="Darline Desca"></div>
  <div class="r-details"><div class="r-band"><a href="darline-desca.php">Darline Desca</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/5h0d7120/DAT-CD.png" alt="Dat7"></div>
  <div class="r-details"><div class="r-band"><a href="dat7.php">Dat7</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3842a0e448d0d1ea0bfe97328fa40250/250x250-000000-80-0-0.jpg" alt="Dave Casseus"></div>
  <div class="r-details"><div class="r-band"><a href="davecasseus.php">Dave Casseus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273b87a835b372ea3e7c080e905" alt="Dave Mackenro"></div>
  <div class="r-details"><div class="r-band"><a href="davemackenro.php">Dave Mackenro</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105853.jpg" alt="David Bontemps"></div>
  <div class="r-details"><div class="r-band"><a href="david-bontemps.php">David Bontemps</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/3/1741199046-cover.jpg" alt="David Dorméus"></div>
  <div class="r-details"><div class="r-band"><a href="david-dormeus.php">David Dorméus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103007.jpg" alt="David Sextet"></div>
  <div class="r-details"><div class="r-band"><a href="david-sextet.php">David Sextet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a8306492fa2c63c0118582c534ea2c24/250x250-000000-80-0-0.jpg" alt="DDKeyz"></div>
  <div class="r-details"><div class="r-band"><a href="ddkeyz.php">DDKeyz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106576.jpg" alt="Dee End"></div>
  <div class="r-details"><div class="r-band"><a href="dee-end.php">Dee End</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/3/1742946828-d-f-fondamantal.png" alt="Dèf Fondamantal"></div>
  <div class="r-details"><div class="r-band"><a href="def-fondamantal.php">Dèf Fondamantal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101494.jpg" alt="Dega"></div>
  <div class="r-details"><div class="r-band"><a href="dega.php">Dega</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102364.jpg" alt="Degree"></div>
  <div class="r-details"><div class="r-band"><a href="degree.php">Degree</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102005.jpg" alt="Dekwochay"></div>
  <div class="r-details"><div class="r-band"><a href="dekwochay.php">Dekwochay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61yzxY5BU0L._UXNaN_FMjpg_QL85_.jpg" alt="Delaindse Leon"></div>
  <div class="r-details"><div class="r-band"><a href="delaindseleon.php">Delaindse Leon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104587.jpg" alt="Delly"></div>
  <div class="r-details"><div class="r-band"><a href="delly.php">Delly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-yQorWs7B7mOXYYrS-akzV5A-t500x500.jpg" alt="Delly Benson"></div>
  <div class="r-details"><div class="r-band"><a href="dellybenson.php">Delly Benson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8b78618f671a41faa7b078ac2a0bffe3/250x250-000000-80-0-0.jpg" alt="Denera Marie Ange"></div>
  <div class="r-details"><div class="r-band"><a href="denera-marie-ange.php">Denera Marie Ange</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/510PpKc3Z+L._UXNaN_FMjpg_QL85_.jpg" alt="Denise H. Carrié"></div>
  <div class="r-details"><div class="r-band"><a href="denisehcarrie.php">Denise H. Carrié</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/a3/29/27/a32927be-2cfd-457d-37db-d63c7cae7fd2/859766161773_cover.jpg/486x486bb.png" alt="Dersnt Emile"></div>
  <div class="r-details"><div class="r-band"><a href="dernstemile.php">Dersnt Emile</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103009.jpg" alt="Delta Force Compas"></div>
  <div class="r-details"><div class="r-band"><a href="delta-force-compas.php">Delta Force Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100248.jpg" alt="Detour"></div>
  <div class="r-details"><div class="r-band"><a href="detour.php">Detour</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102128.jpg" alt="Deutz DHaiti"></div>
  <div class="r-details"><div class="r-band"><a href="deutz-d-haiti.php">Deutz DHaiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/1836060682f77af2f2ecd7a16c2b0f1e/1900x1900-000000-80-0-0.jpg" alt="Dezas"></div>
  <div class="r-details"><div class="r-band"><a href="dezas.php">Dezas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105704.jpg" alt="Dezod Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="dezodmizik.php">Dezod Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/98c422e2b1b2afa079a87e69027ab504/1900x1900-000000-80-0-0.jpg" alt="Diapason"></div>
  <div class="r-details"><div class="r-band"><a href="diapason.php">Diapason</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/3/1742947982-diaspora-septantriyonal.png" alt="Diaspora Septantriyonal"></div>
  <div class="r-details"><div class="r-band"><a href="diaspora-septantriyonal.php">Diaspora Septantriyonal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/022bd938e93eb15ab676d0ba4d2b89d6/500x500.jpg" alt="Didier Labossierel"></div>
  <div class="r-details"><div class="r-band"><a href="didierlabossiere.php">Didier Labossiere</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c819d1a8138e9950d4d47eab4cabae59/250x250-000000-80-0-0.jpg" alt="Djenane Laguerre"></div>
  <div class="r-details"><div class="r-band"><a href="djenane-laguerre.php">Djenane Laguerre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/fd2702bea8dd8862da110b590f8807cb/250x250-000000-80-0-0.jpg" alt="DJ Kawest"></div>
  <div class="r-details"><div class="r-band"><a href="dj-kawest.php">DJ Kawest</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5dce8660973157d4c2430b5a0b65a155/250x250-000000-80-0-0.jpg" alt="DK-DEL"></div>
  <div class="r-details"><div class="r-band"><a href="dk-del.php">DK-DEL</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51oFcjWBvrL._UXNaN_FMjpg_QL85_.jpg" alt="D'Sire"></div>
  <div class="r-details"><div class="r-band"><a href="dsire.php">D'Sire</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/e8e2464a6705129047d067064aca7cb1/500x500.jpg" alt="D'Zel"></div>
  <div class="r-details"><div class="r-band"><a href="dzel.php">D'Zel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-763237cf-8350-40be-baa2-f97cfb66855d-0-t500x500.jpg" alt="D'Zine"></div>
  <div class="r-details"><div class="r-band"><a href="d-zine.php">D'Zine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/15/4/1744242085-didi-j-r-mie-cover.jpg" alt="Didi Jérémie"></div>
  <div class="r-details"><div class="r-band"><a href="didi-jeremie.php">Didi Jérémie</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Didy Velvey"></div>
  <div class="r-details"><div class="r-band"><a href="didyvelvey.php">Didy Velvey</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://prod-onfr-2023.s3.ca-central-1.amazonaws.com/wp-content/uploads/2023/08/02150719/IMG-20181001-WA0019.jpg" alt="Dieufaite Charles"></div>
  <div class="r-details"><div class="r-band"><a href="dieufaitecharles.php">Dieufaite Charles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music117/v4/b8/7d/f1/b87df147-6964-62cf-ebaa-504b35384a35/821689117526_cover.jpg/1200x1200bf-60.jpg" alt="Diggan D'Adesky"></div>
  <div class="r-details"><div class="r-band"><a href="diggan-d-adesky.php">Diggan D'Adesky</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/8e61b15a2ab6d1db49ca0e0f09272db8/1900x1900-000000-80-0-0.jpg" alt="Digital Express"></div>
  <div class="r-details"><div class="r-band"><a href="digital-express.php">Digital Express</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/06f25a9178ef3730acd41ae1c18f3d0c/1900x1900-000000-80-0-0.jpg" alt="Digital Express Plus"></div>
  <div class="r-details"><div class="r-band"><a href="digital-express-plus.php">Digital Express Plus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104391.jpg" alt="Dife"></div>
  <div class="r-details"><div class="r-band"><a href="dife.php">Dife</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100258.jpg" alt="Dilam"></div>
  <div class="r-details"><div class="r-band"><a href="dilam.php">Dilam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2730cea25075b36d17dccbf6707" alt="Dimilom"></div>
  <div class="r-details"><div class="r-band"><a href="dimilom.php">Dimilom</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100260.jpg" alt="Dince Albert"></div>
  <div class="r-details"><div class="r-band"><a href="dince-albert.php">Dince Albert</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103870.jpg" alt="Dionne Lamothe"></div>
  <div class="r-details"><div class="r-band"><a href="dionne-lamothe.php">Dionne Lamothe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/_YpIBnh4EK4w-pJWcPlz2n3rth7wv-tVAJpu43T2l6I/rs:fit/g:sm/q:90/h:480/w:480/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTQyNTYz/NzMtMTM4MTMwNTY2/Ni00MDEyLmpwZWc.jpeg" alt="Dimension"></div>
  <div class="r-details"><div class="r-band"><a href="dimension.php">Dimension</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://pbs.twimg.com/profile_images/764487880538464257/fEqyesNd_400x400.jpg" alt="Dipidji Skillset"></div>
  <div class="r-details"><div class="r-band"><a href="dipidji-skillset.php">Dipidji Skillset</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-wAhAJMAEKiRgPTki-TzNeiA-t240x240.jpg" alt="Discoball"></div>
  <div class="r-details"><div class="r-band"><a href="discoball.php">Discoball</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/3b0ce7febe8cefd90784568464333b30/1900x1900-000000-80-0-0.jpg" alt="Disip"></div>
  <div class="r-details"><div class="r-band"><a href="disip.php">dISIp</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/6c15hmTy/Cover.jpg" alt="Disciples Of Christ (D.O.C.)"></div>
  <div class="r-details"><div class="r-band"><a href="disciples-of-christ.php">Disciples Of Christ (D.O.C.)</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100274.jpg" alt="Dixie Band"></div>
  <div class="r-details"><div class="r-band"><a href="dixie-band.php">Dixie Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/613d+rE5V3L._UF894,1000_QL80_.jpg" alt="Divine Inspiration Ministry"></div>
  <div class="r-details"><div class="r-band"><a href="divine-inspiration-ministry.php">Divine Inspiration Ministry</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music122/v4/33/38/02/33380216-f2ac-be33-fa95-979d70764fd7/artwork.jpg/1200x1200bf-60.jpg" alt="Dj Kerbymix"></div>
  <div class="r-details"><div class="r-band"><a href="dj-kerbymix.php">Dj Kerbymix</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music114/v4/7c/69/60/7c6960b4-0d21-b1f3-9ef9-44122aa3819e/cover.jpg/600x600bf-60.jpg" alt="Djafull"></div>
  <div class="r-details"><div class="r-band"><a href="djafull.php">Djafull</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/613X6QNG38L._UF1000,1000_QL80_.jpg" alt="Djakout Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="djakout-mizik.php">Djakout Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/qYLxSwfx/DJAKOUT1.png" alt="Djakout #1"></div>
  <div class="r-details"><div class="r-band"><a href="djakout1.php">Djakout #1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7191644486236b11a993aff6927d24ca/250x250-000000-80-0-0.jpg" alt="Djam'n"></div>
  <div class="r-details"><div class="r-band"><a href="djam-n.php">Djam'n</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/16/b7/89/mzi.nkpagopr.jpg/1200x1200bb.jpg" alt="Djanm"></div>
  <div class="r-details"><div class="r-band"><a href="djanm.php">Djanm</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106699.jpg" alt="Djapot"></div>
  <div class="r-details"><div class="r-band"><a href="djapot.php">Djapot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104305.jpg" alt="Djarara"></div>
  <div class="r-details"><div class="r-band"><a href="djarara.php">Djarara</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000112853208-8bqon7-t500x500.jpg" alt="Djazz La"></div>
  <div class="r-details"><div class="r-band"><a href="djazzla.php">Djazz La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music124/v4/5a/b1/11/5ab111d1-19c9-9f29-f52e-93f3b6d232d1/792278036019.png/1200x1200bf-60.jpg" alt="Djazz New York La"></div>
  <div class="r-details"><div class="r-band"><a href="djazz-new-york-la.php">Djazz New York La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100287.jpg" alt="Djet-X"></div>
  <div class="r-details"><div class="r-band"><a href="djet-x.php">Djet-X</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/e2/56/ac/e256ac9d-03b9-f97e-a3a7-2ee4b60f881e/859782624801_cover.jpg/1200x1200bf-60.jpg" alt="Dj Marc Bouche"></div>
  <div class="r-details"><div class="r-band"><a href="dj-marc-bouche.php">Dj Marc Bouche</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106437.jpg" alt="Dj Stuba"></div>
  <div class="r-details"><div class="r-band"><a href="dj-stuba.php">Dj Stuba</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/41854553acc423ade118c9f12a256050/1900x1900-000000-80-0-0.jpg" alt="DJ Douly"></div>
  <div class="r-details"><div class="r-band"><a href="dj-douly.php">DJ Douly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/c21e646fe73d6ac97095b8309c919fd1/1900x1900-000000-80-0-0.jpg" alt="Dj Douss"></div>
  <div class="r-details"><div class="r-band"><a href="dj-douss.php">Dj Douss</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104486.jpg" alt="Djous"></div>
  <div class="r-details"><div class="r-band"><a href="djous.php">Djous</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273cd70d321a9f5e6d261a2cfb9" alt="Djumay"></div>
  <div class="r-details"><div class="r-band"><a href="djumay.php">Djumay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/19/5/1746819380-cover.jpg" alt="DK-Del"></div>
  <div class="r-details"><div class="r-band"><a href="dk-del.php">DK-Del</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/7d1df89a315f622324c3947114a4fbf7/1900x1900-000000-80-0-0.jpg" alt="Djordji Innocent"></div>
  <div class="r-details"><div class="r-band"><a href="djordjiinnocent.php">Djordji Innocent</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/309a6889b457e4992e1bf14d442d9e74/250x250-000000-80-0-0.jpg" alt="Doc Filah"></div>
  <div class="r-details"><div class="r-band"><a href="docfilah.php">Doc Filah</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103872.jpg" alt="Do-La"></div>
  <div class="r-details"><div class="r-band"><a href="dola.php">Do-La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106311.jpg" alt="DomGee"></div>
  <div class="r-details"><div class="r-band"><a href="domgee.php">DomGee</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music125/v4/5a/f1/21/5af121b0-4d81-161c-6f4f-76b1f35c4751/cover.jpg/1200x1200bf-60.jpg" alt="Dominique Fils Aime"></div>
  <div class="r-details"><div class="r-band"><a href="dominique-fils-aime.php">Dominique Fils Aime</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41WCd07puKL._UXNaN_FMjpg_QL85_.jpg" alt="Don Bichotte"></div>
  <div class="r-details"><div class="r-band"><a href="donbichotte.php">Don Bichotte</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/c7/98/70/c798706d-8aa0-8467-f805-842ffa2efddc/artwork.jpg/1200x1200bb.jpg" alt="Don Karnage"></div>
  <div class="r-details"><div class="r-band"><a href="donkarnage.php">Don Karnage</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music123/v4/c2/44/22/c244223f-5d21-0245-8702-227d87122941/194660534699.jpg/1200x1200bf-60.jpg" alt="Don Pelo"></div>
  <div class="r-details"><div class="r-band"><a href="donpelo.php">Don Pelo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103156.jpg" alt="Don Polo"></div>
  <div class="r-details"><div class="r-band"><a href="donpolo.php">Don Polo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103637.jpg" alt="Don Q"></div>
  <div class="r-details"><div class="r-band"><a href="donq.php">Don Q</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b20a12e56929f446fe4c353e7b4d8d0d/250x250-000000-80-0-0.jpg" alt="Doozyxp"></div>
  <div class="r-details"><div class="r-band"><a href="doozyxp.php">Doozyxp</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104882.jpg" alt="Dore"></div>
  <div class="r-details"><div class="r-band"><a href="dore.php">Dore</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104938.jpg" alt="Dorothy L Auguste"></div>
  <div class="r-details"><div class="r-band"><a href="dorothylauguste.php">Dorothy L Auguste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100294.jpg" alt="Dostana"></div>
  <div class="r-details"><div class="r-band"><a href="dostana.php">Dostana</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103146.jpg" alt="Doudou Bastide"></div>
  <div class="r-details"><div class="r-band"><a href="doudoubastide.php">Doudou Bastide</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41M1w7-RkSL._UXNaN_FMjpg_QL85_.jpg" alt="Dozz"></div>
  <div class="r-details"><div class="r-band"><a href="dozz.php">Dozz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/125e9ec655751c36c2e89617909093f7/1900x1900-000000-80-0-0.jpg" alt="DP Express"></div>
  <div class="r-details"><div class="r-band"><a href="dp-express.php">DP Express</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104741.jpg" alt="Dr Joseph Julium"></div>
  <div class="r-details"><div class="r-band"><a href="drjosephjulium.php">Dr Joseph Julium</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/80aef60f440656e849904237eebd4129/250x250-000000-80-0-0.jpg" alt="Dream Killah"></div>
  <div class="r-details"><div class="r-band"><a href="dream-killah.php">Dream Killah</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Dream Sweet"></div>
  <div class="r-details"><div class="r-band"><a href="dreamsweet.php">Dream Sweet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/cd/95/ab/cd95ab6f-94fc-37af-c095-422eb36df74e/884501227858.jpg/1200x1200bf-60.jpg" alt="Dreams"></div>
  <div class="r-details"><div class="r-band"><a href="dreams.php">Dreams</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d66c68cd54e2f3d871f67416abcec422/250x250-000000-80-0-0.jpg" alt="Dreysoul"></div>
  <div class="r-details"><div class="r-band"><a href="dreysoul.php">Dreysoul</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51RJk72RXLL._UXNaN_FMjpg_QL85_.jpg" alt="Dro Faka T-Micky"></div>
  <div class="r-details"><div class="r-band"><a href="drofakatmicky.php">Dro Faka T-Micky</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music125/v4/60/42/00/604200ed-16e8-31d7-6b7a-60699a76b916/894232783325.jpg/600x600bf-60.jpg" alt="Dro x Yani"></div>
  <div class="r-details"><div class="r-band"><a href="droxyani.php">Dro x Yani</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61-VTrhCH+L._UXNaN_FMjpg_QL85_.jpg" alt="Drummers Of The Societe Absolument Guini"></div>
  <div class="r-details"><div class="r-band"><a href="drummersofthesocieteabsolumentguinin.php">Drummers Of The Societe Absolument Guinin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://lastfm.freetls.fastly.net/i/u/500x500/044095b36a4f4dcbbdfbbce5d6b45ef3.jpg" alt="DRZ"></div>
  <div class="r-details"><div class="r-band"><a href="drz.php">DRZ</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/3c802cd331895bbcfc5a25f4435085bc/250x250-000000-80-0-0.jpg" alt="Dug G"></div>
  <div class="r-details"><div class="r-band"><a href="dugg.php">Dug G</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/c1/e1/8c/c1e18cba-ad01-9cbb-3698-99b23a6856d4/198026789068.jpg/486x486bb.png" alt="Duke Guillaume"></div>
  <div class="r-details"><div class="r-band"><a href="dukeguillaume.php">Duke Guillaume</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/70128ba6b33f8f985e81f66f7dbe282e/500x500.jpg" alt="Durkheim"></div>
  <div class="r-details"><div class="r-band"><a href="durkheim.php">Durkheim</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/315c88ed5642c90374933839b98cad9f/250x250-000000-80-0-0.jpg" alt="Dx Legendaire"></div>
  <div class="r-details"><div class="r-band"><a href="dx-legendaire.php">Dx Legendaire</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://s.rfi.fr/media/display/7065602e-15b8-11ea-a743-005056bf7c53/w:1280/p:1x1/Dyna%20B%20COUV%20ALBUM_0.jpg" alt="Dyna B"></div>
  <div class="r-details"><div class="r-band"><a href="dynab.php">Dyna B</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100300.jpg" alt="Dynamite All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="dynamiteallstars.php">Dynamite All Stars</a></div></div>
</div>



</div> <!-- Fin de .album-list -->
</div> <!-- Fin du conteneur principal si applicable -->

</main>

<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>