<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>E - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  

  <!-- Liste verticale des albums -->
  <div class="album-list">
      
  <!-- Liste des artistes -->
  <div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music6/v4/57/55/1e/57551e9c-a6ed-d7a6-9be4-a8a4b9bca905/888174835204.jpg/600x600bf-60.jpg" alt="Eagle Shout (Groupe Cri D'aigles )"></div>
  <div class="r-details"><div class="r-band"><a href="eagle-shout-groupe-cri-d-aigles.php">Eagle Shout (Groupe Cri D'aigles )</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104685.jpg" alt="Echo Mysterieux Marchons Ensemble"></div>
  <div class="r-details"><div class="r-band"><a href="echo-mysterieux-marchons-ensemble.php">Echo Mysterieux Marchons Ensemble</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104549.jpg" alt="Eddy Altine A-Team 2001"></div>
  <div class="r-details"><div class="r-band"><a href="eddy-altine-a-team-2001.php">Eddy Altine A-Team 2001</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61nqt22TKkL._UXNaN_FMjpg_QL85_.jpg" alt="Eddy Francois"></div>
  <div class="r-details"><div class="r-band"><a href="eddy-francois.php">Eddy Francois</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/513f0pbRlXL._UXNaN_FMjpg_QL85_.jpg" alt="Eddy Negrit"></div>
  <div class="r-details"><div class="r-band"><a href="eddy-negrit.php">Eddy Negrit</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103137.jpg" alt="Eddy Prophete"></div>
  <div class="r-details"><div class="r-band"><a href="eddy-prophete.php">Eddy Prophete</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://espaskreyol.org/wp-content/uploads/2023/10/edner-guignard.jpeg" alt="Edner Guignard"></div>
  <div class="r-details"><div class="r-band"><a href="edner-guignard.php">Edner Guignard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/a914f5660a39da482908fb5de6ae5d6b/1900x1900-000000-80-0-0.jpg" alt="Edouard Sevele"></div>
  <div class="r-details"><div class="r-band"><a href="edouard-sevele.php">Edouard Sevele</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music123/v4/cc/39/29/cc3929c7-6ac3-2e2a-e5fd-d943f31650eb/artwork.jpg/486x486bb.png" alt="Edro Louis"></div>
  <div class="r-details"><div class="r-band"><a href="edro-louis.php">Edro Louis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103318.jpg" alt="Edy Brisseaux"></div>
  <div class="r-details"><div class="r-band"><a href="edy-brisseaux.php">Edy Brisseaux</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music122/v4/df/38/7c/df387cd5-d36a-9f2c-657f-51ec8f2ac99b/198004151009.jpg/1200x1200bb.jpg" alt="Ejay Michel"></div>
  <div class="r-details"><div class="r-band"><a href="ejay-michel.php">Ejay Michel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/5c84ae35511da2279a948076342c0106/1900x1900-000000-80-0-0.jpg" alt="Ekip"></div>
  <div class="r-details"><div class="r-band"><a href="ekip.php">Ekip</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103874.jpg" alt="Ekla"></div>
  <div class="r-details"><div class="r-band"><a href="ekla.php">Ekla</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106041.jpg" alt="Eklips"></div>
  <div class="r-details"><div class="r-band"><a href="eklips.php">Eklips</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104985.jpg" alt="EkZotik"></div>
  <div class="r-details"><div class="r-band"><a href="ekzotik.php">EkZotik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/3/1750867192-elie-cover.jpg" alt="Elie Lapointe"></div>
  <div class="r-details"><div class="r-band"><a href="elie-lapointe.php">Elie Lapointe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104886.jpg" alt="Elishama Gospel Band"></div>
  <div class="r-details"><div class="r-band"><a href="elishama-gospel-band.php">Elishama Gospel Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/340a9d07ecc461619c99a472fcf70521/1900x1900-000000-80-0-0.jpg" alt="Elisheva"></div>
  <div class="r-details"><div class="r-band"><a href="elisheva.php">Elisheva</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/5524915e9929b6a54d889df38cc2b856/350x350.jpg" alt="Elite Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="elite-mizik.php">Elite Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/9e73e2a0a82c078d09372c454498c279/500x500.jpg" alt="Elit Sexy"></div>
  <div class="r-details"><div class="r-band"><a href="elit-sexy.php">Elit Sexy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/a0905543e827fe71d00bd7c344da6a89/1900x1900-000000-80-0-0.jpg" alt="El Shama"></div>
  <div class="r-details"><div class="r-band"><a href="el-shama.php">El Shama</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/FR/images_produits/FR/Fnac.com/ZoomPE/1/2/2/3045050181221/tsp20130903135554/My-life.jpg" alt="Elson"></div>
  <div class="r-details"><div class="r-band"><a href="elson.php">Elson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/43150e86b04175af91def87f8aea26d9/250x250-000000-80-0-0.jpg" alt="El Tsedeq"></div>
  <div class="r-details"><div class="r-band"><a href="el-tsedeq.php">El Tsedeq</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ZfAT41abS._UXNaN_FMjpg_QL85_.jpg" alt="Elysee Blanc"></div>
  <div class="r-details"><div class="r-band"><a href="elysee-blanc.php">Elysee Blanc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/8e/0a/e8/8e0ae85c-129f-4af6-634a-2ea74038a81d/artwork.jpg/1200x1200bf-60.jpg" alt="Emeline Michel"></div>
  <div class="r-details"><div class="r-band"><a href="emeline-michel.php">Emeline Michel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102905.jpg" alt="Emilio Petiote con Los Diplomáticos de Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="emilio-petiote-con-los-diplom-ticos-de-haiti.php">Emilio Petiote con Los Diplomáticos de Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100316.jpg" alt="Emile Volel"></div>
  <div class="r-details"><div class="r-band"><a href="emile-volel.php">Emile Volel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/cef3e0ba837efa7c865bc09fa8c70cb5/500x500.jpg" alt="Emma Achille Placide"></div>
  <div class="r-details"><div class="r-band"><a href="emma-achille-placide.php">Emma Achille Placide</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103260.jpg" alt="Emmanuel"></div>
  <div class="r-details"><div class="r-band"><a href="emmanuel.php">Emmanuel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106068.jpg" alt="Emmanuel Obas"></div>
  <div class="r-details"><div class="r-band"><a href="emmanuel-obas.php">Emmanuel Obas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/qBSyRFQ/EMMANUEL-TOUSSAINT-Tche-en-mwen-ka-balance.jpg" alt="Emmanuel Toussaint"></div>
  <div class="r-details"><div class="r-band"><a href="emmanuel-toussaint.php">Emmanuel Toussaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music221/v4/ed/6b/57/ed6b5716-9edc-a3c0-751b-75f13a3184b5/artwork.jpg/486x486bb.png" alt="Emmanuel Tuffet"></div>
  <div class="r-details"><div class="r-band"><a href="emmanuel-tuffet.php">Emmanuel Tuffet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/5/1750992805-emo-music.jpg" alt="Emo Music"></div>
  <div class="r-details"><div class="r-band"><a href="emo-music.php">Emo Music</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2735c970ff9b6f1973dd1d61b6e" alt="Emotion"></div>
  <div class="r-details"><div class="r-band"><a href="emotion.php">Emotion</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/2/1742897979-emotion-band.png" alt="Emotion Band"></div>
  <div class="r-details"><div class="r-band"><a href="emotion-band.php">Emotion Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102267.jpg" alt="Emy de Pradines – Haiti Danse Chorus & Orchestra"></div>
  <div class="r-details"><div class="r-band"><a href="emy-de-pradines-haiti-danse-chorus-orchestra.php">Emy de Pradines – Haiti Danse Chorus & Orchestra</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/q7gRNf9/Cover.jpg" alt="Enid"></div>
  <div class="r-details"><div class="r-band"><a href="enid.php">Enid</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/feeda8d11313cb28299e913b1033ff7e/500x500.jpg" alt="Enpekab"></div>
  <div class="r-details"><div class="r-band"><a href="enpekab.php">Enpekab</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/09d43c8e6c73bc138b0cabac45694dbb/1900x1900-000000-80-0-0.jpg" alt="Enposib"></div>
  <div class="r-details"><div class="r-band"><a href="enposib.php">Enposib</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51d1Pc-4hpL._UXNaN_FMjpg_QL85_.jpg" alt="Enpresyon Music Band"></div>
  <div class="r-details"><div class="r-band"><a href="enpresyon-music-band.php">Enpresyon Music Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105417.jpg" alt="Ensemble Aux Calebasses"></div>
  <div class="r-details"><div class="r-band"><a href="ensemble-aux-calebasses.php">Ensemble Aux Calebasses</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100318.jpg" alt="Ensemble Etoile Du Soir"></div>
  <div class="r-details"><div class="r-band"><a href="ensemble-etoile-du-soir.php">Ensemble Etoile Du Soir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Rz2m7Y8/Destination.jpg" alt="Ensemble La Gonave"></div>
  <div class="r-details"><div class="r-band"><a href="ensemble-la-gonave.php">Ensemble La Gonave</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51pBGkqJI0L._UXNaN_FMjpg_QL85_.jpg" alt="Envazyon"></div>
  <div class="r-details"><div class="r-band"><a href="envazyon.php">Envazyon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/fe/87/e8/fe87e858-555d-123c-9cb7-b60150fedd86/859779849361_cover.jpg/1200x1200bb.jpg" alt="Envesti"></div>
  <div class="r-details"><div class="r-band"><a href="envesti.php">Envesti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/514kxdbRIvL._UXNaN_FMjpg_QL85_.jpg" alt="Eric Rousseaux"></div>
  <div class="r-details"><div class="r-band"><a href="eric-rousseaux.php">Eric Rousseaux</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51HovvT45AL._UXNaN_FMjpg_QL85_.jpg" alt="Ermithe Fertile"></div>
  <div class="r-details"><div class="r-band"><a href="ermithe-fertile.php">Ermithe Fertile</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/33e9d613c76871a0f54be09f23c3bb25/1900x1900-000000-80-0-0.jpg" alt="Evazyon Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="evazyon-mizik.php">Evazyon Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51frbJggjXL._UXNaN_FMjpg_QL85_.jpg" alt="Erick Paul"></div>
  <div class="r-details"><div class="r-band"><a href="erick-paul.php">Erick Paul</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103312.jpg" alt="Ernest Lamy"></div>
  <div class="r-details"><div class="r-band"><a href="ernest-lamy.php">Ernest Lamy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51EGjudOpxL._UXNaN_FMjpg_QL85_.jpg" alt="Ernst Bruny"></div>
  <div class="r-details"><div class="r-band"><a href="ernst-bruny.php">Ernst Bruny</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Rz2m7Y8/Destination.jpg" alt="Ernst Métélas"></div>
  <div class="r-details"><div class="r-band"><a href="ernst-metelas.php">Ernst Métélas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51LaGs8n5TL._AC_UF1000,1000_QL80_.jpg" alt="Erol Josue"></div>
  <div class="r-details"><div class="r-band"><a href="erol-josue.php">Erol Josue</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100322.jpg" alt="Essud Fungcap et le Combo de Luis de la Torre"></div>
  <div class="r-details"><div class="r-band"><a href="essud-fungcap-et-le-combo-de-luis-de-la-torre.php">Essud Fungcap et le Combo de Luis de la Torre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/eb3e4537266470a647dd42bb1dbfb759/500x500.jpg" alt="Esteban Y La Banda Mix"></div>
  <div class="r-details"><div class="r-band"><a href="esteban-y-la-banda-mix.php">Esteban Y La Banda Mix</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ws0IEJXjL._UXNaN_FMjpg_QL85_.jpg" alt="Esther Toussaint"></div>
  <div class="r-details"><div class="r-band"><a href="esther-toussaint.php">Esther Toussaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/pr6tkPC/00-estrad-x-en-ba-bois-la-fr-1997-front.jpg" alt="Estrad X"></div>
  <div class="r-details"><div class="r-band"><a href="estrad-x.php">Estrad X</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104809.jpg" alt="Etcetera"></div>
  <div class="r-details"><div class="r-band"><a href="etcetera.php">Etcetera</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104889.jpg" alt="Etnik"></div>
  <div class="r-details"><div class="r-band"><a href="etnik.php">Etnik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/33/af/46/33af469a-ea45-b2a8-b9a0-b26710ebd906/884501893671.jpg/600x600bf-60.jpg" alt="Etzer Nubazz"></div>
  <div class="r-details"><div class="r-band"><a href="etzer-nubazz.php">Etzer Nubazz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105945.jpg" alt="Eval Manigat"></div>
  <div class="r-details"><div class="r-band"><a href="eval-manigat.php">Eval Manigat</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d5834c2c9f77b66ab3c7417fcd024339/250x250-000000-80-0-0.jpg" alt="Evangel Band"></div>
  <div class="r-details"><div class="r-band"><a href="evangel-band.php">Evangel Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5bfcf5a6060e1217ee55e69848441c51/250x250-000000-80-0-0.jpg" alt="Evangelist Rosele Francique"></div>
  <div class="r-details"><div class="r-band"><a href="evangelist-rosele-francique.php">Evangelist Rosele Francique</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101833.jpg" alt="Evans Jean"></div>
  <div class="r-details"><div class="r-band"><a href="evans-jean.php">Evans Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104394.jpg" alt="Ewald Manigat"></div>
  <div class="r-details"><div class="r-band"><a href="ewald-manigat.php">Ewald Manigat</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100326.jpg" alt="Exodus"></div>
  <div class="r-details"><div class="r-band"><a href="exodus.php">Exodus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/JtkJ8GQXjF6w-mCQnXm_mIktMmE_uZMWHqIzJqHZW9s/rs:fit/g:sm/q:90/h:598/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI3OTE1/MzEtMTY2MzQzNDY2/OC05MjA5LmpwZWc.jpeg" alt="Experimental"></div>
  <div class="r-details"><div class="r-band"><a href="experimental.php">Experimental</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/9rm9t0P/Cover.jpg" alt="Explosion"></div>
  <div class="r-details"><div class="r-band"><a href="explosion.php">Explosion</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/PxktPC2/EXPRESS-10-Cover.jpg" alt="Express 10"></div>
  <div class="r-details"><div class="r-band"><a href="express-10.php">Express 10</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103878.jpg" alt="E-Z Band"></div>
  <div class="r-details"><div class="r-band"><a href="e-z-band.php">E-Z Band</a></div></div>
</div>

    <!-- Tu peux continuer à ajouter d'autres groupes ici -->

  </div>

  <script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>