<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>F - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
  

  <!-- Liste verticale des albums -->
  <div class="album-list">
      
    <!-- Liste des artistes -->
    <div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51JBQRThKDL._UXNaN_FMjpg_QL85_.jpg" alt="Fa 7 Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="fa7kompa.php">Fa 7 Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61UKRy2xZRL._UXNaN_FMjpg_QL85_.jpg" alt="Fa Wouch"></div>
  <div class="r-details"><div class="r-band"><a href="fawouch.php">Fa Wouch</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/preview-75/102085.jpg" alt="Faarah Juste"></div>
  <div class="r-details"><div class="r-band"><a href="farah-juste.php">Faarah Juste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/preview-75/100332.jpg" alt="Fabi"></div>
  <div class="r-details"><div class="r-band"><a href="fabi.php">Fabi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/cb8e24d410c2e637c870ffa35b605bad/1900x1900-000000-80-0-0.jpg" alt="Fabiola Shyne"></div>
  <div class="r-details"><div class="r-band"><a href="fabiolashyne.php">Fabiola Shyne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103880.jpg" alt="Fabrice Fombrun"></div>
  <div class="r-details"><div class="r-band"><a href="fabrice-fombrun.php">Fabrice Fombrun</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/preview-75/101950.jpg" alt="Fahrenheit"></div>
  <div class="r-details"><div class="r-band"><a href="fahrenheit.php">Fahrenheit</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/bbd3237f35fcd60936e5029da06d13df/250x250-000000-80-0-0.jpg" alt="Fally Douyon"></div>
  <div class="r-details"><div class="r-band"><a href="fally-douyon.php">Fally Douyon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/preview-75/105007.jpg" alt="Family"></div>
  <div class="r-details"><div class="r-band"><a href="family.php">Family</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music123/v4/b3/22/cc/b322cc69-3b90-fd7c-fd3c-3c00b1a5d575/194660833419.jpg/486x486bb.png" alt="Family Senci"></div>
  <div class="r-details"><div class="r-band"><a href="familysenci.php">Family Senci</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ZlQktGZQwCR2vby781rf-LbR9ek4GQ8aVvD-f7BLbr8/rs:fit/g:sm/q:90/h:597/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI0NTY2/MjIyLTE2NjM4NDM3/MjEtNTI3Mi5qcGVn.jpeg" alt="Fanatik Compas"></div>
  <div class="r-details"><div class="r-band"><a href="fanatikcompa.php">Fanatik Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/7/1742096085-fanmiy-mizik.jpg" alt="Fanmiy Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="fanmiy-mizik.php">Fanmiy Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/df1c845039b959c14644f5d6de35e4df/500x500.jpg" alt="Fantom"></div>
  <div class="r-details"><div class="r-band"><a href="fantom.php">Fantom</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51mYaJH298L._UXNaN_FMjpg_QL85_.jpg" alt="Farrel-x"></div>
  <div class="r-details"><div class="r-band"><a href="farrel-x.php">Farrel-x</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/34421cbcab125c5ea19c38e34cabef88/1900x1900-000000-80-0-0.jpg" alt="Fasad"></div>
  <div class="r-details"><div class="r-band"><a href="fasad.php">Fasad</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103588.jpg" alt="Fashion Color"></div>
  <div class="r-details"><div class="r-band"><a href="fashion-color.php">Fashion Color</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104255.jpg" alt="Fasil"></div>
  <div class="r-details"><div class="r-band"><a href="fasil.php">Fasil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61MbujoaQeL._UXNaN_FMjpg_QL85_.jpg" alt="Father Jay Ayibobo 509"></div>
  <div class="r-details"><div class="r-band"><a href="father-jay-ayibobo-509.php">Father Jay Ayibobo 509</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/2ad5b74fef88339a81d1ae733f0dfac3/0x1900-000000-80-0-0.jpg" alt="Fatima Altieri"></div>
  <div class="r-details"><div class="r-band"><a href="fatima-altieri.php">Fatima Altieri</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/FR/Images_Produits/FR/fnac.com/Visual_Principal_340/9/2/2/3433190655229/tsp20130329171652/Favori-live.jpg" alt="Favori"></div>
  <div class="r-details"><div class="r-band"><a href="favori.php">Favori</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/b0abe1ad6b30d23f1fa98fe41285d873/1900x1900-000000-80-0-0.jpg" alt="Fed"></div>
  <div class="r-details"><div class="r-band"><a href="fed.php">Fed</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/df/c8/b3/dfc8b3a5-0e13-8d81-3617-c66135614cf4/198025166389.jpg/600x600bf-60.jpg" alt="Fede Majik"></div>
  <div class="r-details"><div class="r-band"><a href="fede-majik.php">Fede Majik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104696.jpg" alt="Fedia Laguerre"></div>
  <div class="r-details"><div class="r-band"><a href="fedia-laguerre.php">Fedia Laguerre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105782.jpg" alt="Feedback"></div>
  <div class="r-details"><div class="r-band"><a href="feedback.php">Feedback</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106368.jpg" alt="Feeling Band"></div>
  <div class="r-details"><div class="r-band"><a href="feelingband.php">Feeling Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104552.jpg" alt="Feeling Creole D'Ottawa"></div>
  <div class="r-details"><div class="r-band"><a href="feeling-creole-d-ottawa.php">Feeling Creole D'Ottawa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Q8pwKTJ/Cover.png" alt="Feeling Du Cap"></div>
  <div class="r-details"><div class="r-band"><a href="feeling-du-cap.php">Feeling Du Cap</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51lWSt2nFkL._UXNaN_FMjpg_QL85_.jpg" alt="Feeling Five Style"></div>
  <div class="r-details"><div class="r-band"><a href="feeling-five-style.php">Feeling Five Style</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103188.jpg" alt="Feeling Star"></div>
  <div class="r-details"><div class="r-band"><a href="feeling-star.php">Feeling Star</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://fr.shopping.rakuten.com/photo/833659470.jpg" alt="Feeling-Creol"></div>
  <div class="r-details"><div class="r-band"><a href="feeling-creol.php">Feeling-Creol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41TEGP4IS0L._UXNaN_FMjpg_QL85_.jpg" alt="Felina Backer"></div>
  <div class="r-details"><div class="r-band"><a href="felina-backer.php">Felina Backer</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273f470ddaf06178931ee373f87" alt="Felix Cumbe"></div>
  <div class="r-details"><div class="r-band"><a href="felix-cumbe.php">Felix Cumbe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105731.jpg" alt="Felix Guignard"></div>
  <div class="r-details"><div class="r-band"><a href="felix-guignard.php">Felix Guignard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3b6f09dec026fd94e8755d54b4163079/250x250-000000-80-0-0.jpg" alt="Fenique Michel"></div>
  <div class="r-details"><div class="r-band"><a href="fenique-michel.php">Fenique Michel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Ferdinand Dor"></div>
  <div class="r-details"><div class="r-band"><a href="ferdinand-dor.php">Ferdinand Dor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/40e896f92dd5bb5bce672355f7e901b7/250x250-000000-80-0-0.jpg" alt="Ferline Regis"></div>
  <div class="r-details"><div class="r-band"><a href="ferline-regis.php">Ferline Regis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/50fc7fe99bcc3bc6d7d41547151580eb/250x250-000000-80-0-0.jpg" alt="Ficanooo"></div>
  <div class="r-details"><div class="r-band"><a href="ficanooo.php">Ficanooo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104844.jpg" alt="Fidel"></div>
  <div class="r-details"><div class="r-band"><a href="fidel.php">Fidel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51rhpPGRDfL._UXNaN_FMjpg_QL85_.jpg" alt="Fidel La"></div>
  <div class="r-details"><div class="r-band"><a href="fidel-la.php">Fidel La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100353.jpg" alt="First Class"></div>
  <div class="r-details"><div class="r-band"><a href="first-class.php">First Class</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/5/1751046319-firt-class-cover.png" alt="Firstclass For Christ"></div>
  <div class="r-details"><div class="r-band"><a href="first-class-for-christ.php">Firstclass For Christ</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/03/24/b70f175ca8724aa899b88abb9d2a1d04_464_464.jpg" alt="Firstclass Gospel Mix"></div>
  <div class="r-details"><div class="r-band"><a href="first-class-gospel-mix.php">Firstclass Gospel Mix</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/981ed8eb0e8fce433aadcf58b2ac766f/250x250-000000-80-0-0.jpg" alt="Firstclass Rap Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="firstclass-rap-kreyol.php">Firstclass Rap Kreyol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749903583-achiv.jpg" alt="Fito Rameau"></div>
  <div class="r-details"><div class="r-band"><a href="fito-rameau.php">Fito Rameau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749903583-achiv.jpg" alt="Fitz Larose Jr"></div>
  <div class="r-details"><div class="r-band"><a href="fitz-larose-jr.php">Fitz Larose Jr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/VpLVDvQ/Cover-Flame-Stars.jpg" alt="Flame Stars"></div>
  <div class="r-details"><div class="r-band"><a href="flame-stars.php">Flame Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51PCMh1a2zL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Flanbe"></div>
  <div class="r-details"><div class="r-band"><a href="flanbe.php">Flanbe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106240.jpg" alt="Flanm De Montreal"></div>
  <div class="r-details"><div class="r-band"><a href="flanm.php">Flanm De Montreal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103881.jpg" alt="Flash"></div>
  <div class="r-details"><div class="r-band"><a href="flash.php">Flash</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106575.jpg" alt="Flash Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="flash-kompa.php">Flash Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/512gMTMptkL._UXNaN_FMjpg_QL85_.jpg" alt="Flash Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="flash-mizik.php">Flash Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/48/4e/68/484e6853-b5da-0943-cf15-daa8cb7b3e12/859782802476_cover.jpg/1200x1200bf-60.jpg" alt="Flav"></div>
  <div class="r-details"><div class="r-band"><a href="flav.php">Flav</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/515BMwsxlrL._UXNaN_FMjpg_QL85_.jpg" alt="Flore Saint-Louis"></div>
  <div class="r-details"><div class="r-band"><a href="flore-saint-louis.php">Flore Saint-Louis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Fly Band"></div>
  <div class="r-details"><div class="r-band"><a href="fly-band.php">Fly Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100354.jpg" alt="Fokus"></div>
  <div class="r-details"><div class="r-band"><a href="fokus.php">Fokus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104110.jpg" alt="Folly"></div>
  <div class="r-details"><div class="r-band"><a href="folly.php">Folly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51-ewWMQRxL._UXNaN_FMjpg_QL85_.jpg" alt="Forever"></div>
  <div class="r-details"><div class="r-band"><a href="forever.php">Forever</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105159.jpg" alt="Formul La"></div>
  <div class="r-details"><div class="r-band"><a href="formul-la.php">Formul La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100356.jpg" alt="Formula One Of Hollywood"></div>
  <div class="r-details"><div class="r-band"><a href="formula-one-of-hollywood.php">Formula One Of Hollywood</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102296.jpg" alt="Formule 10 d'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="formule10dhaiti.php">Formule 10 d'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106474.jpg" alt="Foula Vodoule"></div>
  <div class="r-details"><div class="r-band"><a href="foula-vodoule.php">Foula Vodoule</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105545.jpg" alt="Foxy Dana"></div>
  <div class="r-details"><div class="r-band"><a href="foxy-dana.php">Foxy Dana</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101884.jpg" alt="Fragyl"></div>
  <div class="r-details"><div class="r-band"><a href="fragyl.php">Fragyl</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105008.jpg" alt="Francky Lover"></div>
  <div class="r-details"><div class="r-band"><a href="francky-lover.php">Francky Lover</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-mHRe07B949LvxkGe-JePHDQ-t1080x1080.jpg" alt="Franco love federo"></div>
  <div class="r-details"><div class="r-band"><a href="franco-love-federo.php">Franco love federo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6c5e6c65ae7973fb999f5be6908795d2/250x250-000000-80-0-0.jpg" alt="Francois Nono"></div>
  <div class="r-details"><div class="r-band"><a href="francois-nono.php">Francois Nono</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d23ad7b304796967038e1e244c44c274/250x250-000000-80-0-0.jpg" alt="Franklin Medina"></div>
  <div class="r-details"><div class="r-band"><a href="franklin-medina.php">Franklin Medina</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51++mc-YyyL._UXNaN_FMjpg_QL85_.jpg" alt="Frantz Dee"></div>
  <div class="r-details"><div class="r-band"><a href="frantz-dee.php">Frantz Dee</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103039.jpg" alt="Frantz Dugue"></div>
  <div class="r-details"><div class="r-band"><a href="frantz-dugue.php">Frantz Dugue</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102169.jpg" alt="Frantz Faneus y Su Combo"></div>
  <div class="r-details"><div class="r-band"><a href="frantz-faneus.php">Frantz Faneus y Su Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61MqygDYlCL._UXNaN_FMjpg_QL85_.jpg" alt="Frantz Philippe"></div>
  <div class="r-details"><div class="r-band"><a href="frantz-philippe.php">Frantz Philippe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100334.jpg" alt="Frantz Precio"></div>
  <div class="r-details"><div class="r-band"><a href="frantz-precio.php">Frantz Precio</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/images_produits/ZoomPE/2/2/9/3433190585922/tsp20130901121604/Eentiel.jpg" alt="Frantzy"></div>
  <div class="r-details"><div class="r-band"><a href="frantzy.php">Frantzy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103635.jpg" alt="Frantzy Gauthier"></div>
  <div class="r-details"><div class="r-band"><a href="frantzy-gauthier.php">Frantzy Gauthier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51AkyD7LO3L._UXNaN_FMjpg_QL85_.jpg" alt="Fre Gabe"></div>
  <div class="r-details"><div class="r-band"><a href="fre-gabe.php">Fre Gabe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/4deb330a5c88b2c0c81cdc48ce6d5ec2/250x250-000000-80-0-0.jpg" alt="Frederson Joseph"></div>
  <div class="r-details"><div class="r-band"><a href="frederson-joseph.php">Frederson Joseph</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/6d449371f79006fe083f373ddd97df1f/1900x1900-000000-80-0-0.jpg" alt="Fredlin Francois"></div>
  <div class="r-details"><div class="r-band"><a href="fredelin-francois.php">Fredlin Francois</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/32b749f6644a55e2b645b6a14297453c/250x250-000000-80-0-0.jpg" alt="Freedom"></div>
  <div class="r-details"><div class="r-band"><a href="freedom.php">Freedom</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104747.jpg" alt="Freedom #1"></div>
  <div class="r-details"><div class="r-band"><a href="freedom-1.php">Freedom #1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music115/v4/be/8e/61/be8e618a-f0b7-af1e-95cf-67811dc38aa1/859750894397_cover.jpg/486x486bb.png" alt="Frefre Band"></div>
  <div class="r-details"><div class="r-band"><a href="frefre-band.php">Frefre Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://wagmarlovemusicstore.us/wp-content/uploads/2024/04/FRERE20KAMO20NEW.jpg" alt="Frere Kamo"></div>
  <div class="r-details"><div class="r-band"><a href="frere-kamo.php">Frere Kamo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105180.jpg" alt="Frero Jean Baptiste"></div>
  <div class="r-details"><div class="r-band"><a href="frero.php">Frero Jean Baptiste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0c5301e08f9b88a176b5a5df9da00cec/250x250-000000-80-0-0.jpg" alt="Frère Parent Alain Picard"></div>
  <div class="r-details"><div class="r-band"><a href="frere-parent-alain-picard.php">Frère Parent Alain Picard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104485.jpg" alt="Fresh"></div>
  <div class="r-details"><div class="r-band"><a href="fresh.php">Fresh</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104734.jpg" alt="Fresh Compas"></div>
  <div class="r-details"><div class="r-band"><a href="fresh-compas.php">Fresh Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105244.jpg" alt="Fresh-Up"></div>
  <div class="r-details"><div class="r-band"><a href="fresh-up.php">Fresh-Up</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104306.jpg" alt="Frisner Augustin"></div>
  <div class="r-details"><div class="r-band"><a href="frisner-augustin.php">Frisner Augustin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100361.jpg" alt="Fritz Massac"></div>
  <div class="r-details"><div class="r-band"><a href="fritz-massac.php">Fritz Massac</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/7/1751163616-102320.jpg" alt="Fritz Pereira Orchestre de Studio"></div>
  <div class="r-details"><div class="r-band"><a href="fritz-pereira-and-his-orchestra.php">Fritz Pereira Orchestre de Studio</a></div></div>
</div>



<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51vDvXsIrzL._UXNaN_FMjpg_QL85_.jpg" alt="Fu-Zion"></div>
  <div class="r-details"><div class="r-band"><a href="fu-zion.php">Fu-Zion</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/24/6/1749903583-achiv.jpg" alt="Full-Kompas"></div>
  <div class="r-details"><div class="r-band"><a href="full-kompas.php">Full-Kompas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105689.jpg" alt="Fwetkash"></div>
  <div class="r-details"><div class="r-band"><a href="fwetkash.php">Fwetkash</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://f4.bcbits.com/img/a2611288365_10.jpg" alt="Fwonte"></div>
  <div class="r-details"><div class="r-band"><a href="fwonte.php">Fwonte</a></div></div>
</div>



    <!-- Tu peux continuer à ajouter d'autres groupes ici -->

  </div>

  <script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>