<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>G - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
  

  <!-- Liste verticale des albums -->
  <div class="album-list">
      
      <!-- Liste des artistes -->
    <div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/10f812899fbdbd2ab09f6cad40313126/250x250-000000-80-0-0.jpg" alt="G-Lex"></div>
  <div class="r-details"><div class="r-band"><a href="g-lex.php">G-Lex</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51NvnqW-cgL._UXNaN_FMjpg_QL85_.jpg" alt="G-Money Saj"></div>
  <div class="r-details"><div class="r-band"><a href="g-money-saj.php">G-Money Saj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100362.jpg" alt="G.P. Express"></div>
  <div class="r-details"><div class="r-band"><a href="g-p-express.php">G.P. Express</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/07c7f9389d531e4419a1ecd32c82ae9d/250x250-000000-80-0-0.jpg" alt="G.P.S"></div>
  <div class="r-details"><div class="r-band"><a href="g-p-s.php">G.P.S</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/7/1751198016-gabelcover.jpg" alt="Gabel"></div>
  <div class="r-details"><div class="r-band"><a href="gabel.php">Gabel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/2125272971acda8c5ba8b036e48988c9/264x264.jpg" alt="Gabriel Laporte"></div>
  <div class="r-details"><div class="r-band"><a href="gabriel-laporte.php">Gabriel Laporte</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/6/1751110255-default-cover.jpg" alt="Gabriel Morin"></div>
  <div class="r-details"><div class="r-band"><a href="gabriel-morin.php">Gabriel Morin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/4/1750947587-default-cover.jpg" alt="Gadosa"></div>
  <div class="r-details"><div class="r-band"><a href="gadosa.php">Gadosa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103884.jpg" alt="Gagacito"></div>
  <div class="r-details"><div class="r-band"><a href="gagacito.php">Gagacito</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ESuXOcm6L._UXNaN_FMjpg_QL85_.jpg" alt="Galaxy Band de Jérémie"></div>
  <div class="r-details"><div class="r-band"><a href="galaxy-band-de-jeremie.php">Galaxy Band de Jérémie</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101959.jpg" alt="Gamma Express"></div>
  <div class="r-details"><div class="r-band"><a href="gamma-express.php">Gamma Express</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/7/1751199060-cover.jpg" alt="GN"></div>
  <div class="r-details"><div class="r-band"><a href="gn.php">GN</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.globalgroovers.com/wp-content/uploads/2020/11/Gardner-Lalanne-et-son-Combo-Etoile-Moin-Brill%C3%A9-front.jpg" alt="Gardner Lalanne a New York avec Les Loups Noirs"></div>
  <div class="r-details"><div class="r-band"><a href="gardner-lalanne-a-new-york-avec-les-loups-noirs.php">Gardner Lalanne a New York avec Les Loups Noirs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41-Hs3hYINL._UF1000,1000_QL80_.jpg" alt="Gardy Fury"></div>
  <div class="r-details"><div class="r-band"><a href="gardy-fury.php">Gardy Fury</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/87a61d228792a1263ae082696ebdd591/1900x1900-000000-80-0-0.jpg" alt="Gardy Girault"></div>
  <div class="r-details"><div class="r-band"><a href="gardy-girault.php">Gardy Girault</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273bae4b3db767c96620a0ad004" alt="Gardy Parent"></div>
  <div class="r-details"><div class="r-band"><a href="gardy-parent.php">Gardy Parent</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/6/1751110255-default-cover.jpg" alt="Gardy Solimont & Prince Sanson"></div>
  <div class="r-details"><div class="r-band"><a href="gardy-solimont-prince-sanson.php">Gardy Solimont & Prince Sanson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104615.jpg" alt="Garry"></div>
  <div class="r-details"><div class="r-band"><a href="garry.php">Garry</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/e696e9090e24f478a018e117f4afbf81/1900x1900-000000-80-0-0.jpg" alt="Gary Didier Perez et Ozone"></div>
  <div class="r-details"><div class="r-band"><a href="gary-didier-perez-et-ozone.php">Gary Didier Perez et Ozone</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100373.jpg" alt="Gary French"></div>
  <div class="r-details"><div class="r-band"><a href="gary-french.php">Gary French</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103885.jpg" alt="Gaston Cochon"></div>
  <div class="r-details"><div class="r-band"><a href="gaston-cochon.php">Gaston Cochon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103709.jpg" alt="Gathy-M"></div>
  <div class="r-details"><div class="r-band"><a href="gathy-m.php">Gathy-M</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103819.jpg" alt="Gayak"></div>
  <div class="r-details"><div class="r-band"><a href="gayak.php">Gayak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104257.jpg" alt="Gazzman"></div>
  <div class="r-details"><div class="r-band"><a href="gazzman.php">Gazzman</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/59b774d821f2e02788608231659b6ce7/250x250-000000-80-0-0.jpg" alt="G Bobby Bon Flo"></div>
  <div class="r-details"><div class="r-band"><a href="g-bobby-bon-flo.php">G Bobby Bon Flo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102972.jpg" alt="Gemini 1"></div>
  <div class="r-details"><div class="r-band"><a href="gemini-1.php">Gemini 1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61RlNGPDsRL._UXNaN_FMjpg_QL85_.jpg" alt="Generation Freres Dejean"></div>
  <div class="r-details"><div class="r-band"><a href="generation-freres-dejean.php">Generation Freres Dejean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100384.jpg" alt="George Durand"></div>
  <div class="r-details"><div class="r-band"><a href="george-durand.php">George Durand</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103025.jpg" alt="Georges Loubert Chancy"></div>
  <div class="r-details"><div class="r-band"><a href="georges-loubert-chancy.php">Georges Loubert Chancy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106727.jpg" alt="Georges Plonquitte ft. Les Frères Déjean"></div>
  <div class="r-details"><div class="r-band"><a href="georges-plonquitte-ft-les-freres-dejean.php">Georges Plonquitte ft. Les Frères Déjean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/ff0cf19ba46fa5ae8e9583e15028fafa/250x250-000000-80-0-0.jpg" alt="Gep nwa"></div>
  <div class="r-details"><div class="r-band"><a href="gep-nwa.php">Gep nwa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100392.jpg" alt="Gerald Merceron"></div>
  <div class="r-details"><div class="r-band"><a href="gerald-merceron.php">Gerald Merceron</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103384.jpg" alt="Gérard Dupervil"></div>
  <div class="r-details"><div class="r-band"><a href="gerard-dupervil.php">Gérard Dupervil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103886.jpg" alt="Gérard Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="gerard-pierre.php">Gérard Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104349.jpg" alt="Gérard Thifault and Maniboulas Orchestra"></div>
  <div class="r-details"><div class="r-band"><a href="gerard-thifault-and-maniboulas-orchestra.php">Gérard Thifault and Maniboulas Orchestra</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106557.jpg" alt="Germa Adan"></div>
  <div class="r-details"><div class="r-band"><a href="germa-adan.php">Germa Adan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100395.jpg" alt="Gerostar"></div>
  <div class="r-details"><div class="r-band"><a href="gerostar.php">Gerostar</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41OidczzGCL._UXNaN_FMjpg_QL85_.jpg" alt="Gessica Généus"></div>
  <div class="r-details"><div class="r-band"><a href="gessica-geneus.php">Gessica Généus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103277.jpg" alt="Gifrants"></div>
  <div class="r-details"><div class="r-band"><a href="gifrants.php">Gifrants</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51DJZvDNH+L._UXNaN_FMjpg_QL85_.jpg" alt="Gig"></div>
  <div class="r-details"><div class="r-band"><a href="gig.php">Gig</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1c85cd8ec1eae1843cd50bab0c47e8b0/250x250-000000-80-0-0.jpg" alt="Gilbert Dabady"></div>
  <div class="r-details"><div class="r-band"><a href="gilbert-dabady.php">Gilbert Dabady</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41yeLTtE4zL._UF1000,1000_QL80_.jpg" alt="Gina Dupervil"></div>
  <div class="r-details"><div class="r-band"><a href="gina-dupervil.php">Gina Dupervil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103336.jpg" alt="Ginou"></div>
  <div class="r-details"><div class="r-band"><a href="ginou.php">Ginou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c8ec54b81ee828fd62a2cd02aa296d3f/250x250-000000-80-0-0.jpg" alt="Ginou Pierre Taverne"></div>
  <div class="r-details"><div class="r-band"><a href="ginou-pierre-taverne.php">Ginou Pierre Taverne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105754.jpg" alt="Gisele"></div>
  <div class="r-details"><div class="r-band"><a href="gisele.php">Gisele</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104420.jpg" alt="Gisele & Tony"></div>
  <div class="r-details"><div class="r-band"><a href="gisele-tony.php">Gisele & Tony</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41AtrQU4QML._UXNaN_FMjpg_QL85_.jpg" alt="Givens Francois"></div>
  <div class="r-details"><div class="r-band"><a href="givens-francois.php">Givens Francois</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/0b55d18478a7b5f5d325d502ec774f34/1900x1900-000000-80-0-0.jpg" alt="GM Connection"></div>
  <div class="r-details"><div class="r-band"><a href="gm-connection.php">GM Connection</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/91Sq6kKe+1L._UF1000,1000_QL80_.jpg" alt="Godwin Louis"></div>
  <div class="r-details"><div class="r-band"><a href="godwin-louis.php">Godwin Louis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105857.jpg" alt="Gogo"></div>
  <div class="r-details"><div class="r-band"><a href="gogo.php">Gogo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c564c6b8c6784cb86af6b1ca8d62d9fc/250x250-000000-80-0-0.jpg" alt="Golden Light Band"></div>
  <div class="r-details"><div class="r-band"><a href="golden-light-band.php">Golden Light Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/rmXtWX9/Cover.jpg" alt="Goldy Empire"></div>
  <div class="r-details"><div class="r-band"><a href="goldy-empire.php">Goldy Empire</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/615Rra7923L._UXNaN_FMjpg_QL85_.jpg" alt="Goodsound"></div>
  <div class="r-details"><div class="r-band"><a href="goodsound.php">Goodsound</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106406.jpg" alt="Gold Smith Dorval"></div>
  <div class="r-details"><div class="r-band"><a href="gold-smith-dorval.php">Gold Smith Dorval</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c5e60f3b656564a26affd1890c3be7f5/250x250-000000-80-0-0.jpg" alt="Good Tang"></div>
  <div class="r-details"><div class="r-band"><a href="good-tang.php">Good Tang</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/67b90053953e89998703ab34751372ad/250x250-000000-80-0-0.jpg" alt="Gospel Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="gospel-kreyol.php">Gospel Kreyol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51TXfB0-f1L._UXNaN_FMjpg_QL85_.jpg" alt="GQ Nyce"></div>
  <div class="r-details"><div class="r-band"><a href="gq-nyce.php">GQ Nyce</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/fd976f8eefbe7134fc6d58741071e44d/250x250-000000-80-0-0.jpg" alt="G-Renel Machiavel"></div>
  <div class="r-details"><div class="r-band"><a href="g-renel-machiavel.php">G-Renel Machiavel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/8c5a7aaa17759f8158ebcc67ff1b7d24/500x500.jpg" alt="Gracia Delva"></div>
  <div class="r-details"><div class="r-band"><a href="gracia-delva.php">Gracia Delva</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104132.jpg" alt="Gravity"></div>
  <div class="r-details"><div class="r-band"><a href="gravity.php">Gravity</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106646.jpg" alt="Grégory Laforest"></div>
  <div class="r-details"><div class="r-band"><a href="gregory-laforest.php">Grégory Laforest</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100399.jpg" alt="Gregory Laporte"></div>
  <div class="r-details"><div class="r-band"><a href="gregory-laporte.php">Gregory Laporte</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103887.jpg" alt="Gregory Telfort"></div>
  <div class="r-details"><div class="r-band"><a href="gregory-telfort.php">Gregory Telfort</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105682.jpg" alt="Grenn Banbou"></div>
  <div class="r-details"><div class="r-band"><a href="grenn-banbou.php">Grenn Banbou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101832.jpg" alt="Groov La"></div>
  <div class="r-details"><div class="r-band"><a href="groov-la.php">Groov La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102404.jpg" alt="Groov Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="groov-kompa.php">Groov Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101961.jpg" alt="Groove Kreol"></div>
  <div class="r-details"><div class="r-band"><a href="groove-kreol.php">Groove Kreol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105236.jpg" alt="Group Citadelle Records"></div>
  <div class="r-details"><div class="r-band"><a href="group-citadelle-records.php">Group Citadelle Records</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105377.jpg" alt="Groupe BMK"></div>
  <div class="r-details"><div class="r-band"><a href="groupe-bmk.php">Groupe BMK</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/329521f571589f86f7c4bf08ec66c16f/250x250-000000-80-0-0.jpg" alt="Groupe Grace"></div>
  <div class="r-details"><div class="r-band"><a href="groupe-grace.php">Groupe Grace</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7b76673d51c53d8abe139bd301554826/250x250-000000-80-0-0.jpg" alt="Groupe Grâce de Montréal"></div>
  <div class="r-details"><div class="r-band"><a href="groupe-grace-de-montreal.php">Groupe Grâce de Montréal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/bb8a9e5d993c0e58c53d85518c417c14/250x250-000000-80-0-0.jpg" alt="Groupe Nissi Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="groupe-nissi-haiti.php">Groupe Nissi Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104884.jpg" alt="Groupe Rev"></div>
  <div class="r-details"><div class="r-band"><a href="groupe-rev.php">Groupe Rev</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/04d073ffdaf075c193f3d6741ecbdb08/250x250-000000-80-0-0.jpg" alt="Grupo Vocal Desandann"></div>
  <div class="r-details"><div class="r-band"><a href="grupo-vocal-desandann.php">Grupo Vocal Desandann</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/QncHTHJ/Cover.jpg" alt="Guada Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="guada-mizik.php">Guada Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/48262b80d398cad1c0ae3cfd48880c0d/250x250-000000-80-0-0.jpg" alt="Guelce Holly"></div>
  <div class="r-details"><div class="r-band"><a href="guelce-holly.php">Guelce Holly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/510qYVzBpQS._UXNaN_FMjpg_QL85_.jpg" alt="Guerby"></div>
  <div class="r-details"><div class="r-band"><a href="guerby.php">Guerby</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102229.jpg" alt="Guerda Hector"></div>
  <div class="r-details"><div class="r-band"><a href="guerda-hector.php">Guerda Hector</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/f43c05cffa6f72d25817be9a59641bfb/250x250-000000-80-0-0.jpg" alt="Guerda Victor"></div>
  <div class="r-details"><div class="r-band"><a href="guerda-victor.php">Guerda Victor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/4945af30a3f6870c9f46967b80b77a08/250x250-000000-80-0-0.jpg" alt="Guerschon Chariot"></div>
  <div class="r-details"><div class="r-band"><a href="guerschon-chariot.php">Guerschon Chariot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8367f5b1712c7e45771164632be5b591/250x250-000000-80-0-0.jpg" alt="Guito Vitamine"></div>
  <div class="r-details"><div class="r-band"><a href="guito-vitamine.php">Guito Vitamine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100405.jpg" alt="Guy Durosier"></div>
  <div class="r-details"><div class="r-band"><a href="guy-durosier.php">Guy Durosier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106111.jpg" alt="Guy Pageot"></div>
  <div class="r-details"><div class="r-band"><a href="guy-pageot.php">Guy Pageot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/y2005/m06/d04/h20/s07.bwfbrbri.tif/486x486bb.png" alt="Guy Robert Jean"></div>
  <div class="r-details"><div class="r-band"><a href="guy-robert-jean.php">Guy Robert Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a494d59e461492a493261ab8d996c1f9/250x250-000000-80-0-0.jpg" alt="Gwad Aïti"></div>
  <div class="r-details"><div class="r-band"><a href="gwad-aiti.php">Gwad Aïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105855.jpg" alt="Gwayabel & Bradley Barthelemy"></div>
  <div class="r-details"><div class="r-band"><a href="gwayabel-bradley-barthelemy.php">Gwayabel & Bradley Barthelemy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103232.jpg" alt="Gwo-Lobo"></div>
  <div class="r-details"><div class="r-band"><a href="gwo-lobo.php">Gwo-Lobo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/4c02af59af78e003cadc2bebc08740d4/250x250-000000-80-0-0.jpg" alt="Gwotèt"></div>
  <div class="r-details"><div class="r-band"><a href="gwotet.php">Gwotèt</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105600.jpg" alt="Gypdies de Jean Eddy Charleus"></div>
  <div class="r-details"><div class="r-band"><a href="gypdies-de-jean-eddy-charleus.php">Gypdies de Jean Eddy Charleus</a></div></div>
</div>


    <!-- Tu peux continuer à ajouter d'autres groupes ici -->

  </div>

  <script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>