<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>H - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>

  <!-- Liste verticale des albums -->
  <div class="album-list">
      
    <!-- Liste des artistes -->
    <div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103778.jpg" alt="Haiti Radio Choir & Quartet"></div>
  <div class="r-details"><div class="r-band"><a href="haiti-radio-choir-quartet.php">Haiti Radio Choir & Quartet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/1/1740968484-haiti-twoubadou.jpg" alt="Haïti Twoubadou"></div>
  <div class="r-details"><div class="r-band"><a href="haiti-twoubadou.php">Haïti Twoubadou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/791b1d7947ec70a6ae6aa37bdfad84cd/250x250-000000-80-0-0.jpg" alt="Haitianbeats"></div>
  <div class="r-details"><div class="r-band"><a href="haitianbeats.php">Haitianbeats</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://thisis-images.spotifycdn.com/37i9dQZF1DZ06evO1XGsym-default.jpg" alt="Haitiando"></div>
  <div class="r-details"><div class="r-band"><a href="haitiando.php">Haitiando</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f7a8ba6cd3e29c6cc5cfddc7f12b5ef1/250x250-000000-80-0-0.jpg" alt="Hakim_Wil"></div>
  <div class="r-details"><div class="r-band"><a href="hakim-wil.php">Hakim_Wil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100002.jpg" alt="Hamerton Lilavois"></div>
  <div class="r-details"><div class="r-band"><a href="hamerton-lilavois.php">Hamerton Lilavois</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5c5d6f72ffa4166eef310c23a34a1df9/250x250-000000-80-0-0.jpg" alt="Hangout"></div>
  <div class="r-details"><div class="r-band"><a href="hangout.php">Hangout</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b829be5d92fb56f5f4ed92e38ed1d8c9/250x250-000000-80-0-0.jpg" alt="Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="haiti.php">Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100413.jpg" alt="Haiti All-Stars"></div>
  <div class="r-details"><div class="r-band"><a href="haiti-all-stars.php">Haiti All-Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105967.jpg" alt="Haïtian National Folklore Group"></div>
  <div class="r-details"><div class="r-band"><a href="haitian-national-folklore-group.php">Haïtian National Folklore Group</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/7/1743345200-harmonik.png" alt="Harmonik"></div>
  <div class="r-details"><div class="r-band"><a href="harmonik.php">Harmonik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51204ET4RbL._UF1000,1000_QL80_.jpg" alt="Harold Faustin"></div>
  <div class="r-details"><div class="r-band"><a href="harold-faustin.php">Harold Faustin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/71UoX0lb1JL._UF1000,1000_QL80_.jpg" alt="Harold Jean-Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="harold-jean-pierre.php">Harold Jean-Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105049.jpg" alt="Harry A Moise"></div>
  <div class="r-details"><div class="r-band"><a href="harry-a-moise.php">Harry A Moise</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d3aa7629f7921a4a8f7496f737699137/250x250-000000-80-0-0.jpg" alt="Harold Jean-Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="harold-jean-pierre.php">Harold Jean-Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103892.jpg" alt="Harry Brice"></div>
  <div class="r-details"><div class="r-band"><a href="harry-brice.php">Harry Brice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105508.jpg" alt="Harry Star"></div>
  <div class="r-details"><div class="r-band"><a href="harry-star.php">Harry Star</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104217.jpg" alt="Haytian Orchestra – Justin Elie"></div>
  <div class="r-details"><div class="r-band"><a href="haytian-orchestra-justin-elie.php">Haytian Orchestra – Justin Elie</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106207.jpg" alt="Helping Hand"></div>
  <div class="r-details"><div class="r-band"><a href="helping-hand.php">Helping Hand</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104308.jpg" alt="Henri Pierre-Noël"></div>
  <div class="r-details"><div class="r-band"><a href="henri-pierre-noel.php">Henri Pierre-Noël</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104616.jpg" alt="Henry Dorval"></div>
  <div class="r-details"><div class="r-band"><a href="henry-dorval.php">Henry Dorval</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104616.jpg" alt="Henry Dorval & Felix St. Fort"></div>
  <div class="r-details"><div class="r-band"><a href="henry-dorval-felix-st-fort.php">Henry Dorval & Felix St. Fort</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101546.jpg" alt="Herby Widmaier"></div>
  <div class="r-details"><div class="r-band"><a href="herby-widmaier.php">Herby Widmaier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104900.jpg" alt="Herman Desamours"></div>
  <div class="r-details"><div class="r-band"><a href="herman-desamours.php">Herman Desamours</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104625.jpg" alt="Herman Nau"></div>
  <div class="r-details"><div class="r-band"><a href="herman-nau.php">Herman Nau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100415.jpg" alt="Herold Christophe"></div>
  <div class="r-details"><div class="r-band"><a href="herold-christophe.php">Herold Christophe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106690.jpg" alt="Herold One Man Band"></div>
  <div class="r-details"><div class="r-band"><a href="herold-one-man-band.php">Herold One Man Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51FWlVLDtJL._UXNaN_FMjpg_QL85_.jpg" alt="Herve Jerome et Les Kassyk Du Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="herve-jerome-et-les-kassyk-du-konpa.php">Herve Jerome et Les Kassyk Du Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104555.jpg" alt="Hogo Andre"></div>
  <div class="r-details"><div class="r-band"><a href="hogo-andre.php">Hogo Andre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106695.jpg" alt="Holby You"></div>
  <div class="r-details"><div class="r-band"><a href="holby-you.php">Holby You</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/48262b80d398cad1c0ae3cfd48880c0d/250x250-000000-80-0-0.jpg" alt="Holly Guelce"></div>
  <div class="r-details"><div class="r-band"><a href="holly-guelce.php">Holly Guelce</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/79be90076dd41cbb3c2ee0b4a897c47b/250x250-000000-80-0-0.jpg" alt="Holy Music Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="holy-music-haiti.php">Holy Music Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103895.jpg" alt="Honeyman"></div>
  <div class="r-details"><div class="r-band"><a href="honeyman.php">Honeyman</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106512.jpg" alt="Honide"></div>
  <div class="r-details"><div class="r-band"><a href="honide.php">Honide</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/5/1743119118-hugues-sanon.png" alt="Hugues Sanon"></div>
  <div class="r-details"><div class="r-band"><a href="hugues-sanon.php">Hugues Sanon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106741.jpg" alt="Herve Shabba Antenor"></div>
  <div class="r-details"><div class="r-band"><a href="herve-shabba-antenor.php">Herve Shabba Antenor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103465.jpg" alt="Herns Duplan"></div>
  <div class="r-details"><div class="r-band"><a href="herns-duplan.php">Herns Duplan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104786.jpg" alt="Henri Pierre-Noël"></div>
  <div class="r-details"><div class="r-band"><a href="henri-pierre-noel.php">Henri Pierre-Noël</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102694.jpg" alt="Haiti Choc Combo"></div>
  <div class="r-details"><div class="r-band"><a href="haiti-choc-combo.php">Haiti Choc Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103320.jpg" alt="Henri"></div>
  <div class="r-details"><div class="r-band"><a href="henri.php">Henri</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104147.jpg" alt="Haïti 86"></div>
  <div class="r-details"><div class="r-band"><a href="haiti-86.php">Haïti 86</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103556.jpg" alt="Heavy Compas"></div>
  <div class="r-details"><div class="r-band"><a href="heavy-compas.php">Heavy Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101853.jpg" alt="Hip Hop Twoubadou"></div>
  <div class="r-details"><div class="r-band"><a href="hip-hop-twoubadou.php">Hip Hop Twoubadou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105049.jpg" alt="Harry A Moise"></div>
  <div class="r-details"><div class="r-band"><a href="harry-a-moise.php">Harry A Moise</a></div></div>
</div>


    <!-- Tu peux continuer à ajouter d'autres groupes ici -->

  </div>

  <script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>