<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>J - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES J -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/6rgVFM1/cover.jpg" alt="J & J GROOVE"></div>
  <div class="r-details"><div class="r-band"><a href="j-j-groove.php">J & J GROOVE</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101548.jpg" alt="J-Nesis"></div>
  <div class="r-details"><div class="r-band"><a href="j-nesis.php">J-Nesis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/57fd6e40a65153381126e22bd1af31bd/250x250-000000-80-0-0.jpg" alt="J.Perry"></div>
  <div class="r-details"><div class="r-band"><a href="j-perry.php">J.Perry</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/ca7eb41ed963b90eb69ec973996788be/250x250-000000-80-0-0.jpg" alt="J.Sway"></div>
  <div class="r-details"><div class="r-band"><a href="j-sway.php">J.Sway</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103899.jpg" alt="Jackenson"></div>
  <div class="r-details"><div class="r-band"><a href="jackenson.php">Jackenson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/09/07/24b18d96199b40008cacc531a8ffe7ae_464_464.jpg" alt="Jacques Sauveur Jean"></div>
  <div class="r-details"><div class="r-band"><a href="jacques-sauveur-jean.php">Jacques Sauveur Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101963.jpg" alt="Jackito"></div>
  <div class="r-details"><div class="r-band"><a href="jackito.php">Jackito</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106744.jpg" alt="Jacksy"></div>
  <div class="r-details"><div class="r-band"><a href="jacksy.php">Jacksy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105215.jpg" alt="Jacky & Company"></div>
  <div class="r-details"><div class="r-band"><a href="jacky-company.php">Jacky & Company</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104887.jpg" alt="Jacky Ambroise"></div>
  <div class="r-details"><div class="r-band"><a href="jacky-ambroise.php">Jacky Ambroise</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103983.jpg" alt="Jacky & Strings"></div>
  <div class="r-details"><div class="r-band"><a href="jacky-strings.php">Jacky & Strings</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103900.jpg" alt="Jacky L."></div>
  <div class="r-details"><div class="r-band"><a href="jacky-l.php">Jacky L.</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103901.jpg" alt="Jacob Michel Decimus"></div>
  <div class="r-details"><div class="r-band"><a href="jacob-michel-decimus.php">Jacob Michel Decimus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100425.jpg" alt="Jacqueline Mehu Montfleury"></div>
  <div class="r-details"><div class="r-band"><a href="jacqueline-mehu-montfleury.php">Jacqueline Mehu Montfleury</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103902.jpg" alt="Jacques Boutros"></div>
  <div class="r-details"><div class="r-band"><a href="jacques-boutros.php">Jacques Boutros</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104557.jpg" alt="Jacques Chancy"></div>
  <div class="r-details"><div class="r-band"><a href="jacques-chancy.php">Jacques Chancy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105560.jpg" alt="Jacques Fortere , Raoul Joseph, Sylomene Fevrier"></div>
  <div class="r-details"><div class="r-band"><a href="jacques-fortere-raoul-joseph-sylomene-fevrier.php">Jacques Fortere , Raoul Joseph, Sylomene Fevrier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105033.jpg" alt="Jacques François"></div>
  <div class="r-details"><div class="r-band"><a href="jacques-fran-ois.php">Jacques François</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105029.jpg" alt="Jacques Schwarz-Bart"></div>
  <div class="r-details"><div class="r-band"><a href="jacques-schwarz-bart.php">Jacques Schwarz-Bart</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103193.jpg" alt="Jaël & Fwet Cash"></div>
  <div class="r-details"><div class="r-band"><a href="jael-fwet-cash.php">Jaël & Fwet Cash</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106310.jpg" alt="Jah B Feray"></div>
  <div class="r-details"><div class="r-band"><a href="jah-b-feray.php">Jah B Feray</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106812.jpg" alt="Jah La"></div>
  <div class="r-details"><div class="r-band"><a href="jah-la.php">Jah La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101557.jpg" alt="Jah Nesta"></div>
  <div class="r-details"><div class="r-band"><a href="jah-nesta.php">Jah Nesta</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105258.jpg" alt="Jah Nissi"></div>
  <div class="r-details"><div class="r-band"><a href="jah-nissi.php">Jah Nissi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103325.jpg" alt="Jahmen"></div>
  <div class="r-details"><div class="r-band"><a href="jahmen.php">Jahmen</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105270.jpg" alt="Jam"></div>
  <div class="r-details"><div class="r-band"><a href="jam.php">Jam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103904.jpg" alt="Jam All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="jam-all-stars.php">Jam All Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105311.jpg" alt="Jam Stars"></div>
  <div class="r-details"><div class="r-band"><a href="jam-stars.php">Jam Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105097.jpg" alt="James Germain"></div>
  <div class="r-details"><div class="r-band"><a href="james-germain.php">James Germain</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8517004bb64a7ae08b240665881ff614/250x250-000000-80-0-0.jpg" alt="James Jessey Joseph"></div>
  <div class="r-details"><div class="r-band"><a href="james-jessey-joseph.php">James Jessey Joseph</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105672.jpg" alt="Jan Rabèl"></div>
  <div class="r-details"><div class="r-band"><a href="jan-rabel.php">Jan Rabèl</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106559.jpg" alt="Jan Sebon & Kazak International"></div>
  <div class="r-details"><div class="r-band"><a href="jan-sebon-kazak-international.php">Jan Sebon & Kazak International</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51XbsldeelL._UF1000,1000_QL80_.jpg" alt="Janmak"></div>
  <div class="r-details"><div class="r-band"><a href="janmak.php">Janmak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104356.jpg" alt="Jay B"></div>
  <div class="r-details"><div class="r-band"><a href="jay-b.php">Jay B</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/d0/6c/a9/d06ca997-eb3e-80fd-753a-fab38cb3d4ba/cover.jpg/486x486bb.png" alt="Jay Brixxx"></div>
  <div class="r-details"><div class="r-band"><a href="jay-brixxx.php">Jay Brixxx</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5e6e9cd3bdfd4fd86de985d31d34c6c1/250x250-000000-80-0-0.jpg" alt="Jay & John"></div>
  <div class="r-details"><div class="r-band"><a href="jay-john.php">Jay & John</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105690.jpg" alt="JayTee"></div>
  <div class="r-details"><div class="r-band"><a href="jaytee.php">JayTee</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100433.jpg" alt="Jazz Des Jeunes"></div>
  <div class="r-details"><div class="r-band"><a href="jazz-des-jeunes.php">Jazz Des Jeunes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106663.jpg" alt="Jazz Guignard"></div>
  <div class="r-details"><div class="r-band"><a href="jazz-guignard.php">Jazz Guignard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106237.jpg" alt="Jazz Pam"></div>
  <div class="r-details"><div class="r-band"><a href="jazz-pam.php">Jazz Pam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105640.jpg" alt="Jazz Pyebwa"></div>
  <div class="r-details"><div class="r-band"><a href="jazz-pyebwa.php">Jazz Pyebwa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105592.jpg" alt="JazZanm GCLA"></div>
  <div class="r-details"><div class="r-band"><a href="jazzanm-gcla.php">JazZanm GCLA</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51TrCdrMHJL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="J-Beatz"></div>
  <div class="r-details"><div class="r-band"><a href="j-beatz.php">J-Beatz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Jean, Jac & Jo"></div>
  <div class="r-details"><div class="r-band"><a href="jean-jac-jo.php">Jean, Jac & Jo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103437.jpg" alt="Jean Badette l'Homme Orchestre"></div>
  <div class="r-details"><div class="r-band"><a href="jean-badette-l-homme-orchestre.php">Jean Badette l'Homme Orchestre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104069.jpg" alt="Jean Bernard Thomas"></div>
  <div class="r-details"><div class="r-band"><a href="jean-bernard-thomas.php">Jean Bernard Thomas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105262.jpg" alt="Jean Caze"></div>
  <div class="r-details"><div class="r-band"><a href="jean-caze.php">Jean Caze</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c61248dbc4df1e111cd5e9499c428cad/250x250-000000-80-0-0.jpg" alt="Jean Claude Derisier"></div>
  <div class="r-details"><div class="r-band"><a href="jean-claude-derisier.php">Jean Claude Derisier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100437.jpg" alt="Jean-Claude Eugène"></div>
  <div class="r-details"><div class="r-band"><a href="jean-claude-eugene.php">Jean-Claude Eugène</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103907.jpg" alt="Jean-Claude Guillaume"></div>
  <div class="r-details"><div class="r-band"><a href="jean-claude-guillaume.php">Jean-Claude Guillaume</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105599.jpg" alt="Jean-Claude Martineau"></div>
  <div class="r-details"><div class="r-band"><a href="jean-claude-martineau.php">Jean-Claude Martineau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105607.jpg" alt="Jean-Claude Petion"></div>
  <div class="r-details"><div class="r-band"><a href="jean-claude-petion.php">Jean-Claude Petion</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100435.jpg" alt="Jean Cilianus"></div>
  <div class="r-details"><div class="r-band"><a href="jean-cilianus.php">Jean Cilianus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/186de811798c0fbd649db82bf8f9a818/250x250-000000-80-0-0.jpg" alt="Jean Élie Brutus"></div>
  <div class="r-details"><div class="r-band"><a href="jean-elie-brutus.php">Jean Élie Brutus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105932.jpg" alt="Jean Coulanges"></div>
  <div class="r-details"><div class="r-band"><a href="jean-coulanges.php">Jean Coulanges</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/25191b72005a9aad4777344ea8df3818/250x250-000000-80-0-0.jpg" alt="jean-Guy Coulanges"></div>
  <div class="r-details"><div class="r-band"><a href="jean-guy-coulanges.php">jean-Guy Coulanges</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103539.jpg" alt="Jean Durand"></div>
  <div class="r-details"><div class="r-band"><a href="jean-durand.php">Jean Durand</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Jean Etzert Frédérique"></div>
  <div class="r-details"><div class="r-band"><a href="jean-etzert-frederique.php">Jean Etzert Frédérique</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106157.jpg" alt="Jean Jean Roosevelt"></div>
  <div class="r-details"><div class="r-band"><a href="jean-jean-roosevelt.php">Jean Jean Roosevelt</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102068.jpg" alt="Jean Jean-Pierre & Kiskeya: The Haitian Orchestra"></div>
  <div class="r-details"><div class="r-band"><a href="jean-jean-pierre-kiskeya-the-haitian-orchestra.php">Jean Jean-Pierre & Kiskeya: The Haitian Orchestra</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104558.jpg" alt="Jean Marc Montrose"></div>
  <div class="r-details"><div class="r-band"><a href="jean-marc-montrose.php">Jean Marc Montrose</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/733781eff9b872ab9ba6145cd6c43dc5/250x250-000000-80-0-0.jpg" alt="Jean Marie Desir"></div>
  <div class="r-details"><div class="r-band"><a href="jean-marie-desir.php">Jean Marie Desir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103654.jpg" alt="Jean Michel Clermont"></div>
  <div class="r-details"><div class="r-band"><a href="jean-michel-clermont.php">Jean Michel Clermont</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51D9OivCYFL._UXNaN_FMjpg_QL85_.jpg" alt="Jeannot Jourdain"></div>
  <div class="r-details"><div class="r-band"><a href="jeannot-jourdain.php">Jeannot Jourdain</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/515ah8ciDlL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Jean Rene Charles"></div>
  <div class="r-details"><div class="r-band"><a href="jean-rene-charles.php">Jean Rene Charles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105141.jpg" alt="Jean Robert Jean"></div>
  <div class="r-details"><div class="r-band"><a href="jean-robert-jean.php">Jean Robert Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102219.jpg" alt="Jean-Joseph Romain"></div>
  <div class="r-details"><div class="r-band"><a href="jean-joseph-romain.php">Jean-Joseph Romain</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104787.jpg" alt="Jean Sejour et Son Cumbo"></div>
  <div class="r-details"><div class="r-band"><a href="jean-sejour-et-son-cumbo.php">Jean Sejour et Son Cumbo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102273.jpg" alt="Jean Vincent / Alberto Socarras & Orchestre"></div>
  <div class="r-details"><div class="r-band"><a href="jean-vincent-alberto-socarras-orchestre.php">Jean Vincent / Alberto Socarras & Orchestre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105513.jpg" alt="Jean-Marc Pastel"></div>
  <div class="r-details"><div class="r-band"><a href="jean-marc-pastel.php">Jean-Marc Pastel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100441.jpg" alt="Jean-Michel Daudier"></div>
  <div class="r-details"><div class="r-band"><a href="jean-michel-daudier.php">Jean-Michel Daudier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103263.jpg" alt="Jeancky"></div>
  <div class="r-details"><div class="r-band"><a href="jeancky.php">Jeancky</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106110.jpg" alt="Jeff Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="jeff-pierre.php">Jeff Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/39df4e83c1948e8bac8110e16a517172/250x250-000000-80-0-0.jpg" alt="Jehud"></div>
  <div class="r-details"><div class="r-band"><a href="jehud.php">Jehud</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105185.jpg" alt="Jenny Salgado"></div>
  <div class="r-details"><div class="r-band"><a href="jenny-salgado.php">Jenny Salgado</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106304.jpg" alt="Jephté Guillaume"></div>
  <div class="r-details"><div class="r-band"><a href="jephte-guillaume.php">Jephté Guillaume</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/43c6e6428c92311f45dabeb61130bf45/250x250-000000-80-0-0.jpg" alt="Jeriele Prudent"></div>
  <div class="r-details"><div class="r-band"><a href="jeriele-prudent.php">Jeriele Prudent</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103910.jpg" alt="Jessie Desir"></div>
  <div class="r-details"><div class="r-band"><a href="jessie-desir.php">Jessie Desir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106446.jpg" alt="Jessie Simmons"></div>
  <div class="r-details"><div class="r-band"><a href="jessie-simmons.php">Jessie Simmons</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Jetsemanï"></div>
  <div class="r-details"><div class="r-band"><a href="jetsemani.php">Jetsemanï</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104846.jpg" alt="Jezu Bon"></div>
  <div class="r-details"><div class="r-band"><a href="jezu-bon.php">Jezu Bon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103369.jpg" alt="Jho Archer"></div>
  <div class="r-details"><div class="r-band"><a href="jho-archer.php">Jho Archer</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105750.jpg" alt="Jhon Clark Parent"></div>
  <div class="r-details"><div class="r-band"><a href="jhon-clark-parent.php">Jhon Clark Parent</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/58e06848c4debdb6693b4c81bb82099d/250x250-000000-80-0-0.jpg" alt="Jiksdé"></div>
  <div class="r-details"><div class="r-band"><a href="jiksde.php">Jiksdé</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51YexPIDLvL._UXNaN_FMjpg_QL85_.jpg" alt="Jocel Almeus"></div>
  <div class="r-details"><div class="r-band"><a href="jocel-almeus.php">Jocel Almeus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105603.jpg" alt="Jocelyn Hyppolite"></div>
  <div class="r-details"><div class="r-band"><a href="jocelyn-hyppolite.php">Jocelyn Hyppolite</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/724d68bea21b737a70657f0d18d32ce2/1900x1900-000000-80-0-0.jpg" alt="Jocelyne Dorisme"></div>
  <div class="r-details"><div class="r-band"><a href="jocelyne-dorisme.php">Jocelyne Dorisme</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106463.jpg" alt="Joé Dwèt Filé"></div>
  <div class="r-details"><div class="r-band"><a href="joe-dwet-file.php">Joé Dwèt Filé</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101894.jpg" alt="Joe Jack"></div>
  <div class="r-details"><div class="r-band"><a href="joe-jack.php">Joe Jack</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103174.jpg" alt="Joe Trouillot"></div>
  <div class="r-details"><div class="r-band"><a href="joe-trouillot.php">Joe Trouillot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/45ad0b6c3663b21e63665ead3a3080fb/250x250-000000-80-0-0.jpg" alt="Joel Momento"></div>
  <div class="r-details"><div class="r-band"><a href="joel-momento.php">Joel Momento</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103537.jpg" alt="Joel Theodore"></div>
  <div class="r-details"><div class="r-band"><a href="joel-theodore.php">Joel Theodore</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101559.jpg" alt="John Steve Brunache"></div>
  <div class="r-details"><div class="r-band"><a href="john-steve-brunache.php">John Steve Brunache</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105949.jpg" alt="Johnbern Thomas Trio"></div>
  <div class="r-details"><div class="r-band"><a href="johnbern-thomas-trio.php">Johnbern Thomas Trio</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103717.jpg" alt="Johnny"></div>
  <div class="r-details"><div class="r-band"><a href="johnny.php">Johnny</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51IBeaPM-HL._UXNaN_FMjpg_QL85_.jpg" alt="Johnny Frantz Toussaint du Skah-Shah #1"></div>
  <div class="r-details"><div class="r-band"><a href="johnny-frantz-toussaint-du-skah-shah-1.php">Johnny Frantz Toussaint du Skah-Shah #1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27350f5ac25bf8b3afd97cb613d" alt="Johnny V.S. Officiel"></div>
  <div class="r-details"><div class="r-band"><a href="johnny-v-s-officiel.php">Johnny V.S. Officiel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106635.jpg" alt="Johny Posse"></div>
  <div class="r-details"><div class="r-band"><a href="johny-posse.php">Johny Posse</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105217.jpg" alt="Jojo Compas"></div>
  <div class="r-details"><div class="r-band"><a href="jojo-compas.php">Jojo Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105050.jpg" alt="Jonel"></div>
  <div class="r-details"><div class="r-band"><a href="jonel.php">Jonel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c2cb42262a641f53c0e9415f0cbc192d/250x250-000000-80-0-0.jpg" alt="Jorba P Yah Know"></div>
  <div class="r-details"><div class="r-band"><a href="jorba-p-yah-know.php">Jorba P Yah Know</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/cce8125691fbe81cae8d2c1997ad568c/250x250-000000-80-0-0.jpg" alt="Jorvin Keyz"></div>
  <div class="r-details"><div class="r-band"><a href="jorvin-keyz.php">Jorvin Keyz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105916.jpg" alt="Josée"></div>
  <div class="r-details"><div class="r-band"><a href="josee.php">Josée</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103358.jpg" alt="Joseito"></div>
  <div class="r-details"><div class="r-band"><a href="joseito.php">Joseito</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103825.jpg" alt="José Tavernier"></div>
  <div class="r-details"><div class="r-band"><a href="jose-tavernier.php">José Tavernier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105231.jpg" alt="Joseph Augustin R.P."></div>
  <div class="r-details"><div class="r-band"><a href="joseph-augustin-r-p.php">Joseph Augustin R.P.</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106438.jpg" alt="Joseph Laine “Blagueur”"></div>
  <div class="r-details"><div class="r-band"><a href="joseph-laine-blagueur.php">Joseph Laine “Blagueur”</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105847.jpg" alt="Joseph Duroseau and his Orchestre"></div>
  <div class="r-details"><div class="r-band"><a href="joseph-duroseau-and-his-orchestre.php">Joseph Duroseau and his Orchestre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106515.jpg" alt="Joseph Frantz Louis"></div>
  <div class="r-details"><div class="r-band"><a href="joseph-frantz-louis.php">Joseph Frantz Louis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105481.jpg" alt="Josephine Premice"></div>
  <div class="r-details"><div class="r-band"><a href="josephine-premice.php">Josephine Premice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106537.jpg" alt="Josue Alexis"></div>
  <div class="r-details"><div class="r-band"><a href="josue-alexis.php">Josue Alexis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/da74bce64296cc2840519b54984ac629/250x250-000000-80-0-0.jpg" alt="josue Elisme"></div>
  <div class="r-details"><div class="r-band"><a href="josue-elisme.php">josue Elisme</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b93062062f32aff3f566131ab4bbbb26/250x250-000000-80-0-0.jpg" alt="Jovans Lorquet"></div>
  <div class="r-details"><div class="r-band"><a href="jovans-lorquet.php">Jovans Lorquet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104357.jpg" alt="Jovenel Saint-Phard & Kompas Du Sud"></div>
  <div class="r-details"><div class="r-band"><a href="jovenel-saint-phard-kompas-du-sud.php">Jovenel Saint-Phard & Kompas Du Sud</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/239be55b5ace439584381bc37318e8b4/250x250-000000-80-0-0.jpg" alt="Joujou Casimir Crevecoeur"></div>
  <div class="r-details"><div class="r-band"><a href="joujou-casimir-crevecoeur.php">Joujou Casimir Crevecoeur</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105700.jpg" alt="Jowee Omicil"></div>
  <div class="r-details"><div class="r-band"><a href="jowee-omicil.php">Jowee Omicil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5eb163f6fd5f41f7c937a15b9c0" alt="J-Ron"></div>
  <div class="r-details"><div class="r-band"><a href="j-ron.php">J-Ron</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105291.jpg" alt="Joyshanti Dominique Sylvain"></div>
  <div class="r-details"><div class="r-band"><a href="joyshanti-dominique-sylvain.php">Joyshanti Dominique Sylvain</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102600.jpg" alt="Ju Kann"></div>
  <div class="r-details"><div class="r-band"><a href="ju-kann.php">Ju Kann</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106269.jpg" alt="Jude Charles"></div>
  <div class="r-details"><div class="r-band"><a href="jude-charles.php">Jude Charles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102701.jpg" alt="Jude Jean"></div>
  <div class="r-details"><div class="r-band"><a href="jude-jean.php">Jude Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106616.jpg" alt="Jude Jean Platel"></div>
  <div class="r-details"><div class="r-band"><a href="jude-jean-platel.php">Jude Jean Platel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100465.jpg" alt="Judin et Elsie"></div>
  <div class="r-details"><div class="r-band"><a href="judin-et-elsie.php">Judin et Elsie</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100466.jpg" alt="Judin Solo"></div>
  <div class="r-details"><div class="r-band"><a href="judin-solo.php">Judin Solo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/7d5cd118355137071be052249ac1c2b7/250x250-000000-80-0-0.jpg" alt="Judith Rejouis"></div>
  <div class="r-details"><div class="r-band"><a href="judith-rejouis.php">Judith Rejouis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/fff168741946242a530e09c627a23d63/250x250-000000-80-0-0.jpg" alt="Jules Molière Juicy"></div>
  <div class="r-details"><div class="r-band"><a href="jules-moliere-juicy.php">Jules Molière Juicy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104369.jpg" alt="Jules"></div>
  <div class="r-details"><div class="r-band"><a href="jules.php">Jules</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103264.jpg" alt="Julietta Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="julietta-haiti.php">Julietta Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106082.jpg" alt="Julien Paul"></div>
  <div class="r-details"><div class="r-band"><a href="julien-paul.php">Julien Paul</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105365.jpg" alt="Julio Jean"></div>
  <div class="r-details"><div class="r-band"><a href="julio-jean.php">Julio Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106104.jpg" alt="Junior Bazile"></div>
  <div class="r-details"><div class="r-band"><a href="junior-bazile.php">Junior Bazile</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/FR/Images_Produits/FR/fnac.com/ZoomPE/6/2/3/3433191649326/tsp20130125171503/Biznes-la-move.jpg" alt="Justin Benares"></div>
  <div class="r-details"><div class="r-band"><a href="justin-benares.php">Justin Benares</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106701.jpg" alt="Justiny Destiny"></div>
  <div class="r-details"><div class="r-band"><a href="justiny-destiny.php">Justiny Destiny</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/e26237153cdb916d1d572d62d00ea665/250x250-000000-80-0-0.jpg" alt="Justman Update"></div>
  <div class="r-details"><div class="r-band"><a href="justman-update.php">Justman Update</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105213.jpg" alt="Juvo Combo"></div>
  <div class="r-details"><div class="r-band"><a href="juvo-combo.php">Juvo Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://64.media.tumblr.com/0ccef1f618cdd91f06fd60f878bc810e/tumblr_osebxazCMS1u9yd3mo1_1280.jpg" alt="Joël + Zèklè"></div>
  <div class="r-details"><div class="r-band"><a href="joel-zekle.php">Joël + Zèklè</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105063.jpg" alt="Jet-X"></div>
  <div class="r-details"><div class="r-band"><a href="jet-x.php">Jet-X</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103262.jpg" alt="Jan-Jan Dezire"></div>
  <div class="r-details"><div class="r-band"><a href="jan-jan-dezire.php">Jan-Jan Dezire</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/ff5421a89ed4427aeed8c4c6eb59e674/250x250-000000-80-0-0.jpg" alt="JLS"></div>
  <div class="r-details"><div class="r-band"><a href="jls.php">JLS</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105216.jpg" alt="j-R"></div>
  <div class="r-details"><div class="r-band"><a href="j-r.php">j-R</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100464.jpg" alt="Jovial Ti Plume"></div>
  <div class="r-details"><div class="r-band"><a href="jovial-ti-plume.php">Jovial Ti Plume</a></div></div>
</div>




  
  </div>
  </main>
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>