<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>K - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES I -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/ddba44db55b0335eaf26f4f5ce7cd415/250x250-000000-80-0-0.jpg" alt="Kabysh"></div>
  <div class="r-details"><div class="r-band"><a href="kabysh.php">Kabysh</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/lBz-CXeFwYVhaKA5stSGWEYs2k1J1rkPZ89ebegPUm4/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTczMzQw/OTMtMTQzOTE0NDgw/Ny03ODExLmpwZWc.jpeg" alt="Kachimbo"></div>
  <div class="r-details"><div class="r-band"><a href="kachimbo.php">Kachimbo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100470.jpg" alt="Kadanss"></div>
  <div class="r-details"><div class="r-band"><a href="kadanss.php">Kadanss</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f204356f34ec486ab9593205b8c1842f/250x250-000000-80-0-0.jpg" alt="Kadna-C"></div>
  <div class="r-details"><div class="r-band"><a href="kadna-c.php">Kadna-C</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/3bdf372a6a11604d12ec1f3cc2e8a278/250x250-000000-80-0-0.jpg" alt="Kado"></div>
  <div class="r-details"><div class="r-band"><a href="kado.php">Kado</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/5132fVDHh7L._UXNaN_FMjpg_QL85_.jpg" alt="Kafuu"></div>
  <div class="r-details"><div class="r-band"><a href="kafuu.php">Kafuu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-FOQQzTZCiRA135dN-yOLJoA-t500x500.jpg" alt="Kai"></div>
  <div class="r-details"><div class="r-band"><a href="kai.php">Kai</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/5332f0f19ec5eb2f82e191cb20db39d3/250x250-000000-80-0-0.jpg" alt="Kajessa"></div>
  <div class="r-details"><div class="r-band"><a href="kajessa.php">Kajessa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100472.jpg" alt="Kajou"></div>
  <div class="r-details"><div class="r-band"><a href="kajou.php">Kajou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100108.jpg" alt="Kalito Koupe"></div>
  <div class="r-details"><div class="r-band"><a href="kalito-koupe.php">Kalito Koupe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f2882d69bd841f8a14a1968095667614/250x250-000000-80-0-0.jpg" alt="Kamo Flaj"></div>
  <div class="r-details"><div class="r-band"><a href="kamo-flaj.php">Kamo Flaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/16ac8890c405333577fa8d80e03e8330/250x250-000000-80-0-0.jpg" alt="Kana"></div>
  <div class="r-details"><div class="r-band"><a href="kana.php">Kana</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/eb3a875956b05f6fd6a001521e37eaa4/250x250-000000-80-0-0.jpg" alt="Kanis"></div>
  <div class="r-details"><div class="r-band"><a href="kanis.php">Kanis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273db0d8eedec37da09177a8425" alt="Kanpech"></div>
  <div class="r-details"><div class="r-band"><a href="kanpech.php">Kanpech</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100475.jpg" alt="Kampesh Li Boule"></div>
  <div class="r-details"><div class="r-band"><a href="kampesh-li-boule.php">Kampesh Li Boule</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/3612feea8f27057d967af91680b55f11/250x250-000000-80-0-0.jpg" alt="Kapi"></div>
  <div class="r-details"><div class="r-band"><a href="kapi.php">Kapi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104298.jpg" alt="Karess"></div>
  <div class="r-details"><div class="r-band"><a href="karess.php">Karess</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/6aee428d3315cef2c3158131dc37edc5/250x250-000000-80-0-0.jpg" alt="Karizma"></div>
  <div class="r-details"><div class="r-band"><a href="karizma.php">Karizma</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/b71067ef8ca2dff11dc013657164de13/1900x1900-000000-80-0-0.jpg" alt="Karma Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="karma-haiti.php">Karma Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100477.jpg" alt="Kas kad"></div>
  <div class="r-details"><div class="r-band"><a href="kas-kad.php">Kas kad</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.musicamonette.ca/cdn/shop/products/412ezXicPnL._AC.jpg?v=1636675112" alt="Kaskad Montreal"></div>
  <div class="r-details"><div class="r-band"><a href="kaskad-montreal.php">Kaskad Montreal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/d4ed6c998a55b06c550891be0f3575c8/250x250-000000-80-0-0.jpg" alt="Kat X Kat 4 X 4"></div>
  <div class="r-details"><div class="r-band"><a href="kat-x-kat-4-x-4.php">Kat X Kat 4 X 4</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103359.jpg" alt="Kata"></div>
  <div class="r-details"><div class="r-band"><a href="kata.php">Kata</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/dc2c73eacb959fcb832d69187911e374/250x250-000000-80-0-0.jpg" alt="Katel"></div>
  <div class="r-details"><div class="r-band"><a href="katel.php">Katel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://dg9aaz8jl1ktt.cloudfront.net/uploaded_files/000/121/344/verkami_291e07b82b946d0884100ece5cea0dcb.jpg?1490560549" alt="Kati Dada"></div>
  <div class="r-details"><div class="r-band"><a href="kati-dada.php">Kati Dada</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/3e183d8cec4020fdf3c10adef005968c/250x250-000000-80-0-0.jpg" alt="Katiz"></div>
  <div class="r-details"><div class="r-band"><a href="katiz.php">Katiz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105162.jpg" alt="Kawtouch"></div>
  <div class="r-details"><div class="r-band"><a href="kawtouch.php">Kawtouch</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/71mv9ULm+bL._UF1000,1000_QL80_.jpg" alt="Kayimit Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="kayimit-kompa.php">Kayimit Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1d45d278de8c86d27f2d68b30dad0d57/250x250-000000-80-0-0.jpg" alt="Kayos Kf"></div>
  <div class="r-details"><div class="r-band"><a href="kayos-kf.php">Kayos Kf</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103162.jpg" alt="Kazak"></div>
  <div class="r-details"><div class="r-band"><a href="kazak.php">Kazak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02de525d126760c310775c6543" alt="Kazak Eksperyans"></div>
  <div class="r-details"><div class="r-band"><a href="kazak-eksperyans.php">Kazak Eksperyans</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000353928566-aqmb0t-t1080x1080.jpg" alt="Kdans"></div>
  <div class="r-details"><div class="r-band"><a href="kdans.php">Kdans</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000099896372-no06p7-t500x500.jpg" alt="KDM"></div>
  <div class="r-details"><div class="r-band"><a href="kdm.php">KDM</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105694.jpg" alt="Keb"></div>
  <div class="r-details"><div class="r-band"><a href="keb.php">Keb</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/a8295fa4a249074b8bd545cf2f1d241a/250x250-000000-80-0-0.jpg" alt="Kelly Krow"></div>
  <div class="r-details"><div class="r-band"><a href="kelly-krow.php">Kelly Krow</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b2b06f87d583946e720e56433c8ca90a/250x250-000000-80-0-0.jpg" alt="Kemi D"></div>
  <div class="r-details"><div class="r-band"><a href="kemi-d.php">Kemi D</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/d7029fbd7209f803ed1c8a2840f252f6/250x250-000000-80-0-0.jpg" alt="Kenel Desgrottes"></div>
  <div class="r-details"><div class="r-band"><a href="kenel-desgrottes.php">Kenel Desgrottes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27399c9f2213b30c16e1c6af746" alt="Ken fs"></div>
  <div class="r-details"><div class="r-band"><a href="ken-fs.php">Ken fs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104934.jpg" alt="Kenfly"></div>
  <div class="r-details"><div class="r-band"><a href="kenfly.php">Kenfly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/a3d44684993054459233f5cc75d6c20b/1900x1900-000000-80-0-0.jpg" alt="Kenny Desmangles"></div>
  <div class="r-details"><div class="r-band"><a href="kenny-desmangles.php">Kenny Desmangles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103916.jpg" alt="Kenny F"></div>
  <div class="r-details"><div class="r-band"><a href="kenny-f.php">Kenny F</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/6e9a6e96640250f60a18467d1a4d40fd/1900x1900-000000-80-0-0.jpg" alt="Kenny Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="kenny-haiti.php">Kenny Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6ef7c5bce49a7267e52849b7d83c0e09/250x250-000000-80-0-0.jpg" alt="Kensley Alexandre"></div>
  <div class="r-details"><div class="r-band"><a href="kensley-alexandre.php">Kensley Alexandre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51QsNqZZnhL._UXNaN_FMjpg_QL85_.jpg" alt="Kenn'Zo"></div>
  <div class="r-details"><div class="r-band"><a href="kenn-zo.php">Kenn'Zo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/f3/71/9b/f3719bf5-e4c2-d384-b057-c98214acb029/Cover.jpg/1200x1200bb.jpg" alt="Kepopoz"></div>
  <div class="r-details"><div class="r-band"><a href="kepopoz.php">Kepopoz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106044.jpg" alt="Ketlersax"></div>
  <div class="r-details"><div class="r-band"><a href="ketlersax.php">Ketlersax</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f41abd2d9aa1727b54c4c8657e39e800/250x250-000000-80-0-0.jpg" alt="Keylo Dwetgouyadla"></div>
  <div class="r-details"><div class="r-band"><a href="keylo-dwetgouyadla.php">Keylo Dwetgouyadla</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/V5ZnlLaNua0Fp5bOsqDlZ8jgA2_Vj_p57CXrK_7paio/rs:fit/g:sm/q:90/h:600/w:589/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTQyNDg4/MzAtMTQwNjMzNzA2/OS01MzA1LmpwZWc.jpeg" alt="Khal-Mah Vibrations"></div>
  <div class="r-details"><div class="r-band"><a href="khal-mah-vibrations.php">Khal-Mah Vibrations</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music112/v4/06/6b/60/066b60f3-bf2b-69e1-058a-38ae6bf3adbb/859762657164_cover.jpg/1200x1200bf-60.jpg" alt="Khash"></div>
  <div class="r-details"><div class="r-band"><a href="khash.php">Khash</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51L39r8T+oL._UXNaN_FMjpg_QL85_.jpg" alt="Kiki Wainwright"></div>
  <div class="r-details"><div class="r-band"><a href="kiki-wainwright.php">Kiki Wainwright</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab676161000051747acfcaefa8587de01f0f4e29" alt="Kingh509"></div>
  <div class="r-details"><div class="r-band"><a href="kingh509.php">Kingh509</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/94fc2899a6c34d9e335f268a18b09360/250x250-000000-80-0-0.jpg" alt="King J"></div>
  <div class="r-details"><div class="r-band"><a href="king-j.php">King J</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104871.jpg" alt="King Kessy – Koudjay"></div>
  <div class="r-details"><div class="r-band"><a href="king-kessy-koudjay.php">King Kessy – Koudjay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f2d9f710b9236711723fbd42e7df2ff6/250x250-000000-80-0-0.jpg" alt="King Maya"></div>
  <div class="r-details"><div class="r-band"><a href="king-maya.php">King Maya</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102896.jpg" alt="King Of Kings"></div>
  <div class="r-details"><div class="r-band"><a href="king-of-kings.php">King Of Kings</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/c796031fb211505dd2d9022e6f0c264a/250x250-000000-80-0-0.jpg" alt="King Posse"></div>
  <div class="r-details"><div class="r-band"><a href="king-posse.php">King Posse</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/445a172320f28b09e3a8a21d5872ff4d/250x250-000000-80-0-0.jpg" alt="King Street"></div>
  <div class="r-details"><div class="r-band"><a href="king-street.php">King Street</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://img.cdandlp.com/2016/07/imgL/1132229573.jpg" alt="Kita Combo"></div>
  <div class="r-details"><div class="r-band"><a href="kita-combo.php">Kita Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/216057231364d2e5a89ec96679b8d4e8/250x250-000000-80-0-0.jpg" alt="Klasik"></div>
  <div class="r-details"><div class="r-band"><a href="klasik.php">Klasik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://yt3.googleusercontent.com/ytc/AIdro_nbMvdCrO2caF9XTlmcyvoAGqloBJMzEbT8zsxmVyQoFg=s900-c-k-c0x00ffffff-no-rj" alt="Klass"></div>
  <div class="r-details"><div class="r-band"><a href="klass.php">Klass</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/d31b86a5e84be54fa402d7924e72b8e8/250x250-000000-80-0-0.jpg" alt="Kle Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="kle-kompa.php">Kle Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.caraibesmusic.com/images/HP014-1.jpg" alt="Klean"></div>
  <div class="r-details"><div class="r-band"><a href="klean.php">Klean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000446851299-myusqa-t500x500.jpg" alt="Klere"></div>
  <div class="r-details"><div class="r-band"><a href="klere.php">Klere</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101574.jpg" alt="Klinik"></div>
  <div class="r-details"><div class="r-band"><a href="klinik.php">Klinik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/6ebd4881177c025d51c37406ac3d1db1/250x250-000000-80-0-0.jpg" alt="Klo"></div>
  <div class="r-details"><div class="r-band"><a href="klo.php">Klo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105011.jpg" alt="K-Mistry"></div>
  <div class="r-details"><div class="r-band"><a href="k-mistry.php">K-Mistry</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/1a07c575aecd8a282a09f495b212e49b/250x250-000000-80-0-0.jpg" alt="K-niway"></div>
  <div class="r-details"><div class="r-band"><a href="k-niway.php">K-niway</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/f13b0971c29f8773fda39e11be55ffb2/250x250-000000-80-0-0.jpg" alt="Knockout Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="knockout-mizik.php">Knockout Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104204.jpg" alt="Kod"></div>
  <div class="r-details"><div class="r-band"><a href="kod.php">Kod</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102429.jpg" alt="Kolaj"></div>
  <div class="r-details"><div class="r-band"><a href="kolaj.php">Kolaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7c76397fbd2fc092aa9da3fc34550a86/250x250-000000-80-0-0.jpg" alt="Kolonel Freez"></div>
  <div class="r-details"><div class="r-band"><a href="kolonel-freez.php">Kolonel Freez</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/8dbb6582019a5eebaf3eeee42d48cce1/250x250-000000-80-0-0.jpg" alt="Kompa 100 Limit"></div>
  <div class="r-details"><div class="r-band"><a href="kompa-100-limit.php">Kompa 100 Limit</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ngYL1I9pL._UXNaN_FMjpg_QL85_.jpg" alt="Kompa All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="kompa-all-stars.php">Kompa All Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/a554f39258008e2b2cf30c905b932709/250x250-000000-80-0-0.jpg" alt="Kompa Doudou Chéri"></div>
  <div class="r-details"><div class="r-band"><a href="kompa-doudou-cheri.php">Kompa Doudou Chéri</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ipbhm0HcrzleDootZskNm5X-ZkXVGL5SuxTkxZyHc3U/rs:fit/g:sm/q:90/h:600/w:598/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE1MzQz/MjExLTE1OTAxMTkx/MzItMTIzMi5qcGVn.jpeg" alt="Kompabrassa"></div>
  <div class="r-details"><div class="r-band"><a href="kompabrassa.php">Kompabrassa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/b75116a7a95276c73d0fae1cc84d627d/250x250-000000-80-0-0.jpg" alt="Kompa Céleste"></div>
  <div class="r-details"><div class="r-band"><a href="kompa-celeste.php">Kompa Céleste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102432.jpg" alt="Kompa Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="kompa-kompa.php">Kompa Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/9d44fd63910f22c4348b041752d6e349/250x250-000000-80-0-0.jpg" alt="Kompalsa"></div>
  <div class="r-details"><div class="r-band"><a href="kompalsa.php">Kompalsa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/7e8c0227a77adf0516c22c5b5e0b513a/250x250-000000-80-0-0.jpg" alt="Kompas Du Sud"></div>
  <div class="r-details"><div class="r-band"><a href="kompas-du-sud.php">Kompas Du Sud</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105905.jpg" alt="Kompas Express de New York"></div>
  <div class="r-details"><div class="r-band"><a href="kompas-express-de-new-york.php">Kompas Express de New York</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102708.jpg" alt="Kompas Panik De Delma 4"></div>
  <div class="r-details"><div class="r-band"><a href="kompas-panik-de-delma-4.php">Kompas Panik De Delma 4</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/165453fc13f17949d63da6b5f7cf00ec/250x250-000000-80-0-0.jpg" alt="Kompasoul"></div>
  <div class="r-details"><div class="r-band"><a href="kompasoul.php">Kompasoul</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/qY4RYzH/Cover.jpg" alt="Konecsyon Band"></div>
  <div class="r-details"><div class="r-band"><a href="konecsyon-band.php">Konecsyon Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/fedae19d4f6a176b3a464babbe929387/250x250-000000-80-0-0.jpg" alt="Konbinezon"></div>
  <div class="r-details"><div class="r-band"><a href="konbinezon.php">Konbinezon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/33/9b/9b/339b9be9-73f4-b283-9a29-dc58ecbe70aa/859781089861_cover.jpg/600x600bf-60.jpg" alt="Koneksyon"></div>
  <div class="r-details"><div class="r-band"><a href="koneksyon.php">Koneksyon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/7FNMvSfnUMent5h7zL6XJvaHyPypREEbGcQUe66h0ac/rs:fit/g:sm/q:90/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTExNTAw/NTg2LTE1MTc0MzM2/OTktNDM5MS5qcGVn.jpeg" alt="Konektion"></div>
  <div class="r-details"><div class="r-band"><a href="konektion.php">Konektion</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/1e2e97c8cdc90f8989d4c1412484f4ed/250x250-000000-80-0-0.jpg" alt="Konpa Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="konpa-kreyol.php">Konpa Kreyol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/04/22/41bac98c44a849918a355bf673546ffe_464_464.jpg" alt="Konpa Lakay"></div>
  <div class="r-details"><div class="r-band"><a href="konpa-lakay.php">Konpa Lakay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/415ulNA5xSS._UXNaN_FMjpg_QL85_.jpg" alt="Konpa O Feminin"></div>
  <div class="r-details"><div class="r-band"><a href="konpa-o-feminin.php">Konpa O Feminin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTIy43qiZCFsaBBHTgXm_B93j5RN0QriE7hrQ&s" alt="Konpak"></div>
  <div class="r-details"><div class="r-band"><a href="konpak.php">Konpak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51-gX7MIcLL._UXNaN_FMjpg_QL85_.jpg" alt="Kontak"></div>
  <div class="r-details"><div class="r-band"><a href="kontak.php">Kontak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/f6/26/5c/mzi.ymapcirj.jpg/400x400bb.webp" alt="Kontwol"></div>
  <div class="r-details"><div class="r-band"><a href="kontwol.php">Kontwol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104868.jpg" alt="Kool Jazz"></div>
  <div class="r-details"><div class="r-band"><a href="kool-jazz.php">Kool Jazz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/827236cc964fbc98da78b33e1bf82ad5/250x250-000000-80-0-0.jpg" alt="Kooljobeatz"></div>
  <div class="r-details"><div class="r-band"><a href="kooljobeatz.php">Kooljobeatz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102008.jpg" alt="Kool Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="kool-konpa.php">Kool Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104944.jpg" alt="Kool Off"></div>
  <div class="r-details"><div class="r-band"><a href="kool-off.php">Kool Off</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/ee9776df75271cd7fac3a0b628e1193b/1900x1900-000000-80-0-0.jpg" alt="Kot West"></div>
  <div class="r-details"><div class="r-band"><a href="kot-west.php">Kot West</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101834.jpg" alt="K-Res Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="k-res-konpa.php">K-Res Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106349.jpg" alt="K'sou Coupey"></div>
  <div class="r-details"><div class="r-band"><a href="k-sou-coupey.php">K'sou Coupey</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/848e2179c42c3380c927eb7437de3bed/500x500.jpg" alt="K-Ramel de New York"></div>
  <div class="r-details"><div class="r-band"><a href="k-ramel-de-new-york.php">K-Ramel de New York</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104203.jpg" alt="K-Ramel Twoubadou"></div>
  <div class="r-details"><div class="r-band"><a href="k-ramel-twoubadou.php">K-Ramel Twoubadou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-qqRKy3ucqXxM9tJ7-6TGpYg-t500x500.jpg" alt="Kreyol La"></div>
  <div class="r-details"><div class="r-band"><a href="kreyol-la.php">Kreyol La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-9kKgnKfaoueyla6Y-C2ls0g-t240x240.jpg" alt="Krezi Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="krezi-mizik.php">Krezi Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000450523575-12nlfk-t500x500.jpg" alt="Krezibeatz"></div>
  <div class="r-details"><div class="r-band"><a href="krezibeatz.php">Krezibeatz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/dd3f249d6d25ba0ae9d8665d81bb3a3e/250x250-000000-80-0-0.jpg" alt="Krispek"></div>
  <div class="r-details"><div class="r-band"><a href="krispek.php">Krispek</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/b1/ac/e2/b1ace2f2-8b90-f70d-db1d-7d9181cdf4d4/cover.jpg/1200x1200bf-60.jpg" alt="Krys"></div>
  <div class="r-details"><div class="r-band"><a href="krys.php">Krys</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/vwDjxyH/Cover.jpg" alt="Krys-to"></div>
  <div class="r-details"><div class="r-band"><a href="krys-to.php">Krys-to</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/8S9Udx2WB7-qEmTGVqbvy13CafGKsntuDxJS0pdo7ZA/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTcyMjI5/OTctMTQzNjUyNTQ5/Ny0yODk5LmpwZWc.jpeg" alt="Krystal Band"></div>
  <div class="r-details"><div class="r-band"><a href="krystal-band.php">Krystal Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/0b7885605998639e6d1c81b8861ca85a/250x250-000000-80-0-0.jpg" alt="K-dilak & Bedjine"></div>
  <div class="r-details"><div class="r-band"><a href="k-dilak-bedjine.php">K-dilak & Bedjine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000221552326-nsncwt-t500x500.jpg" alt="K-tel Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="k-tel-kreyol.php">K-tel Kreyol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103719.jpg" alt="K-Tel Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="k-tel-konpa.php">K-Tel Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/0ca77f999f9231ae94fb840e85bba633/1900x1900-000000-80-0-0.jpg" alt="K-Zino"></div>
  <div class="r-details"><div class="r-band"><a href="k-zino.php">K-Zino</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/7e9f787532353b6f81a5518db4627b6e/250x250-000000-80-0-0.jpg" alt="Kwaze"></div>
  <div class="r-details"><div class="r-band"><a href="kwaze.php">Kwaze</a></div></div>
</div>


  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>