<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>L - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES L -->
  <div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103731.jpg" alt="L2"></div>
  <div class="r-details"><div class="r-band"><a href="l2.php">L2</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/93fa395ffe78772e891497eafffd62f9/250x250-000000-80-0-0.jpg" alt="La Belle Epoque"></div>
  <div class="r-details"><div class="r-band"><a href="la-belle-epoque.php">La Belle Epoque</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106012.jpg" alt="La Chorale du Théâtre National d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="la-chorale-du-theatre-national-d-haiti.php">La Chorale du Théâtre National d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000002633795-6hjh2h-t1080x1080.jpg" alt="La Femme Sheba"></div>
  <div class="r-details"><div class="r-band"><a href="la-femme-sheba.php">La Femme Sheba</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/fsLk5Ru1FnnLSFl9aQ-0zd93uVQ97MyXsfSPVjQrRNg/rs:fit/g:sm/q:90/h:554/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEyMTQ0/NjEzLTE1ODc0Njc1/OTctMjU5MC5qcGVn.jpeg" alt="La Galaxy"></div>
  <div class="r-details"><div class="r-band"><a href="la-galaxy.php">La Galaxy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103443.jpg" alt="La Grande Puissance by Joubien"></div>
  <div class="r-details"><div class="r-band"><a href="la-grande-puissance-by-joubien.php">La Grande Puissance by Joubien</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61e6J5u5lEL._UXNaN_FMjpg_QL85_.jpg" alt="Labsint'"></div>
  <div class="r-details"><div class="r-band"><a href="labsint.php">Labsint'</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/b9/bd/f3/b9bdf358-3178-d37a-dddd-f230524161e4/cover.jpg/1200x1200bb.jpg" alt="Lady Sugar"></div>
  <div class="r-details"><div class="r-band"><a href="lady-sugar.php">Lady Sugar</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51l6A25ZvBL._UXNaN_FMjpg_QL85_.jpg" alt="Lady G"></div>
  <div class="r-details"><div class="r-band"><a href="lady-g.php">Lady G</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static01.nyt.com/images/2023/01/24/multimedia/23lakecia-benjamin-01-zlfw/23lakecia-benjamin-01-zlfw-mediumSquareAt3X.jpg" alt="Lakecia Benjamin"></div>
  <div class="r-details"><div class="r-band"><a href="lakecia-benjamin.php">Lakecia Benjamin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273453799d5583717d8399c50a9" alt="Lakol"></div>
  <div class="r-details"><div class="r-band"><a href="lakol.php">Lakol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/e3a7c1d43c385b191d9a3f4f8a599e6d/250x250-000000-80-0-0.jpg" alt="Lakol D'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="lakol-d-haiti.php">Lakol D'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://f4.bcbits.com/img/0001222021_10.jpg" alt="Lakou Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="lakou-mizik.php">Lakou Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/2f9cf22bf855d0d06be59505bd5dff0c/250x250-000000-80-0-0.jpg" alt="La Perfecta"></div>
  <div class="r-details"><div class="r-band"><a href="la-perfecta.php">La Perfecta</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104680.jpg" alt="Laraj"></div>
  <div class="r-details"><div class="r-band"><a href="laraj.php">Laraj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Fbkm1ts9/LA-REBELLE.png" alt="La Rebelle"></div>
  <div class="r-details"><div class="r-band"><a href="la-rebelle.php">La Rebelle</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102575.jpg" alt="Lataye"></div>
  <div class="r-details"><div class="r-band"><a href="lataye.php">Lataye</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104331.jpg" alt="La Troupe de Théâtre Kouidor"></div>
  <div class="r-details"><div class="r-band"><a href="la-troupe-de-theatre-kouidor.php">La Troupe de Théâtre Kouidor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103413.jpg" alt="Laurent Ciceron et le Groupe Zatrap"></div>
  <div class="r-details"><div class="r-band"><a href="laurent-ciceron-et-le-groupe-zatrap.php">Laurent Ciceron et le Groupe Zatrap</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/CvDqcqQ/Cover.jpg" alt="Lavog"></div>
  <div class="r-details"><div class="r-band"><a href="lavog.php">Lavog</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/3/1741164465-layv-mizi.jpg" alt="Layv-Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="layv-mizik.php">Layv-Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0fb75245967c1944adb3d59200d4d273/250x250-000000-80-0-0.jpg" alt="Lebel"></div>
  <div class="r-details"><div class="r-band"><a href="lebel.php">Lebel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/bac9011b67d343d1fabcc4906ccd5136/250x250-000000-80-0-0.jpg" alt="Legacy"></div>
  <div class="r-details"><div class="r-band"><a href="legacy.php">Legacy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105803.jpg" alt="Legend"></div>
  <div class="r-details"><div class="r-band"><a href="legend.php">Legend</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a98810a3c7ae2b18426d032a04d7ecb4/250x250-000000-80-0-0.jpg" alt="Le Gip"></div>
  <div class="r-details"><div class="r-band"><a href="le-gip.php">Le Gip</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103194.jpg" alt="Le Groupe Kfe"></div>
  <div class="r-details"><div class="r-band"><a href="le-groupe-kfe.php">Le Groupe Kfe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51oV3MpZrEL._UXNaN_FMjpg_QL85_.jpg" alt="Le Groupe SKH Danti Missile"></div>
  <div class="r-details"><div class="r-band"><a href="le-groupe-skh-danti-missile.php">Le Groupe SKH Danti Missile</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/uBtij1nqgueZWVwrC7g2QY5IzoknoBQ5H5v8bzyHdGM/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc1ODIw/MDMtMTQ0NDUwMjQy/My01NjIyLmpwZWc.jpeg" alt="Le Groupe Soley"></div>
  <div class="r-details"><div class="r-band"><a href="le-groupe-soley.php">Le Groupe Soley</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/28ca74218e0d6ebdd130aeecc75ec4d7/250x250-000000-80-0-0.jpg" alt="Le hyp"></div>
  <div class="r-details"><div class="r-band"><a href="le-hyp.php">Le hyp</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ETlJXROJL._UXNaN_FMjpg_QL85_.jpg" alt="Le Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="le-kompa.php">Le Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105558.jpg" alt="Le Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="le-konpa.php">Le Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/659a4b6d057d28846ab898f7882ddc7c/250x250-000000-80-0-0.jpg" alt="Lekol"></div>
  <div class="r-details"><div class="r-band"><a href="lekol.php">Lekol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/noNSjNqWlqYXvmQT9ncsuQUfoBcnfn_QaNdka0f5KuM/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI4NDM5/NTItMTY1NDA5OTE1/OS0yNjgzLmpwZWc.jpeg" alt="Lele Giha"></div>
  <div class="r-details"><div class="r-band"><a href="lele-giha.php">Lele Giha</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/rKsBmrCs/Monochrome-Aesthetic-Electronic-Music-Album-Cover.png" alt="Leo Connection"></div>
  <div class="r-details"><div class="r-band"><a href="leo-connection.php">Leo Connection</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/ee795e5e930b197709c83b937af3e6dc/250x250-000000-80-0-0.jpg" alt="Leon Dimanche"></div>
  <div class="r-details"><div class="r-band"><a href="leon-dimanche.php">Leon Dimanche</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/3/1741188743-leonidas-haiti.jpeg" alt="Leonidas Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="leonidas-haiti.php">Leonidas Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/107019.jpg" alt="LePael"></div>
  <div class="r-details"><div class="r-band"><a href="lepael.php">LePael</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/91e646403606fb8fdd2138a6b554471a/250x250-000000-80-0-0.jpg" alt="Leroi Antoine"></div>
  <div class="r-details"><div class="r-band"><a href="leroi-antoine.php">Leroi Antoine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/7/1742738809-leroy-guiteau-cover-3.jpg" alt="Leroy Guiteau"></div>
  <div class="r-details"><div class="r-band"><a href="leroy-guiteau.php">Leroy Guiteau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/TB1KYK7B/Leson.png" alt="Leson"></div>
  <div class="r-details"><div class="r-band"><a href="leson.php">Leson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/f0603e701380e3863f02daa10ec1d93b/250x250-000000-80-0-0.jpg" alt="Le Souffle Divin"></div>
  <div class="r-details"><div class="r-band"><a href="le-souffle-divin.php">Le Souffle Divin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103519.jpg" alt="Le Vaudou Haitien"></div>
  <div class="r-details"><div class="r-band"><a href="le-vaudou-haitien.php">Le Vaudou Haitien</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51nno2VVvML._UF1000,1000_QL80_.jpg" alt="Les 7 Vedettes"></div>
  <div class="r-details"><div class="r-band"><a href="les-7-vedettes.php">Les 7 Vedettes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/a2b429fd742ec9551d9ca367df958c1f/250x250-000000-80-0-0.jpg" alt="Les Aiglons"></div>
  <div class="r-details"><div class="r-band"><a href="les-aiglons.php">Les Aiglons</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51BKC2IYK-L._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Les Ambassadeurs D'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="les-ambassadeurs-d-haiti.php">Les Ambassadeurs D'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSslOCACcIFiYIr9F0O_Q7iFgWkIoBP4_8okg&s" alt="Les Animateurs"></div>
  <div class="r-details"><div class="r-band"><a href="les-animateurs.php">Les Animateurs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102454.jpg" alt="Les As De La K-Dans"></div>
  <div class="r-details"><div class="r-band"><a href="les-as-de-la-k-dans.php">Les As De La K-Dans</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/jOpP45o7QEfzHooZmOaLDbvtUrBnxpbPiL5bCWY288w/rs:fit/g:sm/q:90/h:580/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTY2ODIy/OTEtMTQyNDUzNDkw/MC03MjIzLmpwZWc.jpeg" alt="Les As de Pétion-Ville"></div>
  <div class="r-details"><div class="r-band"><a href="les-as-de-petion-ville.php">Les As de Pétion-Ville</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://img.cdandlp.com/2014/07/imgL/117024481.jpg" alt="Les Banges D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="les-banges-d-haiti.php">Les Banges D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/gtav2dLjB3UlYcQknZ_FWnVU6GmMkobEb4zOMjzaYH4/rs:fit/g:sm/q:90/h:597/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTY1OTA1/NzQtMTY0OTk3Nzky/MS01MzQ5LmpwZWc.jpeg" alt="Les Beatniks de Queens"></div>
  <div class="r-details"><div class="r-band"><a href="les-beatniks-de-queens.php">Les Beatniks de Queens</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000145008567-3y04tv-t500x500.jpg" alt="Les Bi Tops"></div>
  <div class="r-details"><div class="r-band"><a href="les-bi-tops.php">Les Bi Tops</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102566.jpg" alt="Les Big Boss du Compas Orchestra"></div>
  <div class="r-details"><div class="r-band"><a href="les-big-boss-du-compas-orchestra.php">Les Big Boss du Compas Orchestra</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51-6Gbx1MeL._UXNaN_FMjpg_QL85_.jpg" alt="Les Chandlers"></div>
  <div class="r-details"><div class="r-band"><a href="les-chandlers.php">Les Chandlers</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTDw0r2ZBzcA1TFgdR2ZcSoGA4vqeDAJVbyEg&s" alt="Les Charmeurs D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="les-charmeurs-d-haiti.php">Les Charmeurs D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/fzwAAOSwO2lhiVTJ/s-l400.jpg" alt="Les Charmeurs Du Cap"></div>
  <div class="r-details"><div class="r-band"><a href="les-charmeurs-du-cap.php">Les Charmeurs Du Cap</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/NKV5BNBx1WEhUeibcuqtAROdTYSy-COAM-3mkejG_lU/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTY5Mzcw/MzAtMTQyOTkxNDY1/My01MzgyLmpwZWc.jpeg" alt="Les Chômeurs"></div>
  <div class="r-details"><div class="r-band"><a href="les-chomeurs.php">Les Chômeurs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSXMrH-dBkrIiKea1asMf8_FAd9lDk3hRprMg&s" alt="Les Consuls d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="les-consuls-d-haiti.php">Les Consuls d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/AV33qJf2mRqllN4OIKdFWyeBMcNriV6-wiy3OUiSFL8/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMwNzMw/MDAtMTQ0MjAxOTAx/NC01OTI0LmpwZWc.jpeg" alt="Les Cougars De Pétion-Ville"></div>
  <div class="r-details"><div class="r-band"><a href="les-cougars-de-petion-ville.php">Les Cougars De Pétion-Ville</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/db/08/86/mzi.haigdpjr.jpg/600x600bf-60.jpg" alt="Les Cousins Réunis"></div>
  <div class="r-details"><div class="r-band"><a href="les-cousins-reunis.php">Les Cousins Réunis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/l-Bt5dGB_XZ_RxquvwpUW3pjljUUuknq-a2cnhpB238/rs:fit/g:sm/q:90/h:598/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI3OTgx/ODk0LTE2OTIxMTUx/ODAtOTA2NS5qcGVn.jpeg" alt="Les Diables Bleues Du Cap Haïtien"></div>
  <div class="r-details"><div class="r-band"><a href="les-diables-bleues-du-cap-haitien.php">Les Diables Bleues Du Cap Haïtien</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/GMnKTU9OxR3QpwXg-3WtV48lVFBA7ZnrjMc2LWqpIvI/rs:fit/g:sm/q:90/h:600/w:590/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE0MDAy/MTQ0LTE1NjU4NTg3/NzUtODAyNC5qcGVn.jpeg" alt="Les Diables Du Rythme De St- Marc"></div>
  <div class="r-details"><div class="r-band"><a href="les-diables-du-rythme-de-st-marc.php">Les Diables Du Rythme De St- Marc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Rec-pskZsVjn3Duq-XJZnUuQmGyNQYIreEdiLHHBKZA/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTg2MTIy/MDUtMTQ2NTEyNzc1/OS0yMDcyLmpwZWc.jpeg" alt="Les Difficiles De New York"></div>
  <div class="r-details"><div class="r-band"><a href="les-difficiles-de-new-york.php">Les Difficiles De New York</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/a0b976f1dc78739209dd98e4f8842834/250x250-000000-80-0-0.jpg" alt="Les Difficiles De Pétion-Ville"></div>
  <div class="r-details"><div class="r-band"><a href="les-difficiles-de-petion-ville.php">Les Difficiles De Pétion-Ville</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Qh3igI61TJmc4Q9HutRHCQlt6OiS09btOs5SvpZV7to/rs:fit/g:sm/q:90/h:554/w:567/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTM4Nzg1/OTMtMTM1MDk5OTI3/MS05MjQ2LmpwZWc.jpeg" alt="Les Diplomates"></div>
  <div class="r-details"><div class="r-band"><a href="les-diplomates.php">Les Diplomates</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/k2Yt4Hnd/les-djou.png" alt="Les Djoubap'S"></div>
  <div class="r-details"><div class="r-band"><a href="les-djoubap-s.php">Les Djoubap'S</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/RwQrtKESKRokX8cDgsYg_fJCuM0Zgux8WDz0XfSgeOs/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTUxNTAz/MzQtMTQzNDQyMDE5/Mi04NDc5LmpwZWc.jpeg" alt="Les Docteurs Du Rythme"></div>
  <div class="r-details"><div class="r-band"><a href="les-docteurs-du-rythme.php">Les Docteurs Du Rythme</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/tp1bcY0V/les-dol.png" alt="Les Dolmen's"></div>
  <div class="r-details"><div class="r-band"><a href="les-dolmen-s.php">Les Dolmen's</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS7qDDrGjXVeig2ZwHoxnC1wPt7T4gshlPylg&s" alt="Les Dragonnaires De Port-De-Paix"></div>
  <div class="r-details"><div class="r-band"><a href="les-dragonnaires-de-port-de-paix.php">Les Dragonnaires De Port-De-Paix</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0440ca975e0ddda23bae0291e6c741e3/250x250-000000-80-0-0.jpg" alt="Les Etincelles de L’Evangile de Boston"></div>
  <div class="r-details"><div class="r-band"><a href="les-etincelles-de-l-evangile-de-boston.php">Les Etincelles de L’Evangile de Boston</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101457.jpg" alt="Les Ex-Musiciens Des Difficiles Et Des Gypsies"></div>
  <div class="r-details"><div class="r-band"><a href="les-ex-musiciens-des-difficiles-et-des-gypsies.php">Les Ex-Musiciens Des Difficiles Et Des Gypsies</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/3Cns_9heAWy3VxujFUpvRhONM1_YVTOP1mgbfKymk6I/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTgxNzQw/NjgtMTU5NDU2MjY4/MS05NzY1LmpwZWc.jpeg" alt="Les Fantaisistes De Carrefour"></div>
  <div class="r-details"><div class="r-band"><a href="les-fantaisistes-de-carrefour.php">Les Fantaisistes De Carrefour</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ56oiprzkGsjfRyd8rgOx3xm4Tq6OEW-CyzQ&s" alt="Les Formidables de Saint Marc"></div>
  <div class="r-details"><div class="r-band"><a href="les-formidables-de-saint-marc.php">Les Formidables de Saint Marc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51XFcA5behL._UXNaN_FMjpg_QL85_.jpg" alt="Les Frères Dejean de Pétion Ville"></div>
  <div class="r-details"><div class="r-band"><a href="les-freres-dejean-de-petion-ville.php">Les Frères Dejean de Pétion Ville</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100555.jpg" alt="Les Frères Dejean Tap Force"></div>
  <div class="r-details"><div class="r-band"><a href="les-freres-dejean-tap-force.php">Les Frères Dejean Tap Force</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-2EOuPQ1zU428-0-t240x240.jpg" alt="Les Frères Dodo"></div>
  <div class="r-details"><div class="r-band"><a href="les-freres-dodo.php">Les Frères Dodo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000084228906-jo55l7-t500x500.jpg" alt="Les Frères Parent"></div>
  <div class="r-details"><div class="r-band"><a href="les-freres-parent.php">Les Frères Parent</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103118.jpg" alt="Les Gitans"></div>
  <div class="r-details"><div class="r-band"><a href="les-gitans.php">Les Gitans</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104249.jpg" alt="Les Guittarlois"></div>
  <div class="r-details"><div class="r-band"><a href="les-guittarlois.php">Les Guittarlois</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51dlaxzp-BL._UXNaN_FMjpg_QL85_.jpg" alt="Les Gypsies De Pétion-Ville"></div>
  <div class="r-details"><div class="r-band"><a href="les-gypsies-de-petion-ville.php">Les Gypsies De Pétion-Ville</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61BxBc1VvBL._UXNaN_FMjpg_QL85_.jpg" alt="Les Gypsies de Queens"></div>
  <div class="r-details"><div class="r-band"><a href="les-gypsies-de-queens.php">Les Gypsies de Queens</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/81YAQ-UcL9L._UF1000,1000_QL80_.jpg" alt="Les Invincibles De Jacmel"></div>
  <div class="r-details"><div class="r-band"><a href="les-invincibles-de-jacmel.php">Les Invincibles De Jacmel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000287816054-r3xg3r-t500x500.jpg" alt="Les Jouvenceaux De Jacmel"></div>
  <div class="r-details"><div class="r-band"><a href="les-jouvenceaux-de-jacmel.php">Les Jouvenceaux De Jacmel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/PIcAAOSwnspj9Sxr/s-l1600.jpg" alt="Les légendaires de Delmas"></div>
  <div class="r-details"><div class="r-band"><a href="les-legendaires-de-delmas.php">Les légendaires de Delmas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a3deccc75c8d8982a600670d46fa778e/250x250-000000-80-0-0.jpg" alt="Lesly Fonrose"></div>
  <div class="r-details"><div class="r-band"><a href="lesly-fonrose.php">Lesly Fonrose</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSz2P61Lc_VVJwEaL-vnNxYdYTVFP2aYhVWsw&s" alt="Les léopards de la Martinique"></div>
  <div class="r-details"><div class="r-band"><a href="les-leopards-de-la-martinique.php">Les léopards de la Martinique</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51g9GDyEeUL._UF1000,1000_QL80_.jpg" alt="Les Lionceaux Des Cayes"></div>
  <div class="r-details"><div class="r-band"><a href="les-lionceaux-des-cayes.php">Les Lionceaux Des Cayes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Fi4n3-JMMzscUdU_CX2TvfTyZz0syg0ZXNRkEpu4bxk/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTQ2NDcw/ODEtMTM3MDk3Mjc0/Ny02NzQ0LmpwZWc.jpeg" alt="Les Loups Noirs"></div>
  <div class="r-details"><div class="r-band"><a href="les-loups-noirs.php">Les Loups Noirs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Rwb7nemEUK7fsN7GBGm_z6nFDQkviCImcVuWZBJtvGk/rs:fit/g:sm/q:90/h:600/w:594/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9BLTIxMDU5/ODYtMTYwMTU2MTQ3/My01NjU5LmpwZWc.jpeg" alt="Les Masteful D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="les-masteful-d-haiti.php">Les Masteful D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/v1EDmJz1WW9-wGPmMKg1Ap-wpjBP6EKWOAmPyHD6D7A/rs:fit/g:sm/q:90/h:589/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9BLTE2Mjg5/NTMtMTQ5NjA4Nzk3/OS03OTU4LmpwZWc.jpeg" alt="Les Maxels"></div>
  <div class="r-details"><div class="r-band"><a href="les-maxels.php">Les Maxels</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000101667935-sucr2f-t500x500.jpg" alt="Les Mécènes"></div>
  <div class="r-details"><div class="r-band"><a href="les-mecenes.php">Les Mécènes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41vxXrqSEtL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Les OdasCieux"></div>
  <div class="r-details"><div class="r-band"><a href="les-odascieux.php">Les OdasCieux</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/0IreaJWARmBGqzyM8vW9v27VJENVoS2g3Rqziy8yu-E/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTYxMDMy/NDMtMTYyMDAzOTY4/Ni02MzE4LmpwZWc.jpeg" alt="Les Pachas Du Canape-Vert"></div>
  <div class="r-details"><div class="r-band"><a href="les-pachas-du-canape-vert.php">Les Pachas Du Canape-Vert</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/B9ld0t77hlsW93g8S8S24kdo06hAgYUfFmIAN_qYqkc/rs:fit/g:sm/q:90/h:600/w:591/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMwOTUy/NTUtMTMxNTQ5MzU2/Ni5qcGVn.jpeg" alt="Les Pedagogues"></div>
  <div class="r-details"><div class="r-band"><a href="les-pedagogues.php">Les Pedagogues</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.fye.com/cdn/shop/files/3539003.jpg?v=1703990932" alt="Les Princes de Port-au-Prince"></div>
  <div class="r-details"><div class="r-band"><a href="les-princes-de-port-au-prince.php">Les Princes de Port-au-Prince</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742430931-les-rapaces-cover-2.jpg" alt="Les Rapaces"></div>
  <div class="r-details"><div class="r-band"><a href="les-rapaces.php">Les Rapaces</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51IzZqsL2WL._UXNaN_FMjpg_QL85_.jpg" alt="Les Rois Du Compas"></div>
  <div class="r-details"><div class="r-band"><a href="les-rois-du-compas.php">Les Rois Du Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSBpejVdoyYLMfzdi-JU5XC5fDQms4nn59HaQ&s" alt="Les Shelberts D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="les-shelberts-d-haiti.php">Les Shelberts D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTxf4HtgxZ_D-f9lFJa_j46wOfEOyZLETCpdA&s" alt="Les Shleu Shleu"></div>
  <div class="r-details"><div class="r-band"><a href="les-shleu-shleu.php">Les Shleu Shleu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://img.cdandlp.com/2023/05/imgL/125228967.jpg" alt="Les Stars"></div>
  <div class="r-details"><div class="r-band"><a href="les-stars.php">Les Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR5AnA5KjR-R6V1JbK6xc8701k3ltm59u6Zpw&s" alt="Les Super Shleu"></div>
  <div class="r-details"><div class="r-band"><a href="les-super-shleu.php">Les Super Shleu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/8d/96/3d/8d963d4a-bfbf-25d2-f99b-b73610c5d767/198003111974.jpg/600x600bf-60.jpg" alt="Les Super Stars Du Compas"></div>
  <div class="r-details"><div class="r-band"><a href="les-super-stars-du-compas.php">Les Super Stars Du Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/DLRBn2gcvmrEvAFDq1fJXUbTt5BNYdrczE9CH5AZvTk/rs:fit/g:sm/q:90/h:270/w:270/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMxNDYx/MTYtMTM0ODMzMjM3/OC02OTI3LmpwZWc.jpeg" alt="Les Tireless"></div>
  <div class="r-details"><div class="r-band"><a href="les-tireless.php">Les Tireless</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/OYelfoDt-sEMg11QfM6Y-XgF7M7aW2EN1eB-KGyKDZ0/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI2NTM5/NjktMTUyNjU1NTcy/NS00MzM4LmpwZWc.jpeg" alt="Les Vicomtes"></div>
  <div class="r-details"><div class="r-band"><a href="les-vicomtes.php">Les Vicomtes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ozCt4ArVaHegH1oYHVOQkm4YNewDYLTp-jsSDxYFYQM/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU2NjY2/ODItMTQ3Mzg3MjM0/MS03MTE3LmpwZWc.jpeg" alt="Les Vikings De La Martinique"></div>
  <div class="r-details"><div class="r-band"><a href="les-vikings-de-la-martinique.php">Les Vikings De La Martinique</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000316594599-3j5293-t500x500.jpg" alt="Les Vikings d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="les-vikings-d-haiti.php">Les Vikings d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102936.jpg" alt="Les Virtuoses Du Rythme de St. Marc"></div>
  <div class="r-details"><div class="r-band"><a href="les-virtuoses-du-rythme-de-st-marc.php">Les Virtuoses Du Rythme de St. Marc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/RJT8Khzend_Fp-ZHOGX3rh3hfGsM--cj_goMPAavWgg/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTYzMDI0/MTQtMTQzMDQ4MjMy/Mi0xMzE4LmpwZWc.jpeg" alt="Les Voodix De Montreal"></div>
  <div class="r-details"><div class="r-band"><a href="les-voodix-de-montreal.php">Les Voodix De Montreal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d9a4a40014582fad60d617ff4dcec0e6/250x250-000000-80-0-0.jpg" alt="Levanjil Plis"></div>
  <div class="r-details"><div class="r-band"><a href="levanjil-plis.php">Levanjil Plis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/71UWdYgIDuL._UF1000,1000_QL80_.jpg" alt="Leyla McCalla"></div>
  <div class="r-details"><div class="r-band"><a href="leyla-mccalla.php">Leyla McCalla</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/1f2b19d630aa4fe467400d8f5382acfb/250x250-000000-80-0-0.jpg" alt="Lil4jmusic"></div>
  <div class="r-details"><div class="r-band"><a href="lil4jmusic.php">Lil4jmusic</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/6acfa2de8323b439f0a52e70938b6e1e/250x250-000000-80-0-0.jpg" alt="Lib Kolabo"></div>
  <div class="r-details"><div class="r-band"><a href="lib-kolabo.php">Lib Kolabo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b22de3bdbd30d53081d3b7d59da24918/250x250-000000-80-0-0.jpg" alt="Lig Evanjelis Lari"></div>
  <div class="r-details"><div class="r-band"><a href="lig-evanjelis-lari.php">Lig Evanjelis Lari</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/207e16f0ca2fd2a52e4fab11730d8216/250x250-000000-80-0-0.jpg" alt="Lil Daddy Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="lil-daddy-haiti.php">Lil Daddy Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/2/1750786201-cover.jpg" alt="Lil Jayne"></div>
  <div class="r-details"><div class="r-band"><a href="lil-jayne.php">Lil Jayne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/2/1750785883-cover.jpg" alt="Lil RJ"></div>
  <div class="r-details"><div class="r-band"><a href="lil-rj.php">Lil RJ</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/f5e396eab7e5f19c2c2ee6f003c55722/250x250-000000-80-0-0.jpg" alt="Limage Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="limage-pierre.php">Limage Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/RTLqNwX7/lionel.png" alt="Lionel Benjamin"></div>
  <div class="r-details"><div class="r-band"><a href="lionel-benjamin.php">Lionel Benjamin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3e202741180bf287ec450f66f9599282/250x250-000000-80-0-0.jpg" alt="Lisa Moise"></div>
  <div class="r-details"><div class="r-band"><a href="lisa-moise.php">Lisa Moise</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/bSmSd5rcyO_2zRRuUfaI9ovWRHeWFUlXCLnO0eTE0LI/rs:fit/g:sm/q:90/h:600/w:597/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTk2ODQ3/MDctMTQ4NDczMzgy/OC0zMDE2LmpwZWc.jpeg" alt="Liza Willams Beauvil"></div>
  <div class="r-details"><div class="r-band"><a href="liza-willams-beauvil.php">Liza Willams Beauvil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2732504e9c2539f88a59461484f" alt="Lochard Remy"></div>
  <div class="r-details"><div class="r-band"><a href="lochard-remy.php">Lochard Remy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/SD9Jkdgg/logic.png" alt="Logic Select"></div>
  <div class="r-details"><div class="r-band"><a href="logic-select.php">Logic Select</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/4f23d1735d2d50d98ad48466280055d7/250x250-000000-80-0-0.jpg" alt="Log-In"></div>
  <div class="r-details"><div class="r-band"><a href="log-in.php">Log-In</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100649.jpg" alt="Loko"></div>
  <div class="r-details"><div class="r-band"><a href="loko.php">Loko</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/2dbd6d3b2148e7f2ee4a33993f3126ab/500x500.jpg" alt="Loïc Emboulé"></div>
  <div class="r-details"><div class="r-band"><a href="loic-emboule.php">Loïc Emboulé</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/X6NyNuRH7pFBIV2wkcF3hxfq9RAaExQDAMAEhovUcP8/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE1NTMy/Nzc4LTE1OTMyNzky/ODEtNDM4My5qcGVn.jpeg" alt="Lole Lolay"></div>
  <div class="r-details"><div class="r-band"><a href="lole-lolay.php">Lole Lolay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103925.jpg" alt="Lolo"></div>
  <div class="r-details"><div class="r-band"><a href="lolo.php">Lolo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/174e425993f41371760a7211ff7c4ec6/250x250-000000-80-0-0.jpg" alt="Lord Imp"></div>
  <div class="r-details"><div class="r-band"><a href="lord-imp.php">Lord Imp</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61a9k9UJFJL._UXNaN_FMjpg_QL85_.jpg" alt="Los Diplomaticos De Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="los-diplomaticos-de-haiti.php">Los Diplomaticos De Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103926.jpg" alt="Lot Nivo"></div>
  <div class="r-details"><div class="r-band"><a href="lot-nivo.php">Lot Nivo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104160.jpg" alt="Loubert Cadet"></div>
  <div class="r-details"><div class="r-band"><a href="loubert-cadet.php">Loubert Cadet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/bfnvIUwyAp7VGHzzaruSya6zB9ZjpwBDyj47jDm9gHc/rs:fit/g:sm/q:90/h:600/w:589/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTgwNzcz/NjUtMTQ1NTIxMTgx/MC03NzMxLmpwZWc.jpeg" alt="Louis Lahens et Ses Gais Troubadours"></div>
  <div class="r-details"><div class="r-band"><a href="louis-lahens-et-ses-gais-troubadours.php">Louis Lahens et Ses Gais Troubadours</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/7/1743338894-louis-philippe-volcy.png" alt="Louis-Philippe Volcy and the Chicago Baraks"></div>
  <div class="r-details"><div class="r-band"><a href="louis-philippe-volcy-and-the-chicago-baraks.php">Louis-Philippe Volcy and the Chicago Baraks</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ZZcfp9aNL._UXNaN_FMjpg_QL85_.jpg" alt="Louisiane"></div>
  <div class="r-details"><div class="r-band"><a href="louisiane.php">Louisiane</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSq_yqIUCT-SgACpxP1zVv_roYLzue8MkK37g&s" alt="Loune"></div>
  <div class="r-details"><div class="r-band"><a href="loune.php">Loune</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/zTY2ZnHV/Lov.png" alt="Lov'"></div>
  <div class="r-details"><div class="r-band"><a href="lov.php">Lov'</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104212.jpg" alt="Love"></div>
  <div class="r-details"><div class="r-band"><a href="love.php">Love</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/37f0801c8fb7f7860315b2a77a99ace4/250x250-000000-80-0-0.jpg" alt="Lover Jay"></div>
  <div class="r-details"><div class="r-band"><a href="lover-jay.php">Lover Jay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTINEk6asBniqRaW_oWUDO1zUEPTzN8HWjykQ&s" alt="Lov'n Kompas"></div>
  <div class="r-details"><div class="r-band"><a href="lov-n-kompas.php">Lov'n Kompas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.iheart.com/v3/url/aHR0cCUzQSUyRiUyRmltYWdlLmloZWFydC5jb20lMkZpaHItaW5nZXN0aW9uLXBpcGVsaW5lLXByb2R1Y3Rpb24tY2RiYWJ5JTJGVGh1bWJQbGF5XzIwMTcwNDAyLUNEQjAxNjYyNjc0JTJGMTkxMDYxNTQ3MDUxJTJGMTkxMDYxNTQ3MDUxLmpwZw==?ops=fit(480%2C480)" alt="Lovokal"></div>
  <div class="r-details"><div class="r-band"><a href="lovokal.php">Lovokal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/f628ca51af57e2272685a7fd23fa5601/250x250-000000-80-0-0.jpg" alt="Lucien Ceran Jr"></div>
  <div class="r-details"><div class="r-band"><a href="lucien-ceran-jr.php">Lucien Ceran Jr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/c78ecd563643868180cacf7f710aece2/1900x1900-000000-80-0-0.jpg" alt="Luck Mervil"></div>
  <div class="r-details"><div class="r-band"><a href="luck-mervil.php">Luck Mervil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/91EeYLZCTYL._UF1000,1000_QL80_.jpg" alt="Lucky Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="lucky-pierre.php">Lucky Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ0_0R5TXfn4DoYn9w3mq-v7Rf8I0Vp9CGhcA&s" alt="Lucky Plus"></div>
  <div class="r-details"><div class="r-band"><a href="lucky-plus.php">Lucky Plus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51fs-qoqyYL._UF1000,1000_QL80_.jpg" alt="Lucky Twoubadou"></div>
  <div class="r-details"><div class="r-band"><a href="lucky-twoubadou.php">Lucky Twoubadou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e.snmc.io/i/600/w/63c5722db299000fca0fa5021eb211d8/4469354/ludovic-lamothe-fleurs-dhaiti-10-selections-de-piano-par-ludovic-lamothe-Cover-Art.jpg" alt="Ludovic Lamothe"></div>
  <div class="r-details"><div class="r-band"><a href="ludovic-lamothe.php">Ludovic Lamothe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/images_produits/ZoomPE/1/2/8/0821689012821/tsp20130831214631/Je-te-le-jure.jpg" alt="Luigi Lin d'Or"></div>
  <div class="r-details"><div class="r-band"><a href="luigi-lin-d-or.php">Luigi Lin d'Or</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-kapBbZiKQKVbDNEP-v07hcA-t500x500.jpg" alt="Lugi ZQ"></div>
  <div class="r-details"><div class="r-band"><a href="lugi-zq.php">Lugi ZQ</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8db24960bd90da12777271d3851fe504/250x250-000000-80-0-0.jpg" alt="Luko Adjaffi"></div>
  <div class="r-details"><div class="r-band"><a href="luko-adjaffi.php">Luko Adjaffi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104397.jpg" alt="Lumiere Céleste"></div>
  <div class="r-details"><div class="r-band"><a href="lumiere-celeste.php">Lumiere Céleste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-8C7CV0JHGzxFo5W4-KzezAA-t240x240.jpg" alt="L-won"></div>
  <div class="r-details"><div class="r-band"><a href="l-won.php">L-won</a></div></div>
</div>

  </div>
  </main>

<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>