<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>M - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES 0-9 -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100658.jpg" alt="Macho Band"></div>
  <div class="r-details"><div class="r-band"><a href="macho-band.php">Macho Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/653c5ec94c6be2acb7c224e14e998d1b/250x250-000000-80-0-0.jpg" alt="Madamamwe"></div>
  <div class="r-details"><div class="r-band"><a href="madamamwe.php">Madamamwe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/616516oPmEL._UXNaN_FMjpg_QL85_.jpg" alt="Made In Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="made-in-mizik.php">Made In Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/616VmPZdvTL._UXNaN_FMjpg_QL85_.jpg" alt="Madigwa"></div>
  <div class="r-details"><div class="r-band"><a href="madigwa.php">Madigwa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://64.media.tumblr.com/4149470c444d38643e1a48abb429d2de/tumblr_o5e9lbFy9r1unv5v8o1_500.jpg" alt="Madman JP"></div>
  <div class="r-details"><div class="r-band"><a href="madman-jp.php">Madman JP</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/fVRZSFVN/maestro.png" alt="Maestro"></div>
  <div class="r-details"><div class="r-band"><a href="maestro.php">Maestro</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/515014ff90fc47e30d0daf2a3185156a/250x250-000000-80-0-0.jpg" alt="Maestro Fanel Valsaint"></div>
  <div class="r-details"><div class="r-band"><a href="maestro-fanel-valsaint.php">Maestro Fanel Valsaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music118/v4/18/ab/e5/18abe5d1-9368-6df6-f1c3-53e9ed101dd6/859725267836_cover.jpg/800x800cc.jpg" alt="Maggie Blanchard"></div>
  <div class="r-details"><div class="r-band"><a href="maggie-blanchard.php">Maggie Blanchard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/GnpWj9zXbl7axUDfsXH0muko2ThGNZ5mBjmeRLV7hxU/rs:fit/g:sm/q:90/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI0Njk0/NjQtMTI4NTc4OTUy/Ni5naWY.jpeg" alt="Magic Connection"></div>
  <div class="r-details"><div class="r-band"><a href="magic-connection.php">Magic Connection</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02107d8411db7bf4c42c68c814" alt="Magic Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="magic-haiti.php">Magic Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741540632-magic-konpa-album-cover.jpg" alt="Magic Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="magic-konpa.php">Magic Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d4c39368500c13117224bf2949345b80/250x250-000000-80-0-0.jpg" alt="Magic Touch"></div>
  <div class="r-details"><div class="r-band"><a href="magic-touch.php">Magic Touch</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/aUWbwkiMv4c4Ons1sc_tkBW19Iftrb1GEIEyyyX0JYI/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTM1NDEz/MjYtMTMzNDUxMzE3/OC5qcGVn.jpeg" alt="Magma"></div>
  <div class="r-details"><div class="r-band"><a href="magma.php">Magma</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a2d6e8936298fb31e6d95b2293ff9e7a/250x250-000000-80-0-0.jpg" alt="Magnum Band"></div>
  <div class="r-details"><div class="r-band"><a href="magnum-band.php">Magnum Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/IWVXCMBoV3Zx3LO1MiWK8eRMZNgk48KzhscZ6SBzoM4/rs:fit/g:sm/q:90/h:600/w:594/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTgzMzQ1/ODMtMTQ1OTU4ODE2/OS02NzM2LmpwZWc.jpeg" alt="Maguy Jean-Louis"></div>
  <div class="r-details"><div class="r-band"><a href="maguy-jean-louis.php">Maguy Jean-Louis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/b6e89dd414703651442d63723c33baa0/250x250-000000-80-0-0.jpg" alt="Majik Click"></div>
  <div class="r-details"><div class="r-band"><a href="majik-click.php">Majik Click</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/710uPsl6SeL._UF1000,1000_QL80_.jpg" alt="Makaya"></div>
  <div class="r-details"><div class="r-band"><a href="makaya.php">Makaya</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/afdc15294dc0a3612ef88edb5b708dba/250x250-000000-80-0-0.jpg" alt="Makenzybeatz"></div>
  <div class="r-details"><div class="r-band"><a href="makenzybeatz.php">Makenzybeatz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/osXNtkMQLKl4huC7kn3B6VLSJar1Hxq0jjg4iSt7_nA/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU3MTY3/ODctMTQwMDc0MjY0/NS0yNjEyLmpwZWc.jpeg" alt="Malanga"></div>
  <div class="r-details"><div class="r-band"><a href="malanga.php">Malanga</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741544171-malakai-cover.png" alt="Malakai"></div>
  <div class="r-details"><div class="r-band"><a href="malakai.php">Malakai</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ipAk1bWKL._UXNaN_FMjpg_QL85_.jpg" alt="Malida"></div>
  <div class="r-details"><div class="r-band"><a href="malida.php">Malida</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51lMu5Ds8kL._UF1000,1000_QL80_.jpg" alt="Malou Beauvoir"></div>
  <div class="r-details"><div class="r-band"><a href="malou-beauvoir.php">Malou Beauvoir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/ksXG75wQ/Pochette-CD-Musique-Photo-Nature-Oiseau-Mer-Ligne-Gras-Typographie-Minimaliste-Moderne-3.png" alt="Mambo Diela"></div>
  <div class="r-details"><div class="r-band"><a href="mambo-diela.php">Mambo Diela</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/jkQhK09k/Pochette-CD-Musique-Photo-Nature-Oiseau-Mer-Ligne-Gras-Typographie-Minimaliste-Moderne-2.png" alt="Mambo Lucienne"></div>
  <div class="r-details"><div class="r-band"><a href="mambo-lucienne.php">Mambo Lucienne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/1/1741568127-mamina-album-cover-1.png" alt="Mamina"></div>
  <div class="r-details"><div class="r-band"><a href="mamina.php">Mamina</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/a1d188346e909c1eaf77b2f26fd9ba6c/250x250-000000-80-0-0.jpg" alt="Mandela"></div>
  <div class="r-details"><div class="r-band"><a href="mandela.php">Mandela</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music4/v4/8c/25/09/8c250919-c436-d81b-6667-e9b4b8e12fe5/cover.jpg/1200x1200bf-60.jpg" alt="Maniak Full Djazz"></div>
  <div class="r-details"><div class="r-band"><a href="maniak-full-djazz.php">Maniak Full Djazz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104540.jpg" alt="Maniak full power"></div>
  <div class="r-details"><div class="r-band"><a href="maniak-full-power.php">Maniak full power</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/WptXVfdy/Pochette-CD-Musique-Photo-Nature-Oiseau-Mer-Ligne-Gras-Typographie-Minimaliste-Moderne-4.png" alt="Maniolita"></div>
  <div class="r-details"><div class="r-band"><a href="maniolita.php">Maniolita</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/737769eac3b9c2c51a33a9725c1a0e04/250x250-000000-80-0-0.jpg" alt="Manitohaiti"></div>
  <div class="r-details"><div class="r-band"><a href="manitohaiti.php">Manitohaiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/cc72d8ef15d22d14dae920c1dddd009d/250x250-000000-80-0-0.jpg" alt="ManitoNation"></div>
  <div class="r-details"><div class="r-band"><a href="manitonation.php">ManitoNation</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/1Y3Ky7Tm/Pochette-CD-Musique-Photo-Nature-Oiseau-Mer-Ligne-Gras-Typographie-Minimaliste-Moderne-5.png" alt="Manjak"></div>
  <div class="r-details"><div class="r-band"><a href="manjak.php">Manjak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/1/1741594863-manmzel-album-cover.jpg" alt="ManmZel"></div>
  <div class="r-details"><div class="r-band"><a href="manmzel.php">ManmZel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/5c966cd1729827ccdd0773731449bff3/1900x1900-000000-80-0-0.jpg" alt="Manno Charlemagne"></div>
  <div class="r-details"><div class="r-band"><a href="manno-charlemagne.php">Manno Charlemagne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/1/1741595342-manno-jr-album-cover.jpg" alt="Manno Jr"></div>
  <div class="r-details"><div class="r-band"><a href="manno-jr.php">Manno Jr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://f4.bcbits.com/img/0025959845_10.jpg" alt="Manouche"></div>
  <div class="r-details"><div class="r-band"><a href="manouche.php">Manouche</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51UnvG4cHfL._UXNaN_FMjpg_QL85_.jpg" alt="Manouchka"></div>
  <div class="r-details"><div class="r-band"><a href="manouchka.php">Manouchka</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/6/1742020720-manuba-stars.jpg" alt="Manumba Stars"></div>
  <div class="r-details"><div class="r-band"><a href="manumba-stars.php">Manumba Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273137b02af107ecfae646b8061" alt="Marc Dorcean"></div>
  <div class="r-details"><div class="r-band"><a href="marc-dorcean.php">Marc Dorcean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/1/1744587208-marcel-alexis-cover.jpg" alt="Marcel Alexis"></div>
  <div class="r-details"><div class="r-band"><a href="marcel-alexis.php">Marcel Alexis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/15/7/1744562515-marcel-pierre-cover.jpg" alt="Marcel Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="marcel-pierre.php">Marcel Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3b996a5e110d32c03d11298efbbabef1/250x250-000000-80-0-0.jpg" alt="Mardoché the Singer"></div>
  <div class="r-details"><div class="r-band"><a href="mardoche-the-singer.php">Mardoché the Singer</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/18ad1c65818d186dd65816e573f48109/250x250-000000-80-0-0.jpg" alt="Marc Eddy Joseph"></div>
  <div class="r-details"><div class="r-band"><a href="marc-eddy-joseph.php">Marc Eddy Joseph</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music122/v4/ac/6c/8a/ac6c8afe-b287-ba2f-e2fa-5022f0e84f03/198004823876.jpg/600x600bf-60.jpg" alt="Marc Frederic"></div>
  <div class="r-details"><div class="r-band"><a href="marc-frederic.php">Marc Frederic</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/510fmbItoSL._UXNaN_FMjpg_QL85_.jpg" alt="Marc Mathelier & Michèle Sorel"></div>
  <div class="r-details"><div class="r-band"><a href="marc-mathelier-michele-sorel.php">Marc Mathelier & Michèle Sorel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/1730fc0765eecab5ebcf32fe1bea6931/250x250-000000-80-0-0.jpg" alt="Marc Rebel"></div>
  <div class="r-details"><div class="r-band"><a href="marc-rebel.php">Marc Rebel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/5c186b7fd62a6d0d4388d87de3a87977/264x264.jpg" alt="Marc-Olivier Gaillard"></div>
  <div class="r-details"><div class="r-band"><a href="marc-olivier-gaillard.php">Marc-Olivier Gaillard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741551823-marc-yves-volcy-album-cover.jpg" alt="Marc-Yves Volcy"></div>
  <div class="r-details"><div class="r-band"><a href="marc-yves-volcy.php">Marc-Yves Volcy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741552315-margareth-blanc-album-cover.jpg" alt="Margareth Blanc"></div>
  <div class="r-details"><div class="r-band"><a href="margareth-blanc.php">Margareth Blanc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/cab473276d9609e907a5cef24c957474/250x250-000000-80-0-0.jpg" alt="Marie-Christine"></div>
  <div class="r-details"><div class="r-band"><a href="marie-christine.php">Marie-Christine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a5a13a2beaca93466295c9f13dc793aa/250x250-000000-80-0-0.jpg" alt="Marie-Josée Lord"></div>
  <div class="r-details"><div class="r-band"><a href="marie-josee-lord.php">Marie-Josée Lord</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/eece0376a9430470b10ae7240f0853a6/250x250-000000-80-0-0.jpg" alt="Marielle Donatien Jean-Francois"></div>
  <div class="r-details"><div class="r-band"><a href="marielle-donatien-jean-francois.php">Marielle Donatien Jean-Francois</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741546754-mario-devolcy-album-cover.jpg" alt="Mario De Volcy"></div>
  <div class="r-details"><div class="r-band"><a href="mario-de-volcy.php">Mario De Volcy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104645.jpg" alt="Mario Sove"></div>
  <div class="r-details"><div class="r-band"><a href="mario-sove.php">Mario Sove</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/89/bd/80/89bd8012-276e-f3bf-c590-76d1b1c124c4/859775297845_cover.jpg/600x600bf-60.jpg" alt="Mario Valentino"></div>
  <div class="r-details"><div class="r-band"><a href="mario-valentino.php">Mario Valentino</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61bkVdD19JL._UXNaN_FMjpg_QL85_.jpg" alt="Markus Schwartz"></div>
  <div class="r-details"><div class="r-band"><a href="markus-schwartz.php">Markus Schwartz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/71O0KNBSoaL._UF1000,1000_QL80_.jpg" alt="Marlène Dorcena"></div>
  <div class="r-details"><div class="r-band"><a href="marlene-dorcena.php">Marlène Dorcena</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSUAPQeMjkaTL7eC3R7iQ8j1TO3buYB-Kj-CA&s" alt="Marley Jeanius"></div>
  <div class="r-details"><div class="r-band"><a href="marley-jeanius.php">Marley Jeanius</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e.snmc.io/i/1200/s/ae180cdac7da8b0ce2452feed1b73741/5849264" alt="Martha Jean-Claude"></div>
  <div class="r-details"><div class="r-band"><a href="martha-jean-claude.php">Martha Jean-Claude</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41h4SzBNHcL._UF1000,1000_QL80_.jpg" alt="Martin Mathelier"></div>
  <div class="r-details"><div class="r-band"><a href="martin-mathelier.php">Martin Mathelier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/26c35580ad96342567bbb55d3ec1b955/250x250-000000-80-0-0.jpg" alt="Martine Alexandrer"></div>
  <div class="r-details"><div class="r-band"><a href="martine-alexandrer.php">Martine Alexandrer</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741554512-maryse-perl-album-cover.jpg" alt="Maryse Perl'"></div>
  <div class="r-details"><div class="r-band"><a href="maryse-perl.php">Maryse Perl'</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000171503343-o913pd-t500x500.jpg" alt="Mass Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="mass-konpa.php">Mass Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51L2tRhStLL._UXNaN_FMjpg_QL85_.jpg" alt="Mass Vocal"></div>
  <div class="r-details"><div class="r-band"><a href="mass-vocal.php">Mass Vocal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27362e0ce00ec3cc0ff1a03f7fa" alt="Massaj"></div>
  <div class="r-details"><div class="r-band"><a href="massaj.php">Massaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000193593566-jac7x2-t500x500.jpg" alt="Master Brain"></div>
  <div class="r-details"><div class="r-band"><a href="master-brain.php">Master Brain</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/86e53328707bb700fdcc0b097b04c996/250x250-000000-80-0-0.jpg" alt="Master DJI"></div>
  <div class="r-details"><div class="r-band"><a href="master-dji.php">Master DJI</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/PszLNJd2/Master-H.png" alt="Master H"></div>
  <div class="r-details"><div class="r-band"><a href="master-h.php">Master H</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ3Nu_z-rRZZv4fmp5ZlXvm-zpPXuNiuWYH0g&s" alt="Matrixx Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="matrixx-kompa.php">Matrixx Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/7/1741537240-maud-et-ti-roi-album-cover.jpg" alt="Maud et Ti-Roi"></div>
  <div class="r-details"><div class="r-band"><a href="maud-et-ti-roi.php">Maud et Ti-Roi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music113/v4/a5/32/5f/a5325f1b-05f7-bf1c-871a-fb650e1a42e0/191018283155.jpg/486x486bb.png" alt="Maurice Bitter"></div>
  <div class="r-details"><div class="r-band"><a href="maurice-bitter.php">Maurice Bitter</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51GadMRCs7L._UXNaN_FMjpg_QL85_.jpg" alt="Mawon"></div>
  <div class="r-details"><div class="r-band"><a href="mawon.php">Mawon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/9462ba5e779fdf42d73743d2258efd7a/1900x1900-000000-80-0-0.jpg" alt="Max Badette"></div>
  <div class="r-details"><div class="r-band"><a href="max-badette.php">Max Badette</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/2/1744706754-max-benoit-cover.jpg" alt="Max Benoit"></div>
  <div class="r-details"><div class="r-band"><a href="max-benoit.php">Max Benoit</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/2/1744709916-maxima-all-starscover.jpg" alt="Maxima All Stars de Ti Claude"></div>
  <div class="r-details"><div class="r-band"><a href="maxima-all-stars-de-ti-claude.php">Maxima All Stars de Ti Claude</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51wcKknBh-L._UXNaN_FMjpg_QL85_.jpg" alt="Max T"></div>
  <div class="r-details"><div class="r-band"><a href="max-t.php">Max T</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/2/1744703758-mc-paji-cover.jpg" alt="MC Paji"></div>
  <div class="r-details"><div class="r-band"><a href="mc-paji.php">MC Paji</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/be000e319b44afae15730234db24b9ab/250x250-000000-80-0-0.jpg" alt="Mdess Prod"></div>
  <div class="r-details"><div class="r-band"><a href="mdess-prod.php">Mdess Prod</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/746d4b4ab9a89c4a49d1503d408cdcff/250x250-000000-80-0-0.jpg" alt="Mdo 333"></div>
  <div class="r-details"><div class="r-band"><a href="mdo-333.php">Mdo 333</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-WWua1oGy1xxdr4lK-Rk8MLg-t500x500.jpg" alt="Medjy"></div>
  <div class="r-details"><div class="r-band"><a href="medjy.php">Medjy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c714c9ef2874f4e65aa116df3ea3c1d2/250x250-000000-80-0-0.jpg" alt="Medjy Ayisyen"></div>
  <div class="r-details"><div class="r-band"><a href="medjy-ayisyen.php">Medjy Ayisyen</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://downbeat.com/images/news/_full/DB22_Melanie_Charles.jpg" alt="Melanie Charles"></div>
  <div class="r-details"><div class="r-band"><a href="melanie-charles.php">Melanie Charles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ52QD2JDH02iN48DXrgQgQ3IkA0jgrZSXgzg&s" alt="Melissa Dauphin"></div>
  <div class="r-details"><div class="r-band"><a href="melissa-dauphin.php">Melissa Dauphin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/377a765ba70b0ba3afeb535aa2fd8b64/1900x1900-000000-80-0-0.jpg" alt="Melissa Laveaux"></div>
  <div class="r-details"><div class="r-band"><a href="melissa-laveaux.php">Melissa Laveaux</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000277645568-biayca-t500x500.jpg" alt="Melodeek"></div>
  <div class="r-details"><div class="r-band"><a href="melodeek.php">Melodeek</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music4/v4/4d/c9/1f/4dc91f7e-aa69-bad0-ac41-36400191fa8e/884501948227.jpg/1200x1200bf-60.jpg" alt="Melodi"></div>
  <div class="r-details"><div class="r-band"><a href="melodi.php">Melodi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2739c0f958a22138e4d73573a67" alt="Melting-Groov'"></div>
  <div class="r-details"><div class="r-band"><a href="melting-groov.php">Melting-Groov'</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104564.jpg" alt="Men Blagueur"></div>
  <div class="r-details"><div class="r-band"><a href="men-blagueur.php">Men Blagueur</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS-nDGjiwubFOXWkAqzZk1x34RvbBf6zMZ2yg&s" alt="Meridional De Montreal"></div>
  <div class="r-details"><div class="r-band"><a href="meridional-de-montreal.php">Meridional De Montreal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104105.jpg" alt="Message"></div>
  <div class="r-details"><div class="r-band"><a href="message.php">Message</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/9986b0821303b808bd0696755519cb32/250x250-000000-80-0-0.jpg" alt="Messiah Gospel Band"></div>
  <div class="r-details"><div class="r-band"><a href="messiah-gospel-band.php">Messiah Gospel Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/2/1744747536-meteor-cover.jpg" alt="Meteor d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="meteor-d-haiti.php">Meteor d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music221/v4/e8/6c/f2/e86cf244-05a1-b959-0d19-93c875ec246d/859784174373_cover.jpg/486x486bb.png" alt="Métiskacao"></div>
  <div class="r-details"><div class="r-band"><a href="metiskacao.php">Métiskacao</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/2/1744748167-miami-hit-cover.jpg" alt="Miami Hit & Marco Polo"></div>
  <div class="r-details"><div class="r-band"><a href="miami-hit-marco-polo.php">Miami Hit & Marco Polo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/4/1744872882-miami-live-cover.png" alt="Miami Live"></div>
  <div class="r-details"><div class="r-band"><a href="miami-live.php">Miami Live</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/22d1c0170604dbb9307a232c576337df/250x250-000000-80-0-0.jpg" alt="Mich Michee"></div>
  <div class="r-details"><div class="r-band"><a href="mich-michee.php">Mich Michee</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/ea0c7e74dfd10c8748e433cd98eae2f1/250x250-000000-80-0-0.jpg" alt="Mikaben"></div>
  <div class="r-details"><div class="r-band"><a href="mikaben.php">Mikaben</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.wixstatic.com/media/348b7c_1c7feaabea0e42649d328b92d9c72729~mv2.jpg/v1/fill/w_700,h_700,al_c,q_85/MICHAEL%20BRUN.jpg" alt="Michael Brun"></div>
  <div class="r-details"><div class="r-band"><a href="michael-brun.php">Michael Brun</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7761e62fb63033617cd8d122822ef0cb/250x250-000000-80-0-0.jpg" alt="Michael Lemorin"></div>
  <div class="r-details"><div class="r-band"><a href="michael-lemorin.php">Michael Lemorin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/16/1/1744589900-michael-stety-cover.jpg" alt="Michael Stety Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="michael-stety-pierre.php">Michael Stety Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103935.jpg" alt="Michel Ange Bazile"></div>
  <div class="r-details"><div class="r-band"><a href="michel-ange-bazile.php">Michel Ange Bazile</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000116290259-x11idd-t500x500.jpg" alt="Michel Batista"></div>
  <div class="r-details"><div class="r-band"><a href="michel-batista.php">Michel Batista</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51kVbk9apCL._UXNaN_FMjpg_QL85_.jpg" alt="Michel Blaise"></div>
  <div class="r-details"><div class="r-band"><a href="michel-blaise.php">Michel Blaise</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/1obZMFwP0wMQxp3uA2Y2N_Yc2A4YfQKPELekCuUKnUg/rs:fit/g:sm/q:90/h:600/w:599/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTYyNTM0/MjYtMTY1MTMyNjc3/My04ODI5LmpwZWc.jpeg" alt="Michel Chaupard"></div>
  <div class="r-details"><div class="r-band"><a href="michel-chaupard.php">Michel Chaupard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61y3t2WiTWL._UXNaN_FMjpg_QL85_.jpg" alt="Michel Desgrottes"></div>
  <div class="r-details"><div class="r-band"><a href="michel-desgrottes.php">Michel Desgrottes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61+Lvvi+2iL._UXNaN_FMjpg_QL85_.jpg" alt="Michel Jabbour"></div>
  <div class="r-details"><div class="r-band"><a href="michel-jabbour.php">Michel Jabbour</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103753.jpg" alt="Michel Marchand"></div>
  <div class="r-details"><div class="r-band"><a href="michel-marchand.php">Michel Marchand</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.popsike.ch/pix/20081109/380080214670.jpg" alt="Michel Pressoir"></div>
  <div class="r-details"><div class="r-band"><a href="michel-pressoir.php">Michel Pressoir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/81v0zJAjcHL._UF1000,1000_QL80_.jpg" alt="Michel Martelly"></div>
  <div class="r-details"><div class="r-band"><a href="michel-martelly.php">Michel Martelly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51Yb1lo0R8L._UXNaN_FMjpg_QL85_.jpg" alt="Michelet"></div>
  <div class="r-details"><div class="r-band"><a href="michelet.php">Michelet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103947.jpg" alt="Michelet Brutus"></div>
  <div class="r-details"><div class="r-band"><a href="michelet-brutus.php">Michelet Brutus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273f503a80ff655345f809478ac" alt="Micheline Laudun Denis"></div>
  <div class="r-details"><div class="r-band"><a href="micheline-laudun-denis.php">Micheline Laudun Denis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/90229fa4c410f5d8b7d3798fd64b6bef/250x250-000000-80-0-0.jpg" alt="Mikael L. Jules"></div>
  <div class="r-details"><div class="r-band"><a href="mikael-l-jules.php">Mikael L. Jules</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61X-abRf2UL._UXNaN_FMjpg_QL85_.jpg" alt="Mike Overlord"></div>
  <div class="r-details"><div class="r-band"><a href="mike-overlord.php">Mike Overlord</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103821.jpg" alt="Min Gran Panpan"></div>
  <div class="r-details"><div class="r-band"><a href="min-gran-panpan.php">Min Gran Panpan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e0200d2d38e2e7a3b9cdae5e71f" alt="Mini All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="mini-all-stars.php">Mini All Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103948.jpg" alt="Miraj"></div>
  <div class="r-details"><div class="r-band"><a href="miraj.php">Miraj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104566.jpg" alt="Miraj Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="miraj-mizik.php">Miraj Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000510850773-rh02bq-t500x500.jpg" alt="Mireille Diaz Con Les Freres Dejean"></div>
  <div class="r-details"><div class="r-band"><a href="mireille-diaz-con-les-freres-dejean.php">Mireille Diaz Con Les Freres Dejean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51Oq30Xij5L._UF1000,1000_QL80_.jpg" alt="Mireille Menard"></div>
  <div class="r-details"><div class="r-band"><a href="mireille-menard.php">Mireille Menard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/30ff9f87dbb5204ca335815f27fe05af/250x250-000000-80-0-0.jpg" alt="Mista Jet"></div>
  <div class="r-details"><div class="r-band"><a href="mista-jet.php">Mista Jet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/0f1e0e1872501b342ba59738ac498e3c/1900x1900-000000-80-0-0.jpg" alt="Misié Sadik"></div>
  <div class="r-details"><div class="r-band"><a href="misie-sadik.php">Misié Sadik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103949.jpg" alt="Miss Prince"></div>
  <div class="r-details"><div class="r-band"><a href="miss-prince.php">Miss Prince</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/9lZstmtfQ_q9KxYaP0jS1IFri4Ts3GLcNwzN_E_LK58/rs:fit/g:sm/q:90/h:594/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU3OTY2/OTgtMTQwMjkyNDcw/Ny0yMTA5LmpwZWc.jpeg" alt="Missile 727"></div>
  <div class="r-details"><div class="r-band"><a href="missile-727.php">Missile 727</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51KxwID1RHS._UXNaN_FMjpg_QL85_.jpg" alt="Mister Henri"></div>
  <div class="r-details"><div class="r-band"><a href="mister-henri.php">Mister Henri</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51PDNvhAn1L._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Mister SAG"></div>
  <div class="r-details"><div class="r-band"><a href="mister-sag.php">Mister SAG</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/7/1742160983-misty-jean-cover.jpg" alt="Misty Jean"></div>
  <div class="r-details"><div class="r-band"><a href="misty-jean.php">Misty Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d6293d97d72449c4c36aeaf718f71a1c/250x250-000000-80-0-0.jpg" alt="Miu Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="miu-haiti.php">Miu Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/1/1742167429-mizik-kreyol-cover.jpg" alt="Mizik Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="mizik-kreyol.php">Mizik Kreyol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/WWcyPC8M/Mizik-Adi.png" alt="Mizik Madik"></div>
  <div class="r-details"><div class="r-band"><a href="mizik-madik.php">Mizik Madik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS3IaaV8mX-Q4IiFgMtgUmmxYa2ufYvnNcLWQ&s" alt="Mizik Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="mizik-mizik.php">Mizik Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/07/20/a699dd73d3b04005b22c7c8aacd3cd84_320_320.jpg" alt="Mizik Nap Bay"></div>
  <div class="r-details"><div class="r-band"><a href="mizik-nap-bay.php">Mizik Nap Bay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/twKQvxLc/Model-kompa.png" alt="Model Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="model-kompa.php">Model Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/0j11k8wr/Momento-Mizik.png" alt="Momento Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="momento-mizik.php">Momento Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273b7ccaadafce0256c84165932" alt="Mondy Blue"></div>
  <div class="r-details"><div class="r-band"><a href="mondy-blue.php">Mondy Blue</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/812e9b47fcc9fc10548a2606cfef464f/250x250-000000-80-0-0.jpg" alt="Monvelyno Alexis"></div>
  <div class="r-details"><div class="r-band"><a href="monvelyno-alexis.php">Monvelyno Alexis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/0ff3c5da2b998e42e02931421ede4990/250x250-000000-80-0-0.jpg" alt="Monvelyno Eksperyans"></div>
  <div class="r-details"><div class="r-band"><a href="monvelyno-eksperyans.php">Monvelyno Eksperyans</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/823515e31f3dc2a6bb0aea0af04f47ad/1900x1900-000000-80-0-0.jpg" alt="Mood Band"></div>
  <div class="r-details"><div class="r-band"><a href="mood-band.php">Mood Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://moonlightbenjamin.com/assets/images/image04.jpg?v=c595af19" alt="Moonlight Benjamin"></div>
  <div class="r-details"><div class="r-band"><a href="moonlight-benjamin.php">Moonlight Benjamin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/610J6qn5KyL._UXNaN_FMjpg_QL85_.jpg" alt="Mozart Band"></div>
  <div class="r-details"><div class="r-band"><a href="mozart-band.php">Mozart Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51hgARIFJxL._AC_UF894,1000_QL80_.jpg" alt="Mozayik"></div>
  <div class="r-details"><div class="r-band"><a href="mozayik.php">Mozayik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/040b64f1401a2a25c4a56a0e3f9833b8/250x250-000000-80-0-0.jpg" alt="M-One Dezod"></div>
  <div class="r-details"><div class="r-band"><a href="m-one-dezod.php">M-One Dezod</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/3/1742369754-m-pak-album-cover.jpg" alt="M-Pak"></div>
  <div class="r-details"><div class="r-band"><a href="m-pak.php">M-Pak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/94e4455b28c79c366bf5156207ee84e4/250x250-000000-80-0-0.jpg" alt="Mr Nico"></div>
  <div class="r-details"><div class="r-band"><a href="mr-nico.php">Mr Nico</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7f2d2cdabccb3d83f116842799d2a649/250x250-000000-80-0-0.jpg" alt="Mr.Passs & Scandy"></div>
  <div class="r-details"><div class="r-band"><a href="mr-passs-scandy.php">Mr.Passs & Scandy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/32c9a61613428dd75ab38476dee38620/250x250-000000-80-0-0.jpg" alt="Mr Steve Jr"></div>
  <div class="r-details"><div class="r-band"><a href="mr-steve-jr.php">Mr Steve Jr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e8c8225a6c8b45794bb53a03959f237a/250x250-000000-80-0-0.jpg" alt="Mr vibe"></div>
  <div class="r-details"><div class="r-band"><a href="mr-vibe.php">Mr vibe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/930a9315fde5764ce503b9c897312d62/250x250-000000-80-0-0.jpg" alt="Mr Wal"></div>
  <div class="r-details"><div class="r-band"><a href="mr-wal.php">Mr Wal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/69d9b2d68f24593dd560c3f45559c347/250x250-000000-80-0-0.jpg" alt="Mr YeZZzzSirr"></div>
  <div class="r-details"><div class="r-band"><a href="mr-yezzzzsirr.php">Mr YeZZzzSirr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-poQpYYudUtq8bcje-Qy3sqA-t500x500.jpg" alt="Mr Zomò"></div>
  <div class="r-details"><div class="r-band"><a href="mr-zom.php">Mr Zomò</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273e8ff7154c71b2d6735d452c9" alt="Mushy Widmaier"></div>
  <div class="r-details"><div class="r-band"><a href="mushy-widmaier.php">Mushy Widmaier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/2/1741654207-myriam-philidor-dorisme.jpg" alt="Myriam Philidor Dorisme"></div>
  <div class="r-details"><div class="r-band"><a href="myriam-philidor-dorisme.php">Myriam Philidor Dorisme</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41XTIuHlGtL._UXNaN_FMjpg_QL85_.jpg" alt="Mystah R"></div>
  <div class="r-details"><div class="r-band"><a href="mystah-r.php">Mystah R</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/lV7pQiU33ITuTwbEWlDiqTKII5Bj2Nf51qeMU0IBQC0/rs:fit/g:sm/q:90/h:518/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTIwODYw/NDAtMTI2MzE3MzUw/Ny5qcGVn.jpeg" alt="Mystik703"></div>
  <div class="r-details"><div class="r-band"><a href="mystik703.php">Mystik703</a></div></div>
</div>

  
  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>