<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>N - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES N -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/0e/61/c5/mzi.ptccwwtr.jpg/400x400bb.webp" alt="Nakawout"></div>
  <div class="r-details"><div class="r-band"><a href="nakawout.php">Nakawout</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51qUgCSIY-L._UF1000,1000_QL80_.jpg" alt="Nandy Pierre-louis & Lucky Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="nandy-pierre-louis-lucky-pierre.php">Nandy Pierre-louis & Lucky Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/128e79d05852af13224c22b0c7838ae3/250x250-000000-80-0-0.jpg" alt="Nanm"></div>
  <div class="r-details"><div class="r-band"><a href="nanm.php">Nanm</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/3/1742949155-nathalie-joachim.png" alt="Nathalie Joachim"></div>
  <div class="r-details"><div class="r-band"><a href="nathalie-joachim.php">Nathalie Joachim</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/656152102f99016f60cb868d0231b44b/250x250-000000-80-0-0.jpg" alt="Neg J"></div>
  <div class="r-details"><div class="r-band"><a href="neg-j.php">Neg J</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/8578ac90ce7cc38ccc425ccd3f12c071/250x250-000000-80-0-0.jpg" alt="Neg red yoo"></div>
  <div class="r-details"><div class="r-band"><a href="neg-red-yoo.php">Neg red yoo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000227848538-c9hhp7-t500x500.jpg" alt="Neks"></div>
  <div class="r-details"><div class="r-band"><a href="neks.php">Neks</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQqECtkNnysVCznWd2E38TaEVfThZMGWGfZVA&s" alt="Nemours Jean Baptiste & Son Super Ensemble"></div>
  <div class="r-details"><div class="r-band"><a href="nemours-jean-baptiste-son-super-ensemble.php">Nemours Jean Baptiste & Son Super Ensemble</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/mQ3j8fFxmFswqytqTQMdJk_SrclYr0rVUw3fQqzjJEE/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEwNTU3/NDc4LTE0OTk4NTYw/MTMtMzkzNi5qcGVn.jpeg" alt="Nemours Jean Baptiste"></div>
  <div class="r-details"><div class="r-band"><a href="nemours-jean-baptiste.php">Nemours Jean Baptiste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/52e67a62b26834bee0e5ddb597f83e0f/1900x1900-000000-80-0-0.jpg" alt="Nestor Azerot"></div>
  <div class="r-details"><div class="r-band"><a href="nestor-azerot.php">Nestor Azerot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/3176a6b1f0958512d8776a9bc9e46736/1900x1900-000000-80-0-0.jpg" alt="Nesty Di Lova"></div>
  <div class="r-details"><div class="r-band"><a href="nesty-di-lova.php">Nesty Di Lova</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/0b157db24a0a7480effb19e1d56a951c/250x250-000000-80-0-0.jpg" alt="New Generation Music"></div>
  <div class="r-details"><div class="r-band"><a href="new-generation-music.php">New Generation Music</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/FR/Images_Produits/FR/fnac.com/Visual_Principal_340/8/9/0/3760128761098/tsp20121011112600/New-rebels-live-volume-1.jpg" alt="New Rebel's"></div>
  <div class="r-details"><div class="r-band"><a href="new-rebel-s.php">New Rebel's</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273c63f05a7752f51fb2a445b20" alt="New York All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="new-york-all-stars.php">New York All Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/mMncPn0NyYKTtgPdhYuM2Da7HLbokk0OiRzvo-q_XyU/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMzMTIz/NjctMTM3MDUwNzU3/NS00MDIyLmpwZWc.jpeg" alt="New York Superstars"></div>
  <div class="r-details"><div class="r-band"><a href="new-york-superstars.php">New York Superstars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51HGI-suuHL._UXNaN_FMjpg_QL85_.jpg" alt="Nia Musiq"></div>
  <div class="r-details"><div class="r-band"><a href="nia-musiq.php">Nia Musiq</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102865.jpg" alt="Nick"></div>
  <div class="r-details"><div class="r-band"><a href="nick.php">Nick</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000212630042-nv8x78-t500x500.jpg" alt="Nickenson Prud'Homme"></div>
  <div class="r-details"><div class="r-band"><a href="nickenson-prud-homme.php">Nickenson Prud'Homme</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/17deecfcb1a9e1dd38fd805283a78900/250x250-000000-80-0-0.jpg" alt="Nickson"></div>
  <div class="r-details"><div class="r-band"><a href="nickson.php">Nickson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/cc30b5fc8c1ebcd89e83dc6261816d35/250x250-000000-80-0-0.jpg" alt="Night-Time Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="night-time-kompa.php">Night-Time Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104360.jpg" alt="Nikel"></div>
  <div class="r-details"><div class="r-band"><a href="nikel.php">Nikel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://s.songswave.com/album-images/vol32/1560/1560243/3433599-big/Eneji-cover.jpg" alt="Niska"></div>
  <div class="r-details"><div class="r-band"><a href="niska.php">Niska</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103951.jpg" alt="N'Joy"></div>
  <div class="r-details"><div class="r-band"><a href="n-joy.php">N'Joy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music1/v4/70/56/09/70560974-0c88-06c0-515c-7028acca0b01/cover.jpg/1200x1200bf-60.jpg" alt="Njoy D'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="njoy-d-haiti.php">Njoy D'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02f57fb28be9e0d309964beeaf" alt="Nodéjà"></div>
  <div class="r-details"><div class="r-band"><a href="nodeja.php">Nodéjà</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/f13450f1477d98425355003eae42d758/250x250-000000-80-0-0.jpg" alt="Noldy"></div>
  <div class="r-details"><div class="r-band"><a href="noldy.php">Noldy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/920ffbe5a97e08ffb8bc127398f17c21/156x156-000000-80-0-0.jpg" alt="Nolly Romeus"></div>
  <div class="r-details"><div class="r-band"><a href="nolly-romeus.php">Nolly Romeus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e020aeaf880e5d504411c289e6a" alt="Nomads"></div>
  <div class="r-details"><div class="r-band"><a href="nomads.php">Nomads</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000025391318-repkuy-t500x500.jpg" alt="Nou Krezi"></div>
  <div class="r-details"><div class="r-band"><a href="nou-krezi.php">Nou Krezi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a75c4d20dc5d5c8a7ada023b7e525571/250x250-000000-80-0-0.jpg" alt="Nou Shelbè"></div>
  <div class="r-details"><div class="r-band"><a href="nou-shelbe.php">Nou Shelbè</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e073cd01d8066cb61ed8f3758ee03a30/250x250-000000-80-0-0.jpg" alt="Nouvelle Des Jeunes"></div>
  <div class="r-details"><div class="r-band"><a href="nouvelle-des-jeunes.php">Nouvelle Des Jeunes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273a8f3ca4b084c67c07ad7511c" alt="Nouvelle Vague de Montréal"></div>
  <div class="r-details"><div class="r-band"><a href="nouvelle-vague-de-montreal.php">Nouvelle Vague de Montréal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/2ff64a9e0e9ea80617e5ff440efdcb5f/250x250-000000-80-0-0.jpg" alt="Nouvo Lib"></div>
  <div class="r-details"><div class="r-band"><a href="nouvo-lib.php">Nouvo Lib</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/7/1743370405-nouvovox.png" alt="NouvoVox"></div>
  <div class="r-details"><div class="r-band"><a href="nouvovox.php">NouvoVox</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/7/1743371938-nu-bel.png" alt="Nu Bel"></div>
  <div class="r-details"><div class="r-band"><a href="nu-bel.php">Nu Bel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c763b741486d9320646451e61dd9e360/250x250-000000-80-0-0.jpg" alt="Nu Chill"></div>
  <div class="r-details"><div class="r-band"><a href="nu-chill.php">Nu Chill</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-qCXkuAy8kQl6OPBf-GBwrig-t500x500.jpg" alt="NuDore"></div>
  <div class="r-details"><div class="r-band"><a href="nudore.php">NuDore</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102476.jpg" alt="Nufaze"></div>
  <div class="r-details"><div class="r-band"><a href="nufaze.php">Nufaze</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/7/1743342437-nu-look.png" alt="Nu Look"></div>
  <div class="r-details"><div class="r-band"><a href="nu-look.php">Nu Look</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c2eab1fb2b3165f6721d62c7b05aa794/250x250-000000-80-0-0.jpg" alt="NP"></div>
  <div class="r-details"><div class="r-band"><a href="np.php">NP</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/14/1/1743376347-nu-poz.png" alt="Nu Poz"></div>
  <div class="r-details"><div class="r-band"><a href="nu-poz.php">Nu Poz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51UsybQmC3L._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Nu Relax Officiel"></div>
  <div class="r-details"><div class="r-band"><a href="nu-relax-officiel.php">Nu Relax Officiel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/14/1/1743375701-nu-stars.png" alt="Nu Stars"></div>
  <div class="r-details"><div class="r-band"><a href="nu-stars.php">Nu Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000072181863-ghqrum-t1080x1080.jpg" alt="NuStil"></div>
  <div class="r-details"><div class="r-band"><a href="nustil.php">NuStil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51ydL0rlnsL._UXNaN_FMjpg_QL85_.jpg" alt="Nu-Style"></div>
  <div class="r-details"><div class="r-band"><a href="nu-style.php">Nu-Style</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/14/1/1743386660-nu-system-2.png" alt="Nu System"></div>
  <div class="r-details"><div class="r-band"><a href="nu-system.php">Nu System</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/516Krt2UMzL._UXNaN_FMjpg_QL85_.jpg" alt="Nu Tempo"></div>
  <div class="r-details"><div class="r-band"><a href="nu-tempo.php">Nu Tempo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/vfP5Bv8CH37bitpSQA4bUj5AIeKcM35FMCtwiCqfj2I/rs:fit/g:sm/q:90/h:588/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTIxMTg2/ODMyLTE2MzgzNTAx/NzgtMzYzMS5qcGVn.jpeg" alt="Nu Vice"></div>
  <div class="r-details"><div class="r-band"><a href="nu-vice.php">Nu Vice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music49/v4/20/56/d6/2056d61e-3691-ca34-d7ec-293d351132fb/859716987194_cover.jpg/1200x1200bf-60.jpg" alt="Nu Voice"></div>
  <div class="r-details"><div class="r-band"><a href="nu-voice.php">Nu Voice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000068464612-gk1wpb-t500x500.jpg" alt="Nuz Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="nuz-haiti.php">Nuz Haïti</a></div></div>
</div>

  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>

