<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>O - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES O -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/df54acc581b5cb14b0c4120dd84082ad/250x250-000000-80-0-0.jpg" alt="O.L.C."></div>
  <div class="r-details"><div class="r-band"><a href="o-l-c.php">O.L.C.</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/pxsAAOSwpGJmVR6~/s-l1200.jpg" alt="O2 D.P Express"></div>
  <div class="r-details"><div class="r-band"><a href="o2dpexpress.php">O2 D.P Express</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/2e765bbdfe0b5efb178ee3fa69e53955/1900x1900-000000-80-0-0.jpg" alt="Ocean Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="ocean-kompa.php">Ocean Kompa</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105201.jpg" alt="Odjah"></div>
  <div class="r-details"><div class="r-band"><a href="odjah.php">Odjah</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102189.jpg" alt="Odyssey-One"></div>
  <div class="r-details"><div class="r-band"><a href="odysseyone.php">Odyssey-One</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/948685542cb5788d36c1da5e08d06d37/250x250-000000-80-0-0.jpg" alt="OG Sam"></div>
  <div class="r-details"><div class="r-band"><a href="og-sam.php">OG Sam</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51mBZmDOpOL._UXNaN_FMjpg_QL85_.jpg" alt="OK. Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="okhaiti.php">OK. Haïti</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104370.jpg" alt="Omega"></div>
  <div class="r-details"><div class="r-band"><a href="omega.php">Omega</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61Lk+GlsxML._UXNaN_FMjpg_QL85_.jpg" alt="Omega Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="omega-mizik.php">Omega Mizik</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2731f42fdbeb75f4209045bf3ff" alt="Omni Band d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="omnibanddhaiti.php">Omni Band d'Haïti</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61Vtr+oXBjL._UXNaN_FMjpg_QL85_.jpg" alt="Onal"></div>
  <div class="r-details"><div class="r-band"><a href="onal.php">Onal</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/37255c31505f431b6fcf4e7e9ea14535/250x250-000000-80-0-0.jpg" alt="Opak MNG"></div>
  <div class="r-details"><div class="r-band"><a href="opakmng.php">Opak MNG</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/wsNdTuWrbgYD1yELbEJTLDETTMRgVf6JjYaUdZwLIF4/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMyNzUz/NjMtMTMyMzUwMjMz/NC5qcGVn.jpeg" alt="Ophelia"></div>
  <div class="r-details"><div class="r-band"><a href="ophelia.php">Ophelia</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e024c4f9dd4090829c42d1adaea" alt="Option"></div>
  <div class="r-details"><div class="r-band"><a href="option.php">Option</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/b83ef0c1a793cd3f8adf323820b713ed/1900x1900-000000-80-0-0.jpg" alt="Orchestre Citadelle"></div>
  <div class="r-details"><div class="r-band"><a href="orchestrecitadelle.php">Orchestre Citadelle</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102722.jpg" alt="Orchestre Compas Du Nord D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="orchestrecompasdunorddhaiti.php">Orchestre Compas Du Nord D'Haiti</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/73287e0acd527fd6695f20cfc696cf42/250x250-000000-80-0-0.jpg" alt="Orchestre Crysoprase"></div>
  <div class="r-details"><div class="r-band"><a href="orchestre-crysoprase.php">Orchestre Crysoprase</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ZUlZxnmsMxwnSXQc_jyyKoFnzttKik-KIYLRaqZSqTM/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTk5NDc1/NDUtMTQ4OTA1MTY3/OS04NDU1LmpwZWc.jpeg" alt="Orchestre De La Radio Nationale"></div>
  <div class="r-details"><div class="r-band"><a href="orchestredelaradionationale.php">Orchestre De La Radio Nationale</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102661.jpg" alt="Orchestre La Ruche De Leogane"></div>
  <div class="r-details"><div class="r-band"><a href="orchestrelaruchedeleogane.php">Orchestre La Ruche De Leogane</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102737.jpg" alt="Orchestre Les Diables Du Rythme"></div>
  <div class="r-details"><div class="r-band"><a href="orchestrelesdiablesdurythme.php">Orchestre Les Diables Du Rythme</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/hRVEzVpXZ5rdF56WAhjL5YtzonDTagQTONSUEI6NaGc/rs:fit/g:sm/q:90/h:421/w:425/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEzMzgw/MzEzLTE1NTMxMTEw/MDAtOTY4OC5qcGVn.jpeg" alt="Orchestre Magic de Chicago"></div>
  <div class="r-details"><div class="r-band"><a href="orchestremagicdechicago.php">Orchestre Magic de Chicago</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://img.discogs.com/jpp7snfJTBS-Td-GfOsrRArLjZE=/fit-in/600x601/filters:strip_icc():format(jpeg):mode_rgb():quality(90)/discogs-images/R-11143306-1510653127-3412.jpeg.jpg" alt="Orchestre Meridional Des Cayes"></div>
  <div class="r-details"><div class="r-band"><a href="orchestremeridionaldescayes.php">Orchestre Meridional Des Cayes</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRSJSBPbQ2kNNBEpNnqxj2CKf3nfKr2OXsjEA&s" alt="Orchestre Panorama Des Cayes"></div>
  <div class="r-details"><div class="r-band"><a href="orchestrepanoramadescayes.php">Orchestre Panorama Des Cayes</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://viberate-upload.ams3.cdn.digitaloceanspaces.com/prod/entity/artist/orchestre-septentrional-pxxaN" alt="Orchestre Septentrional"></div>
  <div class="r-details"><div class="r-band"><a href="orchestre-septentrional.php">Orchestre Septentrional</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Rs2R0hmnA1kHeSvTxu1jASg0SyWmMS-Mzg4uotC6aSo/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTExMzEy/NzQ0LTE1MTQwNDA0/NDAtNTA0MC5qcGVn.jpeg" alt="Orchestre Simbie Des Gonaïves"></div>
  <div class="r-details"><div class="r-band"><a href="orchestresimbiedesgonaives.php">Orchestre Simbie Des Gonaïves</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/gXAa43obNDpPexT24KNGQPRmjQYEn-Ln_OlIukND8KE/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTk1MTk1/ODctMTQ4MTk5MTI1/Ni0zMTgwLmpwZWc.jpeg" alt="Orchestre Super Choucoune"></div>
  <div class="r-details"><div class="r-band"><a href="orchestresuperchoucoune.php">Orchestre Super Choucoune</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://pbs.twimg.com/profile_images/1285263736060747781/kK6e7TXi_400x400.jpg" alt="Orchestre Tropicana D'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="orchestre-tropicana-d-haiti.php">Orchestre Tropicana D'Haïti</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102936.jpg" alt="Orchestre Virtuose De St. Marc"></div>
  <div class="r-details"><div class="r-band"><a href="orchestrevirtuosedestmarc.php">Orchestre Virtuose De St. Marc</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/12c084b9cff4a70ca4ddfeaa751875b8/1900x1900-000000-80-0-0.jpg" alt="Original H"></div>
  <div class="r-details"><div class="r-band"><a href="originalh.php">Original H</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/nyue7xQ2bWZmYtGLOS1c7kmebSB7cc5e4IFOXmwXH9Q/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTM2NzYx/MTMtMTYxNDcwNjY2/MC0xMDU0LmpwZWc.jpeg" alt="Original Shleu Shleu"></div>
  <div class="r-details"><div class="r-band"><a href="originalshleushleu.php">Original Shleu Shleu</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/91hj4t5h7xL._UF1000,1000_QL80_.jpg" alt="Orline Titus"></div>
  <div class="r-details"><div class="r-band"><a href="orlinetitus.php">Orline Titus</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000681550057-alowj0-t500x500.jpg" alt="Oswald"></div>
  <div class="r-details"><div class="r-band"><a href="oswald.php">Oswald</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/02/15/e0a127c4ef024720b6e95cc39fe19226_320_320.jpg" alt="Ouanga Negesse Band"></div>
  <div class="r-details"><div class="r-band"><a href="ouanganegesseband.php">Ouanga Negesse Band</a></div></div>
</div>


  
  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>