<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>P - Artistes & groupes</title>
   <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES P -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2730b656bfb5986861aef31ce65" alt="Pa Flipe"></div>
  <div class="r-details"><div class="r-band"><a href="pa-flipe.php">Pa Flipe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.opamusic.com/wp-content/uploads/2020/04/Zin_Se-Zin.jpg" alt="Pactrick Apollon & Romeo Volcy"></div>
  <div class="r-details"><div class="r-band"><a href="pactrick-apollon-romeo-volcy.php">Pactrick Apollon & Romeo Volcy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/5b3419209e4b49582f17dc638e6f9089/1900x1900-000000-80-0-0.jpg" alt="Palavilé"></div>
  <div class="r-details"><div class="r-band"><a href="palavile.php">Palavilé</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742429610-pam-cover.jpg" alt="Pam"></div>
  <div class="r-details"><div class="r-band"><a href="pam.php">Pam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742429401-panash-cover.jpg" alt="Panash"></div>
  <div class="r-details"><div class="r-band"><a href="panash.php">Panash</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5f08230543bdf6f164af502da744daea/250x250-000000-80-0-0.jpg" alt="Panel Compas"></div>
  <div class="r-details"><div class="r-band"><a href="panel-compas.php">Panel Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-JDNxqDiZsFHGS9oQ-OMaByg-t240x240.jpg" alt="Panick de Pétion-Ville"></div>
  <div class="r-details"><div class="r-band"><a href="panick-de-petion-ville.php">Panick de Pétion-Ville</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/2bbd47e7e0c58199aa677cf258f435dd/250x250-000000-80-0-0.jpg" alt="Papaloko & Loray Mistik"></div>
  <div class="r-details"><div class="r-band"><a href="papaloko-loray-mistik.php">Papaloko & Loray Mistik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000075407963-rdjtyd-t500x500.jpg" alt="Papash"></div>
  <div class="r-details"><div class="r-band"><a href="papash.php">Papash</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02512f3236c2ec680199895552" alt="Pascal Albert"></div>
  <div class="r-details"><div class="r-band"><a href="pascal-albert.php">Pascal Albert</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5eb7d6c54bf61333a6c59ca642f" alt="Pascale LeBlanc"></div>
  <div class="r-details"><div class="r-band"><a href="pascale-leblanc.php">Pascale LeBlanc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/d48414c56ccb4243a8a00bd8e8978a52/1900x1900-000000-80-0-0.jpg" alt="Passion Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="passion-kompa.php">Passion Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQoBH89SBky74ESlMkqdZXoLbnYdfWGDRI1OQ&s" alt="Patricia Juste"></div>
  <div class="r-details"><div class="r-band"><a href="patricia-juste.php">Patricia Juste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-FQtYR8MPwami8zmS-h6GuVw-t500x500.jpg" alt="Patricia Val"></div>
  <div class="r-details"><div class="r-band"><a href="patricia-val.php">Patricia Val</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742429266-patrick-jean-pierre-cover.jpg" alt="Patrick Jean Pierre (J.P)"></div>
  <div class="r-details"><div class="r-band"><a href="patrick-jean-pierre-j-p.php">Patrick Jean Pierre (J.P)</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000153628597-rzn0xr-t1080x1080.jpg" alt="Patrick Jeannette"></div>
  <div class="r-details"><div class="r-band"><a href="patrick-jeannette.php">Patrick Jeannette</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/5ke885nMOZZRzShTmDJHSCDptkYxIqceWe1CktRdIvM/rs:fit/g:sm/q:90/h:600/w:596/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU1NDIy/NjQtMTM5ODU0MzIx/MC0yODc4LmpwZWc.jpeg" alt="Patrick Parole"></div>
  <div class="r-details"><div class="r-band"><a href="patrick-parole.php">Patrick Parole</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742429092-patrick-toussaint-cover.jpg" alt="Patrick Toussaint"></div>
  <div class="r-details"><div class="r-band"><a href="patrick-toussaint.php">Patrick Toussaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742428920-paul-beaubrun-cover.jpg" alt="Paul Beaubrun"></div>
  <div class="r-details"><div class="r-band"><a href="paul-beaubrun.php">Paul Beaubrun</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273b75a30071e3dcee4d7f4ef13" alt="Pauline Jean"></div>
  <div class="r-details"><div class="r-band"><a href="pauline-jean.php">Pauline Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/419Rh+X01pL._UXNaN_FMjpg_QL85_.jpg" alt="Paulo Mongis"></div>
  <div class="r-details"><div class="r-band"><a href="paulo-mongis.php">Paulo Mongis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/XEiXFyWFLHpLwvJR1KnejG5LGdIkkHhWGOcHQIBKqrU/rs:fit/g:sm/q:90/h:600/w:599/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc0NDc3/NzYtMTYyMjY2ODMy/Ny03OTUyLmpwZWc.jpeg" alt="Paulo & Brimads"></div>
  <div class="r-details"><div class="r-band"><a href="paulo-brimads.php">Paulo & Brimads</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/737e88fa7dc27c654c2ac09f62a9e487/250x250-000000-80-0-0.jpg" alt="Pa'w"></div>
  <div class="r-details"><div class="r-band"><a href="pa-w.php">Pa'w</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/9d236e555f80d985fd98011e52e6bb6d/250x250-000000-80-0-0.jpg" alt="Pawòl Tanbou"></div>
  <div class="r-details"><div class="r-band"><a href="paw-l-tanbou.php">Pawòl Tanbou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/3YRLwZN5/Peterson-Se-dic.png" alt="Peeterson St Dic"></div>
  <div class="r-details"><div class="r-band"><a href="peeterson-st-dic.php">Peeterson St Dic</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/518OcQWOMHL._UXNaN_FMjpg_QL85_.jpg" alt="Pelen"></div>
  <div class="r-details"><div class="r-band"><a href="pelen.php">Pelen</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://f4.bcbits.com/img/a1278512426_10.jpg" alt="Pepe Bayard"></div>
  <div class="r-details"><div class="r-band"><a href="pepe-bayard.php">Pepe Bayard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/4be1f0b43fa1d90cce67704ebd25e740/250x250-000000-80-0-0.jpg" alt="Percutantflow"></div>
  <div class="r-details"><div class="r-band"><a href="percutantflow.php">Percutantflow</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/images_produits/ZoomPE/2/2/6/3433190531622/tsp20130828072805/Petay-Cho.jpg" alt="Petay Cho"></div>
  <div class="r-details"><div class="r-band"><a href="petay-cho.php">Petay Cho</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6ae0ae6672eafc47aed73ec7ed6fe693/250x250-000000-80-0-0.jpg" alt="Peter Michel Joseph"></div>
  <div class="r-details"><div class="r-band"><a href="peter-michel-joseph.php">Peter Michel Joseph</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/3/1741187068-cover.jpg" alt="Peterson Jean Jacques"></div>
  <div class="r-details"><div class="r-band"><a href="peterson-jean-jacques.php">Peterson Jean Jacques</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103956.jpg" alt="P-G kompas"></div>
  <div class="r-details"><div class="r-band"><a href="p-g-kompas.php">P-G kompas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/829f09d6edda477197cb6d65756058f0/250x250-000000-80-0-0.jpg" alt="P-Jay"></div>
  <div class="r-details"><div class="r-band"><a href="p-jay.php">P-Jay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/a6/3e/81/a63e8158-fa70-9dad-9266-6118628795ef/cover.jpg/1200x1200bf-60.jpg" alt="Phantoms"></div>
  <div class="r-details"><div class="r-band"><a href="phantoms.php">Phantoms</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/9c8020f054ef76762d70d6605bf1deb5/250x250-000000-80-0-0.jpg" alt="Phare Celeste Band"></div>
  <div class="r-details"><div class="r-band"><a href="phare-celeste-band.php">Phare Celeste Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100893.jpg" alt="Phase One"></div>
  <div class="r-details"><div class="r-band"><a href="phase-one.php">Phase One</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105113.jpg" alt="Phélicia Dell"></div>
  <div class="r-details"><div class="r-band"><a href="phelicia-dell.php">Phélicia Dell</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51SX6ESQbEL._UXNaN_FMjpg_QL85_.jpg" alt="Pic"></div>
  <div class="r-details"><div class="r-band"><a href="pic.php">Pic</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c08456ce2b17334c323613efb4b1fcea/250x250-000000-80-0-0.jpg" alt="Pidy Brake"></div>
  <div class="r-details"><div class="r-band"><a href="pidy-brake.php">Pidy Brake</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/gdpClWyH0cwIdpdBHiYLczCfxyHhUzivzSLXDBmN8-w/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI0Njky/NTEtMTYwMjMxMzk2/MC03ODIxLmpwZWc.jpeg" alt="Pie 1"></div>
  <div class="r-details"><div class="r-band"><a href="pie-1.php">Pie 1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/610Mv7GXygL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Pierre Antoine Jules"></div>
  <div class="r-details"><div class="r-band"><a href="pierre-antoine-jules.php">Pierre Antoine Jules</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/7fa62fd9aa030f4829d2e27a5d8bdb69/1900x1900-000000-80-0-0.jpg" alt="Pierre Fronton"></div>
  <div class="r-details"><div class="r-band"><a href="pierre-fronton.php">Pierre Fronton</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/517DYVEeP7L._UXNaN_FMjpg_QL85_.jpg" alt="Pierre Jean"></div>
  <div class="r-details"><div class="r-band"><a href="pierre-jean.php">Pierre Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://assets.audiomack.com/pierre-paul-saget-pipo/43241e26396256acdd3c549f9268896924f729285c45a0c0269fa1f67a718fec.png?width=1000&height=1000&max=true" alt="Pierre Paul Saget (Pipo)"></div>
  <div class="r-details"><div class="r-band"><a href="pierre-paul-saget-pipo.php">Pierre Paul Saget (Pipo)</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Pierre-Rigaud Chery"></div>
  <div class="r-details"><div class="r-band"><a href="pierre-rigaud-chery.php">Pierre-Rigaud Chery</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/37bb8bf7138e9dc9ae3b538050fec6ac/250x250-000000-80-0-0.jpg" alt="Pikliz Beatz"></div>
  <div class="r-details"><div class="r-band"><a href="pikliz-beatz.php">Pikliz Beatz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27321bb6a59d135db98ad3ede46" alt="Pimba Brothers"></div>
  <div class="r-details"><div class="r-band"><a href="pimba-brothers.php">Pimba Brothers</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61cKuzDrktL._UXNaN_FMjpg_QL85_.jpg" alt="Pipo"></div>
  <div class="r-details"><div class="r-band"><a href="pipo.php">Pipo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a88eb7f3cadb4e60bc18ba0d53c929d6/250x250-000000-80-0-0.jpg" alt="Piwo Records"></div>
  <div class="r-details"><div class="r-band"><a href="piwo-records.php">Piwo Records</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101983.jpg" alt="Platinum Age"></div>
  <div class="r-details"><div class="r-band"><a href="platinum-age.php">Platinum Age</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSBj3MaGthzYIPMB6QKTCulE_zJLMPP9kjeRA&s" alt="Plen Pip"></div>
  <div class="r-details"><div class="r-band"><a href="plen-pip.php">Plen Pip</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/0429aabb81cb625c5034cabb05983969/250x250-000000-80-0-0.jpg" alt="Plourde Vallon"></div>
  <div class="r-details"><div class="r-band"><a href="plourde-vallon.php">Plourde Vallon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/31pUm3-pFvL._UF1000,1000_QL80_.jpg" alt="Pomoz Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="pomoz-kompa.php">Pomoz Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/VrYAAOSw-6Jk1UUV/s-l1600.png" alt="Pomoz Story"></div>
  <div class="r-details"><div class="r-band"><a href="pomoz-story.php">Pomoz Story</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02cf9f28caf81dbf9794830426" alt="Popeye Ke Kontan"></div>
  <div class="r-details"><div class="r-band"><a href="popeye-ke-kontan.php">Popeye Ke Kontan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0f3b4c33eccf6deb66a9803bdb9f4d54/250x250-000000-80-0-0.jpg" alt="Poppy"></div>
  <div class="r-details"><div class="r-band"><a href="poppy.php">Poppy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/492147f10885b02899b944cdc3e9a9ce/250x250-000000-80-0-0.jpg" alt="Poppy Duverne"></div>
  <div class="r-details"><div class="r-band"><a href="poppy-duverne.php">Poppy Duverne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104906.jpg" alt="Pouvwa"></div>
  <div class="r-details"><div class="r-band"><a href="pouvwa.php">Pouvwa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/tCWmcFayMI8UA6gqFOC-awjYpu2pReqrWsCmEs_yBcs/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEyNTU4/MDctMTUxMjQwNTQx/MS0yODgwLmpwZWc.jpeg" alt="Power 4"></div>
  <div class="r-details"><div class="r-band"><a href="power-4.php">Power 4</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61lHV5tDSPL._UXNaN_FMjpg_QL85_.jpg" alt="Power Fly"></div>
  <div class="r-details"><div class="r-band"><a href="power-fly.php">Power Fly</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51Fnh6Gn7sL._UXNaN_FMjpg_QL85_.jpg" alt="Poze"></div>
  <div class="r-details"><div class="r-band"><a href="poze.php">Poze</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTUW35EBeHwA6TsTxGuof2jQCZznw-Wt3M6Pw&s" alt="Prestans Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="prestans-kompa.php">Prestans Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51D79f8dPJL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Pri-Vice"></div>
  <div class="r-details"><div class="r-band"><a href="pri-vice.php">Pri-Vice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/31hu6YPGLWL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Prince Compas"></div>
  <div class="r-details"><div class="r-band"><a href="prince-compas.php">Prince Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51XTaQ3EHCL._UXNaN_FMjpg_QL85_.jpg" alt="Prince Ello"></div>
  <div class="r-details"><div class="r-band"><a href="prince-ello.php">Prince Ello</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music128/v4/3e/30/a8/3e30a860-e963-75e4-4cff-201cfe5b0e2f/cover.jpg/600x600bf-60.jpg" alt="Prince Love"></div>
  <div class="r-details"><div class="r-band"><a href="prince-love.php">Prince Love</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742430046-prince-rocky-cover.jpg" alt="Prince Rocky"></div>
  <div class="r-details"><div class="r-band"><a href="prince-rocky.php">Prince Rocky</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104274.jpg" alt="Prince Yno"></div>
  <div class="r-details"><div class="r-band"><a href="prince-yno.php">Prince Yno</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b5d4523b9afc45f8df9a0eabede4896c/250x250-000000-80-0-0.jpg" alt="Princely Player"></div>
  <div class="r-details"><div class="r-band"><a href="princely-player.php">Princely Player</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/aae3fa4f49516de7172ea18ace27ee63/1900x1900-000000-80-0-0.jpg" alt="Princess Eud"></div>
  <div class="r-details"><div class="r-band"><a href="princess-eud.php">Princess Eud</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.iheart.com/v3/url/aHR0cCUzQSUyRiUyRmltYWdlLmloZWFydC5jb20lMkZjb250ZW50JTJGbXVzaWMlMkZwcm9kJTJGQ0RCQUJZMjclMkZUaHVtYl9Db250ZW50JTJGRnVsbF9QQyUyRkNEQkFCWSUyRk5vdjE0JTJGMTEyNTE0JTJGODg5MjExMjAzNDk5JTJGODg5MjExMjAzNDk5LmpwZw==?ops=fit(480%2C480)" alt="Princess Georgy"></div>
  <div class="r-details"><div class="r-band"><a href="princess-georgy.php">Princess Georgy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/7aEZYOOtNqWc2m-xYeI_DXCcUtVvF8d_zIDJrge9Unw/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTY4NjY2/OTAtMTUxNjg1MDA5/My03NzY2LmpwZWc.jpeg" alt="Priva Riga"></div>
  <div class="r-details"><div class="r-band"><a href="priva-riga.php">Priva Riga</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51Y1sz5hNgL._UXNaN_FMjpg_QL85_.jpg" alt="Pro-Domo-Sua"></div>
  <div class="r-details"><div class="r-band"><a href="pro-domo-sua.php">Pro-Domo-Sua</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51zlCiqVOgL._UXNaN_FMjpg_QL85_.jpg" alt="Prospère Marcellus"></div>
  <div class="r-details"><div class="r-band"><a href="prospere-marcellus.php">Prospère Marcellus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000171482040-phs50g-t500x500.jpg" alt="P.S.B"></div>
  <div class="r-details"><div class="r-band"><a href="p-s-b.php">P.S.B</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/23AlZ-JHqPkhB_xyYmKp64oV5RESx4zwiHl4WIMXsJU/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTM3NjAx/OTctMTM0MzI4NDgx/Ni0xNjA1LmpwZWc.jpeg" alt="Puissance 8"></div>
  <div class="r-details"><div class="r-band"><a href="puissance-8.php">Puissance 8</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/m-Y6vfflFfj_oXswaV_i4P0G_BP6sebJnHE4fJLO5xA/rs:fit/g:sm/q:90/h:350/w:350/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI5MDg1/MTMtMTMwNjc1Nzg4/NS5qcGVn.jpeg" alt="Pulsation"></div>
  <div class="r-details"><div class="r-band"><a href="pulsation.php">Pulsation</a></div></div>
</div>

  
  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>