<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>R - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>

  <!-- Liste verticale des albums -->
<div class="album-list">
  <!-- TOUS LES ARTISTES R -->

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b01a64f2e68aaa538f9c3e88fdc8d189/250x250-000000-80-0-0.jpg" alt="Racin Bwa-Kay-Iman"></div>
  <div class="r-details"><div class="r-band"><a href="racin-bwa-kay-iman.php">Racin Bwa-Kay-Iman</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101646.jpg" alt="Rafrechi"></div>
  <div class="r-details"><div class="r-band"><a href="rafrechi.php">Rafrechi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104077.jpg" alt="Ralph Chevry"></div>
  <div class="r-details"><div class="r-band"><a href="ralph-chevry.php">Ralph Chevry</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e1f475c6b3e3d742a73243cffafdd1e0/250x250-000000-80-0-0.jpg" alt="Ralph Conde"></div>
  <div class="r-details"><div class="r-band"><a href="ralph-conde.php">Ralph Conde</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106178.jpg" alt="Ralph Millet"></div>
  <div class="r-details"><div class="r-band"><a href="ralph-millet.php">Ralph Millet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music125/v4/d4/a0/63/d4a063c4-e4f4-0f7a-7a69-e451e7d7cd79/198000133030.jpg/486x486bb.png" alt="Ralph Papillon"></div>
  <div class="r-details"><div class="r-band"><a href="ralph-papillon.php">Ralph Papillon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100907.jpg" alt="Raoul Denis Jr"></div>
  <div class="r-details"><div class="r-band"><a href="raoul-denis-jr.php">Raoul Denis Jr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100909.jpg" alt="Raoul Guillaume Et Son Groupe"></div>
  <div class="r-details"><div class="r-band"><a href="raoul-guillaume-et-son-groupe.php">Raoul Guillaume Et Son Groupe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103972.jpg" alt="Rapadoo"></div>
  <div class="r-details"><div class="r-band"><a href="rapadoo.php">Rapadoo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101919.jpg" alt="Ravaj"></div>
  <div class="r-details"><div class="r-band"><a href="ravaj.php">Ravaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.fnac-static.com/multimedia/images_produits/ZoomPE/8/2/3/3433190572328/tsp20130831170656/Ravaj.jpg" alt="Ravaj Weldy"></div>
  <div class="r-details"><div class="r-band"><a href="ravaj-weldy.php">Ravaj Weldy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27343e77f4b2b314e8ad8d550f4" alt="Raymond Cajuste"></div>
  <div class="r-details"><div class="r-band"><a href="raymond-cajuste.php">Raymond Cajuste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Wfzp4H2iyifhCvxrmW1J1rz7fnJXV_Ms-mIuMig1IYg/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEzNTI1/NzA2LTE1NzA5Njgx/NDgtNzk5NS5qcGVn.jpeg" alt="Raymond Cicault et ses Étoiles"></div>
  <div class="r-details"><div class="r-band"><a href="raymond-cicault-et-ses-etoiles.php">Raymond Cicault et ses Étoiles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://yt3.googleusercontent.com/ytc/AIdro_nc9ko08nvbxDck-vHnKQi4YrVCFwNEJYOssYv5npoIsJ4=s900-c-k-c0x00ffffff-no-rj" alt="Rayy Raymond"></div>
  <div class="r-details"><div class="r-band"><a href="rayy-raymond.php">Rayy Raymond</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1991ef967bc4d0229c760d37d2cefaec/250x250-000000-80-0-0.jpg" alt="Rbens Melodiek"></div>
  <div class="r-details"><div class="r-band"><a href="rbens-melodiek.php">Rbens Melodiek</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5a7f17bb71ad67bf027c51b8f98d6543/1900x1900-000000-80-0-0.jpg" alt="RD Muzik"></div>
  <div class="r-details"><div class="r-band"><a href="rd-muzik.php">RD Muzik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQAZ5KKMGtDfvPEn0OgMOClwZL8ZD8GHbf4UQ&s" alt="Rebecca Jean"></div>
  <div class="r-details"><div class="r-band"><a href="rebecca-jean.php">Rebecca Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106245.jpg" alt="Rèd-La"></div>
  <div class="r-details"><div class="r-band"><a href="red-la.php">Rèd-La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102024.jpg" alt="Reflex"></div>
  <div class="r-details"><div class="r-band"><a href="reflex.php">Reflex</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/9c047a756cda658e5182cf05839104b9/250x250-000000-80-0-0.jpg" alt="Réginald Lubin"></div>
  <div class="r-details"><div class="r-band"><a href="reginald-lubin.php">Réginald Lubin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e5d94c948e549b700c059dbdf4292513/250x250-000000-80-0-0.jpg" alt="Réginald Pluviose"></div>
  <div class="r-details"><div class="r-band"><a href="reginald-pluviose.php">Réginald Pluviose</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d75655f520f54a6b048f54ea3748d186/250x250-000000-80-0-0.jpg" alt="Réginald Policard"></div>
  <div class="r-details"><div class="r-band"><a href="reginald-policard.php">Réginald Policard</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100921.jpg" alt="Relaxx Band"></div>
  <div class="r-details"><div class="r-band"><a href="relaxx-band.php">Relaxx Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105155.jpg" alt="Renès BBWI Lophanor"></div>
  <div class="r-details"><div class="r-band"><a href="renes-bbwi-lophanor.php">Renès BBWI Lophanor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105733.jpg" alt="Renette Desir"></div>
  <div class="r-details"><div class="r-band"><a href="renette-desir.php">Renette Desir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104955.jpg" alt="Reynold-Duverglas"></div>
  <div class="r-details"><div class="r-band"><a href="reynold-duverglas.php">Reynold-Duverglas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105447.jpg" alt="Rich Band Freshup"></div>
  <div class="r-details"><div class="r-band"><a href="rich-band-freshup.php">Rich Band Freshup</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/86a4f8b88fbbbde7959589fe607cff54/250x250-000000-80-0-0.jpg" alt="Rich Fetti"></div>
  <div class="r-details"><div class="r-band"><a href="rich-fetti.php">Rich Fetti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102339.jpg" alt="Richard Augustin"></div>
  <div class="r-details"><div class="r-band"><a href="richard-augustin.php">Richard Augustin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100929.jpg" alt="Richard Duroseau"></div>
  <div class="r-details"><div class="r-band"><a href="richard-duroseau.php">Richard Duroseau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/694be8117b78c0f04c524e5d8a9b77e0/250x250-000000-80-0-0.jpg" alt="Richard Prevalu"></div>
  <div class="r-details"><div class="r-band"><a href="richard-prevalu.php">Richard Prevalu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e4c9489c95b5f7b4e3032fa8ddebea0d/250x250-000000-80-0-0.jpg" alt="Richie & Zenglen"></div>
  <div class="r-details"><div class="r-band"><a href="richie-zenglen.php">Richie & Zenglen</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106231.jpg" alt="Richy Jay"></div>
  <div class="r-details"><div class="r-band"><a href="richy-jay.php">Richy Jay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101660.jpg" alt="Ricky Juste"></div>
  <div class="r-details"><div class="r-band"><a href="ricky-juste.php">Ricky Juste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/04b5c1d166e0c30e5bac8605a8af3bd0/250x250-000000-80-0-0.jpg" alt="Ricky Rick Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="ricky-rick-kompa.php">Ricky Rick Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0a6e80d52840eed5d83f9322f9613eba/250x250-000000-80-0-0.jpg" alt="Rictrude Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="rictrude-pierre.php">Rictrude Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music124/v4/4d/96/07/4d96074a-9cfc-b459-a4b8-454f37d5869c/artwork.jpg/1200x1200bf-60.jpg" alt="Rigaud Dessources"></div>
  <div class="r-details"><div class="r-band"><a href="rigaud-dessources.php">Rigaud Dessources</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104319.jpg" alt="Ragiloge"></div>
  <div class="r-details"><div class="r-band"><a href="ragiloge.php">Ragiloge</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100930.jpg" alt="Riske"></div>
  <div class="r-details"><div class="r-band"><a href="riske.php">Riske</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://yt3.googleusercontent.com/ytc/AIdro_kpft7dcYM_6M-u2Z4F3OhfVDU7Mh2pzr9jRyar-eyE2XA=s900-c-k-c0x00ffffff-no-rj" alt="Riva Nyri Precil"></div>
  <div class="r-details"><div class="r-band"><a href="riva-nyri-precil.php">Riva Nyri Precil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://pbs.twimg.com/media/Dj4l24SU8AEpcDi.jpg" alt="RJ Piverger"></div>
  <div class="r-details"><div class="r-band"><a href="rj-piverger.php">RJ Piverger</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7229fc508bf35a8cb4d99b823e2d7f04/250x250-000000-80-0-0.jpg" alt="Rob Vital"></div>
  <div class="r-details"><div class="r-band"><a href="rob-vital.php">Rob Vital</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music3/v4/b8/f5/27/b8f527c1-3d55-b338-24de-e5379c0c5538/606417908627_cover.jpg/486x486bb.png" alt="Robert Charlot"></div>
  <div class="r-details"><div class="r-band"><a href="robert-charlot.php">Robert Charlot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Robert Magic"></div>
  <div class="r-details"><div class="r-band"><a href="robert-magic.php">Robert Magic</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/ae037cd93b22839c933ce1ebeba55a69/1900x1900-000000-80-0-0.jpg" alt="Robert Martino"></div>
  <div class="r-details"><div class="r-band"><a href="robert-martino.php">Robert Martino</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://iscale.iheart.com/catalog/album/253208044" alt="Robinson Auguste"></div>
  <div class="r-details"><div class="r-band"><a href="robinson-auguste.php">Robinson Auguste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e0242b6a83ee0af426bac251525" alt="Rockfam"></div>
  <div class="r-details"><div class="r-band"><a href="rockfam.php">Rockfam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/db8c6feaf6f862fdb67de00ea37d4186/250x250-000000-80-0-0.jpg" alt="Rodlin Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="rodlin-pierre.php">Rodlin Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105573.jpg" alt="Rodne Eliassaint"></div>
  <div class="r-details"><div class="r-band"><a href="rodne-eliassaint.php">Rodne Eliassaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41akMMBtYpL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Rodrigue Fleurisca"></div>
  <div class="r-details"><div class="r-band"><a href="rodrigue-fleurisca.php">Rodrigue Fleurisca</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106251.jpg" alt="Rodrigue Georges"></div>
  <div class="r-details"><div class="r-band"><a href="rodrigue-georges.php">Rodrigue Georges</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102300.jpg" alt="Rodrigue Millien"></div>
  <div class="r-details"><div class="r-band"><a href="rodrigue-millien.php">Rodrigue Millien</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103297.jpg" alt="Rodrigue Millien & Combite Créole"></div>
  <div class="r-details"><div class="r-band"><a href="rodrigue-millien-combite-creole.php">Rodrigue Millien & Combite Créole</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100071.jpg" alt="Rodrigue Toussaint"></div>
  <div class="r-details"><div class="r-band"><a href="rodrigue-toussaint.php">Rodrigue Toussaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100945.jpg" alt="Roger Colas"></div>
  <div class="r-details"><div class="r-band"><a href="roger-colas.php">Roger Colas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTxE3biCBuAzV3stjQZZwYd72ceLLL-V3DZjw&s" alt="Roger Jean-Baptiste"></div>
  <div class="r-details"><div class="r-band"><a href="roger-jean-baptiste.php">Roger Jean-Baptiste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/60/13/f4/mzi.jsjlcqpl.jpg/486x486bb.png" alt="Roland Cameau"></div>
  <div class="r-details"><div class="r-band"><a href="roland-cameau.php">Roland Cameau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106154.jpg" alt="Ronald Bs"></div>
  <div class="r-details"><div class="r-band"><a href="ronald-bs.php">Ronald Bs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/7/1742162970-romeomania-cover.jpg" alt="Ronald Bs"></div>
  <div class="r-details"><div class="r-band"><a href="ronald-bs.php">Ronald Bs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103655.jpg" alt="Ronald Lebeau"></div>
  <div class="r-details"><div class="r-band"><a href="ronald-lebeau.php">Ronald Lebeau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100948.jpg" alt="Ronald Rodrigue"></div>
  <div class="r-details"><div class="r-band"><a href="ronald-rodrigue.php">Ronald Rodrigue</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103469.jpg" alt="Ronald Smith"></div>
  <div class="r-details"><div class="r-band"><a href="ronald-smith.php">Ronald Smith</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3d80fb7a6a8a147f2f80c9a273313a66/250x250-000000-80-0-0.jpg" alt="RonsonDjam"></div>
  <div class="r-details"><div class="r-band"><a href="ronsondjam.php">RonsonDjam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6d55a24ab14beb7a469f96e070657b30/250x250-000000-80-0-0.jpg" alt="Roobens D'or"></div>
  <div class="r-details"><div class="r-band"><a href="roobens-d-or.php">Roobens D'or</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106440.jpg" alt="Roody Delpe"></div>
  <div class="r-details"><div class="r-band"><a href="roody-delpe.php">Roody Delpe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105482.jpg" alt="Rosalie Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="rosalie-haiti.php">Rosalie Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/a2f7f699317eec2675a7fd02e439e93e/250x250-000000-80-0-0.jpg" alt="Rosena Josselin Orys"></div>
  <div class="r-details"><div class="r-band"><a href="rosena-josselin-orys.php">Rosena Josselin Orys</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104573.jpg" alt="Roselin Antoine"></div>
  <div class="r-details"><div class="r-band"><a href="roselin-antoine.php">Roselin Antoine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742428328-rossignols-noirs-cover.jpg" alt="Rossignols Noirs"></div>
  <div class="r-details"><div class="r-band"><a href="rossignols-noirs.php">Rossignols Noirs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/4/1742427780-rosy-cadet-cover.jpg" alt="Rosy Cadet"></div>
  <div class="r-details"><div class="r-band"><a href="rosy-cadet.php">Rosy Cadet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/r2L3XwpC/rpl.png" alt="R.P.L."></div>
  <div class="r-details"><div class="r-band"><a href="r-p-l.php">R.P.L.</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61QU9Zq0pNL._UXNaN_FMjpg_QL85_.jpg" alt="Ruddy Pris'k"></div>
  <div class="r-details"><div class="r-band"><a href="ruddy-pris-k.php">Ruddy Pris'k</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music114/v4/83/eb/54/83eb54b2-db67-c56f-2685-0d479fb9d66b/859744361980_cover.jpg/486x486bb.png" alt="Rüdy Ambroise"></div>
  <div class="r-details"><div class="r-band"><a href="rudy-ambroise.php">Rüdy Ambroise</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music114/v4/88/41/33/8841337b-a780-402f-2082-928b4803d06f/888295995771.jpg/1200x1200bf-60.jpg" alt="Ruthza Jean-Baptiste"></div>
  <div class="r-details"><div class="r-band"><a href="ruthza-jean-baptiste.php">Ruthza Jean-Baptiste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/YFvsMTYq/RUTH.png" alt="Rutshelle Guillaume"></div>
  <div class="r-details"><div class="r-band"><a href="rutshelle-guillaume.php">Rutshelle Guillaume</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/Z6pjSwfZ/RYLAXXXX.png" alt="Rylax"></div>
  <div class="r-details"><div class="r-band"><a href="rylax.php">Rylax</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music114/v4/d8/b4/4d/d8b44d5b-2205-1cf8-cae2-e1cc9a5c6f4a/792278024511.png/1200x1200bb.jpg" alt="Rythmo Band D'Alfred Moise"></div>
  <div class="r-details"><div class="r-band"><a href="rythmo-band-d-alfred-moise.php">Rythmo Band D'Alfred Moise</a></div></div>
</div>

</body>
</html>



