<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>S - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
  <!-- Liste verticale des albums -->
  <div class="album-list">
  <!-- TOUS LES ARTISTES S -->

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/nvDIy_MfFHg8nEe5OcNnR03LY8HxG4PuWUSQL1L9-cc/rs:fit/g:sm/q:90/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTQyMzU4/MTUtMTU4NDI2OTIw/MS04NTIxLmpwZWc.jpeg" alt="S.S. One Music Band"></div>
  <div class="r-details"><div class="r-band"><a href="s-s-one-music-band.php">S.S. One Music Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51hcCF8Pn8L._UXNaN_FMjpg_QL85_.jpg" alt="Sabine Francoeur"></div>
  <div class="r-details"><div class="r-band"><a href="sabine-francoeur.php">Sabine Francoeur</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS8OS3Z_Bitd7KqEmt3N8X8D2iUUDVxHTghYg&s" alt="Safari Combo d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="safari-combo-d-haiti.php">Safari Combo d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/13/7/1743339502-sah-jadah.png" alt="Sah-Jadah"></div>
  <div class="r-details"><div class="r-band"><a href="sah-jadah.php">Sah-Jadah</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51+ngNTM+pL._UXNaN_FMjpg_QL85_.jpg" alt="Saima"></div>
  <div class="r-details"><div class="r-band"><a href="saima.php">Saima</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2733b07fb1ebc1c8c2ebf4a487d" alt="Sainteus Oge"></div>
  <div class="r-details"><div class="r-band"><a href="sainteus-oge.php">Sainteus Oge</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2730ef6c7e6ada414f7d14d6438" alt="Saj Drums"></div>
  <div class="r-details"><div class="r-band"><a href="saj-drums.php">Saj Drums</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/q3i8bXX79c1FJ3aP0_6VIQ0S088HmBOj3td2ZhnLDtE/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTUyMjIw/NjctMTU0Njc3MDg0/OC01OTMxLmpwZWc.jpeg" alt="Sakad"></div>
  <div class="r-details"><div class="r-band"><a href="sakad.php">Sakad</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000074515583-zcwiw6-t500x500.jpg" alt="Sakaj"></div>
  <div class="r-details"><div class="r-band"><a href="sakaj.php">Sakaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/78b0bf0b5fe92cfafa728a14b5d5ed74/250x250-000000-80-0-0.jpg" alt="Salina Charles"></div>
  <div class="r-details"><div class="r-band"><a href="salina-charles.php">Salina Charles</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/7f2321a54f2310918ea6cac772e78b8d/250x250-000000-80-0-0.jpg" alt="Salomon Lira"></div>
  <div class="r-details"><div class="r-band"><a href="salomon-lira.php">Salomon Lira</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/AUZAbSj-BUwatXKLpvO19tsD0X4LtE4iCObyY34KppQ/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTg2NjYx/MTAtMTQ2NjIwMjkw/MS03OTg3LmpwZWc.jpeg" alt="Samba Créole"></div>
  <div class="r-details"><div class="r-band"><a href="samba-creole.php">Samba Créole</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/44617f1ea4d5f156cc5fd97bfa14b7c2/250x250-000000-80-0-0.jpg" alt="Samuel Marcelus"></div>
  <div class="r-details"><div class="r-band"><a href="samuel-marcelus.php">Samuel Marcelus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://s.songswave.com/album-images/vol32/1255/1255276/3123951-292-292.jpg" alt="Samuel Placide"></div>
  <div class="r-details"><div class="r-band"><a href="samuel-placide.php">Samuel Placide</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQZazS-OmrGVHRMERgMe3PaA2zWihny6J2Stg&s" alt="Sanba Lele"></div>
  <div class="r-details"><div class="r-band"><a href="sanba-lele.php">Sanba Lele</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61QejArMV3L._UXNaN_FMjpg_QL85_.jpg" alt="Sångensemblen Amanda"></div>
  <div class="r-details"><div class="r-band"><a href="s-ngensemblen-amanda.php">Sångensemblen Amanda</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/71x1rwup4OL._UF1000,1000_QL80_.jpg" alt="Sara Rénélik"></div>
  <div class="r-details"><div class="r-band"><a href="sara-renelik.php">Sara Rénélik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000050719264-j2hjvk-t240x240.jpg" alt="Sarah Jane Rameau"></div>
  <div class="r-details"><div class="r-band"><a href="sarah-jane-rameau.php">Sarah Jane Rameau</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/35e7ae3d667f3baabad638f351fab458/250x250-000000-80-0-0.jpg" alt="Savalou Twoubadou"></div>
  <div class="r-details"><div class="r-band"><a href="savalou-twoubadou.php">Savalou Twoubadou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51+6tQo-SSL._UXNaN_FMjpg_QL85_.jpg" alt="Saxo Latino"></div>
  <div class="r-details"><div class="r-band"><a href="saxo-latino.php">Saxo Latino</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e0213fb12674e6748b58e461096" alt="Saxolove"></div>
  <div class="r-details"><div class="r-band"><a href="saxolove.php">Saxolove</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/54a970c877e03b60e193c78e339ae2c8/250x250-000000-80-0-0.jpg" alt="Saxophone Healing Music"></div>
  <div class="r-details"><div class="r-band"><a href="saxophone-healing-music.php">Saxophone Healing Music</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103093.jpg" alt="Scandal Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="scandal-mizik.php">Scandal Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/40d7defc218748ae891bbc51b7a7c849/250x250-000000-80-0-0.jpg" alt="Scandy"></div>
  <div class="r-details"><div class="r-band"><a href="scandy.php">Scandy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/06b855b286c084a10a3603e59a66175a/250x250-000000-80-0-0.jpg" alt="Schmidt Pitit Bondye"></div>
  <div class="r-details"><div class="r-band"><a href="schmidt-pitit-bondye.php">Schmidt Pitit Bondye</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/885ac5dc54200cc8f146363443fc2335/250x250-000000-80-0-0.jpg" alt="Schnaider Derisier"></div>
  <div class="r-details"><div class="r-band"><a href="schnaider-derisier.php">Schnaider Derisier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/819XUUColZL._UF1000,1000_QL80_.jpg" alt="Scorpio Universel"></div>
  <div class="r-details"><div class="r-band"><a href="scorpio-universel.php">Scorpio Universel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6cfc6367eece5d7564641ced3bd80f32/250x250-000000-80-0-0.jpg" alt="Scraggy haiti"></div>
  <div class="r-details"><div class="r-band"><a href="scraggy-haiti.php">Scraggy haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.afromix.org/html/musique/artistes/seewell/zepon_.jpg" alt="Seewell"></div>
  <div class="r-details"><div class="r-band"><a href="seewell.php">Seewell</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music126/v4/6f/ed/d9/6fedd9d7-f80a-ead6-c53a-153e2e81bd34/859771967865_cover.jpg/486x486bb.png" alt="SEHYO San Antonio"></div>
  <div class="r-details"><div class="r-band"><a href="sehyo-san-antonio.php">SEHYO San Antonio</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100981.jpg" alt="Select De New York"></div>
  <div class="r-details"><div class="r-band"><a href="select-de-new-york.php">Select De New York</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2736af078ed1edbe91564dc39db" alt="Selecta Martinique"></div>
  <div class="r-details"><div class="r-band"><a href="selecta-martinique.php">Selecta Martinique</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/csi0uHwyDb_fBh6lqps7cAVmwCXwwPEtKE_F1ry3Yb4/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE2MjIy/MjEtMTIzMjc2NjY2/Ni5qcGVn.jpeg" alt="Selecta Internacional"></div>
  <div class="r-details"><div class="r-band"><a href="selecta-internacional.php">Selecta Internacional</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2739e73f89d289a070103cc13ff" alt="Senkop"></div>
  <div class="r-details"><div class="r-band"><a href="senkop.php">Senkop</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61MtWNWouYL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Serge G Duviella"></div>
  <div class="r-details"><div class="r-band"><a href="serge-g-duviella.php">Serge G Duviella</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/vrxNE9HPa2AhLGhDQu9rPh68bOa2EevWf2Th2Zc8Of0/rs:fit/g:sm/q:90/h:600/w:598/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTUwMjg1/MzUtMTY2NjE0OTI5/NS03NjU2LmpwZWc.jpeg" alt="Serge Rémion"></div>
  <div class="r-details"><div class="r-band"><a href="serge-remion.php">Serge Rémion</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/df/7f/6c/mzi.vtmzahvd.jpg/486x486bb.png" alt="Sergo Decius"></div>
  <div class="r-details"><div class="r-band"><a href="sergo-decius.php">Sergo Decius</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/7c/df/3b/mzi.nrwqtfsa.jpg/600x600bf-60.jpg" alt="Sesa"></div>
  <div class="r-details"><div class="r-band"><a href="sesa.php">Sesa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41Yl+fTn6eL._UXNaN_FMjpg_QL85_.jpg" alt="Sexy Frantzy"></div>
  <div class="r-details"><div class="r-band"><a href="sexy-frantzy.php">Sexy Frantzy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000055832092-y839ps-t500x500.jpg" alt="Sexy One"></div>
  <div class="r-details"><div class="r-band"><a href="sexy-one.php">Sexy One</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/cd649e97068bc66d820afddd54b9d533/1900x1900-000000-80-0-0.jpg" alt="Shabba"></div>
  <div class="r-details"><div class="r-band"><a href="shabba.php">Shabba</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/oBRFj__nq5Ipl2ALvAFw1xB7w2eHFdegmzzaqnW4L5U/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTExMTc2/NzcxLTE1MTEyODI4/ODUtODM1Mi5qcGVn.jpeg" alt="Shadow"></div>
  <div class="r-details"><div class="r-band"><a href="shadow.php">Shadow</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103296.jpg" alt="Shadox"></div>
  <div class="r-details"><div class="r-band"><a href="shadox.php">Shadox</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/9c9b6fe945a898280fd45328ec619aa4/250x250-000000-80-0-0.jpg" alt="Shaka Dream's"></div>
  <div class="r-details"><div class="r-band"><a href="shaka-dream-s.php">Shaka Dream's</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/LuPXQ2hRcgnEMogR7jSSiLUhJkPyZwxqljL_ug8ITUE/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTUwOTQ3/NDYtMTY3MjUyNjIz/OS0yOTk5LmpwZWc.jpeg" alt="Sham-Sham Band"></div>
  <div class="r-details"><div class="r-band"><a href="sham-sham-band.php">Sham-Sham Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/6494e8c5ed89556d94a6de7492e855f5/1900x1900-000000-80-0-0.jpg" alt="Shamba De Boston"></div>
  <div class="r-details"><div class="r-band"><a href="shamba-de-boston.php">Shamba De Boston</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27381fd30564fcea9ff939f235a" alt="Shandel"></div>
  <div class="r-details"><div class="r-band"><a href="shandel.php">Shandel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://assets.bigcartel.com/product_images/326059413/Shap_1.jpg?auto=format&fit=max&w=780" alt="Shap"></div>
  <div class="r-details"><div class="r-band"><a href="shap.php">Shap</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRfoIsBovbs3S5vrVwmHWfMwR40SQ4NO7UkZw&s" alt="Shassy"></div>
  <div class="r-details"><div class="r-band"><a href="shassy.php">Shassy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.opamusic.com/wp-content/uploads/2019/01/Shedly-Abraham_profile.jpg" alt="Shedly Abraham"></div>
  <div class="r-details"><div class="r-band"><a href="shedly-abraham.php">Shedly Abraham</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQ8YD80WFW39XenAGjmc23MNYTJsobZ0oUwfw&s" alt="Sheila DeGraff"></div>
  <div class="r-details"><div class="r-band"><a href="sheila-degraff.php">Sheila DeGraff</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2736f8f5693c243e4a4badbe4c5" alt="Sherlee Skai"></div>
  <div class="r-details"><div class="r-band"><a href="sherlee-skai.php">Sherlee Skai</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/fce7733f9a397960c661396f0b0f05cd/250x250-000000-80-0-0.jpg" alt="Shindler Auguste"></div>
  <div class="r-details"><div class="r-band"><a href="shindler-auguste.php">Shindler Auguste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ZKKoc0E1piaFUPmGT-hGPzdd8y3VtGKH8wPbzKGkjDw/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEyODE2/NTg3LTE1NDI1MTA1/NDAtMTYzMS5qcGVn.jpeg" alt="Shirley Desgrottes"></div>
  <div class="r-details"><div class="r-band"><a href="shirley-desgrottes.php">Shirley Desgrottes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ytimg.com/vi/c2c4Bn9FAMg/sddefault.jpg" alt="Shoo-Blak"></div>
  <div class="r-details"><div class="r-band"><a href="shoo-blak.php">Shoo-Blak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/l2oSeUklS7J3cF7jxcXy16ADiVi-CXXDRDGPkGnPUMI/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTM0NTAz/OTAtMTMzMDg2MjUy/OS5qcGVn.jpeg" alt="Shoogar Combo"></div>
  <div class="r-details"><div class="r-band"><a href="shoogar-combo.php">Shoogar Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://static.wixstatic.com/media/6a7dde_44bcb42c359d4a4560b5a8a4526e97b0.jpg/v1/fill/w_480,h_540,al_c,lg_1,q_80,enc_auto/6a7dde_44bcb42c359d4a4560b5a8a4526e97b0.jpg" alt="Shoubou"></div>
  <div class="r-details"><div class="r-band"><a href="shoubou.php">Shoubou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103981.jpg" alt="Show Off"></div>
  <div class="r-details"><div class="r-band"><a href="show-off.php">Show Off</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/G_jaw3sB38TqksA43j2UtbNzy6rIZdzv1C8tUMYQHZE/rs:fit/g:sm/q:90/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc2NzQ4/MzEtMTQ0NjQ2OTA4/OS0xNzU1LmpwZWc.jpeg" alt="Shupa Shupa"></div>
  <div class="r-details"><div class="r-band"><a href="shupa-shupa.php">Shupa Shupa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ytimg.com/vi/zoV9APMrJnk/maxresdefault.jpg" alt="Sidon Joseph"></div>
  <div class="r-details"><div class="r-band"><a href="sidon-joseph.php">Sidon Joseph</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/6/1742030989-simbi-cover.jpg" alt="Simbi"></div>
  <div class="r-details"><div class="r-band"><a href="simbi.php">Simbi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRHSEJYXmpIWhqV1efiMlY_ME8Apvzq0JT-kg&s" alt="Simon Ibo"></div>
  <div class="r-details"><div class="r-band"><a href="simon-ibo.php">Simon Ibo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://f4.bcbits.com/img/a1010591749_65" alt="Simon Jurad"></div>
  <div class="r-details"><div class="r-band"><a href="simon-jurad.php">Simon Jurad</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000061174079-8e217l-t1080x1080.jpg" alt="Sinik Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="sinik-mizik.php">Sinik Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105570.jpg" alt="Siwo"></div>
  <div class="r-details"><div class="r-band"><a href="siwo.php">Siwo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ivQdsX8Hw8h06YJqbdxwBqogGwN5_SmDbmaBjbL-Njk/rs:fill/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTg2ODgw/MTAtMTQ2NjYzMTM4/Ny04ODQ1LmpwZWc.jpeg" alt="Siwo d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="siwo-d-haiti.php">Siwo d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music123/v4/4d/a2/92/4da292c6-b98d-4f66-969f-1131799f376c/artwork.jpg/600x600bf-60.jpg" alt="Sixty9"></div>
  <div class="r-details"><div class="r-band"><a href="sixty9.php">Sixty9</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/E1ZsJyuOwjd0d8jv__PtRwpXt62VQqlnUsgwfo7sKzs/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTcyMjYx/NjktMTYzNDMxMjQ1/NC02MTMyLmpwZWc.jpeg" alt="Skah Shah #1"></div>
  <div class="r-details"><div class="r-band"><a href="skah-shah-1.php">Skah Shah #1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music62/v4/5a/f9/c5/5af9c552-0d6b-ccfd-2d88-64a7f48c2385/cover.jpg/800x800cc.jpg" alt="SKH d'Anti-Missile"></div>
  <div class="r-details"><div class="r-band"><a href="skh-d-anti-missile.php">SKH d'Anti-Missile</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/5142S9Z2FRL._UXNaN_FMjpg_QL85_.jpg" alt="Skj Sakaj"></div>
  <div class="r-details"><div class="r-band"><a href="skj-sakaj.php">Skj Sakaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51OQa8xnvHL._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Sky #1"></div>
  <div class="r-details"><div class="r-band"><a href="sky-1.php">Sky #1</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2734aa7598033756ed06a75e1a8" alt="Sky La"></div>
  <div class="r-details"><div class="r-band"><a href="sky-la.php">Sky La</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://source.boomplaymusic.com/group10/M00/04/01/706c1eebfbc14ae4875849494fbe1315_464_464.jpg" alt="Snaille"></div>
  <div class="r-details"><div class="r-band"><a href="snaille.php">Snaille</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/634e882db752be312616208e021c80f2/250x250-000000-80-0-0.jpg" alt="Socrate Ankorr"></div>
  <div class="r-details"><div class="r-band"><a href="socrate-ankorr.php">Socrate Ankorr</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/2ee24f2d4bb14f045ab6ab2f7d9ce08e/250x250-000000-80-0-0.jpg" alt="Soldats Des Ambassadeurs"></div>
  <div class="r-details"><div class="r-band"><a href="soldats-des-ambassadeurs.php">Soldats Des Ambassadeurs</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/SI8AAOSwW6Fjff3N/s-l1200.jpg" alt="Soldats Des Ambassadeurs De Jésus Christ"></div>
  <div class="r-details"><div class="r-band"><a href="soldats-des-ambassadeurs-de-jesus-christ.php">Soldats Des Ambassadeurs De Jésus Christ</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/414MKuUXREL._UF1000,1000_QL80_.jpg" alt="Souvenirs Des Beaux Jours"></div>
  <div class="r-details"><div class="r-band"><a href="souvenirs-des-beaux-jours.php">Souvenirs Des Beaux Jours</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/6366facaa0ca6b30489e9dada3a6eb74/250x250-000000-80-0-0.jpg" alt="Spack Reel"></div>
  <div class="r-details"><div class="r-band"><a href="spack-reel.php">Spack Reel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102055.jpg" alt="Speed"></div>
  <div class="r-details"><div class="r-band"><a href="speed.php">Speed</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/4103e80a59e4b4729971984c9c09359d/250x250-000000-80-0-0.jpg" alt="Spencer Brutus"></div>
  <div class="r-details"><div class="r-band"><a href="spencer-brutus.php">Spencer Brutus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/278502411bb3c09ac028ca015729e4d1/250x250-000000-80-0-0.jpg" alt="Sr. Eunide Bernard M"></div>
  <div class="r-details"><div class="r-band"><a href="sr-eunide-bernard-m.php">Sr. Eunide Bernard M</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8824b16aa4a14082d8cb4a50e31749bf/250x250-000000-80-0-0.jpg" alt="Sr. Naromie Buissereth"></div>
  <div class="r-details"><div class="r-band"><a href="sr-naromie-buissereth.php">Sr. Naromie Buissereth</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-000001590000-jmjyyx-t240x240.jpg" alt="Staff 613"></div>
  <div class="r-details"><div class="r-band"><a href="staff-613.php">Staff 613</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5ebaaf08a00b0ab190a39d5cb94" alt="Stan Ofisyèl"></div>
  <div class="r-details"><div class="r-band"><a href="stan-ofisyel.php">Stan Ofisyèl</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/441a4753339668cb6c2b51fb6b4bf6d5/250x250-000000-80-0-0.jpg" alt="Stanley Toussaint"></div>
  <div class="r-details"><div class="r-band"><a href="stanley-toussaint.php">Stanley Toussaint</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://img.cdandlp.com/2019/07/imgL/119575205.png" alt="Star Combo"></div>
  <div class="r-details"><div class="r-band"><a href="star-combo.php">Star Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/3536e2609b4db20778f49fffa3d301a9/250x250-000000-80-0-0.jpg" alt="Star Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="star-mizik.php">Star Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102054.jpg" alt="Steel"></div>
  <div class="r-details"><div class="r-band"><a href="steel.php">Steel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/guFBAToIPzhon74uWB-CFGLCz0R85mACnFFaYnIBLZI/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTU3MTY3/NjItMTQwMDc0MTc1/NS01MDU1LmpwZWc.jpeg" alt="Steel Jazz du marin"></div>
  <div class="r-details"><div class="r-band"><a href="steel-jazz-du-marin.php">Steel Jazz du marin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRpQsLKerg-nPKqkkBaKzFftXTj0n4Hy8nFug&s" alt="Steele Groove"></div>
  <div class="r-details"><div class="r-band"><a href="steele-groove.php">Steele Groove</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51UlW8MZe-L._SX354_SY354_BL0_QL100__UXNaN_FMjpg_QL85_.jpg" alt="Sterling Compas Mix"></div>
  <div class="r-details"><div class="r-band"><a href="sterling-compas-mix.php">Sterling Compas Mix</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1bccb0c74d6926b6b681544622c34743/250x250-000000-80-0-0.jpg" alt="Steve Antoine"></div>
  <div class="r-details"><div class="r-band"><a href="steve-antoine.php">Steve Antoine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/10fa3862184102580b7a62c6f0169bf5/250x250-000000-80-0-0.jpg" alt="Steves J. Bryan"></div>
  <div class="r-details"><div class="r-band"><a href="steves-j-bryan.php">Steves J. Bryan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3b7be4a6789ff9c4d3e2e7ba1100ea86/250x250-000000-80-0-0.jpg" alt="Steve Parolier"></div>
  <div class="r-details"><div class="r-band"><a href="steve-parolier.php">Steve Parolier</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/511NZlsAqzL._UXNaN_FMjpg_QL85_.jpg" alt="Stil"></div>
  <div class="r-details"><div class="r-band"><a href="stil.php">Stil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/6nIGQTU0hkE36mYMjDpBQzuyhpjiXvW6rJA_c2Q3jJA/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI3Mjcx/MDItMTI5ODI5NTAw/Ny5qcGVn.jpeg" alt="Stratos"></div>
  <div class="r-details"><div class="r-band"><a href="stratos.php">Stratos</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/7/1742767248-strings-haiti-cover-3.jpg" alt="Strings"></div>
  <div class="r-details"><div class="r-band"><a href="strings.php">Strings</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/f929fdbe8a10e415149cb47f9ddac85e/250x250-000000-80-0-0.jpg" alt="Studiofest"></div>
  <div class="r-details"><div class="r-band"><a href="studiofest.php">Studiofest</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51HaidzxAfL._UXNaN_FMjpg_QL85_.jpg" alt="Styl Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="styl-kompa.php">Styl Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/c4/8c/2f/c48c2f62-8025-7267-ea87-31b6296d90c2/cover.jpg/486x486bb.png" alt="Styl Vice"></div>
  <div class="r-details"><div class="r-band"><a href="styl-vice.php">Styl Vice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51C+ASF4+OL._UXNaN_FMjpg_QL85_.jpg" alt="Suav Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="suav-mizik.php">Suav Mizik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27305032972a9a711a62d1a3367" alt="SuCh"></div>
  <div class="r-details"><div class="r-band"><a href="such.php">SuCh</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://fr.shopping.rakuten.com/photo/1101599467.jpg" alt="Sully L'homme de Base"></div>
  <div class="r-details"><div class="r-band"><a href="sully-l-homme-de-base.php">Sully L'homme de Base</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101697.jpg" alt="Summer"></div>
  <div class="r-details"><div class="r-band"><a href="summer.php">Summer</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/tIOJMyfzLcK--QnQw-Qxqfx7QGqp8sxc7apZ4uCUVQU/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTUyNDc0/NTItMTM4ODY2OTI3/NC00MjY2LmpwZWc.jpeg" alt="Super 9"></div>
  <div class="r-details"><div class="r-band"><a href="super-9.php">Super 9</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ytimg.com/vi/IqWbYudNb08/hqdefault.jpg" alt="Super Channel 10"></div>
  <div class="r-details"><div class="r-band"><a href="super-channel-10.php">Super Channel 10</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/w~kAAOSwG2RlNVEA/s-l1600.jpg" alt="Super Choucoune"></div>
  <div class="r-details"><div class="r-band"><a href="super-choucoune.php">Super Choucoune</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/8UOM0hktR-y2i74_iLoI_78RCjevq1kZCC8Q9zW5Scs/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI1NzM5/MTYtMTI5MTE1Mzky/NC5wbmc.jpeg" alt="Super Choucoune Soleil D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="super-choucoune-soleil-d-haiti.php">Super Choucoune Soleil D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/jDy8c5rrb5-KnXDoXryCqfvqq-oe6ml4k7NQsmB71kY/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTIyMjg2/NzctMTQxMTIzMjI2/OC0xMTM3LmpwZWc.jpeg" alt="Super Combo"></div>
  <div class="r-details"><div class="r-band"><a href="super-combo.php">Super Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/tuo52hJmBW8GmE4wGpIRjKuASD0UH-7Olok20rLUbC4/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEwMjkz/OTEyLTE0OTQ3OTgy/NzQtODU2OS5qcGVn.jpeg" alt="Super Ensemble Top Compas"></div>
  <div class="r-details"><div class="r-band"><a href="super-ensemble-top-compas.php">Super Ensemble Top Compas</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/4ukDz_53CEyBSmQL6nWkVYDO-cac0xcyogn2JBwT-t8/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTUwODQx/NzQtMTU1ODA5NzIx/OC0xODYzLmpwZWc.jpeg" alt="Super Jazz Des Jeunes"></div>
  <div class="r-details"><div class="r-band"><a href="super-jazz-des-jeunes.php">Super Jazz Des Jeunes</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcR5AnA5KjR-R6V1JbK6xc8701k3ltm59u6Zpw&s" alt="Super Shleu"></div>
  <div class="r-details"><div class="r-band"><a href="super-shleu.php">Super Shleu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273ce4923b642b4068ecfaa029e" alt="Super Soline d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="super-soline-d-haiti.php">Super Soline d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102329.jpg" alt="Super Combo De Nemours Jean baptiste"></div>
  <div class="r-details"><div class="r-band"><a href="super-combo-de-nemours-jean-baptiste.php">Super Combo De Nemours Jean baptiste</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2732bdfe6d42b61d2a01e356c80" alt="Super Stars D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="super-stars-d-haiti.php">Super Stars D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRBsq0lk5g6IEM7Xh3Zsjr6VlHSN8gEsfdnIg&s" alt="Super Stars Music Machine"></div>
  <div class="r-details"><div class="r-band"><a href="super-stars-music-machine.php">Super Stars Music Machine</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/U3kfPg12fLVxTAyr-67pfNPNgaJubwFYiur3GkGFPow/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE0NjQ1/MTQ2LTE1Nzg4MTcy/ODQtMTg3NC5qcGVn.jpeg" alt="Super Tabou Combo"></div>
  <div class="r-details"><div class="r-band"><a href="super-tabou-combo.php">Super Tabou Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61c2UbXq8jL._UXNaN_FMjpg_QL85_.jpg" alt="Supersonic 747 De Larose"></div>
  <div class="r-details"><div class="r-band"><a href="supersonic-747-de-larose.php">Supersonic 747 De Larose</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51aNyi27F8L._UXNaN_FMjpg_QL85_.jpg" alt="Superstars de New York"></div>
  <div class="r-details"><div class="r-band"><a href="superstars-de-new-york.php">Superstars de New York</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/e5433f87e557852549047342ba58ae4b/250x250-000000-80-0-0.jpg" alt="Superstars Ti Tabou"></div>
  <div class="r-details"><div class="r-band"><a href="superstars-ti-tabou.php">Superstars Ti Tabou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2735c721561570cbf522e0703e2" alt="Superstars"></div>
  <div class="r-details"><div class="r-band"><a href="superstars.php">Superstars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/619+-TV-gLL._UXNaN_FMjpg_QL85_.jpg" alt="Suspense"></div>
  <div class="r-details"><div class="r-band"><a href="suspense.php">Suspense</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000264402197-t9qkkq-t500x500.jpg" alt="Swag Muzik"></div>
  <div class="r-details"><div class="r-band"><a href="swag-muzik.php">Swag Muzik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104577.jpg" alt="Sweet Coupe"></div>
  <div class="r-details"><div class="r-band"><a href="sweet-coupe.php">Sweet Coupe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music62/v4/1d/ea/d7/1dead7d8-6552-ea1b-39ea-7673d0a3d25c/cover.jpg/1200x1200bf-60.jpg" alt="Sweet Groove"></div>
  <div class="r-details"><div class="r-band"><a href="sweet-groove.php">Sweet Groove</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/deab00e127284b5dd2c3a0001dd91ea1/250x250-000000-80-0-0.jpg" alt="Sweet Kattia"></div>
  <div class="r-details"><div class="r-band"><a href="sweet-kattia.php">Sweet Kattia</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-PoiYrUlufELN8NdB-SCOxew-t500x500.jpg" alt="Sweet Vibe"></div>
  <div class="r-details"><div class="r-band"><a href="sweet-vibe.php">Sweet Vibe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2737ef0716861fbb34cd7ab4372" alt="Sweet Way"></div>
  <div class="r-details"><div class="r-band"><a href="sweet-way.php">Sweet Way</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102508.jpg" alt="Sweety"></div>
  <div class="r-details"><div class="r-band"><a href="sweety.php">Sweety</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5eba8a12c8889911b23027dc0a6" alt="Sylvie Henry"></div>
  <div class="r-details"><div class="r-band"><a href="sylvie-henry.php">Sylvie Henry</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/ICanXDT8NYU3AA7nKX0lMSRQDfHaMm685ARm5vR7zf0/rs:fill/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI1MTE5/MzgtMTYxOTcwNzM3/My04OTY0LmpwZWc.jpeg" alt="System 2000"></div>
  <div class="r-details"><div class="r-band"><a href="system-2000.php">System 2000</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105105.jpg" alt="System Vice"></div>
  <div class="r-details"><div class="r-band"><a href="system-vice.php">System Vice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/D1nJEXxG7ErEdG5oZrxpnAfA8zbxkw0MgLNyVyeMmFg/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTIwMDc1/MTktMTI1ODE5ODUx/NC5qcGVn.jpeg" alt="System Band"></div>
  <div class="r-details"><div class="r-band"><a href="system-band.php">System Band</a></div></div>
</div>
  
  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>