<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>T - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- TOUS LES ARTISTES T -->
  
  <div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102779.jpg" alt="T Strong"></div>
  <div class="r-details"><div class="r-band"><a href="t-strong.php">T Strong</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273adadee6a8b89a154a226fd75" alt="T Tabou"></div>
  <div class="r-details"><div class="r-band"><a href="t-tabou.php">T Tabou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSWyGRrKlO7pBPhkWQ_esR4DemqET9HX9sh3A&s" alt="Taboo Generation"></div>
  <div class="r-details"><div class="r-band"><a href="taboo-generation.php">Taboo Generation</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/35a6c1409b5e422952bf734389f0ba92/1900x1900-000000-80-0-0.jpg" alt="Tabou Combo"></div>
  <div class="r-details"><div class="r-band"><a href="tabou-combo.php">Tabou Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103987.jpg" alt="Tacaj"></div>
  <div class="r-details"><div class="r-band"><a href="tacaj.php">Tacaj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i0.wp.com/haitiantimes.com/wp-content/uploads/2024/01/Tafa_Mi-Soleil.jpg?fit=897%2C899&ssl=1" alt="Tafa Mi-Soleil"></div>
  <div class="r-details"><div class="r-band"><a href="tafa-mi-soleil.php">Tafa Mi-Soleil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273c51723981ad900e1f59ee7c1" alt="Tag Musik"></div>
  <div class="r-details"><div class="r-band"><a href="tag-musik.php">Tag Musik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000217317983-9f3qm4-t500x500.jpg" alt="Tah-Pajj"></div>
  <div class="r-details"><div class="r-band"><a href="tahpajj.php">Tah-Pajj</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101739.jpg" alt="Take 5"></div>
  <div class="r-details"><div class="r-band"><a href="take5.php">Take 5</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/102226.jpg" alt="Take Off"></div>
  <div class="r-details"><div class="r-band"><a href="take-off.php">Take Off</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/85/51/88/mzi.hxevphfp.jpg/800x800cc.jpg" alt="Take Over"></div>
  <div class="r-details"><div class="r-band"><a href="take-over.php">Take Over</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/5acfc65044fba374f26a540bd8e3f852/1900x1900-000000-80-0-0.jpg" alt="Tamara Suffren"></div>
  <div class="r-details"><div class="r-band"><a href="tamara-suffren.php">Tamara Suffren</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02dea3ab5686ef117194a8fa1c" alt="Tamaryo"></div>
  <div class="r-details"><div class="r-band"><a href="tamaryo.php">Tamaryo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61jIrmeexjL._UXNaN_FMjpg_QL85_.jpg" alt="Tam-Tam Band"></div>
  <div class="r-details"><div class="r-band"><a href="tam-tam-band.php">Tam-Tam Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c7307f70ed0e3a9a2350d5a1c90089ce/250x250-000000-80-0-0.jpg" alt="T-Maya bel Etwal"></div>
  <div class="r-details"><div class="r-band"><a href="t-mayabeletwal.php">T-Maya bel Etwal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2733b54243e44413de2693ebce8" alt="Tandans"></div>
  <div class="r-details"><div class="r-band"><a href="tandans.php">Tandans</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ebayimg.com/images/g/LK0AAOSwRvRg1~0v/s-l1600.jpg" alt="Tanpet"></div>
  <div class="r-details"><div class="r-band"><a href="tanpet.php">Tanpet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://pbs.twimg.com/profile_images/1636455918266187776/rbFRTjnN_400x400.jpg" alt="T-Ansyto"></div>
  <div class="r-details"><div class="r-band"><a href="tansyto.php">T-Ansyto</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61CrDbbyfML._UXNaN_FMjpg_QL85_.jpg" alt="Taptap Band"></div>
  <div class="r-details"><div class="r-band"><a href="taptap-band.php">Taptap Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103308.jpg" alt="Tchaka Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="tchaka-kompa.php">Tchaka Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51IPGdTrpuL._UXNaN_FMjpg_QL85_.jpg" alt="Teddy"></div>
  <div class="r-details"><div class="r-band"><a href="teddy.php">Teddy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/c208977239d43e3857a63e9b09476c2b/250x250-000000-80-0-0.jpg" alt="Teddy Hashrag"></div>
  <div class="r-details"><div class="r-band"><a href="teddyhashrag.php">Teddy Hashrag</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/dbdd6d95b8ed2fab975e2cc403abab92/250x250-000000-80-0-0.jpg" alt="Teeshu"></div>
  <div class="r-details"><div class="r-band"><a href="teeshu.php">Teeshu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27347bab381ddb49538be99f471" alt="Tempo"></div>
  <div class="r-details"><div class="r-band"><a href="tempo.php">Tempo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101162.jpg" alt="Thamad Band"></div>
  <div class="r-details"><div class="r-band"><a href="thamad-band.php">Thamad Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51Xv6ym6lmL._UXNaN_FMjpg_QL85_.jpg" alt="Thamad Fever"></div>
  <div class="r-details"><div class="r-band"><a href="thamad-fever.php">Thamad Fever</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100058.jpg" alt="The Big One"></div>
  <div class="r-details"><div class="r-band"><a href="the-big-one.php">The Big One</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51nfHfek3pL._UXNaN_FMjpg_QL85_.jpg" alt="The Global Zoe"></div>
  <div class="r-details"><div class="r-band"><a href="theglobalzoe.php">The Global Zoe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/5c28cfeda087ecdbb84014dde735782c/250x250-000000-80-0-0.jpg" alt="Thelo"></div>
  <div class="r-details"><div class="r-band"><a href="thelo.php">Thelo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273289d162d876c259d1dc99512" alt="The Michael Pluznick Group"></div>
  <div class="r-details"><div class="r-band"><a href="themichaelpluznickgroup.php">The Michael Pluznick Group</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/100607.jpg" alt="The Partners"></div>
  <div class="r-details"><div class="r-band"><a href="thepartners.php">The Partners</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/47f7ab981c97e4ce004aa1eca270d87c/250x250-000000-80-0-0.jpg" alt="The Plug"></div>
  <div class="r-details"><div class="r-band"><a href="theplug.php">The Plug</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1dd6c37697925251cc69112b78366e19/250x250-000000-80-0-0.jpg" alt="The Port-au-Prince International Combo"></div>
  <div class="r-details"><div class="r-band"><a href="the-portauprince-international-combo.php">The Port-au-Prince International Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/1cc6e4d6ce74e4895c890955ed39c6fe/250x250-000000-80-0-0.jpg" alt="The Vilsaint Squad"></div>
  <div class="r-details"><div class="r-band"><a href="the-vilsaint-squad.php">The Vilsaint Squad</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i0.wp.com/haitiantimes.com/wp-content/uploads/2022/08/TiCorn-at-Festival-Sons-Croises-Creole-Paris-Credit_-Cornelia-Schutt-1-scaled.jpg?fit=2525%2C2560&ssl=1" alt="Ti Corn"></div>
  <div class="r-details"><div class="r-band"><a href="ti-corn.php">Ti Corn</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/LZMPvFWphbW-T0PV2OR0EHcTLvqXr3aNY-WW0I-Wx8U/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTExOTY5/OTk4LTE1MjU3MjAz/NTItMjMxMy5qcGVn.jpeg" alt="Ti Crane"></div>
  <div class="r-details"><div class="r-band"><a href="ti-crane.php">Ti Crane</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000129992548-8au40u-t500x500.jpg" alt="Ti Doz"></div>
  <div class="r-details"><div class="r-band"><a href="ti-doz.php">Ti Doz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000160185271-38mym0-t500x500.jpg" alt="Ti Kabzy"></div>
  <div class="r-details"><div class="r-band"><a href="ti-kabzy.php">Ti Kabzy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/3b90b9b373e4d7d435f27e1bb349390c/250x250-000000-80-0-0.jpg" alt="Tikawo Trafik"></div>
  <div class="r-details"><div class="r-band"><a href="tikawo-trafik.php">Tikawo Trafik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/b289e11313f4a13814e42fdc77faddfe/1900x1900-000000-80-0-0.jpg" alt="Ti Lunèt"></div>
  <div class="r-details"><div class="r-band"><a href="ti-lunet.php">Ti Lunèt</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://64.media.tumblr.com/cb35e90966d81f03950f1f10bbd53f8c/9f18ab0f97b766a5-1b/s500x750/e2565c9705d3580a8b3e88442ca05af04197948b.jpg" alt="Ti Manno"></div>
  <div class="r-details"><div class="r-band"><a href="ti-manno.php">Ti Manno</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e02d1fca9fbf123f6610b96a9c6" alt="Ti Paris"></div>
  <div class="r-details"><div class="r-band"><a href="ti-paris.php">Ti Paris</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/mX9oCFq7HEGT26NF1o95GTOO8kRMknk0q0b_7M693Ms/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE0ODgx/MTgyLTE1ODMzNzk4/NzEtNTEzMS5qcGVn.jpeg" alt="Ti Plume"></div>
  <div class="r-details"><div class="r-band"><a href="ti-plume.php">Ti Plume</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51jY6mOqXfL._UXNaN_FMjpg_QL85_.jpg" alt="Ti Polis"></div>
  <div class="r-details"><div class="r-band"><a href="ti-polis.php">Ti Polis</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://kreyonomi.wordpress.com/wp-content/uploads/2021/09/manje.jpg?w=400" alt="Ti Will"></div>
  <div class="r-details"><div class="r-band"><a href="tiwill.php">Ti Will</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/81pOjulinhL._UF1000,1000_QL80_.jpg" alt="Ti-coca"></div>
  <div class="r-details"><div class="r-band"><a href="ticoca.php">Ti-coca</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://resources.tidal.com/images/fb340ec2/b103/4260/8240/4d30ee1b453d/750x750.jpg" alt="Tiemdi"></div>
  <div class="r-details"><div class="r-band"><a href="tiemdi.php">Tiemdi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://shoutoutatlanta.com/wp-content/uploads/2023/04/c-StephanieSejour__GCS69512_1678068484812.jpg" alt="Tifane"></div>
  <div class="r-details"><div class="r-band"><a href="tifane.php">Tifane</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103212.jpg" alt="Ti Guy – First Class"></div>
  <div class="r-details"><div class="r-band"><a href="ti-guy-first-class.php">Ti Guy – First Class</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41REFKP6J8L._UF1000,1000_QL80_.jpg" alt="Ti-Jack"></div>
  <div class="r-details"><div class="r-band"><a href="tijack.php">Ti-Jack</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41REFKP6J8L._UF1000,1000_QL80_.jpg" alt="Tika J"></div>
  <div class="r-details"><div class="r-band"><a href="tika-j.php">Tika J</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/fda8b1e267ce72eb5fd744a38d42b7ad/250x250-000000-80-0-0.jpg" alt="TINA RI4"></div>
  <div class="r-details"><div class="r-band"><a href="tinari4.php">TINA RI4</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSKY_Wsaxlbqe0W09HHBNw6g5HEKCCMDf1GEg&s" alt="Tines Salvant"></div>
  <div class="r-details"><div class="r-band"><a href="tinessalvant.php">Tines Salvant</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/619+-TV-gLL._UXNaN_FMjpg_QL85_.jpg" alt="Tipa Tipa"></div>
  <div class="r-details"><div class="r-band"><a href="tipatipa.php">Tipa Tipa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27383b6387c87ee03d3f1367163" alt="Titi Congo"></div>
  <div class="r-details"><div class="r-band"><a href="titicongo.php">Titi Congo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS6GhhXYdGizGpzBUGN0z7FONwiGukD5BDt3w&s" alt="Tito Laurent Marechal"></div>
  <div class="r-details"><div class="r-band"><a href="tito-laurent-marechal.php">Tito Laurent Marechal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101748.jpg" alt="Tiz"></div>
  <div class="r-details"><div class="r-band"><a href="tiz.php">Tiz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music71/v4/f5/86/bb/f586bb00-f426-877a-2416-6c986c7bd5f3/888295496759.jpg/800x800cc.jpg" alt="T-Klasik JD"></div>
  <div class="r-details"><div class="r-band"><a href="tklasikjd.php">T-Klasik JD</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273448429009e0c89e244e55871" alt="T-Love"></div>
  <div class="r-details"><div class="r-band"><a href="t-love.php">T-Love</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2739caaed33f44d1ce3bdf543c0" alt="T-Micky"></div>
  <div class="r-details"><div class="r-band"><a href="t-micky.php">T-Micky</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/9b003b219e5ea32ab73769b287525eef/250x250-000000-80-0-0.jpg" alt="TNT"></div>
  <div class="r-details"><div class="r-band"><a href="tnt.php">TNT</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27376d520a81688680a7c3c6fa6" alt="Toby & Vanessa"></div>
  <div class="r-details"><div class="r-band"><a href="toby-and-vanessa.php">Toby & Vanessa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/6/1741393989-toby-anbake.jpg" alt="Toby Anbake"></div>
  <div class="r-details"><div class="r-band"><a href="toby-anbake.php">Toby Anbake</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/FUELNp1BDIRxl7GUTgFVgvsFwMP71XJ2zUb73ANboVs/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE1OTcy/NjM5LTE2MDExNTQ1/MDQtNjAzOC5qcGVn.jpeg" alt="Tommy Evans Jr. & Tabasco"></div>
  <div class="r-details"><div class="r-band"><a href="tommy-evans-jr-and-tabasco.php">Tommy Evans Jr. & Tabasco</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/9rrISYXAqk_L9uWF0l-K18mz3DOHZ380ovdJYlCWBiM/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEwNDg5/NDQ2LTE0OTg1MDAx/MzItNDg3Ni5qcGVn.jpeg" alt="Tony Bordey"></div>
  <div class="r-details"><div class="r-band"><a href="tony-bordey.php">Tony Bordey</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/a295d116fd59f4ca42e0f63e4c13edfc/1900x1900-000000-80-0-0.jpg" alt="Tony Lilong"></div>
  <div class="r-details"><div class="r-band"><a href="tony-lilong.php">Tony Lilong</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27391bafeb4147c37b6b63bccb8" alt="Top Adlerman"></div>
  <div class="r-details"><div class="r-band"><a href="top-adlerman.php">Top Adlerman</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/nEiceCnrOL9oJ45tRKwoaS7yRPVj93KM-2-8xp0z7Yo/rs:fit/g:sm/q:90/h:600/w:593/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTQ0OTcw/ODQtMTU2ODI4MjEw/MS00Njc2LmpwZWc.jpeg" alt="Top Combo"></div>
  <div class="r-details"><div class="r-band"><a href="top-combo.php">Top Combo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101930.jpg" alt="Top Coupé"></div>
  <div class="r-details"><div class="r-band"><a href="top-coupe.php">Top Coupé</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101751.jpg" alt="Top Digital"></div>
  <div class="r-details"><div class="r-band"><a href="top-digital.php">Top Digital</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27300deb2428d0c954731b96849" alt="Top Gyps"></div>
  <div class="r-details"><div class="r-band"><a href="top-gyps.php">Top Gyps</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/W96xTpDsAlYbBx6827YbD3kDUOIYZn-u3ZpQu3bQC9s/rs:fit/g:sm/q:90/h:579/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE1NTQw/Nzg2LTE1OTMyODM4/MzAtNDc0Mi5qcGVn.jpeg" alt="Top Masters"></div>
  <div class="r-details"><div class="r-band"><a href="top-masters.php">Top Masters</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/70/f3/cb/70f3cb5b-bc55-ac4c-f971-c03786e3991a/859780802560_cover.jpg/486x486bb.png" alt="Top Posse Band"></div>
  <div class="r-details"><div class="r-band"><a href="top-posse-band.php">Top Posse Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-s8yDJNU0Zl4r-0-t240x240.jpg" alt="Top Shleu"></div>
  <div class="r-details"><div class="r-band"><a href="top-shleu.php">Top Shleu</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/827c3241eeea3f4b8b4a837b5285ac1b/250x250-000000-80-0-0.jpg" alt="Topson"></div>
  <div class="r-details"><div class="r-band"><a href="topson.php">Topson</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/nxZ28HTDsOaQdVn7GO_UGSmEVWXbLrHQBsytrYS61cI/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTI3MjA5/NjItMTY2MDEzMzMx/Mi00OTc0LmpwZWc.jpeg" alt="Top Vice"></div>
  <div class="r-details"><div class="r-band"><a href="top-vice.php">Top Vice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/J5iywWH3_NCy7Zpqw-9A_RegGmaMFJEuc35Frfp6NZU/rs:fit/g:sm/q:90/h:594/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTM0MDU5/ODItMTQ5Mjg0ODg2/Ny01NTUyLmpwZWc.jpeg" alt="Topazz"></div>
  <div class="r-details"><div class="r-band"><a href="topazz.php">Topazz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273fae829f125b7903a99ee7108" alt="Toto Bissainthe"></div>
  <div class="r-details"><div class="r-band"><a href="toto-bissainthe.php">Toto Bissainthe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/3/1742349401-toto-laraque-cover-1.jpg" alt="Toto Laraque"></div>
  <div class="r-details"><div class="r-band"><a href="toto-laraque.php">Toto Laraque</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000135199362-yzcr2y-t500x500.jpg" alt="Toto Nécessite"></div>
  <div class="r-details"><div class="r-band"><a href="toto-necessite.php">Toto Nécessite</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103214.jpg" alt="Touch Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="touch-kompa.php">Touch Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music116/v4/30/c3/fc/30c3fc1b-cd9b-ae00-8945-6f9341f4605d/198026821065.jpg/375x375bb.webp" alt="Tounèf Djaz"></div>
  <div class="r-details"><div class="r-band"><a href="tounef-djaz.php">Tounèf Djaz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2739c5441be89efc0c8eb1a4328" alt="Toxic Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="toxic-haiti.php">Toxic Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://s.mxmcdn.net/images-storage/albums5/8/4/2/2/7/0/33072248_500_500.jpg" alt="TPO"></div>
  <div class="r-details"><div class="r-band"><a href="tpo.php">TPO</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105529.jpg" alt="Trankil"></div>
  <div class="r-details"><div class="r-band"><a href="trankil.php">Trankil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51GCr86SqVL._UXNaN_FMjpg_QL85_.jpg" alt="Triomec's"></div>
  <div class="r-details"><div class="r-band"><a href="triomecs.php">Triomec's</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/0e518769e65abe2a39f5a1579b2bd5d5/250x250-000000-80-0-0.jpg" alt="Triumph For God"></div>
  <div class="r-details"><div class="r-band"><a href="triumph-for-god.php">Triumph For God</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103161.jpg" alt="Tropical Breeze"></div>
  <div class="r-details"><div class="r-band"><a href="tropical-breeze.php">Tropical Breeze</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Eh1CJ4XnRnDg_fqwR2PZabX4nFdEtYzWgXr0MHJ8OLE/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEyOTQw/MjQzLTE1NDQ5Njgy/MjgtOTMwOS5wbmc.jpeg" alt="Tropical Combo De Ti Jacque"></div>
  <div class="r-details"><div class="r-band"><a href="tropical-combo-de-ti-jacque.php">Tropical Combo De Ti Jacque</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/cMYowXNfZNCTUhRYDwWdszyHmNU5wDNoXzKhs3g7ICk/rs:fit/g:sm/q:90/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc4OTQ1/NTItMTQ1MTE0NDM5/Mi03NTI1LmpwZWc.jpeg" alt="Tropical Quintet"></div>
  <div class="r-details"><div class="r-band"><a href="tropical-quintet.php">Tropical Quintet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/XGeZRIYrkD4sdsqiPOq3Jl5VS-cvXdIU-7-Vm36bTUs/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTgxNjQ5/MDctMTQ1NjM1MDI1/My04NjY3LmpwZWc.jpeg" alt="Tropical Sextet"></div>
  <div class="r-details"><div class="r-band"><a href="tropical-sextet.php">Tropical Sextet</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Y3Msh06q0T_Q4mQtNnTFbFGxld8SoDxMuDmNT3k1oTM/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTc0NzQ2/NjgtMTQ0MjIyMjMx/My0yOTQ1LmpwZWc.jpeg" alt="Tropical Systeme"></div>
  <div class="r-details"><div class="r-band"><a href="tropical-systeme.php">Tropical Systeme</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/zrIe5Sq2VjxfWyEUm-6gJlRE2suMVreFvR1nwRV1l6U/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTIwMTQ2/ODc2LTE2MzEwMTg5/OTgtNDAwMy5qcGVn.jpeg" alt="Tropicana Orchestra De La Guadeloupe"></div>
  <div class="r-details"><div class="r-band"><a href="tropicana-orchestra-de-la-guadeloupe.php">Tropicana Orchestra De La Guadeloupe</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-1mbdadm5AsT80zBr-JMU0lg-t500x500.jpg" alt="Troubleboy Hitmaker"></div>
  <div class="r-details"><div class="r-band"><a href="trouble-boy-hitmaker.php">Troubleboy Hitmaker</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273361927a233d42eca1ee746b0" alt="Tuco Bouzi"></div>
  <div class="r-details"><div class="r-band"><a href="tuco-bouzi.php">Tuco Bouzi</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2734f585bca1c6e665f6ce47c65" alt="Turbo"></div>
  <div class="r-details"><div class="r-band"><a href="turbo.php">Turbo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/4b8352f2cd941ccaea2062ca276c70b4/250x250-000000-80-0-0.jpg" alt="T-Eka Opak"></div>
  <div class="r-details"><div class="r-band"><a href="t-eka-opak.php">T-Eka Opak</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000589356164-t159hq-t500x500.jpg" alt="T-Vice"></div>
  <div class="r-details"><div class="r-band"><a href="t-vice.php">T-Vice</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e0296ee2da2d473cb338f53cf60" alt="Typical Combo"></div>
  <div class="r-details"><div class="r-band"><a href="typical.php">Typical Combo</a></div></div>
</div>
  
  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>