<?php
$file = basename(__FILE__, '.php') . '.json';
$path = __DIR__ . '/' . $file;
if (!file_exists($path)) {
  http_response_code(404);
  echo "<h2>Le fichier JSON '$file' est introuvable.</h2>";
  exit;
}
$data = json_decode(file_get_contents($path), true);
if (!$data) {
  echo "<h2>Erreur : fichier JSON invalide ou vide.</h2>";
  exit;
}
?>

<?php
$file = basename(__FILE__, '.php') . ".json";
$path = __DIR__ . "/" . $file;

if (!file_exists($path)) {
  http_response_code(404);
  echo "<h2>Le fichier JSON '$file' est introuvable.</h2>";
  exit;
}

$data = json_decode(file_get_contents($path), true);
if (!$data) {
  echo "<h2>Erreur : fichier JSON invalide ou vide.</h2>";
  exit;
}

$artistName = $data[0]['artist'] ?? 'Artiste inconnu';
$coverImage = $data[0]['cover'] ?? '';

// Nettoyage des pistes (Face A, CD1, Disc 1, etc.)
foreach ($data as &$album) {
  if (!isset($album['tracks']) || !is_array($album['tracks'])) continue;

  $tracks = $album['tracks'];
  $structured = [];
  $currentSection = null;

  foreach ($tracks as $entry) {
    $line = trim(is_string($entry) ? $entry : '');
    if ($line === '') continue;

    if (preg_match('/^(Face\s*[A-D]|CD\s*\d+|Disc\s*\d+)/i', $line)) {
      $currentSection = trim($line);
      $structured[$currentSection] = [];
    } elseif ($currentSection) {
      $cleanLine = preg_replace('/^\d+\.\s*/', '', $line);
      $structured[$currentSection][] = $cleanLine;
    }
  }
  if (!empty($structured)) {
    $album['tracks'] = $structured;
  }
}
unset($album);
?>


<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Ti Roro & Red Camp - Discographie</title>
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link rel="icon" href="https://image.noelshack.com/fichiers/2025/25/5/1750452542-logo-achiv.jpg" type="image/png">
</head>
<body>

<header>
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 400px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }
     @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .artist-list {
      display: flex;
      justify-content: center;
      margin: 30px auto;
    }

    .results-container {
      background: #E6E6E6;
      padding: 30px;
      border-radius: 12px;
      max-width: 1800px;
      width: 100%;
      box-shadow: 0 0 20px rgba(201, 165, 76, 0.05);
    }

    .container {
      max-width: 1850px;
      margin: auto;
      padding: 2rem;
      background: #E6E6E6;
      border-radius: 12px;
    }

    .artist-header {
      display: flex;
      gap: 2rem;
      background: #E6E6E6;
      padding: 1.5rem;
      border-radius: 12px;
      margin-bottom: 2rem;
      flex-wrap: wrap;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }

    .artist-photo img {
      width: 180px;
      height: 180px;
      border-radius: 12px;
      object-fit: cover;
    }

    .artist-info {
      flex: 1;
      min-width: 250px;
      color: #212121;
    }

    .artist-info p {
      margin: 0.5rem 0;
      font-size: 14px;
      line-height: 1.5;
    }

    .artist-badges {
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 0.5rem;
      margin: 2rem auto;
    }

    .badge {
      background: #FFFFFF;
      color: #C9A54C;
      border: 1px solid #C9A54C;
      padding: 6px 12px;
      font-size: 13px;
      border-radius: 999px;
      cursor: pointer;
      transition: 0.2s ease;
    }

    .badge:hover {
      background: #F3F3F3;
    }

    .badge.active {
      background: #C9A54C;
      color: #FFFFFF;
    }

    .main-layout {
      display: flex;
      flex-wrap: wrap;
      gap: 2rem;
    }

    .sidebar {
      flex: 1;
      min-width: 300px;
      max-width: 400px;
      display: flex;
      flex-direction: column;
      gap: 0.5rem;
      max-height: 70vh;
      overflow-y: auto;
    }

    .album-item {
      opacity: 0;
      transform: translateY(10px);
      animation: fadeInUp 0.4s ease forwards;
      background: #F5F5F5;
      padding: 0.5rem;
      border-radius: 10px;
      display: flex;
      align-items: center;
      gap: 0.75rem;
      border: 1px solid #ddd;
      cursor: pointer;
    }

    .album-item:hover,
    .album-item.active {
      background: #E0E0E0;
    }

    .album-item img {
      width: 60px;
      height: 60px;
      border-radius: 6px;
      object-fit: cover;
    }

    @keyframes fadeInUp {
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .album-preview {
      flex: 2;
      min-width: 280px;
      background: #E6E6E6;
      padding: 1.5rem;
      border-radius: 12px;
      display: flex;
      flex-wrap: wrap;
      gap: 2rem;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }

    .cover-and-info {
      max-width: 300px;
      flex: 1;
    }

    .cover-and-info img {
      width: 100%;
      border-radius: 12px;
      margin-bottom: 1rem;
    }

    .album-meta p {
      font-size: 14px;
      color: #888;
      margin: 4px 0;
    }

    .tracklist-container {
      flex: 2;
    }

    .tracklist-container ol {
      padding-left: 1rem;
    }

     .track-face {
      font-weight: bold;
      font-size: 1.2rem;
      margin-top: 1rem;
      margin-bottom: 0.5rem;
      border-top: 1px dashed #aaa;
      padding-top: 0.5rem;
      color: #C9A54C;
    }
    .tracklist-container ol {
      padding-left: 0;
      list-style: none;
    }
    .tracklist-container li {
      font-size: 1.1rem;
      background: #fff6e6;
      border-radius: 12px;
      margin-bottom: 8px;
      padding: 10px 14px;
      position: relative;
    }
    .tracklist-container ol[data-face] {
      counter-reset: track;
      padding-left: 2rem;
    }
    .tracklist-container ol[data-face] li::before {
      counter-increment: track;
      content: counter(track) ". ";
      position: absolute;
      left: -1.6rem;
      font-weight: bold;
      color: black;
    }

    @media (max-width: 768px) {
      .artist-header {
        flex-direction: column;
        align-items: center;
        text-align: center;
      }

      .main-layout {
        flex-direction: column;
      }

      .album-preview {
        flex-direction: column;
      }

      .artist-info {
        text-align: left;
      }
    }
  </style>
</head>
<body>
 <!-- Alphabet + Recherche -->
<div class="abc-container">
  <div class="abc-ribbon">
    <!-- Icônes ajoutées dans le ruban -->
    <div class="abc-icons" style="display: flex; gap: 10px; align-items: center; margin-right: 10px;">
      <!-- 🔙 Retour -->
      <a href="javascript:history.back()" class="home-link" title="Retour">
        <svg xmlns="http://www.w3.org/2000/svg" height="24" width="24" fill="#555" viewBox="0 0 24 24">
          <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"/>
        </svg>
      </a>

      <!-- 🏠 Accueil -->
      <a href="../../index.php" class="home-link" title="Accueil">
        <svg xmlns="http://www.w3.org/2000/svg" height="24" width="24" fill="#555" viewBox="0 0 24 24">
          <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>
        </svg>
      </a>
    </div>

    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
    </div>

    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
</div>


      <!-- 🎤 Bloc Artiste -->
  <div class="container">
    <div class="artist-header">
      <div class="artist-photo">
        <img src="" alt="" />
      </div>
      <div class="artist-info">
        <p><strong>Artiste ou Groupe :</strong> </p>
        <p><strong>Origine :</strong> Haïti</p>
        <p><strong>Année de formation :</strong> </p>
        <p><strong>Genre :</strong> Kompa</p>
        <p><strong>Membres fondateurs :</strong> </p>
        <p><strong>Biographie :</strong><br>Avenir...</p>
      </div>
    </div>
    <div class="artist-badges">
      <span class="badge active" data-filter="all">📀 Tous</span>
      <span class="badge" data-filter="Studio">💿 Studio</span>
      <span class="badge" data-filter="Live">🔊 Live</span>
      <span class="badge" data-filter="Best of">⭐ Best Of</span>
      <span class="badge" data-filter="Promo">📢 Promo</span>
    </div>
    <div class="main-layout">
      <div class="sidebar" id="albumSidebar"></div>
      <div class="album-preview" id="albumPreview">Sélectionnez un album pour voir les détails</div>
    </div>
  </div>

<script>
const sidebar = document.getElementById('albumSidebar');
const preview = document.getElementById('albumPreview');
let albums = [];

function showAlbum(album, el) {
  document.querySelectorAll('.album-item').forEach(i => i.classList.remove('active'));
  el.classList.add('active');

  let trackHTML = '';
  if (Array.isArray(album.tracks)) {
    trackHTML = `<ol data-face="CD">${album.tracks.map(track => `<li>${track}</li>`).join('')}</ol>`;
  } else if (typeof album.tracks === 'object') {
    for (const [face, tracks] of Object.entries(album.tracks)) {
      const faceLabel = face.replace(/face/i, '').trim().toUpperCase();
      trackHTML += `<div class='track-face'>${faceLabel}</div><ol data-face="${faceLabel}">${tracks.map(track => `<li>${track}</li>`).join('')}</ol>`;
    }
  }

  preview.innerHTML = `
    <div class="cover-and-info">
      <img src="${album.cover}" alt="${album.title}" />
      <div class="album-meta">
        <h2>${album.artist}</h2>
        <h3>${album.title}</h3>
        <p><strong>Année :</strong> ${album.year}</p>
        <p><strong>Catégorie :</strong> <span class="badge">${album.category || ''}</span></p>
        <p><strong>Format :</strong> <span class="badge badge-format">${album.format || album.type || ''}</span></p>
        <p><strong>Genre :</strong> ${album.genre || '–'}</p>
        <p><strong>Label :</strong> ${album.label || '–'}</p>
      </div>
    </div>
    <div class="tracklist-container">
      <h3>Tracklist</h3>
      ${trackHTML}
    </div>
  `;
}

function renderSidebar(list) {
  sidebar.innerHTML = '';
  list.forEach(album => {
    const div = document.createElement('div');
    div.className = 'album-item';
    div.innerHTML = `
      <img src="${album.cover}" alt="${album.title}">
      <div>
        <strong>${album.title}</strong><br>
        <small>${album.year} • ${album.category || ''} • ${album.format || album.type || ''}</small>
      </div>
    `;
    div.onclick = () => showAlbum(album, div);
    sidebar.appendChild(div);
  });
}

function updateBadgeCounts(data) {
  const counts = {
    all: data.length,
    studio: 0,
    live: 0,
    'best of': 0,
    promo: 0,
  };

  data.forEach(album => {
    const category = album.category?.toLowerCase();
    if (category in counts) counts[category]++;
  });

  document.querySelectorAll('.badge').forEach(badge => {
    const type = badge.dataset.filter.toLowerCase();
    if (counts[type] !== undefined) {
      const label = badge.textContent.split('(')[0].trim();
      badge.textContent = `${label} (${counts[type]})`;
    }
  });
}

const jsonFile = window.location.pathname.split('/').pop().replace('.php', '.json');
fetch(jsonFile)
  .then(res => res.json())
  .then(data => {
    albums = data.sort((a, b) => parseInt(b.year) - parseInt(a.year));
    updateBadgeCounts(albums);
    renderSidebar(albums);
    document.querySelectorAll('.badge').forEach(badge => {
      badge.addEventListener('click', () => {
        document.querySelectorAll('.badge').forEach(b => b.classList.remove('active'));
        badge.classList.add('active');
        const filter = badge.dataset.filter;
        const filtered = filter === 'all'
          ? albums
          : albums.filter(a => a.category?.toLowerCase() === filter.toLowerCase());
        renderSidebar(filtered);
      });
    });
  });
</script>
</body>
</html>