<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>v - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
  

  <!-- Liste verticale des albums -->
  <div class="album-list">
      
    <!-- Liste des artistes -->
    <div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/pBcB-SKks6NKH0tEr0vqFwqVRXtapTeNC6nF5_hhnV4/rs:fit/g:sm/q:90/h:591/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEzOTg4/MTM0LTE1NjU1NDk4/MjAtNDg1My5qcGVn.jpeg" alt="Vag"></div>
  <div class="r-details"><div class="r-band"><a href="vag.php">Vag</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/024dbb8c4ef324a46a557527d5080b82/250x250-000000-80-0-0.jpg" alt="Vakam"></div>
  <div class="r-details"><div class="r-band"><a href="vakam.php">Vakam</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/d62b66053a376a3eb08f629e858c2eb1/250x250-000000-80-0-0.jpg" alt="Val-Inc"></div>
  <div class="r-details"><div class="r-band"><a href="val-inc.php">Val-Inc</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/25/7/1750604922-va-cover.jpg" alt="Valérie Clio"></div>
  <div class="r-details"><div class="r-band"><a href="valerie-clio.php">Valérie Clio</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c05db67038cf0b1bf7b4a8edb8ec9609/250x250-000000-80-0-0.jpg" alt="Valérie Tribord"></div>
  <div class="r-details"><div class="r-band"><a href="valerie-tribord.php">Valérie Tribord</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/25/7/1750605640-cover.jpg" alt="Valeus Sisters "></div>
  <div class="r-details"><div class="r-band"><a href="valeus-sisters.php">Valeus Sisters</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/20f11f5c2594b2f07d4e7336aafea541/1900x1900-000000-80-0-0.jpg" alt="Vanessa Desire"></div>
  <div class="r-details"><div class="r-band"><a href="vanessa-desire.php">Vanessa Desire</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103402.jpg" alt="Vaudou"></div>
  <div class="r-details"><div class="r-band"><a href="vaudou.php">Vaudou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/dd3842f44374a09c7066cca6c88922f3/250x250-000000-80-0-0.jpg" alt="Vayb"></div>
  <div class="r-details"><div class="r-band"><a href="vayb.php">Vayb</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/1tdgRgmaPYDF-cL5y7GD1YPavXvpZqu8ApBAVs2kU38/rs:fit/g:sm/q:90/h:595/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTIyNzEz/MzgtMTI3MzU5Nzc5/OS5qcGVn.jpeg" alt="Vega Band De Paris"></div>
  <div class="r-details"><div class="r-band"><a href="vega-band-de-paris.php">Vega Band De Paris</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/Ov-IU_FnML0uWeKHLRBzxvovUYThR0ebZIpdhEPLBBQ/rs:fit/g:sm/q:90/h:600/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTQ0OTY5/NDMtMTYzNDI4OTgx/MS0zNTE4LmpwZWc.jpeg" alt="Vega Band D'Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="vega-band-d-haiti.php">Vega Band D'Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106720.jpg" alt="Velox Band Polydor"></div>
  <div class="r-details"><div class="r-band"><a href="veloxbandpolydor.php">Velox Band Polydor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/c70caa354ab11b57b0c13a4422861915/250x250-000000-80-0-0.jpg" alt="Venso Vokal"></div>
  <div class="r-details"><div class="r-band"><a href="vensovokal.php">Venso Vokal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/b4687e5c92b2ab9f81ff4d9d1ffb68c6/250x250-000000-80-0-0.jpg" alt="Vensyy"></div>
  <div class="r-details"><div class="r-band"><a href="vensyy.php">Vensyy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/597a015ef021cc95ace34eeb8f716ebc/250x250-000000-80-0-0.jpg" alt="Versyle Sylvestre"></div>
  <div class="r-details"><div class="r-band"><a href="versyle-vylvestre.php">Versyle Sylvestre</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/b7914e2743caf48f561d800444aea7a2/250x250-000000-80-0-0.jpg" alt="Vewonik"></div>
  <div class="r-details"><div class="r-band"><a href="vewonik.php">Vewonik</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/52851c1ff30dd90c89b0f8bc9842d1e7/250x250-000000-80-0-0.jpg" alt="Vibrasyon"></div>
  <div class="r-details"><div class="r-band"><a href="vibrasyon.php">Vibrasyon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105920.jpg" alt="Victor Surpris Jr."></div>
  <div class="r-details"><div class="r-band"><a href="victor-surpris-jr.php">Victor Surpris Jr.</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101277.jpg" alt="Video Band"></div>
  <div class="r-details"><div class="r-band"><a href="video-band.php">Video Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000316594599-3j5293-t500x500.jpg" alt="Vikings d'Haïti"></div>
  <div class="r-details"><div class="r-band"><a href="vikings-d-haiti.php">Vikings d'Haïti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/97712eb024629057dc29ec7f20f06718/250x250-000000-80-0-0.jpg" alt="Vincent Petit-Frere"></div>
  <div class="r-details"><div class="r-band"><a href="vincent-petit-frere.php">Vincent Petit-Frere</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/9e5f5eb26b1ee5f37a6c8dcdc0030ae5/250x250-000000-80-0-0.jpg" alt="Vis-Jan-Sa"></div>
  <div class="r-details"><div class="r-band"><a href="vis-jan-sa.php">Vis-Jan-Sa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103993.jpg" alt="Vizion All Stars"></div>
  <div class="r-details"><div class="r-band"><a href="vizion-all-stars.php">Vizion All Stars</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/cWw0HQz8TExM-mAwprUt_eTsOeLKml7oLtnf31j2Ilo/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTY1MTQx/MjgtMTQyMDk4Nzg5/Mi04ODcwLmpwZWc.jpeg" alt="V.M. Band de Montréal"></div>
  <div class="r-details"><div class="r-band"><a href="v-m-band-de-montreal.php">V.M. Band de Montréal</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103992.jpg" alt="Vod'K Mizik"></div>
  <div class="r-details"><div class="r-band"><a href="vod-k-mizik.php">Vod'K Mizik</a></div></div>
</div>
<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/c2bff24e83c2b10da7425eb9f548e592/250x250-000000-80-0-0.jpg" alt="Vo-Duo"></div>
  <div class="r-details"><div class="r-band"><a href="vo-duo.php">Vo-Duo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.dustygroove.com/images/products/v/vodu155~~~~_vodu155~~_101b.jpg" alt="Vodu 155"></div>
  <div class="r-details"><div class="r-band"><a href="vodu155.php">Vodu 155</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106011.jpg" alt="Voix et Harmonie"></div>
  <div class="r-details"><div class="r-band"><a href="voix-et-harmonie.php">Voix et Harmonie</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/uFSVnJM6-u8V-_QQ3kFwhtkOO4mDD4aK4FqAePd4jQk/rs:fit/g:sm/q:90/h:600/w:595/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTk5MTMy/NjYtMTcwNjQ2OTc5/OS0yNTQzLmpwZWc.jpeg" alt="Volcan Des Gonaives"></div>
  <div class="r-details"><div class="r-band"><a href="volcan-des-gonaives.php">Volcan Des Gonaives</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/EKBL8yDEkW_5kWD8Q9h0_MLyIfJNp06KMVz-qvewrLI/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMyMzc2/OTUtMTUxNzM2NDgw/MS03NjcwLmpwZWc.jpeg" alt="Volny Orchestra"></div>
  <div class="r-details"><div class="r-band"><a href="volny-orchestra.php">Volny Orchestra</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/519H7OFI3fL._UF1000,1000_QL80_.jpg" alt="Volo Volo de Boston"></div>
  <div class="r-details"><div class="r-band"><a href="volo-volo-de-boston.php">Volo Volo de Boston</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src=" https://image.noelshack.com/fichiers/2025/22/2/1748349122-vol-cover.jpg" alt="Volume"></div>
  <div class="r-details"><div class="r-band"><a href="volume.php">Volume</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/22/2/1748359034-volu-cover.png" alt="Volume Music"></div>
  <div class="r-details"><div class="r-band"><a href="volume-music.php">Volume Music</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/503a140afa4ca66477bdd0d93dc869d6/250x250-000000-80-0-0.jpg" alt="Vox Sambou"></div>
  <div class="r-details"><div class="r-band"><a href="vox-sambou.php">Vox Sambou</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/eab91eff8c1c639a81db10c3d484081c/250x250-000000-80-0-0.jpg" alt="Vwadezil"></div>
  <div class="r-details"><div class="r-band"><a href="vwadezil.php">Vwadezil</a></div></div>
</div>



    <!-- Tu peux continuer à ajouter d'autres groupes ici -->

  </div>

  <script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>