<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>w - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
  

  <!-- Liste verticale des albums -->
  <div class="album-list">
      
    <div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/03e6f12f9dea24a2848e29267333f86d/250x250-000000-80-0-0.jpg" alt="Waahli"></div>
  <div class="r-details"><div class="r-band"><a href="waahli.php">Waahli</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/sQ7aLBHZQ_nyzBQayZPhiK8qKDLXANezfQB0NtLrhEQ/rs:fit/g:sm/q:90/h:522/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTMwOTEx/ODY1LTE3MTc4OTQw/MjUtNTA2Ni5qcGVn.jpeg" alt="Wagner Lalanne"></div>
  <div class="r-details"><div class="r-band"><a href="wagner-lalanne.php">Wagner Lalanne</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103623.jpg" alt="Wake Up Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="wake-up-kompa.php">Wake Up Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5eb5cc4db13d856738f9fceddd8" alt="Wanito"></div>
  <div class="r-details"><div class="r-band"><a href="wanito.php">Wanito</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/r2NbsfbZ/washington.png" alt="Washington Express Band"></div>
  <div class="r-details"><div class="r-band"><a href="washingtonexpressband.php">Washington Express Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104977.jpg" alt="Watchout"></div>
  <div class="r-details"><div class="r-band"><a href="watchout.php">Watchout</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/49058a438a458fee3ee04a76ff787335/250x250-000000-80-0-0.jpg" alt="Wawa"></div>
  <div class="r-details"><div class="r-band"><a href="wawa.php">Wawa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/d1668239b85e71b66fb1d7e3e95ee4ef/1900x1900-000000-80-0-0.jpg" alt="Webert Sicot"></div>
  <div class="r-details"><div class="r-band"><a href="webertsicot.php">Webert Sicot</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/9159c92195806075a21385cf84bbd68b/1900x1900-000000-80-0-0.jpg" alt="Wellborn"></div>
  <div class="r-details"><div class="r-band"><a href="wellborn.php">Wellborn</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/752a13323dff4f381824876525c65d5e/250x250-000000-80-0-0.jpg" alt="Welmyr Jean-Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="welmyrjean-pierre.php">Welmyr Jean-Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/1073c2871c9b70e35a15f8d55b0499ce/250x250-000000-80-0-0.jpg" alt="Wendyyy"></div>
  <div class="r-details"><div class="r-band"><a href="wendyyy.php">Wendyyy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/12/1/1742170411-cover.jpg" alt="Wenly-jay"></div>
  <div class="r-details"><div class="r-band"><a href="wenly-jay.php">Wenly-jay</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://f4.bcbits.com/img/a0523043544_5.jpg" alt="Wesli"></div>
  <div class="r-details"><div class="r-band"><a href="wesli.php">Wesli</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000220619998-9wompd-t500x500.jpg" alt="Wester Desamours"></div>
  <div class="r-details"><div class="r-band"><a href="wester-desamours.php">Wester Desamours</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/012934f3e1de16651719412652b46d1c/1900x1900-000000-80-0-0.jpg" alt="WiD"></div>
  <div class="r-details"><div class="r-band"><a href="wid.php">WiD</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/avatars-WV2UzSyLzycCNMZ4-xo20fg-t1080x1080.jpg" alt="Widmayard CJ"></div>
  <div class="r-details"><div class="r-band"><a href="widmayardcj.php">Widmayard CJ</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27346e6cd55c86e9cc48fa659b9" alt="Wigens"></div>
  <div class="r-details"><div class="r-band"><a href="wigens.php">Wigens</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/94fba1baed0289151005f5824dcd071d/0x1900-000000-80-0-0.jpg" alt="Wiliadel Denervil"></div>
  <div class="r-details"><div class="r-band"><a href="wiliadeldenervil.php">Wiliadel Denervil</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7b90f103a83e6669c9ebd0a94b82bdb1/250x250-000000-80-0-0.jpg" alt="William Mondesir"></div>
  <div class="r-details"><div class="r-band"><a href="william-mondesir.php">William Mondesir</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music114/v4/ec/56/13/ec561391-1184-f32c-c65a-0079627ece64/792278081583.png/486x486bb.png" alt="Wilky Fortunat"></div>
  <div class="r-details"><div class="r-band"><a href="wilkyfortunatcollection.php">Wilky Fortunat</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273675f6d35c3255357eb31055c" alt="Will"></div>
  <div class="r-details"><div class="r-band"><a href="will.php">Will</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/41kIPFbuxeL._UXNaN_FMjpg_QL85_.jpg" alt="Will Julia"></div>
  <div class="r-details"><div class="r-band"><a href="willjulia.php">Will Julia</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music118/v4/7c/c9/40/7cc9401c-cebc-9ca7-514f-184f4deae31b/cover.jpg/1380x1380bb.webp" alt="Williams Brutus"></div>
  <div class="r-details"><div class="r-band"><a href="williamsbrutus.php">Williams Brutus</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/8c2cad95391fbf0a09904740072bd309/250x250-000000-80-0-0.jpg" alt="Willy Deep Voix"></div>
  <div class="r-details"><div class="r-band"><a href="willy-deep-voix.php">Willy Deep Voix</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/10/3/1741215118-willymusic-album-cover.png" alt="Willy Le Wa"></div>
  <div class="r-details"><div class="r-band"><a href="willy-le-wa.php">Willy Le Wa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab6761610000e5ebefd1a5637e832d6fc4cc5ccc" alt="Wilner Pierre"></div>
  <div class="r-details"><div class="r-band"><a href="wilnerpierre.php">Wilner Pierre</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/3193a141d9b2202642b105d8df06908b/250x250-000000-80-0-0.jpg" alt="Winnie Ofisyèl"></div>
  <div class="r-details"><div class="r-band"><a href="winnie-ofisyel.php">Winnie Ofisyèl</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/d7d23f0f0a04258a518609edc0cea806/250x250-000000-80-0-0.jpg" alt="Wolc Youth Gospel Music"></div>
  <div class="r-details"><div class="r-band"><a href="wolc-youth-gospel-music.php">Wolc Youth Gospel Music</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://e-cdns-images.dzcdn.net/images/cover/dd1f9fcd05aa39ad722428cae42e96c5/250x250-000000-80-0-0.jpg" alt="Wood Terrib"></div>
  <div class="r-details"><div class="r-band"><a href="wood-terrib.php">Wood Terrib</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/512b788be9c0d04ccd6775b086cf61aa/250x250-000000-80-0-0.jpg" alt="Woolens Strong"></div>
  <div class="r-details"><div class="r-band"><a href="woolens-strong.php">Woolens Strong</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/AMCArtistImages122/v4/a7/bd/a3/a7bda391-2ffa-eec1-965b-b1a5a1abfe5a/04b850f0-f834-4efc-8142-714be6c5a6f0_file_cropped.png/486x486bb.png" alt="Woolphy B"></div>
  <div class="r-details"><div class="r-band"><a href="woolphyb.php">Woolphy B</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQWhTEOdsjhdnQHf5nZ3QPWqiFa9X8wKVEfHQ&s" alt="Wooly Saint Louis Jean"></div>
  <div class="r-details"><div class="r-band"><a href="woolysaintlouisjeancollection.php">Wooly Saint Louis Jean</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105467.jpg" alt="Wow"></div>
  <div class="r-details"><div class="r-band"><a href="wow.php">Wow</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61EUQ6o-h0L._UXNaN_FMjpg_QL85_.jpg" alt="Wowoli"></div>
  <div class="r-details"><div class="r-band"><a href="wowoli.php">Wowoli</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/p1CCfXW/Cover-Cd-Desti-2.png" alt="Wudjanhi"></div>
  <div class="r-details"><div class="r-band"><a href="wudjanhi.php">Wudjanhi</a></div></div>
</div>



    <!-- Tu peux continuer à ajouter d'autres groupes ici -->

  </div>

  <script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>