<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>X - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="../Z/Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

<!-- TOUS LES ARTISTES X -->

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/YFrJFwrB/X-cape.png" alt="X-Cape"></div>
  <div class="r-details"><div class="r-band"><a href="X-Cape.php">X-Cape</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273afb806ebb3de36b8f4896a7d" alt="X-Factor"></div>
  <div class="r-details"><div class="r-band"><a href="X-Factor.php">X-Factor</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/a775d9e61530d08aea69a5a6386c9368/1900x1900-000000-80-0-0.jpg" alt="Xl Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="Xl-Kompa.php">Xl Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/31VRFZKoraL._UF1000,1000_QL80_.jpg" alt="Xsussa"></div>
  <div class="r-details"><div class="r-band"><a href="Xsussa.php">Xsussa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.ibb.co/whTMw6GQ/x-tassy.png" alt="X-Tassy"></div>
  <div class="r-details"><div class="r-band"><a href="X-Tassy.php">X-Tassy</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/5195WfqWVnL._UXNaN_FMjpg_QL85_.jpg" alt="Xtazz"></div>
  <div class="r-details"><div class="r-band"><a href="Xtazz.php">Xtazz</a></div>
</div></div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/7424a7f3fb82af6c3a5024cbd872dcde/250x250-000000-80-0-0.jpg" alt="X-Tra Brutus"></div>
  <div class="r-details"><div class="r-band"><a href="X-tra-Brutus.php">X-Tra Brutus</a></div></div>
</div>
  
  </div>
  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>