<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Z - Artistes & groupes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
      display: none;
    }

    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }

    .side-menu.open {
      width: 250px;
    }

    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: 0.3s;
    }

    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }

    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }

    @media (max-width: 991px) {
      nav.menu {
        display: none;
      }
      .burger {
        display: block;
      }
    }

    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      gap: 8px;
    }

    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }

    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }

    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }

    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }

    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }

    .album-list {
      display: flex;
      flex-direction: column;
      gap: 20px;
      padding: 20px;
      max-width: 1770px;
      margin: 0 auto;
    }

    .album-item {
      display: flex;
      gap: 20px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 8px;
      padding: 10px;
      align-items: center;
      transition: background 0.3s ease;
    }

    .album-item:hover {
      background: #fdf9f1;
    }

    .r-cover img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      border-radius: 6px;
      border: 1px solid #C9A54C;
    }

    .r-details {
      flex: 1;
      text-align: left;
    }

    .r-band a {
      font-weight: bold;
      font-size: 1.1em;
      color: #212121;
      text-decoration: none;
      transition: color 0.3s ease;
    }

    .r-band a:hover {
      color: #C9A54C;
    }
  </style>
</head>
<body>

<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">
  ☰
</span>
<span class="burger" aria-label="Menu mobile" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i>Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>

<div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>

<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

  <div class="abc-ribbon">
    <div class="abc-links">
      <a href="../0-9/0-9.php" class="abc-link">#</a>
      <a href="../A/A.php" class="abc-link">A</a>
      <a href="../B/B.php" class="abc-link">B</a>
      <a href="../C/C.php" class="abc-link">C</a>
      <a href="../D/D.php" class="abc-link">D</a>
      <a href="../E/E.php" class="abc-link">E</a>
      <a href="../F/F.php" class="abc-link">F</a>
      <a href="../G/G.php" class="abc-link">G</a>
      <a href="../H/H.php" class="abc-link">H</a>
      <a href="../I/I.php" class="abc-link">I</a>
      <a href="../J/J.php" class="abc-link">J</a>
      <a href="../K/K.php" class="abc-link">K</a>
      <a href="../L/L.php" class="abc-link">L</a>
      <a href="../M/M.php" class="abc-link">M</a>
      <a href="../N/N.php" class="abc-link">N</a>
      <a href="../O/O.php" class="abc-link">O</a>
      <a href="../P/P.php" class="abc-link">P</a>
      <a href="../Q/Q.php" class="abc-link">Q</a>
      <a href="../R/R.php" class="abc-link">R</a>
      <a href="../S/S.php" class="abc-link">S</a>
      <a href="../T/T.php" class="abc-link">T</a>
      <a href="../U/U.php" class="abc-link">U</a>
      <a href="../V/V.php" class="abc-link">V</a>
      <a href="../W/W.php" class="abc-link">W</a>
      <a href="../X/X.php" class="abc-link">X</a>
      <a href="../Y/Y.php" class="abc-link">Y</a>
      <a href="Z.php" class="abc-link">Z</a>
      <a href="../various-artists/various-artists.php" class="abc-link" title="Compilations Various Artists"><i class="bi bi-stars"></i> V.A.</a>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit" class="search-button">🔍</button>
    </form>
  </div>
  
<!-- Liste verticale des albums -->
<div class="album-list">

  <!-- Artist List -->
  <div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104579.jpg" alt="Zaboca Berger"></div>
  <div class="r-details"><div class="r-band"><a href="zaboca-berger.php">Zaboca Berger</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/cover/4792dbe31fd325bb6144985b0fdb42a6/1900x1900-000000-80-0-0.jpg" alt="Zafem"></div>
  <div class="r-details"><div class="r-band"><a href="zafem.php">Zafem</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106395.jpg" alt="Zak-Top Fanfanr"></div>
  <div class="r-details"><div class="r-band"><a href="zak-top-fanfan.php">Zak-Top Fanfan</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51vLBGdJgdL._UXNaN_FMjpg_QL85_.jpg" alt="Zam Kompa Collection"></div>
  <div class="r-details"><div class="r-band"><a href="zamkompa.php">Zam Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/103999.jpg" alt="Zanset Band"></div>
  <div class="r-details"><div class="r-band"><a href="zansetband.php">Zanset Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104227.jpg" alt="Zap-Zap"></div>
  <div class="r-details"><div class="r-band"><a href="zapzap.php">Zap-Zap</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music/v4/32/4c/e2/324ce2de-887d-e34a-b5b7-43bd686498bf/884501840484.jpg/1200x1200bb.jpg" alt="Zatrap Band Collection"></div>
  <div class="r-details"><div class="r-band"><a href="zatrapband.php">Zatrap</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/5NkddL339-Uiu_fmeTPgxtGmy5PRY157nfUfcE3k_vw/rs:fit/g:sm/q:40/h:300/w:300/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTg4MDI2/NzktMTQ2OTA4OTMx/MS02MjM2LmpwZWc.jpeg" alt="Zekle"></div>
  <div class="r-details"><div class="r-band"><a href="zekle.php">Zekle</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music6/v4/72/92/fa/7292faf0-a76a-c7f2-57bc-b2e279e6852c/cover.jpg/1200x1200bf-60.jpg" alt="Zel"></div>
  <div class="r-details"><div class="r-band"><a href="zel.php">Zel</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/26/6/1751110255-default-cover.jpg" alt="Zénit Still"></div>
  <div class="r-details"><div class="r-band"><a href="zenit-still.php">Zénit Still</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51yftf0z5oL._UXNaN_FMjpg_QL85_.jpg" alt="Zenglen"></div>
  <div class="r-details"><div class="r-band"><a href="zenglen.php">Zenglen</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101803.jpg" alt="Zephyr Music Band"></div>
  <div class="r-details"><div class="r-band"><a href="zephyrmusicband.php">Zephyr Music Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105869.jpg" alt="Zepon"></div>
  <div class="r-details"><div class="r-band"><a href="zepon.php">Zepon</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSQDSMBseP3nzQJSzDVdZlUqJJsiL1zFTOERQ&s" alt="Zetwal Kreyol"></div>
  <div class="r-details"><div class="r-band"><a href="zetwalkreyol.php">Zetwal Kreyol</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdns-images.dzcdn.net/images/artist/d2c70b42c6a4ca9a43dfa4c02dfee9c2/1900x1900-000000-80-0-0.jpg" alt="Zic Band"></div>
  <div class="r-details"><div class="r-band"><a href="zicband.php">Zic Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b2731ebe921898489eea4f4b4a44" alt="Zigge"></div>
  <div class="r-details"><div class="r-band"><a href="zigge.php">Zigge</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/51qmOw-iZEL._UXNaN_FMjpg_QL85_.jpg" alt="Zig-Zag"></div>
  <div class="r-details"><div class="r-band"><a href="zigzag.php">Zig-Zag</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b27335b413379e063f7135eb9262" alt="Zig-Zag De Florida"></div>
  <div class="r-details"><div class="r-band"><a href="zigzagdeflorida.php">Zig-Zag De Florida</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/106664.jpg" alt="Zikos"></div>
  <div class="r-details"><div class="r-band"><a href="zikos.php">Zikos</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101323.jpg" alt="Zin"></div>
  <div class="r-details"><div class="r-band"><a href="zin.php">Zin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/71SDtZE9RBL._UF1000,1000_QL80_.jpg" alt="Zing Experience"></div>
  <div class="r-details"><div class="r-band"><a href="zingexperience.php">Zing Experience</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101330.jpg" alt="Zinglin"></div>
  <div class="r-details"><div class="r-band"><a href="zinglin.php">Zinglin</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273a0ba60eddee55c1206ebe6cc" alt="Zion Band"></div>
  <div class="r-details"><div class="r-band"><a href="zion-band.php">Zion Band</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101331.jpg" alt="Zipé"></div>
  <div class="r-details"><div class="r-band"><a href="zipe.php">Zipé</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-i9zW8PsglvzIEZ92-5vWCFA-t240x240.jpg" alt="Zizou Guitare"></div>
  <div class="r-details"><div class="r-band"><a href="zizouguitare.php">Zizou Guitare</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://m.media-amazon.com/images/I/61GzFZoRqWL._UXNaN_FMjpg_QL85_.jpg" alt="Zobop"></div>
  <div class="r-details"><div class="r-band"><a href="zobop.php">Zobop</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music124/v4/96/2b/48/962b4872-ee90-aea6-e706-1770ecfded5c/artwork.jpg/1200x1200bf-60.jpg" alt="Zoedjo Beatz"></div>
  <div class="r-details"><div class="r-band"><a href="zoedjobeatz.php">Zoedjo Beatz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/c32c51932c57d677cc0743d62caee711/250x250-000000-80-0-0.jpg" alt="Zoé Mouvement"></div>
  <div class="r-details"><div class="r-band"><a href="zoe-mouvement.php">Zoé Mouvement</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://is1-ssl.mzstatic.com/image/thumb/Music118/v4/a3/dd/d5/a3ddd584-7907-d853-a229-dadedf385689/859729863171_cover.jpg/1200x1200bf-60.jpg" alt="Zoe Solo"></div>
  <div class="r-details"><div class="r-band"><a href="zoesolo.php">Zoe Solo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d00001e0284b0aa1e95afd67c12e1b5de" alt="Zo Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="zokonpa.php">Zo Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://cdn-images.dzcdn.net/images/cover/a9cc34a3d25ad270f2377f3ee1fd1864/250x250-000000-80-0-0.jpg" alt="Zo-Manno Music Haiti"></div>
  <div class="r-details"><div class="r-band"><a href="zo-manno-music-haiti.php">Zo-Manno Music Haiti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://image.noelshack.com/fichiers/2025/11/4/1741877071-mr-zomo-album-cover.jpg" alt="Mr. Zomo"></div>
  <div class="r-details"><div class="r-band"><a href="mr-zomo.php">Mr. Zomo</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/105214.jpg" alt="Zone Konpa"></div>
  <div class="r-details"><div class="r-band"><a href="zonekonpa.php">Zone Konpa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/101747.jpg" alt="Zoom"></div>
  <div class="r-details"><div class="r-band"><a href="zoom.php">Zoom</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104002.jpg" alt="Zooty Kompa"></div>
  <div class="r-details"><div class="r-band"><a href="zootykompa.php">Zooty Kompa</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://www.konpa.info/cover-300/104580.jpg" alt="Zouloum"></div>
  <div class="r-details"><div class="r-band"><a href="zouloum.php">Zouloum</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/H-WiTR2GpN386Z0k_An2DB-1fixgaRxZ1pyvqU3tfBc/rs:fit/g:sm/q:90/h:600/w:595/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTE3Mzk5/ODYtMTI0MDMwNTE2/Ni5qcGVn.jpeg" alt="Zouti"></div>
  <div class="r-details"><div class="r-band"><a href="zouti.php">Zouti</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i1.sndcdn.com/artworks-000040656616-ylxvs0-t1080x1080.jpg" alt="Zoumpahitz"></div>
  <div class="r-details"><div class="r-band"><a href="zoumpahitz.php">Zoumpahitz</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.scdn.co/image/ab67616d0000b273d48485d64d6b0716729291c1" alt="Zshea"></div>
  <div class="r-details"><div class="r-band"><a href="zshea.php">Zshea</a></div></div>
</div>

<div class="album-item">
  <div class="r-cover"><img src="https://i.discogs.com/EVZUWyKtM0yLH_S5RAR3Pbjrnk2nj3qYnAWMxZU6aHw/rs:fit/g:sm/q:90/h:597/w:600/czM6Ly9kaXNjb2dz/LWRhdGFiYXNlLWlt/YWdlcy9SLTEyNzc0/Mjc4LTE1NDE2OTMw/MjctOTM2Mi5qcGVn.jpeg" alt="Zyltik"></div>
  <div class="r-details"><div class="r-band"><a href="zyltik.php">Zyltik</a></div></div>
</div>


</div>

  </main>
  
  
<script>
  function toggleMenu() {
    const menu = document.getElementById("sideMenu");
    const overlay = document.getElementById("overlay");
    const isOpen = menu.style.width === "250px";

    if (isOpen) {
      menu.style.width = "0";
      overlay.style.display = "none";
    } else {
      menu.style.width = "250px";
      overlay.style.display = "block";
    }
  }
</script>

</body>
</html>