<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connexion DB
if (!defined('DB_HOST')) define('DB_HOST', 'localhost');
if (!defined('DB_USER')) define('DB_USER', 'destinat_archive');
if (!defined('DB_PASS')) define('DB_PASS', '@rchivekompa1');
if (!defined('DB_NAME')) define('DB_NAME', 'destinat_archive');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) die("Connexion échouée : " . $conn->connect_error);

// Variables
$query = isset($_GET['query']) ? trim($_GET['query']) : '';
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$perPage = 30;
$offset = ($page - 1) * $perPage;

$where = '1';
$params = [];
$types = '';

if ($query !== '') {
    $where .= " AND LOWER(name) LIKE ?";
    $params[] = '%' . strtolower($query) . '%';
    $types .= 's';
}

// COUNT
$countQuery = "SELECT COUNT(*) FROM artists WHERE $where";
$countStmt = $conn->prepare($countQuery);
if ($types) {
    $countStmt->bind_param($types, ...$params);
}
$countStmt->execute();
$countStmt->bind_result($totalResults);
$countStmt->fetch();
$countStmt->close();

// Requête principale AVEC compteur d'albums
$sql = "SELECT name, image_url, CONCAT('/Artist/', UPPER(LEFT(name, 1)), '/', 
       LOWER(REPLACE(REPLACE(REPLACE(REPLACE(name, ' ', '-'), '&', 'and'), '\'', ''), '’', '')), 
       '.php') as page_url,
       albums, live_count, best_of_count,
       (albums + live_count + best_of_count) as total_albums
       FROM artists
       WHERE $where
       ORDER BY name
       LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);

if ($types) {
    $types .= 'ii';
    $params[] = $perPage;
    $params[] = $offset;
    $stmt->bind_param($types, ...$params);
} else {
    $stmt->bind_param('ii', $perPage, $offset);
}
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Recherche - Achiv Kompa</title>
  <link rel="icon" href="/assets/icons/favicon.ico" type="image/x-icon">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: #FAFAFA;
      margin: 0;
      color: #212121;
    }
    header {
      width: 100%;
      margin-bottom: 10px;
    }
    header img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      display: block;
    }
    .burger {
      font-size: 28px;
      color: #C9A54C;
      background: #FFF;
      padding: 10px 15px;
      border-radius: 4px;
      cursor: pointer;
      position: fixed;
      top: 15px;
      left: 15px;
      z-index: 1100;
    }
    .side-menu {
      height: 100%;
      width: 0;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #F5F5F5;
      overflow-x: hidden;
      transition: 0.4s;
      padding-top: 60px;
      z-index: 1101;
    }
    .side-menu.open { width: 250px; }
    .side-menu a {
      padding: 12px 20px;
      text-decoration: none;
      font-size: 18px;
      color: #212121;
      display: block;
    }
    .side-menu a:hover {
      background: #C9A54C;
      color: #fff;
    }
    .side-menu .closebtn {
      position: absolute;
      top: 15px;
      right: 25px;
      font-size: 30px;
      color: #212121;
      cursor: pointer;
    }
    nav.menu {
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px;
      background: #fff;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
    }
    nav.menu a {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 8px 12px;
      border: 2px solid #C9A54C;
      border-radius: 6px;
    }
    .sticky-header {
      position: sticky;
      top: 0;
      z-index: 999;
      background: #fff;
      box-shadow: 0 2px 5px rgba(0,0,0,0.05);
      padding: 6px 0;
    }
    .abc-ribbon {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      align-items: center;
      padding: 10px;
      gap: 8px;
      border-top: 2px solid #C9A54C;
      border-bottom: 2px solid #C9A54C;
      background: #fff;
    }
    .abc-links {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      justify-content: center;
      align-items: center;
    }
    .abc-link {
      text-decoration: none;
      color: #212121;
      font-weight: 600;
      padding: 6px 10px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }
    .abc-link:hover {
      background: #C9A54C;
      color: #fff;
    }
    .search-form {
      display: flex;
      align-items: center;
      gap: 5px;
      margin-left: 20px;
    }
    .search-form input {
      padding: 5px;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }
    .search-form button {
      background: #C9A54C;
      color: #fff;
      border: none;
      padding: 5px 10px;
      border-radius: 4px;
      cursor: pointer;
    }
    .album-item {
      display: flex;
      align-items: center;
      gap: 10px;
      background: #fff;
      border: 1px solid #C9A54C;
      border-radius: 6px;
      padding: 10px 14px;
      margin: 10px auto;
      width: 95%;
      max-width: 1200px;
    }
    .r-cover img {
      width: 90px;
      height: 90px;
      object-fit: cover;
      border-radius: 4px;
      border: 1px solid #C9A54C;
    }
    .r-details { flex: 1; }
    .r-band a {
      font-weight: bold;
      font-size: 1em;
      color: #212121;
      text-decoration: none;
      display: inline-block;
      margin-bottom: 5px;
    }
    .r-band a:hover { color: #C9A54C; }
    .category-icons {
      display: flex;
      flex-wrap: wrap;
      gap: 6px;
      font-size: 0.85em;
      margin-top: 4px;
    }
    .category-icons span {
      display: inline-flex;
      align-items: center;
      gap: 4px;
      padding: 3px 8px;
      border-radius: 4px;
      background: #ffffff;
      border: 1px solid #004B8D;
      color: #004B8D;
      font-weight: 600;
    }
    footer {
      margin-top: 30px;
      text-align: center;
      padding: 20px 0;
    }
    footer img {
      height: 170px;
    }
  </style>
</head>
<body>
<header>
  <img src="/assets/banner/achiv-kompa.png" alt="Achiv Kompa">
</header>
<span class="burger" onclick="document.getElementById('sideMenu').classList.toggle('open')">☰</span>
<div id="sideMenu" class="side-menu">
  <span class="closebtn" onclick="document.getElementById('sideMenu').classList.remove('open')">&times;</span>
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</div>
<nav class="menu">
  <a href="/index.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

<div class="sticky-header">
  <div class="abc-ribbon">
    <div class="abc-links">
      <a class="abc-link" href="0-9.php">#</a>
      <?php foreach (range('A', 'Z') as $l): ?>
        <a class="abc-link" href="../<?= $l ?>/<?= $l ?>.php"><?= $l ?></a>
      <?php endforeach; ?>
    </div>
    <form action="search.php" method="get" class="search-form">
      <input type="text" name="query" placeholder="Rechercher..." required>
      <button type="submit">🔍</button>
    </form>
  </div>
</div>

<div style="text-align:center; margin:20px 0;">
  <span style="border:1px dashed #d2aa4e; padding:6px 12px; border-radius:8px; font-weight:bold;">
    <i class="bi bi-music-note-beamed"></i> <?= $totalResults ?> résultat<?= ($totalResults > 1 ? 's' : '') ?> trouvé(s)
  </span>
</div>

<?php while ($row = $result->fetch_assoc()): ?>
  <div class="album-item">
    <div class="r-cover">
      <a href="<?= $row['page_url'] ?>"><img src="<?= !empty($row['image_url']) ? $row['image_url'] : '/assets/icons/default-artist.png' ?>" alt="<?= $row['name'] ?>"></a>
    </div>
    <div class="r-details">
      <div class="r-band"><a href="<?= $row['page_url'] ?>"><i class="bi bi-person-fill"></i> <?= $row['name'] ?></a></div>
      <div class="category-icons">
        <?php if ($row['albums'] > 0): ?><span><i class="bi bi-vinyl-fill"></i> Studio (<?= $row['albums'] ?>)</span><?php endif; ?>
        <?php if ($row['live_count'] > 0): ?><span><i class="bi bi-broadcast-pin"></i> Live (<?= $row['live_count'] ?>)</span><?php endif; ?>
        <?php if ($row['best_of_count'] > 0): ?><span><i class="bi bi-star-fill"></i> Best Of (<?= $row['best_of_count'] ?>)</span><?php endif; ?>
        <span><i class="bi bi-collection-play-fill"></i> Total (<?= $row['total_albums'] ?>)</span>
      </div>
    </div>
  </div>
<?php endwhile; ?>
<footer>
  <img src="/assets/icons/achiv-kompa-logo.png" alt="Achiv Kompa Logo">
</footer>

</body>
</html>
