<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Recherche Artistes</title>
  <!-- <link rel="stylesheet" href="style.css" /> -->
  <!-- Favicon classiques -->
<link rel="icon" type="image/x-icon" href="/assets/icons/favicon.ico">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/icons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="/assets/icons/favicon-96x96.png">

<!-- Apple Touch -->
<link rel="apple-touch-icon" href="/assets/icons/apple-touch-icon.png">

<!-- Web App (Android / PWA) -->
<link rel="manifest" href="/assets/icons/manifest.json">
<meta name="theme-color" content="#000000">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" />
  <style>
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #F0F0F0;
      color: #212121;
    }

    .banner img {
      width: 100%;
      max-height: 450px;
      object-fit: cover;
      border-bottom: 4px solid #C9A54C;
    }

    nav.menu {
      background: #fff;
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 10px;
      padding: 10px 0;
      border-top: 3px solid #C9A54C;
      border-bottom: 3px solid #C9A54C;
    }

    nav.menu a {
      text-decoration: none;
      font-weight: bold;
      color: #212121;
      padding: 10px 18px;
      background: #fff;
      border: 2px solid #C9A54C;
      border-radius: 6px;
      display: flex;
      align-items: center;
      gap: 6px;
      transition: all 0.2s ease-in-out;
    }

    nav.menu a:hover {
      background: #C9A54C;
      color: #fff;
    }
    h2 {
      text-align: center;
      margin: 20px;
    }
    #searchInput {
      width: 400px;
      padding: 8px;
      display: block;
      margin: 0 auto 20px auto;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    /* Grille */
    #results {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
      gap: 15px;
      padding: 20px;
      max-width: 1400px;
      margin: auto;
    }
    .album-item {
      background: white;
      border: 1px solid #ddd;
      border-radius: 8px;
      text-align: center;
      padding: 8px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.05);
      transition: transform 0.2s;
    }
    .album-item:hover {
      transform: scale(1.05);
    }
    .album-item img {
      width: 100%;
      border-radius: 6px;
    }
    .r-band a {
      text-decoration: none;
      color: #333;
      font-weight: bold;
      display: block;
      margin-top: 8px;
    }
    /* Pagination */
    .pagination {
      margin: 20px auto;
      text-align: center;
    }
    .pagination button {
      margin: 2px;
      padding: 6px 12px;
      border: 1px solid #aaa;
      background: white;
      cursor: pointer;
      border-radius: 5px;
    }
    .pagination button:hover {
      background-color: #eee;
    }
    footer {
      background: #000;
      color: white;
      text-align: center;
      padding: 10px;
      margin-top: 40px;
    }
  </style>
</head>
<body>

<header>
  <div class="banner">
  <img src="https://image.noelshack.com/fichiers/2025/25/2/1750113712-banner-achiv.png" alt="Bannière Achiv Kompa">
</div>
</header>

<nav class="menu">
  <a href="/testindex.php"><i class="bi bi-house-door"></i> Accueil</a>
  <a href="/Intro1.php"><i class="bi bi-info-circle"></i> Intro</a>
  <a href="/Forum/index.php"><i class="bi bi-chat-dots"></i> Forum</a>
  <a href="/achiv-menu.php"><i class="bi bi-vinyl"></i> Achiv Menu</a>
  <a href="/video.php"><i class="bi bi-camera-video"></i> Vidéo</a>
  <a href="/playlist2.php"><i class="bi bi-music-note-list"></i> Music Promo</a>
  <a href="/Kompa.php"><i class="bi bi-person-badge"></i> À propos</a>
  <a href="/contact.php"><i class="bi bi-envelope"></i> Contact</a>
</nav>

<h2>Recherche d'artistes</h2>
<input type="text" id="searchInput" placeholder="Tapez un nom...">

<div id="results">Chargement...</div>

<div class="pagination" id="pagination"></div>

<footer>
  © ACHIV KOMPA 2025
</footer>

<script>
function fetchResults(query = '', page = 1) {
  const params = new URLSearchParams({ query: query, page: page });
  history.replaceState(null, '', '?' + params.toString());

  const xhr = new XMLHttpRequest();
  xhr.open('GET', 'search_ajax_data.php?query=' + encodeURIComponent(query) + '&page=' + page, true);
  xhr.onload = function () {
    if (xhr.status === 200) {
      try {
        const response = JSON.parse(xhr.responseText);
        renderResults(response.results);
        renderPagination(response.totalPages, page, query);
      } catch (e) {
        document.getElementById('results').innerHTML = '<p>Erreur de données.</p>';
        console.error('Erreur JSON:', e);
      }
    } else {
      document.getElementById('results').innerHTML = '<p>Erreur serveur : ' + xhr.status + '</p>';
    }
  };
  xhr.onerror = function() {
    document.getElementById('results').innerHTML = '<p>Erreur réseau.</p>';
  };
  xhr.send();
}

function renderResults(items) {
  const resultsDiv = document.getElementById('results');
  resultsDiv.innerHTML = '';
  if (!items || items.length === 0) {
    resultsDiv.innerHTML = '<p>Aucun résultat trouvé.</p>';
    return;
  }

  items.forEach(item => {
    const div = document.createElement('div');
    div.className = 'album-item';
    div.innerHTML = `
      <div class="r-cover"><img src="${item.image}" alt="${item.name}"></div>
      <div class="r-band"><a href="${item.link}">${item.name}</a></div>
    `;
    resultsDiv.appendChild(div);
  });
}

function renderPagination(totalPages, currentPage, query) {
  const paginationDiv = document.getElementById('pagination');
  paginationDiv.innerHTML = '';

  if (totalPages <= 1) return;

  for (let i = 1; i <= totalPages; i++) {
    const btn = document.createElement('button');
    btn.textContent = i;
    btn.disabled = (i === currentPage);
    btn.onclick = () => fetchResults(query, i);
    paginationDiv.appendChild(btn);
  }
}

document.getElementById('searchInput').addEventListener('input', function () {
  fetchResults(this.value.trim(), 1);
});

window.onload = () => {
  const params = new URLSearchParams(window.location.search);
  const query = params.get('query') || '';
  const page = parseInt(params.get('page')) || 1;

  document.getElementById('searchInput').value = query;
  fetchResults(query, page);
};
</script>

</body>
</html>

